#pragma once

#include "../profiling/Record.h"
#include "BoundsMap.h"

#include <vtkm/rendering/CanvasRayTracer.h>
#include <vtkm/rendering/Mapper.h>

#include <vector>

namespace beams
{
namespace rendering
{
class MapperVolumeBase : public vtkm::rendering::Mapper
{
public:
  MapperVolumeBase();

  ~MapperVolumeBase();

  virtual void SetCanvas(vtkm::rendering::Canvas* canvas) override;
  virtual vtkm::rendering::Canvas* GetCanvas() const override;

  void SetBoundsMap(beams::rendering::BoundsMap* boundsMap);

  void SetSampleDistance(const vtkm::Float32 distance);

  void SetDensityCorrectionRatio(const vtkm::Float32 ratio);

  void SetCompositeBackground(const bool compositeBackground);

  virtual std::vector<beams::profiling::Record> GetProfilerTimes() = 0;

protected:
  vtkm::rendering::CanvasRayTracer* Canvas;
  vtkm::Float32 SampleDistance;
  bool CompositeBackground;
  beams::rendering::BoundsMap* BoundsMap;
  vtkm::Float32 DensityCorrectionRatio;
};
}
}
