#include "MapperVolumeBase.h"

#define DEFAULT_SAMPLE_DISTANCE -1.f

namespace beams
{
namespace rendering
{
MapperVolumeBase::MapperVolumeBase()
  : Canvas(nullptr)
  , SampleDistance(DEFAULT_SAMPLE_DISTANCE)
  , CompositeBackground(true)
{
}

MapperVolumeBase::~MapperVolumeBase() {}

void MapperVolumeBase::SetCanvas(vtkm::rendering::Canvas* canvas)
{
  if (canvas != nullptr)
  {
    this->Canvas = dynamic_cast<vtkm::rendering::CanvasRayTracer*>(canvas);

    if (this->Canvas == nullptr)
    {
      throw vtkm::cont::ErrorBadValue("Ray Tracer: bad canvas type. Must be CanvasRayTracer");
    }
  }
  else
  {
    this->Canvas = nullptr;
  }
}

vtkm::rendering::Canvas* MapperVolumeBase::GetCanvas() const
{
  return this->Canvas;
}

void MapperVolumeBase::SetBoundsMap(beams::rendering::BoundsMap* boundsMap)
{
  this->BoundsMap = boundsMap;
}

void MapperVolumeBase::SetDensityCorrectionRatio(vtkm::Float32 densityCorrectionRatio)
{
  this->DensityCorrectionRatio = densityCorrectionRatio;
}

void MapperVolumeBase::SetSampleDistance(const vtkm::Float32 sampleDistance)
{
  this->SampleDistance = sampleDistance;
}

void MapperVolumeBase::SetCompositeBackground(const bool compositeBackground)
{
  this->CompositeBackground = compositeBackground;
}
}
}
