#pragma once

#include "Light.h"
#include "MapperVolumeBase.h"

#include <memory>

namespace beams
{
namespace rendering
{
class MapperPhongVolume : public MapperVolumeBase
{
public:
  MapperPhongVolume();

  ~MapperPhongVolume();

  virtual void RenderCells(const vtkm::cont::UnknownCellSet& cellset,
                           const vtkm::cont::CoordinateSystem& coords,
                           const vtkm::cont::Field& scalarField,
                           const vtkm::cont::ColorTable&, //colorTable
                           const vtkm::rendering::Camera& camera,
                           const vtkm::Range& scalarRange) override;

  vtkm::rendering::Mapper* NewCopy() const override;

  std::vector<beams::profiling::Record> GetProfilerTimes() override;

  void AddLight(std::shared_ptr<Light> light);

  void ClearLights();

  void SetUsePhongDiffuse(bool usePhongDiffuse);

  void SetUsePhongSpecular(bool usePhongSpecular);

private:
  struct InternalsType;
  std::shared_ptr<InternalsType> Internals;
};
}
}
