#ifndef beams_mapper_volume_shadow_h
#define beams_mapper_volume_shadow_h

#include "../mpi/MpiEnv.h"
#include "../profiling/Record.h"
#include "BoundsMap.h"
#include "Light.h"
#include "MapperVolumeBase.h"

#include <memory>

namespace beams
{
namespace rendering
{
class MapperLitVolume : public beams::rendering::MapperVolumeBase
{
public:
  MapperLitVolume();

  ~MapperLitVolume();

  void SetShadowMapSize(vtkm::Id3 size);

  void SetShadowMapNumSteps(vtkm::Id numSteps);

  virtual void RenderCells(const vtkm::cont::UnknownCellSet& cellset,
                           const vtkm::cont::CoordinateSystem& coords,
                           const vtkm::cont::Field& scalarField,
                           const vtkm::cont::ColorTable&, //colorTable
                           const vtkm::rendering::Camera& camera,
                           const vtkm::Range& scalarRange) override;

  vtkm::rendering::Mapper* NewCopy() const override;

  void AddLight(std::shared_ptr<Light> light);

  void ClearLights();

  void SetDensityScale(vtkm::Float32 densityScale);

  void Composite(const vtkm::rendering::Camera& camera);

  void GlobalComposite(const vtkm::rendering::Camera& camera);

  void SetNumShadowSamples(vtkm::Id numShadowSamples);

  std::vector<beams::profiling::Record> GetProfilerTimes() override;

  void SetUseClamp(bool useClamp);

  void SetUseReinhard(bool useReinhard);

private:
  std::vector<int> FindVisibilityOrdering(const vtkm::rendering::Camera& camera);

  vtkm::Float32 FindMinDepth(const vtkm::rendering::Camera& camera, const vtkm::Bounds& bounds);

  void DepthSort(int size, std::vector<vtkm::Float32>& minDepths, std::vector<int>& visOrderings);

  struct InternalsType;
  std::shared_ptr<InternalsType> Internals;
};
} // namespace rendering
} //namespace beams

#endif // beams_MapperVolume_h