#pragma once

#include "MapperVolumeBase.h"

#include <memory>

namespace beams
{
namespace rendering
{
class MapperDirectVolume : public MapperVolumeBase
{
public:
  MapperDirectVolume();

  ~MapperDirectVolume();

  virtual void RenderCells(const vtkm::cont::UnknownCellSet& cellset,
                           const vtkm::cont::CoordinateSystem& coords,
                           const vtkm::cont::Field& scalarField,
                           const vtkm::cont::ColorTable&, //colorTable
                           const vtkm::rendering::Camera& camera,
                           const vtkm::Range& scalarRange) override;

  vtkm::rendering::Mapper* NewCopy() const override;

  std::vector<beams::profiling::Record> GetProfilerTimes() override;

private:
  struct InternalsType;
  std::shared_ptr<InternalsType> Internals;
};
}
}
