#pragma once

#include <vtkm/Types.h>

namespace beams
{
namespace rendering
{
class Lights
{
public:
  std::vector<vtkm::Float32> Intensities;
  std::vector<vtkm::Vec<vtkm::Float32, 3>> Locations;
  std::vector<vtkm::Vec<vtkm::Float32, 3>> Colors;

public:
  void AddLight(vtkm::Vec<vtkm::Float32, 3> location,
                vtkm::Vec<vtkm::Float32, 3> color,
                vtkm::Float32 intensity)
  {
    Locations.push_back(location);
    Colors.push_back(color);
    Intensities.push_back(intensity);
  }

  void ClearLights()
  {
    Locations.clear();
    Colors.clear();
    Intensities.clear();
  }
};
}
}