#pragma once

#include "../Config.h"
#include "Scene.h"

namespace beams
{
namespace rendering
{
struct FileSceneBase : public Scene
{
  FileSceneBase() = default;
  virtual ~FileSceneBase() = default;

protected:
  virtual void LoadDataSet(const beams::Config& config,
                           const beams::Preset& preset,
                           beams::mpi::MpiEnv& mpi) override;

  virtual std::string GetFileName(const beams::Config& config,
                                  const beams::Preset& preset,
                                  const beams::mpi::MpiEnv& mpi) const;

}; // struct FileSceneBase
}
} // namespace beams::rendering