#ifndef beams_mpi_MpiEnv_h
#define beams_mpi_MpiEnv_h

#include "Result.h"

#include <vtkm/thirdparty/diy/diy.h>

#include <mpi.h>

#include <memory>

namespace beams
{
namespace mpi
{
struct MpiEnv
{
public:
  enum class TopologyShape
  {
    Unknown,
    Line,
    Rectangle,
    Cuboid,
    Custom
  };

  MpiEnv(int argc, char* argv[]);
  ~MpiEnv();

  void ReshapeCustom(int xLength, int yLength, int zLength);

  void ReshapeAsLine();

  void ReshapeAsRectangle();

  void ReshapeAsCuboid();

  static MpiEnv* GetInstance() { return Instance; }

  vtkmdiy::mpi::environment Env;
  vtkmdiy::mpi::communicator Comm;
  MPI_Comm RawComm;

  TopologyShape Shape;
  std::string Hostname;
  int Rank;
  int Size;
  int XLength;
  int YLength;
  int ZLength;
  int XRank;
  int YRank;
  int ZRank;

private:
  static MpiEnv* Instance;
};
}
} // beams::mpi

#endif // beams_mpi_env_h