//============================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//============================================================================

#include "Beams.h"
#include "Result.h"
#include "utils/Fmt.h"

#include <vtkm/cont/Initialize.h>
#include <vtkm/rendering/Actor.h>
#include <vtkm/rendering/CanvasRayTracer.h>
#include <vtkm/rendering/MapperVolume.h>
#include <vtkm/rendering/Scene.h>
#include <vtkm/rendering/View3D.h>
#include <vtkm/source/Tangle.h>

int main(int argc, char* argv[])
{
  beams::mpi::MpiEnv mpi(argc, argv);

  Fmt::Initialize(&mpi);

  beams::Beams app(mpi);
  auto result = app.Initialize(argc, argv);

  if (!result.Success)
  {
    Fmt::Println0("Beams failed with error: {}", result.Err);
    return EXIT_FAILURE;
  }

  app.Run();

  return EXIT_SUCCESS;
}