#pragma once

#include "../Result.h"
#include "../mpi/MpiEnv.h"
#include "../rendering/Scene.h"

#include <memory>
#include <string>

namespace beams
{
namespace gui
{
struct Window
{
  Window();
  ~Window();

  beams::Result Initialize(const std::string& title,
                           int width,
                           int height,
                           std::shared_ptr<beams::Config> config,
                           beams::mpi::MpiEnv* mpi,
                           std::function<void()> onReloadConfig);

  void SetConfig(std::shared_ptr<beams::Config> config);

  void Shutdown();

  void Run();

  struct WindowInternals;

protected:
  void OnCursorState(bool leftButtonDown, double xPos, double yPos);

  void OnArrowKeys(bool leftArrowDown, bool rightArrowDown, bool upArrowDown, bool downArrowDown);

  void Repaint(bool force = false);

  std::shared_ptr<WindowInternals> Internals;
};
} // namespace gui
} // namespace beams