#include "SceneFactory.h"
#include "rendering/FileSceneBase.h"
#include "rendering/PerlinScene.h"
#include "rendering/SummerMovieScene.h"
#include "utils/Fmt.h"

namespace beams
{
std::shared_ptr<beams::rendering::Scene> SceneFactory::CreateFromPreset(const beams::Config& config,
                                                                        const beams::Preset& preset,
                                                                        beams::mpi::MpiEnv& mpi)
{
  std::shared_ptr<beams::rendering::Scene> scene;
  const beams::DataSetOptions& dataSetOptions = config.DataSets.at(preset.DataSetId);
  if (dataSetOptions.Factory == "perlin")
  {
    scene = std::make_shared<beams::rendering::PerlinScene>();
  }
  else if (dataSetOptions.Factory == "file")
  {
    scene = std::make_shared<beams::rendering::FileSceneBase>();
  }
  else if (dataSetOptions.Factory == "summer_movie")
  {
    scene = std::make_shared<beams::rendering::SummerMovieScene>();
  }
  else
  {
    Fmt::Println("Trying to load preset from invalid dataset type");
    return nullptr;
  }

  scene->LoadFromPreset(config, preset, mpi);
  return scene;
}
} // namespace beams
