#ifndef beams_beams_h
#define beams_beams_h

#include "Result.h"
#include "mpi/MpiEnv.h"
#include "rendering/Scene.h"

#include <memory>
#include <string>

namespace beams
{
enum class InteractiveMode
{
  Headless,
  Gui,
  SummerMovie,
  SummerMovieFast,
  MovieCamera,
  MovieLightTheta,
  Unknown
};

class Beams
{
public:
  Beams(beams::mpi::MpiEnv& mpiEnv);

  beams::Result Initialize(int& argc, char** argv);

  void Run();

  struct InternalsType;

private:
  void LoadScene();

  void SetupScene();

  void RunHeadless();

  void RunGui();

  void RunSummerMovie(bool fast = false);

  void RunMovieCamera();

  void RunMovieLightTheta();

  void SaveCanvas(int frame = 0, std::string suffix = "");

 std::string GetSaveCanvasName(std::string frameName, std::string suffix = "");

  void SaveCanvas(std::string frameName, std::string suffix = "");

  std::shared_ptr<InternalsType> Internals;
}; // class Beams

} // namespace beams

#endif
