//============================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//
//  Copyright 2015 National Technology & Engineering Solutions of Sandia, LLC (NTESS).
//  Copyright 2015 UT-Battelle, LLC.
//  Copyright 2015 Los Alamos National Security.
//
//  Under the terms of Contract DE-NA0003525 with NTESS,
//  the U.S. Government retains certain rights in this software.
//
//  Under the terms of Contract DE-AC52-06NA25396 with Los Alamos National
//  Laboratory (LANL), the U.S. Government retains certain rights in
//  this software.
//============================================================================
#ifndef vtk_m_rendering_raytracing_MeshOracleContainer_h
#define vtk_m_rendering_raytracing_MeshOracleContainer_h

#include <vtkm/cont/DataSet.h>
#include <vtkm/rendering/raytracing/MeshOracleBase.h>

namespace vtkm
{
namespace rendering
{
namespace raytracing
{

class MeshOracleContainer : vtkm::cont::ExecutionObjectBase
{
public:
  MeshOracleContainer();
  virtual ~MeshOracleContainer();

  virtual const MeshOracleBase* Construct(const vtkm::cont::DeviceAdapterId deviceId) = 0;

  MeshOracleWrapper PrepareForExecution(const vtkm::cont::DeviceAdapterId deviceId);

protected:
  OracleHandle Handle;
};

class RectilinearContainer : public MeshOracleContainer
{
public:
  using DefaultHandle = vtkm::cont::ArrayHandle<vtkm::FloatDefault>;
  using CartesianArrayHandle =
    vtkm::cont::ArrayHandleCartesianProduct<DefaultHandle, DefaultHandle, DefaultHandle>;

  vtkm::cont::CellSetStructured<3> CellSet;
  CartesianArrayHandle Coords;

  VTKM_CONT
  RectilinearContainer(const vtkm::cont::CellSetStructured<3>& cellset,
                       const CartesianArrayHandle &coords);

  virtual ~RectilinearContainer();

  const MeshOracleBase* Construct(const vtkm::cont::DeviceAdapterId deviceId);
private:
  VTKM_CONT
  RectilinearContainer(){};
};
//
//class StructuredContainer : public MeshConnContainer
//{
//protected:
//  typedef vtkm::cont::ArrayHandle<vtkm::Vec<vtkm::Id, 4>> Id4Handle;
//  vtkm::Id3 CellDims;
//  vtkm::Id3 PointDims;
//  vtkm::Bounds CoordinateBounds;
//  vtkm::cont::CoordinateSystem Coords;
//  vtkm::cont::CellSetStructured<3> Cellset;
//
//private:
//  VTKM_CONT
//  StructuredContainer() {}
//
//public:
//  VTKM_CONT
//  StructuredContainer(const vtkm::cont::CellSetStructured<3>& cellset,
//                      const vtkm::cont::CoordinateSystem& coords,
//                      Id4Handle& externalTriangles);
//
//  const MeshConnectivityBase* Construct(const vtkm::cont::DeviceAdapterId deviceId) override;
//
//}; //structure mesh conn
//
//class UnstructuredSingleContainer : public MeshConnContainer
//{
//public:
//  typedef vtkm::cont::ArrayHandle<vtkm::Id> IdHandle;
//  typedef vtkm::cont::ArrayHandle<vtkm::Vec<vtkm::Id, 4>> Id4Handle;
//  typedef vtkm::cont::ArrayHandleCounting<vtkm::Id> CountingHandle;
//  typedef vtkm::cont::ArrayHandleConstant<vtkm::UInt8> ShapesHandle;
//  typedef vtkm::cont::ArrayHandleConstant<vtkm::IdComponent> NumIndicesHandle;
//  // Control Environment Handles
//  IdHandle FaceConnectivity;
//  CountingHandle CellOffsets;
//  IdHandle CellConnectivity;
//
//  vtkm::Bounds CoordinateBounds;
//  vtkm::cont::CoordinateSystem Coords;
//  vtkm::cont::CellSetSingleType<> Cellset;
//
//  vtkm::Int32 ShapeId;
//  vtkm::Int32 NumIndices;
//  vtkm::Int32 NumFaces;
//
//private:
//  VTKM_CONT
//  UnstructuredSingleContainer();
//
//public:
//  VTKM_CONT
//  UnstructuredSingleContainer(const vtkm::cont::CellSetSingleType<>& cellset,
//                              const vtkm::cont::CoordinateSystem& coords,
//                              IdHandle& faceConn,
//                              Id4Handle& externalFaces);
//
//  const MeshConnectivityBase* Construct(const vtkm::cont::DeviceAdapterId deviceId) override;
//
//}; //UnstructuredSingleContainer
}
}
} //namespace vtkm::rendering::raytracing
#endif
