/*
 * Decompiled with CFR 0.152.
 */
package org.xj3d.impl.core.loading;

import java.util.ArrayList;
import java.util.Map;
import org.web3d.util.ErrorReporter;
import org.web3d.vrml.lang.BasicScene;
import org.web3d.vrml.lang.VRMLNode;
import org.web3d.vrml.nodes.VRMLExternProtoDeclare;
import org.web3d.vrml.nodes.VRMLExternalNodeType;
import org.web3d.vrml.nodes.VRMLMultiExternalNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLScriptNodeType;
import org.web3d.vrml.nodes.VRMLSingleExternalNodeType;
import org.web3d.vrml.nodes.VRMLUrlListener;
import org.web3d.vrml.util.NodeArray;
import org.xj3d.core.loading.ContentLoadManager;
import org.xj3d.core.loading.ContentLoadQueue;
import org.xj3d.core.loading.FileCache;
import org.xj3d.core.loading.LoadConstants;
import org.xj3d.core.loading.LoadDetails;
import org.xj3d.core.loading.LoadRequest;
import org.xj3d.core.loading.LoadRequestHandler;
import org.xj3d.core.loading.LoaderThreadPool;
import org.xj3d.impl.core.loading.ContentLoadDetails;
import org.xj3d.impl.core.loading.ContentLoadHandler;

public abstract class AbstractLoadManager
implements ContentLoadManager,
LoadConstants,
VRMLUrlListener {
    private LoaderThreadPool loaderPool = LoaderThreadPool.getLoaderThreadPool();
    private ContentLoadQueue pending = this.loaderPool.getWaitingList();
    private Map inProgress = this.loaderPool.getProgressMap();

    protected AbstractLoadManager() {
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.loaderPool.setErrorReporter(errorReporter);
    }

    public synchronized void queueExternProtoLoad(VRMLExternProtoDeclare vRMLExternProtoDeclare) {
        if (vRMLExternProtoDeclare == null) {
            return;
        }
        String[] stringArray = vRMLExternProtoDeclare.getUrl();
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        this.ayeShesDeadCapn();
        FileCache fileCache = this.getCache();
        ContentLoadDetails contentLoadDetails = new ContentLoadDetails();
        contentLoadDetails.fieldIndex = -1;
        contentLoadDetails.node = vRMLExternProtoDeclare;
        LoadRequest loadRequest = (LoadRequest)this.inProgress.get(stringArray);
        if (loadRequest != null) {
            if (!loadRequest.loadList.contains(contentLoadDetails)) {
                loadRequest.loadList.add(contentLoadDetails);
            }
        } else {
            ContentLoadHandler contentLoadHandler = new ContentLoadHandler(fileCache);
            this.pending.add("externprotos", stringArray, contentLoadHandler, contentLoadDetails);
        }
    }

    public void queueSceneLoad(BasicScene basicScene) {
        int n;
        Object object;
        Object object2;
        ContentLoadDetails contentLoadDetails;
        Object object3;
        if (basicScene == null) {
            return;
        }
        this.ayeShesDeadCapn();
        FileCache fileCache = this.getCache();
        ArrayList arrayList = basicScene.getNodeTemplates();
        int n2 = arrayList.size();
        for (int i = 0; i < n2; ++i) {
            Object e = arrayList.get(i);
            if (!(e instanceof VRMLExternalNodeType) || (object3 = ((VRMLSingleExternalNodeType)e).getUrl()) == null || ((String[])object3).length == 0) continue;
            contentLoadDetails = new ContentLoadDetails();
            contentLoadDetails.fieldIndex = -1;
            contentLoadDetails.node = (VRMLExternalNodeType)e;
            object2 = (LoadRequest)this.inProgress.get(object3);
            if (object2 != null) {
                if (((LoadRequest)object2).loadList.contains(contentLoadDetails)) continue;
                ((LoadRequest)object2).loadList.add(contentLoadDetails);
                continue;
            }
            object = new ContentLoadHandler(fileCache);
            this.pending.add("externprotos", (String[])object3, (LoadRequestHandler)object, contentLoadDetails);
        }
        ArrayList arrayList2 = basicScene.getBySecondaryType(44);
        n2 = arrayList2.size();
        for (n = 0; n < n2; ++n) {
            object3 = arrayList2.get(n);
            if (object3 instanceof VRMLScriptNodeType) continue;
            object2 = ((VRMLSingleExternalNodeType)object3).getUrl();
            contentLoadDetails = new ContentLoadDetails();
            contentLoadDetails.fieldIndex = -1;
            contentLoadDetails.node = (VRMLExternalNodeType)object3;
            if (object2 == null || ((Object)object2).length == 0) continue;
            object = (LoadRequest)this.inProgress.get(object2);
            if (object != null) {
                if (!object.loadList.contains(contentLoadDetails)) {
                    object.loadList.add(contentLoadDetails);
                }
            } else {
                ContentLoadHandler contentLoadHandler = new ContentLoadHandler(fileCache);
                this.pending.add(this.findLoadConstant((VRMLNodeType)object3), (String[])object2, contentLoadHandler, contentLoadDetails);
            }
            ((VRMLExternalNodeType)object3).addUrlListener(this);
        }
        arrayList2 = basicScene.getBySecondaryType(30);
        n2 = arrayList2.size();
        for (n = 0; n < n2; ++n) {
            object2 = (VRMLMultiExternalNodeType)arrayList2.get(n);
            object = object2.getUrlFieldIndexes();
            for (int i = 0; i < ((int[])object).length; ++i) {
                String[] stringArray = object2.getUrl(object[i]);
                if (stringArray == null || stringArray.length == 0) continue;
                contentLoadDetails = new ContentLoadDetails();
                contentLoadDetails.fieldIndex = object[i];
                contentLoadDetails.node = object2;
                LoadRequest loadRequest = (LoadRequest)this.inProgress.get(stringArray);
                if (loadRequest != null) {
                    if (loadRequest.loadList.contains(contentLoadDetails)) continue;
                    loadRequest.loadList.add(contentLoadDetails);
                    continue;
                }
                ContentLoadHandler contentLoadHandler = new ContentLoadHandler(fileCache);
                this.pending.add(this.findLoadConstant((VRMLNodeType)object2), stringArray, contentLoadHandler, contentLoadDetails);
            }
            object2.addUrlListener(this);
        }
    }

    public void queueNodesLoad(NodeArray nodeArray) {
        int n = nodeArray.size();
        if (n == 0) {
            return;
        }
        FileCache fileCache = this.getCache();
        this.ayeShesDeadCapn();
        for (int i = 0; i < n; ++i) {
            String[] stringArray;
            Object[] objectArray;
            ContentLoadDetails contentLoadDetails;
            VRMLExternalNodeType vRMLExternalNodeType;
            VRMLNode vRMLNode = nodeArray.get(i);
            if (vRMLNode instanceof VRMLScriptNodeType) continue;
            if (vRMLNode instanceof VRMLSingleExternalNodeType) {
                vRMLExternalNodeType = (VRMLSingleExternalNodeType)((Object)vRMLNode);
                contentLoadDetails = new ContentLoadDetails();
                contentLoadDetails.fieldIndex = -1;
                contentLoadDetails.node = vRMLExternalNodeType;
                objectArray = vRMLExternalNodeType.getUrl();
                LoadRequest loadRequest = (LoadRequest)this.inProgress.get(objectArray);
                if (loadRequest != null) {
                    if (!loadRequest.loadList.contains(contentLoadDetails)) {
                        loadRequest.loadList.add(contentLoadDetails);
                    }
                } else {
                    stringArray = new ContentLoadHandler(fileCache);
                    this.pending.add(this.findLoadConstant((VRMLNodeType)vRMLNode), (String[])objectArray, (LoadRequestHandler)stringArray, contentLoadDetails);
                }
                vRMLExternalNodeType.addUrlListener(this);
                continue;
            }
            if (!(vRMLNode instanceof VRMLMultiExternalNodeType)) continue;
            vRMLExternalNodeType = (VRMLMultiExternalNodeType)((Object)vRMLNode);
            objectArray = vRMLExternalNodeType.getUrlFieldIndexes();
            for (int j = 0; j < objectArray.length; ++j) {
                contentLoadDetails = new ContentLoadDetails();
                contentLoadDetails.fieldIndex = objectArray[j];
                contentLoadDetails.node = vRMLExternalNodeType;
                stringArray = vRMLExternalNodeType.getUrl(objectArray[j]);
                LoadRequest loadRequest = (LoadRequest)this.inProgress.get(stringArray);
                if (loadRequest != null) {
                    if (loadRequest.loadList.contains(contentLoadDetails)) continue;
                    loadRequest.loadList.add(contentLoadDetails);
                    continue;
                }
                ContentLoadHandler contentLoadHandler = new ContentLoadHandler(fileCache);
                this.pending.add(this.findLoadConstant((VRMLNodeType)vRMLNode), stringArray, contentLoadHandler, contentLoadDetails);
            }
            vRMLExternalNodeType.addUrlListener(this);
        }
    }

    public void stopSceneLoad(BasicScene basicScene) {
        Object object;
        Object object2;
        VRMLExternalNodeType vRMLExternalNodeType;
        Object e;
        int n;
        if (basicScene == null) {
            return;
        }
        ArrayList arrayList = basicScene.getBySecondaryType(44);
        int n2 = arrayList.size();
        if (n2 == 0) {
            return;
        }
        for (n = 0; n < n2; ++n) {
            e = arrayList.get(n);
            vRMLExternalNodeType = (VRMLSingleExternalNodeType)e;
            object2 = new ContentLoadDetails();
            ((ContentLoadDetails)object2).fieldIndex = -1;
            ((ContentLoadDetails)object2).node = vRMLExternalNodeType;
            String[] stringArray = vRMLExternalNodeType.getUrl();
            if (this.inProgress.containsKey(stringArray)) {
                object = (LoadRequest)this.inProgress.get(stringArray);
                ((LoadRequest)object).loadList.remove(object2);
                continue;
            }
            this.pending.remove(stringArray, (LoadDetails)object2);
        }
        arrayList = basicScene.getBySecondaryType(30);
        n2 = arrayList.size();
        if (n2 == 0) {
            return;
        }
        for (n = 0; n < n2; ++n) {
            e = arrayList.get(n);
            vRMLExternalNodeType = (VRMLMultiExternalNodeType)e;
            object2 = vRMLExternalNodeType.getUrlFieldIndexes();
            for (int i = 0; i < ((Object)object2).length; ++i) {
                object = new ContentLoadDetails();
                ((ContentLoadDetails)object).fieldIndex = (int)object2[i];
                ((ContentLoadDetails)object).node = vRMLExternalNodeType;
                String[] stringArray = vRMLExternalNodeType.getUrl((int)object2[i]);
                if (this.inProgress.containsKey(stringArray)) {
                    LoadRequest loadRequest = (LoadRequest)this.inProgress.get(stringArray);
                    loadRequest.loadList.remove(object);
                    continue;
                }
                this.pending.remove(stringArray, (LoadDetails)object);
            }
        }
    }

    public void clear() {
        this.pending.clear();
        this.loaderPool.clear();
    }

    public void urlChanged(VRMLNodeType vRMLNodeType, int n) {
        FileCache fileCache = this.getCache();
        ContentLoadDetails contentLoadDetails = new ContentLoadDetails();
        String[] stringArray = null;
        if (vRMLNodeType instanceof VRMLSingleExternalNodeType) {
            VRMLSingleExternalNodeType vRMLSingleExternalNodeType = (VRMLSingleExternalNodeType)((Object)vRMLNodeType);
            stringArray = vRMLSingleExternalNodeType.getUrl();
            if (stringArray == null || stringArray.length == 0) {
                return;
            }
            vRMLSingleExternalNodeType.setLoadState(1);
            contentLoadDetails.fieldIndex = -1;
            contentLoadDetails.node = vRMLSingleExternalNodeType;
            ContentLoadHandler contentLoadHandler = new ContentLoadHandler(fileCache);
            this.pending.add(this.findLoadConstant(vRMLNodeType), stringArray, contentLoadHandler, contentLoadDetails);
        } else {
            VRMLMultiExternalNodeType vRMLMultiExternalNodeType = (VRMLMultiExternalNodeType)((Object)vRMLNodeType);
            stringArray = vRMLMultiExternalNodeType.getUrl(n);
            if (stringArray == null || stringArray.length == 0) {
                return;
            }
            vRMLMultiExternalNodeType.setLoadState(n, 1);
            contentLoadDetails.fieldIndex = n;
            contentLoadDetails.node = vRMLMultiExternalNodeType;
            ContentLoadHandler contentLoadHandler = new ContentLoadHandler(fileCache);
            this.pending.add(this.findLoadConstant(vRMLNodeType), stringArray, contentLoadHandler, contentLoadDetails);
        }
    }

    public int getNumberInProgress() {
        int n = this.pending.size() + this.inProgress.size();
        return n;
    }

    public void shutdown() {
        this.loaderPool.shutdown();
    }

    protected abstract FileCache getCache();

    private void ayeShesDeadCapn() {
        this.loaderPool.restartThreads();
    }

    private String findLoadConstant(VRMLNodeType vRMLNodeType) {
        switch (vRMLNodeType.getPrimaryType()) {
            case 4: 
            case 50: {
                int[] nArray = vRMLNodeType.getSecondaryType();
                if (nArray != null) {
                    for (int i = 0; i < nArray.length; ++i) {
                        if (nArray[i] != 3) continue;
                        return "movies";
                    }
                }
                return "textures";
            }
            case 41: {
                return "scripts";
            }
            case 3: {
                return "audio";
            }
            case 91: {
                return "shaders";
            }
            case 24: {
                return "inlines";
            }
            case 38: {
                return "externprotos";
            }
        }
        return "others";
    }
}

