catch {load vtktcl}
if { [catch {set VTK_TCL $env(VTK_TCL)}] != 0} { set VTK_TCL "../../examplesTcl" }
if { [catch {set VTK_DATA $env(VTK_DATA)}] != 0} { set VTK_DATA "../../../vtkdata" }

#
# this is a tcl version of the Mace example
# get the interactor ui

source $VTK_TCL/vtkInt.tcl

# Create the rendering stuff
vtkRenderer ren
  ren SetBackground 1 1 1 
vtkRenderWindow renWin
  renWin AddRenderer ren 
  renWin SetSize 300  300 
vtkRenderWindowInteractor iren
  iren SetRenderWindow renWin 

# Create a structured grid data set with scalar point data
# generated by a quadric
vtkStructuredGrid sg
  sg SetDimensions 50  50  50 
vtkPoints points
vtkScalars scalars
vtkQuadric quadric
  quadric SetCoefficients .5 1 .2 0 .1 0 0 .2 0 0 
for  {set k 0} { $k<50 } {incr k} {
  set z $k
  for {set j 0} {$j<50} {incr j} {
    set y $j
    for {set i 0 } {$i <50} {incr i} {
      set x $i
      points InsertNextPoint $x $y $z
      scalars InsertNextScalar [quadric EvaluateFunction $x $y $z]
    }
  }
}
sg SetPoints points 
[sg GetPointData]   SetScalars scalars 
points Delete  
scalars Delete  

vtkExtractGrid extractGrid
  extractGrid SetInput sg 
  extractGrid SetVOI 10  40  10  40  10  40 
  extractGrid SetSampleRate -1 2 3

# Perform lower threshold on data set to create actor 1
vtkThreshold threshold1
  threshold1 SetInput [extractGrid GetOutput]
  threshold1 ThresholdByLower 1000 

vtkDataSetMapper mapper1
  mapper1 SetInput [threshold1 GetOutput]
  mapper1 SetScalarRange 0  4000 

vtkActor actor1
  actor1 SetMapper mapper1 
ren AddActor actor1 

# Perform upper threshold on data set to create actor 2
vtkThreshold threshold2
  threshold2 SetInput [extractGrid GetOutput]
  threshold2 ThresholdByUpper 1500 

vtkDataSetMapper mapper2
  mapper2 SetInput [threshold2 GetOutput]
  mapper2 SetScalarRange 0  4000 

vtkActor actor2
  actor2 SetMapper mapper2 
ren AddActor actor2 

# Render and interact
renWin Render  
iren SetUserMethod {wm deiconify .vtkInteract}
iren Initialize

vtkWindowToImageFilter windowToImage
  windowToImage SetInput renWin

vtkTIFFWriter tiffimage
  tiffimage SetInput [windowToImage GetOutput]
  tiffimage SetFileName extractGrid.tcl.tif
#  tiffimage Write

# prevent the tk window from showing up then start the event loop
wm withdraw .

