#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/* warning this code is also in getclasses.cxx under pcmaker */
/* this roputine creates the init file */
static void CreateInitFile(const char *libName,
  int numFiles, char **files,
  FILE *fout)
{
  int i;

#if defined(_WIN32) && !defined(__CYGWIN__)
  const char* prefix = "";
#else
  const char* prefix = "lib";
#endif

#if defined(_WIN32)
  const char* dllexp = "__declspec(dllexport) ";
#else
  const char* dllexp = "";
#endif

  fprintf(fout,"// Generated by vtkWrapPythonInit in VTK/Wrapping\n");
  fprintf(fout,"#include \"vtkPython.h\"\n\n");
  fprintf(fout,"#include \"vtkSystemIncludes.h\"\n");
  fprintf(fout,"#include <string.h>\n");
  fprintf(fout,"// Handle compiler warning messages, etc.\n"
          "#if defined( _MSC_VER ) && !defined(VTK_DISPLAY_WIN32_WARNINGS)\n"
          "#pragma warning ( disable : 4706 )\n"
          "#endif // Windows Warnings \n\n");

for (i = 0; i < numFiles; i++)
    {
    fprintf(fout,"extern  \"C\" {%sPyObject *PyVTKAddFile_%s(PyObject *, const char *); }\n", dllexp, files[i]);
    }

  fprintf(fout,"\nstatic PyMethodDef Py%s_ClassMethods[] = {\n", libName);
  fprintf(fout,"{NULL, NULL, 0, NULL}};\n\n");

  fprintf(fout,"extern  \"C\" {%svoid init%s%s();}\n\n", dllexp, prefix, libName);
  fprintf(fout,"void init%s%s()\n{\n", prefix, libName);

  /* module init function */
  fprintf(fout,"  PyObject *m, *d;\n\n");
  fprintf(fout,"  static const char modulename[] = \"%s%s\";\n", prefix, libName);
  fprintf(fout,"  m = Py_InitModule((char*)modulename, Py%s_ClassMethods);\n",
    libName);

  fprintf(fout,"  d = PyModule_GetDict(m);\n");
  fprintf(fout,"  if (!d)\n");
  fprintf(fout,"    {\n");
  fprintf(fout,"    Py_FatalError((char*)\"can't get dictionary for module %s\");\n",
    libName);
  fprintf(fout,"    }\n");

  for (i = 0; i < numFiles; i++)
    {
    fprintf(fout,"  PyVTKAddFile_%s(d, modulename);\n",
      files[i]);
    }
  fprintf(fout,"}\n\n");
}


int main(int argc,char *argv[])
{
  FILE *file;
  FILE *fout;
  int numFiles = 0;
  char libName[250];
  char tmpVal[250];
  char *files[4000];

  if (argc < 3)
    {
    fprintf(stderr,"Usage: %s input_file output_file\n",argv[0]);
    return 1;
    }

  file = fopen(argv[1],"r");
  if (!file)
    {
    fprintf(stderr,"Input file %s could not be opened\n",argv[1]);
    return 1;
    }

  fout = fopen(argv[2],"w");
  if (!fout)
    {
    fclose(file);
    return 1;
    }

  /* read the info from the file */
  fscanf(file,"%s",libName);

  /* read in the classes */
  while (fscanf(file,"%s",tmpVal) != EOF)
    {
    files[numFiles] = strdup(tmpVal);
    numFiles++;
    }
  /* close the file */
  fclose(file);

  CreateInitFile(libName, numFiles, files, fout);
  fclose(fout);

  return 0;
}
