// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-FileCopyrightText: Copyright 2008 Sandia Corporation
// SPDX-License-Identifier: LicenseRef-BSD-3-Clause-Sandia-USGov
#include "vtkCellData.h"
#include "vtkCommand.h"
#include "vtkDataRepresentation.h"
#include "vtkGraphLayoutView.h"
#include "vtkIdTypeArray.h"
#include "vtkInteractorEventRecorder.h"
#include "vtkRegressionTestImage.h"
#include "vtkRenderWindow.h"
#include "vtkRenderWindowInteractor.h"
#include "vtkRenderedGraphRepresentation.h"
#include "vtkRenderer.h"
#include "vtkScalarBarActor.h"
#include "vtkScalarBarWidget.h"
#include "vtkStringArray.h"
#include "vtkStringToNumeric.h"
#include "vtkTestUtilities.h"
#include "vtkXMLTreeReader.h"

using std::string;

#include "vtkSmartPointer.h"
#define VTK_CREATE(type, name) vtkSmartPointer<type> name = vtkSmartPointer<type>::New()

static char GraphLayoutViewEventLog[] = "# StreamVersion 1\n"
                                        "RenderEvent 0 0 0 0 0 0 0\n"
                                        "EnterEvent 291 110 0 0 0 0 0\n"
                                        "MouseMoveEvent 291 110 0 0 0 0 0\n"
                                        "MouseMoveEvent 284 114 0 0 0 0 0\n"
                                        "MouseMoveEvent 277 117 0 0 0 0 0\n"
                                        "MouseMoveEvent 272 120 0 0 0 0 0\n"
                                        "MouseMoveEvent 267 122 0 0 0 0 0\n"
                                        "MouseMoveEvent 261 125 0 0 0 0 0\n"
                                        "MouseMoveEvent 256 128 0 0 0 0 0\n"
                                        "MouseMoveEvent 249 130 0 0 0 0 0\n"
                                        "MouseMoveEvent 244 133 0 0 0 0 0\n"
                                        "MouseMoveEvent 240 134 0 0 0 0 0\n"
                                        "MouseMoveEvent 238 136 0 0 0 0 0\n"
                                        "MouseMoveEvent 235 137 0 0 0 0 0\n"
                                        "MouseMoveEvent 231 138 0 0 0 0 0\n"
                                        "MouseMoveEvent 229 140 0 0 0 0 0\n"
                                        "MouseMoveEvent 225 142 0 0 0 0 0\n"
                                        "MouseMoveEvent 222 143 0 0 0 0 0\n"
                                        "MouseMoveEvent 217 145 0 0 0 0 0\n"
                                        "MouseMoveEvent 212 148 0 0 0 0 0\n"
                                        "MouseMoveEvent 208 149 0 0 0 0 0\n"
                                        "MouseMoveEvent 205 150 0 0 0 0 0\n"
                                        "MouseMoveEvent 200 152 0 0 0 0 0\n"
                                        "MouseMoveEvent 197 154 0 0 0 0 0\n"
                                        "MouseMoveEvent 192 156 0 0 0 0 0\n"
                                        "MouseMoveEvent 188 157 0 0 0 0 0\n"
                                        "MouseMoveEvent 185 158 0 0 0 0 0\n"
                                        "MouseMoveEvent 180 160 0 0 0 0 0\n"
                                        "MouseMoveEvent 177 160 0 0 0 0 0\n"
                                        "MouseMoveEvent 174 161 0 0 0 0 0\n"
                                        "MouseMoveEvent 172 161 0 0 0 0 0\n"
                                        "MouseMoveEvent 171 162 0 0 0 0 0\n"
                                        "MouseMoveEvent 169 162 0 0 0 0 0\n"
                                        "MouseMoveEvent 167 162 0 0 0 0 0\n"
                                        "MouseMoveEvent 165 162 0 0 0 0 0\n"
                                        "MouseMoveEvent 164 162 0 0 0 0 0\n"
                                        "MouseMoveEvent 162 162 0 0 0 0 0\n"
                                        "MouseMoveEvent 160 162 0 0 0 0 0\n"
                                        "MouseMoveEvent 158 162 0 0 0 0 0\n"
                                        "MouseMoveEvent 156 162 0 0 0 0 0\n"
                                        "MouseMoveEvent 155 162 0 0 0 0 0\n"
                                        "MouseMoveEvent 153 162 0 0 0 0 0\n"
                                        "MouseMoveEvent 152 162 0 0 0 0 0\n"
                                        "MouseMoveEvent 151 162 0 0 0 0 0\n"
                                        "MouseMoveEvent 149 162 0 0 0 0 0\n"
                                        "MouseMoveEvent 148 162 0 0 0 0 0\n"
                                        "MouseMoveEvent 147 162 0 0 0 0 0\n"
                                        "MouseMoveEvent 146 162 0 0 0 0 0\n"
                                        "MouseMoveEvent 145 162 0 0 0 0 0\n"
                                        "MouseMoveEvent 144 162 0 0 0 0 0\n"
                                        "MiddleButtonPressEvent 144 162 0 0 0 0 0\n"
                                        "StartInteractionEvent 144 162 0 0 0 0 0\n"
                                        "MouseMoveEvent 144 164 0 0 0 0 0\n"
                                        "RenderEvent 144 164 0 0 0 0 0\n"
                                        "MouseMoveEvent 144 166 0 0 0 0 0\n"
                                        "RenderEvent 144 166 0 0 0 0 0\n"
                                        "MouseMoveEvent 144 169 0 0 0 0 0\n"
                                        "RenderEvent 144 169 0 0 0 0 0\n"
                                        "MouseMoveEvent 144 171 0 0 0 0 0\n"
                                        "RenderEvent 144 171 0 0 0 0 0\n"
                                        "MouseMoveEvent 144 174 0 0 0 0 0\n"
                                        "RenderEvent 144 174 0 0 0 0 0\n"
                                        "MouseMoveEvent 144 176 0 0 0 0 0\n"
                                        "RenderEvent 144 176 0 0 0 0 0\n"
                                        "MouseMoveEvent 144 179 0 0 0 0 0\n"
                                        "RenderEvent 144 179 0 0 0 0 0\n"
                                        "MouseMoveEvent 144 181 0 0 0 0 0\n"
                                        "RenderEvent 144 181 0 0 0 0 0\n"
                                        "MouseMoveEvent 144 185 0 0 0 0 0\n"
                                        "RenderEvent 144 185 0 0 0 0 0\n"
                                        "MouseMoveEvent 144 187 0 0 0 0 0\n"
                                        "RenderEvent 144 187 0 0 0 0 0\n"
                                        "MouseMoveEvent 144 189 0 0 0 0 0\n"
                                        "RenderEvent 144 189 0 0 0 0 0\n"
                                        "MouseMoveEvent 144 193 0 0 0 0 0\n"
                                        "RenderEvent 144 193 0 0 0 0 0\n"
                                        "MouseMoveEvent 144 195 0 0 0 0 0\n"
                                        "RenderEvent 144 195 0 0 0 0 0\n"
                                        "MouseMoveEvent 144 196 0 0 0 0 0\n"
                                        "RenderEvent 144 196 0 0 0 0 0\n"
                                        "MouseMoveEvent 144 198 0 0 0 0 0\n"
                                        "RenderEvent 144 198 0 0 0 0 0\n"
                                        "MouseMoveEvent 144 199 0 0 0 0 0\n"
                                        "RenderEvent 144 199 0 0 0 0 0\n"
                                        "MouseMoveEvent 144 200 0 0 0 0 0\n"
                                        "RenderEvent 144 200 0 0 0 0 0\n"
                                        "MouseMoveEvent 144 199 0 0 0 0 0\n"
                                        "RenderEvent 144 199 0 0 0 0 0\n"
                                        "MouseMoveEvent 144 198 0 0 0 0 0\n"
                                        "RenderEvent 144 198 0 0 0 0 0\n"
                                        "MouseMoveEvent 143 195 0 0 0 0 0\n"
                                        "RenderEvent 143 195 0 0 0 0 0\n"
                                        "MouseMoveEvent 141 193 0 0 0 0 0\n"
                                        "RenderEvent 141 193 0 0 0 0 0\n"
                                        "MouseMoveEvent 140 188 0 0 0 0 0\n"
                                        "RenderEvent 140 188 0 0 0 0 0\n"
                                        "MouseMoveEvent 139 184 0 0 0 0 0\n"
                                        "RenderEvent 139 184 0 0 0 0 0\n"
                                        "MouseMoveEvent 138 179 0 0 0 0 0\n"
                                        "RenderEvent 138 179 0 0 0 0 0\n"
                                        "MouseMoveEvent 137 177 0 0 0 0 0\n"
                                        "RenderEvent 137 177 0 0 0 0 0\n"
                                        "MouseMoveEvent 136 173 0 0 0 0 0\n"
                                        "RenderEvent 136 173 0 0 0 0 0\n"
                                        "MouseMoveEvent 135 168 0 0 0 0 0\n"
                                        "RenderEvent 135 168 0 0 0 0 0\n"
                                        "MouseMoveEvent 135 167 0 0 0 0 0\n"
                                        "RenderEvent 135 167 0 0 0 0 0\n"
                                        "MouseMoveEvent 135 164 0 0 0 0 0\n"
                                        "RenderEvent 135 164 0 0 0 0 0\n"
                                        "MouseMoveEvent 135 161 0 0 0 0 0\n"
                                        "RenderEvent 135 161 0 0 0 0 0\n"
                                        "MouseMoveEvent 135 159 0 0 0 0 0\n"
                                        "RenderEvent 135 159 0 0 0 0 0\n"
                                        "MouseMoveEvent 135 156 0 0 0 0 0\n"
                                        "RenderEvent 135 156 0 0 0 0 0\n"
                                        "MouseMoveEvent 137 152 0 0 0 0 0\n"
                                        "RenderEvent 137 152 0 0 0 0 0\n"
                                        "MouseMoveEvent 139 149 0 0 0 0 0\n"
                                        "RenderEvent 139 149 0 0 0 0 0\n"
                                        "MouseMoveEvent 139 147 0 0 0 0 0\n"
                                        "RenderEvent 139 147 0 0 0 0 0\n"
                                        "MouseMoveEvent 139 146 0 0 0 0 0\n"
                                        "RenderEvent 139 146 0 0 0 0 0\n"
                                        "MiddleButtonReleaseEvent 139 146 0 0 0 0 0\n"
                                        "EndInteractionEvent 139 146 0 0 0 0 0\n"
                                        "MouseMoveEvent 139 146 0 0 0 0 0\n"
                                        "MouseMoveEvent 138 146 0 0 0 0 0\n"
                                        "MouseMoveEvent 137 146 0 0 0 0 0\n"
                                        "MouseMoveEvent 136 146 0 0 0 0 0\n"
                                        "LeftButtonPressEvent 136 146 0 0 0 0 0\n"
                                        "StartInteractionEvent 136 146 0 0 0 0 0\n"
                                        "MouseMoveEvent 136 148 0 0 0 0 0\n"
                                        "MouseMoveEvent 136 150 0 0 0 0 0\n"
                                        "MouseMoveEvent 136 151 0 0 0 0 0\n"
                                        "MouseMoveEvent 135 152 0 0 0 0 0\n"
                                        "MouseMoveEvent 135 154 0 0 0 0 0\n"
                                        "MouseMoveEvent 135 156 0 0 0 0 0\n"
                                        "MouseMoveEvent 135 158 0 0 0 0 0\n"
                                        "MouseMoveEvent 134 160 0 0 0 0 0\n"
                                        "MouseMoveEvent 134 162 0 0 0 0 0\n"
                                        "MouseMoveEvent 134 165 0 0 0 0 0\n"
                                        "MouseMoveEvent 133 167 0 0 0 0 0\n"
                                        "MouseMoveEvent 133 168 0 0 0 0 0\n"
                                        "MouseMoveEvent 133 169 0 0 0 0 0\n"
                                        "MouseMoveEvent 133 171 0 0 0 0 0\n"
                                        "MouseMoveEvent 133 172 0 0 0 0 0\n"
                                        "MouseMoveEvent 133 173 0 0 0 0 0\n"
                                        "MouseMoveEvent 133 174 0 0 0 0 0\n"
                                        "MouseMoveEvent 133 177 0 0 0 0 0\n"
                                        "MouseMoveEvent 133 178 0 0 0 0 0\n"
                                        "MouseMoveEvent 133 180 0 0 0 0 0\n"
                                        "MouseMoveEvent 133 181 0 0 0 0 0\n"
                                        "MouseMoveEvent 133 183 0 0 0 0 0\n"
                                        "MouseMoveEvent 133 185 0 0 0 0 0\n"
                                        "MouseMoveEvent 133 188 0 0 0 0 0\n"
                                        "MouseMoveEvent 133 191 0 0 0 0 0\n"
                                        "MouseMoveEvent 133 192 0 0 0 0 0\n"
                                        "MouseMoveEvent 133 194 0 0 0 0 0\n"
                                        "MouseMoveEvent 133 196 0 0 0 0 0\n"
                                        "MouseMoveEvent 133 198 0 0 0 0 0\n"
                                        "MouseMoveEvent 133 200 0 0 0 0 0\n"
                                        "MouseMoveEvent 133 201 0 0 0 0 0\n"
                                        "MouseMoveEvent 133 202 0 0 0 0 0\n"
                                        "MouseMoveEvent 133 203 0 0 0 0 0\n"
                                        "MouseMoveEvent 133 204 0 0 0 0 0\n"
                                        "MouseMoveEvent 133 206 0 0 0 0 0\n"
                                        "MouseMoveEvent 133 207 0 0 0 0 0\n"
                                        "MouseMoveEvent 133 208 0 0 0 0 0\n"
                                        "MouseMoveEvent 133 210 0 0 0 0 0\n"
                                        "MouseMoveEvent 133 212 0 0 0 0 0\n"
                                        "MouseMoveEvent 133 213 0 0 0 0 0\n"
                                        "MouseMoveEvent 133 214 0 0 0 0 0\n"
                                        "MouseMoveEvent 133 216 0 0 0 0 0\n"
                                        "MouseMoveEvent 133 217 0 0 0 0 0\n"
                                        "MouseMoveEvent 133 219 0 0 0 0 0\n"
                                        "MouseMoveEvent 133 220 0 0 0 0 0\n"
                                        "MouseMoveEvent 133 221 0 0 0 0 0\n"
                                        "MouseMoveEvent 133 223 0 0 0 0 0\n"
                                        "MouseMoveEvent 133 224 0 0 0 0 0\n"
                                        "MouseMoveEvent 134 224 0 0 0 0 0\n"
                                        "MouseMoveEvent 136 225 0 0 0 0 0\n"
                                        "MouseMoveEvent 137 225 0 0 0 0 0\n"
                                        "MouseMoveEvent 139 226 0 0 0 0 0\n"
                                        "MouseMoveEvent 140 226 0 0 0 0 0\n"
                                        "MouseMoveEvent 142 227 0 0 0 0 0\n"
                                        "MouseMoveEvent 144 227 0 0 0 0 0\n"
                                        "MouseMoveEvent 147 228 0 0 0 0 0\n"
                                        "MouseMoveEvent 150 228 0 0 0 0 0\n"
                                        "MouseMoveEvent 152 229 0 0 0 0 0\n"
                                        "MouseMoveEvent 155 229 0 0 0 0 0\n"
                                        "MouseMoveEvent 157 229 0 0 0 0 0\n"
                                        "MouseMoveEvent 158 229 0 0 0 0 0\n"
                                        "MouseMoveEvent 160 230 0 0 0 0 0\n"
                                        "MouseMoveEvent 161 230 0 0 0 0 0\n"
                                        "MouseMoveEvent 162 230 0 0 0 0 0\n"
                                        "MouseMoveEvent 164 230 0 0 0 0 0\n"
                                        "MouseMoveEvent 167 230 0 0 0 0 0\n"
                                        "MouseMoveEvent 170 230 0 0 0 0 0\n"
                                        "MouseMoveEvent 173 230 0 0 0 0 0\n"
                                        "MouseMoveEvent 175 230 0 0 0 0 0\n"
                                        "MouseMoveEvent 177 230 0 0 0 0 0\n"
                                        "MouseMoveEvent 180 230 0 0 0 0 0\n"
                                        "MouseMoveEvent 181 230 0 0 0 0 0\n"
                                        "MouseMoveEvent 184 230 0 0 0 0 0\n"
                                        "MouseMoveEvent 186 230 0 0 0 0 0\n"
                                        "MouseMoveEvent 187 230 0 0 0 0 0\n"
                                        "MouseMoveEvent 189 230 0 0 0 0 0\n"
                                        "MouseMoveEvent 192 230 0 0 0 0 0\n"
                                        "MouseMoveEvent 194 230 0 0 0 0 0\n"
                                        "MouseMoveEvent 197 230 0 0 0 0 0\n"
                                        "MouseMoveEvent 200 230 0 0 0 0 0\n"
                                        "MouseMoveEvent 203 230 0 0 0 0 0\n"
                                        "MouseMoveEvent 206 229 0 0 0 0 0\n"
                                        "MouseMoveEvent 208 229 0 0 0 0 0\n"
                                        "MouseMoveEvent 210 229 0 0 0 0 0\n"
                                        "MouseMoveEvent 211 229 0 0 0 0 0\n"
                                        "MouseMoveEvent 212 229 0 0 0 0 0\n"
                                        "MouseMoveEvent 214 229 0 0 0 0 0\n"
                                        "MouseMoveEvent 216 229 0 0 0 0 0\n"
                                        "MouseMoveEvent 218 229 0 0 0 0 0\n"
                                        "MouseMoveEvent 219 229 0 0 0 0 0\n"
                                        "MouseMoveEvent 221 229 0 0 0 0 0\n"
                                        "MouseMoveEvent 223 229 0 0 0 0 0\n"
                                        "MouseMoveEvent 224 229 0 0 0 0 0\n"
                                        "MouseMoveEvent 231 230 0 0 0 0 0\n"
                                        "MouseMoveEvent 234 230 0 0 0 0 0\n"
                                        "MouseMoveEvent 237 230 0 0 0 0 0\n"
                                        "MouseMoveEvent 240 230 0 0 0 0 0\n"
                                        "MouseMoveEvent 242 230 0 0 0 0 0\n"
                                        "MouseMoveEvent 244 230 0 0 0 0 0\n"
                                        "MouseMoveEvent 245 230 0 0 0 0 0\n"
                                        "MouseMoveEvent 246 230 0 0 0 0 0\n"
                                        "MouseMoveEvent 247 230 0 0 0 0 0\n"
                                        "MouseMoveEvent 248 230 0 0 0 0 0\n"
                                        "MouseMoveEvent 249 230 0 0 0 0 0\n"
                                        "MouseMoveEvent 250 230 0 0 0 0 0\n"
                                        "MouseMoveEvent 251 230 0 0 0 0 0\n"
                                        "MouseMoveEvent 252 230 0 0 0 0 0\n"
                                        "MouseMoveEvent 254 230 0 0 0 0 0\n"
                                        "MouseMoveEvent 256 230 0 0 0 0 0\n"
                                        "MouseMoveEvent 258 230 0 0 0 0 0\n"
                                        "MouseMoveEvent 260 230 0 0 0 0 0\n"
                                        "MouseMoveEvent 261 230 0 0 0 0 0\n"
                                        "MouseMoveEvent 262 230 0 0 0 0 0\n"
                                        "MouseMoveEvent 263 230 0 0 0 0 0\n"
                                        "MouseMoveEvent 265 231 0 0 0 0 0\n"
                                        "MouseMoveEvent 266 232 0 0 0 0 0\n"
                                        "MouseMoveEvent 267 232 0 0 0 0 0\n"
                                        "MouseMoveEvent 267 233 0 0 0 0 0\n"
                                        "MouseMoveEvent 268 234 0 0 0 0 0\n"
                                        "MouseMoveEvent 269 235 0 0 0 0 0\n"
                                        "MouseMoveEvent 270 235 0 0 0 0 0\n"
                                        "MouseMoveEvent 271 237 0 0 0 0 0\n"
                                        "MouseMoveEvent 272 237 0 0 0 0 0\n"
                                        "MouseMoveEvent 272 238 0 0 0 0 0\n"
                                        "MouseMoveEvent 273 239 0 0 0 0 0\n"
                                        "MouseMoveEvent 274 239 0 0 0 0 0\n"
                                        "MouseMoveEvent 274 241 0 0 0 0 0\n"
                                        "MouseMoveEvent 275 242 0 0 0 0 0\n"
                                        "MouseMoveEvent 275 243 0 0 0 0 0\n"
                                        "MouseMoveEvent 276 244 0 0 0 0 0\n"
                                        "MouseMoveEvent 276 245 0 0 0 0 0\n"
                                        "MouseMoveEvent 277 246 0 0 0 0 0\n"
                                        "MouseMoveEvent 278 247 0 0 0 0 0\n"
                                        "LeftButtonReleaseEvent 278 247 0 0 0 0 0\n"
                                        "EndInteractionEvent 278 247 0 0 0 0 0\n"
                                        "MouseMoveEvent 278 247 0 0 0 0 0\n"
                                        "MouseMoveEvent 277 247 0 0 0 0 0\n"
                                        "MouseMoveEvent 276 247 0 0 0 0 0\n"
                                        "MouseMoveEvent 275 247 0 0 0 0 0\n"
                                        "MouseMoveEvent 274 247 0 0 0 0 0\n"
                                        "MouseMoveEvent 273 247 0 0 0 0 0\n"
                                        "MouseMoveEvent 272 246 0 0 0 0 0\n"
                                        "MouseMoveEvent 270 246 0 0 0 0 0\n"
                                        "MouseMoveEvent 269 244 0 0 0 0 0\n"
                                        "MouseMoveEvent 268 244 0 0 0 0 0\n"
                                        "MouseMoveEvent 266 244 0 0 0 0 0\n"
                                        "MouseMoveEvent 266 243 0 0 0 0 0\n"
                                        "MouseMoveEvent 264 243 0 0 0 0 0\n"
                                        "MouseMoveEvent 263 241 0 0 0 0 0\n"
                                        "MouseMoveEvent 262 241 0 0 0 0 0\n"
                                        "MouseMoveEvent 260 240 0 0 0 0 0\n"
                                        "MouseMoveEvent 259 238 0 0 0 0 0\n"
                                        "MouseMoveEvent 257 237 0 0 0 0 0\n"
                                        "MouseMoveEvent 253 235 0 0 0 0 0\n"
                                        "MouseMoveEvent 250 233 0 0 0 0 0\n"
                                        "MouseMoveEvent 246 230 0 0 0 0 0\n"
                                        "MouseMoveEvent 242 226 0 0 0 0 0\n"
                                        "MouseMoveEvent 236 222 0 0 0 0 0\n"
                                        "MouseMoveEvent 228 218 0 0 0 0 0\n"
                                        "MouseMoveEvent 222 214 0 0 0 0 0\n"
                                        "MouseMoveEvent 216 210 0 0 0 0 0\n"
                                        "MouseMoveEvent 212 207 0 0 0 0 0\n"
                                        "MouseMoveEvent 207 203 0 0 0 0 0\n"
                                        "MouseMoveEvent 201 199 0 0 0 0 0\n"
                                        "MouseMoveEvent 195 195 0 0 0 0 0\n"
                                        "MouseMoveEvent 189 191 0 0 0 0 0\n"
                                        "MouseMoveEvent 183 188 0 0 0 0 0\n"
                                        "MouseMoveEvent 177 184 0 0 0 0 0\n"
                                        "MouseMoveEvent 172 181 0 0 0 0 0\n"
                                        "MouseMoveEvent 169 178 0 0 0 0 0\n"
                                        "MouseMoveEvent 166 175 0 0 0 0 0\n"
                                        "MouseMoveEvent 164 172 0 0 0 0 0\n"
                                        "MouseMoveEvent 162 169 0 0 0 0 0\n"
                                        "MouseMoveEvent 161 168 0 0 0 0 0\n"
                                        "MouseMoveEvent 161 165 0 0 0 0 0\n"
                                        "MouseMoveEvent 159 163 0 0 0 0 0\n"
                                        "MouseMoveEvent 158 162 0 0 0 0 0\n"
                                        "MouseMoveEvent 158 160 0 0 0 0 0\n"
                                        "MouseMoveEvent 157 160 0 0 0 0 0\n"
                                        "MouseMoveEvent 157 159 0 0 0 0 0\n"
                                        "MouseMoveEvent 156 158 0 0 0 0 0\n"
                                        "MouseMoveEvent 155 157 0 0 0 0 0\n"
                                        "MouseMoveEvent 155 156 0 0 0 0 0\n"
                                        "MouseMoveEvent 154 155 0 0 0 0 0\n"
                                        "MouseMoveEvent 154 154 0 0 0 0 0\n"
                                        "MouseMoveEvent 153 153 0 0 0 0 0\n"
                                        "RightButtonPressEvent 153 153 0 0 0 0 0\n"
                                        "StartInteractionEvent 153 153 0 0 0 0 0\n"
                                        "MouseMoveEvent 153 156 0 0 0 0 0\n"
                                        "RenderEvent 153 156 0 0 0 0 0\n"
                                        "MouseMoveEvent 153 167 0 0 0 0 0\n"
                                        "RenderEvent 153 167 0 0 0 0 0\n"
                                        "MouseMoveEvent 153 177 0 0 0 0 0\n"
                                        "RenderEvent 153 177 0 0 0 0 0\n"
                                        "MouseMoveEvent 153 182 0 0 0 0 0\n"
                                        "RenderEvent 153 182 0 0 0 0 0\n"
                                        "MouseMoveEvent 153 186 0 0 0 0 0\n"
                                        "RenderEvent 153 186 0 0 0 0 0\n"
                                        "MouseMoveEvent 153 191 0 0 0 0 0\n"
                                        "RenderEvent 153 191 0 0 0 0 0\n"
                                        "MouseMoveEvent 153 194 0 0 0 0 0\n"
                                        "RenderEvent 153 194 0 0 0 0 0\n"
                                        "MouseMoveEvent 153 198 0 0 0 0 0\n"
                                        "RenderEvent 153 198 0 0 0 0 0\n"
                                        "MouseMoveEvent 153 203 0 0 0 0 0\n"
                                        "RenderEvent 153 203 0 0 0 0 0\n"
                                        "MouseMoveEvent 153 207 0 0 0 0 0\n"
                                        "RenderEvent 153 207 0 0 0 0 0\n"
                                        "MouseMoveEvent 153 210 0 0 0 0 0\n"
                                        "RenderEvent 153 210 0 0 0 0 0\n"
                                        "MouseMoveEvent 153 214 0 0 0 0 0\n"
                                        "RenderEvent 153 214 0 0 0 0 0\n"
                                        "MouseMoveEvent 153 220 0 0 0 0 0\n"
                                        "RenderEvent 153 220 0 0 0 0 0\n"
                                        "MouseMoveEvent 153 229 0 0 0 0 0\n"
                                        "RenderEvent 153 229 0 0 0 0 0\n"
                                        "MouseMoveEvent 153 234 0 0 0 0 0\n"
                                        "RenderEvent 153 234 0 0 0 0 0\n"
                                        "MouseMoveEvent 153 239 0 0 0 0 0\n"
                                        "RenderEvent 153 239 0 0 0 0 0\n"
                                        "MouseMoveEvent 153 245 0 0 0 0 0\n"
                                        "RenderEvent 153 245 0 0 0 0 0\n"
                                        "MouseMoveEvent 153 250 0 0 0 0 0\n"
                                        "RenderEvent 153 250 0 0 0 0 0\n"
                                        "MouseMoveEvent 153 254 0 0 0 0 0\n"
                                        "RenderEvent 153 254 0 0 0 0 0\n"
                                        "MouseMoveEvent 153 256 0 0 0 0 0\n"
                                        "RenderEvent 153 256 0 0 0 0 0\n"
                                        "MouseMoveEvent 153 257 0 0 0 0 0\n"
                                        "RenderEvent 153 257 0 0 0 0 0\n"
                                        "MouseMoveEvent 153 258 0 0 0 0 0\n"
                                        "RenderEvent 153 258 0 0 0 0 0\n"
                                        "MouseMoveEvent 152 257 0 0 0 0 0\n"
                                        "RenderEvent 152 257 0 0 0 0 0\n"
                                        "MouseMoveEvent 151 254 0 0 0 0 0\n"
                                        "RenderEvent 151 254 0 0 0 0 0\n"
                                        "MouseMoveEvent 150 250 0 0 0 0 0\n"
                                        "RenderEvent 150 250 0 0 0 0 0\n"
                                        "MouseMoveEvent 149 247 0 0 0 0 0\n"
                                        "RenderEvent 149 247 0 0 0 0 0\n"
                                        "MouseMoveEvent 147 242 0 0 0 0 0\n"
                                        "RenderEvent 147 242 0 0 0 0 0\n"
                                        "MouseMoveEvent 146 239 0 0 0 0 0\n"
                                        "RenderEvent 146 239 0 0 0 0 0\n"
                                        "MouseMoveEvent 145 236 0 0 0 0 0\n"
                                        "RenderEvent 145 236 0 0 0 0 0\n"
                                        "MouseMoveEvent 145 233 0 0 0 0 0\n"
                                        "RenderEvent 145 233 0 0 0 0 0\n"
                                        "MouseMoveEvent 144 228 0 0 0 0 0\n"
                                        "RenderEvent 144 228 0 0 0 0 0\n"
                                        "MouseMoveEvent 142 222 0 0 0 0 0\n"
                                        "RenderEvent 142 222 0 0 0 0 0\n"
                                        "MouseMoveEvent 141 219 0 0 0 0 0\n"
                                        "RenderEvent 141 219 0 0 0 0 0\n"
                                        "MouseMoveEvent 139 213 0 0 0 0 0\n"
                                        "RenderEvent 139 213 0 0 0 0 0\n"
                                        "MouseMoveEvent 138 210 0 0 0 0 0\n"
                                        "RenderEvent 138 210 0 0 0 0 0\n"
                                        "MouseMoveEvent 137 205 0 0 0 0 0\n"
                                        "RenderEvent 137 205 0 0 0 0 0\n"
                                        "MouseMoveEvent 135 199 0 0 0 0 0\n"
                                        "RenderEvent 135 199 0 0 0 0 0\n"
                                        "MouseMoveEvent 134 195 0 0 0 0 0\n"
                                        "RenderEvent 134 195 0 0 0 0 0\n"
                                        "MouseMoveEvent 132 190 0 0 0 0 0\n"
                                        "RenderEvent 132 190 0 0 0 0 0\n"
                                        "MouseMoveEvent 131 185 0 0 0 0 0\n"
                                        "RenderEvent 131 185 0 0 0 0 0\n"
                                        "MouseMoveEvent 130 181 0 0 0 0 0\n"
                                        "RenderEvent 130 181 0 0 0 0 0\n"
                                        "MouseMoveEvent 128 175 0 0 0 0 0\n"
                                        "RenderEvent 128 175 0 0 0 0 0\n"
                                        "MouseMoveEvent 127 171 0 0 0 0 0\n"
                                        "RenderEvent 127 171 0 0 0 0 0\n"
                                        "MouseMoveEvent 126 164 0 0 0 0 0\n"
                                        "RenderEvent 126 164 0 0 0 0 0\n"
                                        "MouseMoveEvent 125 160 0 0 0 0 0\n"
                                        "RenderEvent 125 160 0 0 0 0 0\n"
                                        "MouseMoveEvent 124 153 0 0 0 0 0\n"
                                        "RenderEvent 124 153 0 0 0 0 0\n"
                                        "MouseMoveEvent 123 147 0 0 0 0 0\n"
                                        "RenderEvent 123 147 0 0 0 0 0\n"
                                        "MouseMoveEvent 122 144 0 0 0 0 0\n"
                                        "RenderEvent 122 144 0 0 0 0 0\n"
                                        "MouseMoveEvent 121 141 0 0 0 0 0\n"
                                        "RenderEvent 121 141 0 0 0 0 0\n"
                                        "MouseMoveEvent 121 135 0 0 0 0 0\n"
                                        "RenderEvent 121 135 0 0 0 0 0\n"
                                        "MouseMoveEvent 120 129 0 0 0 0 0\n"
                                        "RenderEvent 120 129 0 0 0 0 0\n"
                                        "MouseMoveEvent 119 122 0 0 0 0 0\n"
                                        "RenderEvent 119 122 0 0 0 0 0\n"
                                        "MouseMoveEvent 118 120 0 0 0 0 0\n"
                                        "RenderEvent 118 120 0 0 0 0 0\n"
                                        "MouseMoveEvent 118 118 0 0 0 0 0\n"
                                        "RenderEvent 118 118 0 0 0 0 0\n"
                                        "MouseMoveEvent 118 117 0 0 0 0 0\n"
                                        "RenderEvent 118 117 0 0 0 0 0\n"
                                        "RightButtonReleaseEvent 118 117 0 0 0 0 0\n"
                                        "EndInteractionEvent 118 117 0 0 0 0 0\n"
                                        "MouseMoveEvent 118 117 0 0 0 0 0\n"
                                        "MouseMoveEvent 117 119 0 0 0 0 0\n"
                                        "MouseMoveEvent 116 121 0 0 0 0 0\n"
                                        "MouseMoveEvent 115 123 0 0 0 0 0\n"
                                        "MouseMoveEvent 114 124 0 0 0 0 0\n"
                                        "MouseMoveEvent 113 126 0 0 0 0 0\n"
                                        "MouseMoveEvent 111 128 0 0 0 0 0\n"
                                        "MouseMoveEvent 109 129 0 0 0 0 0\n"
                                        "MouseMoveEvent 107 131 0 0 0 0 0\n"
                                        "MouseMoveEvent 103 133 0 0 0 0 0\n"
                                        "MouseMoveEvent 99 135 0 0 0 0 0\n"
                                        "MouseMoveEvent 94 136 0 0 0 0 0\n"
                                        "MouseMoveEvent 90 139 0 0 0 0 0\n"
                                        "MouseMoveEvent 85 142 0 0 0 0 0\n"
                                        "MouseMoveEvent 79 144 0 0 0 0 0\n"
                                        "MouseMoveEvent 74 147 0 0 0 0 0\n"
                                        "MouseMoveEvent 70 149 0 0 0 0 0\n"
                                        "MouseMoveEvent 67 149 0 0 0 0 0\n"
                                        "MouseMoveEvent 64 150 0 0 0 0 0\n"
                                        "MouseMoveEvent 62 150 0 0 0 0 0\n"
                                        "MouseMoveEvent 59 150 0 0 0 0 0\n"
                                        "MouseMoveEvent 56 150 0 0 0 0 0\n"
                                        "MouseMoveEvent 54 151 0 0 0 0 0\n"
                                        "MouseMoveEvent 52 151 0 0 0 0 0\n"
                                        "MouseMoveEvent 50 151 0 0 0 0 0\n"
                                        "MouseMoveEvent 49 152 0 0 0 0 0\n"
                                        "MouseMoveEvent 47 152 0 0 0 0 0\n"
                                        "MouseMoveEvent 46 153 0 0 0 0 0\n"
                                        "MouseMoveEvent 44 154 0 0 0 0 0\n"
                                        "MouseMoveEvent 42 155 0 0 0 0 0\n"
                                        "MouseMoveEvent 39 157 0 0 0 0 0\n"
                                        "MouseMoveEvent 38 158 0 0 0 0 0\n"
                                        "MouseMoveEvent 37 159 0 0 0 0 0\n"
                                        "MouseMoveEvent 36 160 0 0 0 0 0\n"
                                        "MouseMoveEvent 35 159 0 0 0 0 0\n"
                                        "MouseMoveEvent 35 158 0 0 0 0 0\n"
                                        "MouseMoveEvent 35 156 0 0 0 0 0\n"
                                        "MouseMoveEvent 35 154 0 0 0 0 0\n"
                                        "MouseMoveEvent 35 152 0 0 0 0 0\n"
                                        "MouseMoveEvent 35 150 0 0 0 0 0\n"
                                        "MouseMoveEvent 35 149 0 0 0 0 0\n"
                                        "MouseMoveEvent 36 148 0 0 0 0 0\n"
                                        "MouseMoveEvent 38 148 0 0 0 0 0\n"
                                        "MouseMoveEvent 38 147 0 0 0 0 0\n"
                                        "LeftButtonPressEvent 38 147 0 0 0 0 0\n"
                                        "StartInteractionEvent 38 147 0 0 0 0 0\n"
                                        "MouseMoveEvent 39 147 0 0 0 0 0\n"
                                        "MouseMoveEvent 41 148 0 0 0 0 0\n"
                                        "MouseMoveEvent 43 149 0 0 0 0 0\n"
                                        "MouseMoveEvent 45 150 0 0 0 0 0\n"
                                        "MouseMoveEvent 47 150 0 0 0 0 0\n"
                                        "MouseMoveEvent 51 152 0 0 0 0 0\n"
                                        "MouseMoveEvent 55 155 0 0 0 0 0\n"
                                        "MouseMoveEvent 60 158 0 0 0 0 0\n"
                                        "MouseMoveEvent 65 161 0 0 0 0 0\n"
                                        "MouseMoveEvent 70 164 0 0 0 0 0\n"
                                        "MouseMoveEvent 74 169 0 0 0 0 0\n"
                                        "MouseMoveEvent 79 173 0 0 0 0 0\n"
                                        "MouseMoveEvent 83 177 0 0 0 0 0\n"
                                        "MouseMoveEvent 88 180 0 0 0 0 0\n"
                                        "MouseMoveEvent 93 185 0 0 0 0 0\n"
                                        "MouseMoveEvent 96 189 0 0 0 0 0\n"
                                        "MouseMoveEvent 100 193 0 0 0 0 0\n"
                                        "MouseMoveEvent 103 196 0 0 0 0 0\n"
                                        "MouseMoveEvent 106 199 0 0 0 0 0\n"
                                        "MouseMoveEvent 108 201 0 0 0 0 0\n"
                                        "MouseMoveEvent 110 203 0 0 0 0 0\n"
                                        "MouseMoveEvent 113 207 0 0 0 0 0\n"
                                        "MouseMoveEvent 115 209 0 0 0 0 0\n"
                                        "MouseMoveEvent 117 211 0 0 0 0 0\n"
                                        "MouseMoveEvent 119 214 0 0 0 0 0\n"
                                        "MouseMoveEvent 121 216 0 0 0 0 0\n"
                                        "MouseMoveEvent 124 218 0 0 0 0 0\n"
                                        "MouseMoveEvent 126 220 0 0 0 0 0\n"
                                        "MouseMoveEvent 128 223 0 0 0 0 0\n"
                                        "MouseMoveEvent 129 225 0 0 0 0 0\n"
                                        "MouseMoveEvent 130 226 0 0 0 0 0\n"
                                        "MouseMoveEvent 131 229 0 0 0 0 0\n"
                                        "MouseMoveEvent 133 230 0 0 0 0 0\n"
                                        "MouseMoveEvent 133 231 0 0 0 0 0\n"
                                        "MouseMoveEvent 135 232 0 0 0 0 0\n"
                                        "MouseMoveEvent 137 234 0 0 0 0 0\n"
                                        "MouseMoveEvent 138 236 0 0 0 0 0\n"
                                        "MouseMoveEvent 141 237 0 0 0 0 0\n"
                                        "MouseMoveEvent 143 239 0 0 0 0 0\n"
                                        "MouseMoveEvent 145 241 0 0 0 0 0\n"
                                        "MouseMoveEvent 147 243 0 0 0 0 0\n"
                                        "MouseMoveEvent 150 244 0 0 0 0 0\n"
                                        "MouseMoveEvent 151 245 0 0 0 0 0\n"
                                        "MouseMoveEvent 153 247 0 0 0 0 0\n"
                                        "MouseMoveEvent 154 248 0 0 0 0 0\n"
                                        "MouseMoveEvent 155 249 0 0 0 0 0\n"
                                        "MouseMoveEvent 156 251 0 0 0 0 0\n"
                                        "MouseMoveEvent 157 251 0 0 0 0 0\n"
                                        "MouseMoveEvent 158 252 0 0 0 0 0\n"
                                        "MouseMoveEvent 158 253 0 0 0 0 0\n"
                                        "MouseMoveEvent 158 254 0 0 0 0 0\n"
                                        "LeftButtonReleaseEvent 158 254 0 0 0 0 0\n"
                                        "EndInteractionEvent 158 254 0 0 0 0 0\n"
                                        "MouseMoveEvent 158 254 0 0 0 0 0\n"
                                        "MouseMoveEvent 157 254 0 0 0 0 0\n"
                                        "MouseMoveEvent 156 253 0 0 0 0 0\n"
                                        "MouseMoveEvent 155 252 0 0 0 0 0\n"
                                        "MouseMoveEvent 154 251 0 0 0 0 0\n"
                                        "MouseMoveEvent 152 249 0 0 0 0 0\n"
                                        "MouseMoveEvent 150 247 0 0 0 0 0\n"
                                        "MouseMoveEvent 146 243 0 0 0 0 0\n"
                                        "MouseMoveEvent 143 240 0 0 0 0 0\n"
                                        "MouseMoveEvent 139 236 0 0 0 0 0\n"
                                        "MouseMoveEvent 134 232 0 0 0 0 0\n"
                                        "MouseMoveEvent 130 227 0 0 0 0 0\n"
                                        "MouseMoveEvent 125 222 0 0 0 0 0\n"
                                        "MouseMoveEvent 122 218 0 0 0 0 0\n"
                                        "MouseMoveEvent 118 213 0 0 0 0 0\n"
                                        "MouseMoveEvent 113 209 0 0 0 0 0\n"
                                        "MouseMoveEvent 108 205 0 0 0 0 0\n"
                                        "MouseMoveEvent 103 201 0 0 0 0 0\n"
                                        "MouseMoveEvent 100 198 0 0 0 0 0\n"
                                        "MouseMoveEvent 94 195 0 0 0 0 0\n"
                                        "MouseMoveEvent 89 191 0 0 0 0 0\n"
                                        "MouseMoveEvent 83 187 0 0 0 0 0\n"
                                        "MouseMoveEvent 77 182 0 0 0 0 0\n"
                                        "MouseMoveEvent 71 176 0 0 0 0 0\n"
                                        "MouseMoveEvent 64 169 0 0 0 0 0\n"
                                        "MouseMoveEvent 58 162 0 0 0 0 0\n"
                                        "MouseMoveEvent 50 153 0 0 0 0 0\n"
                                        "MouseMoveEvent 43 147 0 0 0 0 0\n"
                                        "MouseMoveEvent 36 140 0 0 0 0 0\n"
                                        "MouseMoveEvent 29 135 0 0 0 0 0\n"
                                        "MouseMoveEvent 26 130 0 0 0 0 0\n"
                                        "MouseMoveEvent 23 128 0 0 0 0 0\n"
                                        "MouseMoveEvent 22 127 0 0 0 0 0\n"
                                        "MouseMoveEvent 23 127 0 0 0 0 0\n"
                                        "MouseMoveEvent 24 128 0 0 0 0 0\n"
                                        "MouseMoveEvent 26 129 0 0 0 0 0\n"
                                        "MouseMoveEvent 29 130 0 0 0 0 0\n"
                                        "MouseMoveEvent 31 131 0 0 0 0 0\n"
                                        "MouseMoveEvent 33 132 0 0 0 0 0\n"
                                        "MouseMoveEvent 34 133 0 0 0 0 0\n"
                                        "MouseMoveEvent 36 133 0 0 0 0 0\n"
                                        "MouseMoveEvent 37 134 0 0 0 0 0\n"
                                        "MouseMoveEvent 38 135 0 0 0 0 0\n"
                                        "MouseMoveEvent 39 135 0 0 0 0 0\n"
                                        "MouseMoveEvent 39 136 0 0 0 0 0\n"
                                        "MouseMoveEvent 40 136 0 0 0 0 0\n"
                                        "MouseMoveEvent 40 137 0 0 0 0 0\n"
                                        "LeftButtonPressEvent 40 137 0 0 0 0 0\n"
                                        "StartInteractionEvent 40 137 0 0 0 0 0\n"
                                        "MouseMoveEvent 41 137 0 0 0 0 0\n"
                                        "MouseMoveEvent 43 136 0 0 0 0 0\n"
                                        "MouseMoveEvent 45 135 0 0 0 0 0\n"
                                        "MouseMoveEvent 48 132 0 0 0 0 0\n"
                                        "MouseMoveEvent 51 130 0 0 0 0 0\n"
                                        "MouseMoveEvent 55 127 0 0 0 0 0\n"
                                        "MouseMoveEvent 59 123 0 0 0 0 0\n"
                                        "MouseMoveEvent 65 120 0 0 0 0 0\n"
                                        "MouseMoveEvent 71 116 0 0 0 0 0\n"
                                        "MouseMoveEvent 79 112 0 0 0 0 0\n"
                                        "MouseMoveEvent 89 108 0 0 0 0 0\n"
                                        "MouseMoveEvent 100 102 0 0 0 0 0\n"
                                        "MouseMoveEvent 113 97 0 0 0 0 0\n"
                                        "MouseMoveEvent 125 91 0 0 0 0 0\n"
                                        "MouseMoveEvent 137 85 0 0 0 0 0\n"
                                        "MouseMoveEvent 148 81 0 0 0 0 0\n"
                                        "MouseMoveEvent 158 77 0 0 0 0 0\n"
                                        "MouseMoveEvent 167 72 0 0 0 0 0\n"
                                        "MouseMoveEvent 173 68 0 0 0 0 0\n"
                                        "MouseMoveEvent 179 65 0 0 0 0 0\n"
                                        "MouseMoveEvent 183 63 0 0 0 0 0\n"
                                        "MouseMoveEvent 188 60 0 0 0 0 0\n"
                                        "MouseMoveEvent 193 56 0 0 0 0 0\n"
                                        "MouseMoveEvent 197 53 0 0 0 0 0\n"
                                        "MouseMoveEvent 201 51 0 0 0 0 0\n"
                                        "MouseMoveEvent 204 48 0 0 0 0 0\n"
                                        "MouseMoveEvent 208 46 0 0 0 0 0\n"
                                        "MouseMoveEvent 210 45 0 0 0 0 0\n"
                                        "MouseMoveEvent 211 44 0 0 0 0 0\n"
                                        "MouseMoveEvent 213 43 0 0 0 0 0\n"
                                        "MouseMoveEvent 215 43 0 0 0 0 0\n"
                                        "MouseMoveEvent 217 43 0 0 0 0 0\n"
                                        "MouseMoveEvent 218 43 0 0 0 0 0\n"
                                        "MouseMoveEvent 219 43 0 0 0 0 0\n"
                                        "MouseMoveEvent 220 43 0 0 0 0 0\n"
                                        "MouseMoveEvent 221 43 0 0 0 0 0\n"
                                        "MouseMoveEvent 224 43 0 0 0 0 0\n"
                                        "MouseMoveEvent 226 42 0 0 0 0 0\n"
                                        "MouseMoveEvent 228 41 0 0 0 0 0\n"
                                        "MouseMoveEvent 229 39 0 0 0 0 0\n"
                                        "MouseMoveEvent 230 39 0 0 0 0 0\n"
                                        "MouseMoveEvent 231 38 0 0 0 0 0\n"
                                        "LeftButtonReleaseEvent 231 38 0 0 0 0 0\n"
                                        "EndInteractionEvent 231 38 0 0 0 0 0\n"
                                        "MouseMoveEvent 231 38 0 0 0 0 0\n"
                                        "MouseMoveEvent 230 38 0 0 0 0 0\n"
                                        "MouseMoveEvent 229 38 0 0 0 0 0\n"
                                        "MouseMoveEvent 228 39 0 0 0 0 0\n"
                                        "MouseMoveEvent 226 39 0 0 0 0 0\n"
                                        "MouseMoveEvent 224 40 0 0 0 0 0\n"
                                        "MouseMoveEvent 221 42 0 0 0 0 0\n"
                                        "MouseMoveEvent 218 43 0 0 0 0 0\n"
                                        "MouseMoveEvent 212 44 0 0 0 0 0\n"
                                        "MouseMoveEvent 206 46 0 0 0 0 0\n"
                                        "MouseMoveEvent 200 48 0 0 0 0 0\n"
                                        "MouseMoveEvent 195 50 0 0 0 0 0\n"
                                        "MouseMoveEvent 190 52 0 0 0 0 0\n"
                                        "MouseMoveEvent 186 54 0 0 0 0 0\n"
                                        "MouseMoveEvent 181 55 0 0 0 0 0\n"
                                        "MouseMoveEvent 178 56 0 0 0 0 0\n"
                                        "MouseMoveEvent 175 57 0 0 0 0 0\n"
                                        "MouseMoveEvent 173 59 0 0 0 0 0\n"
                                        "MouseMoveEvent 172 59 0 0 0 0 0\n"
                                        "MouseMoveEvent 172 60 0 0 0 0 0\n"
                                        "MouseMoveEvent 172 61 0 0 0 0 0\n"
                                        "MouseMoveEvent 172 62 0 0 0 0 0\n"
                                        "MouseMoveEvent 172 63 0 0 0 0 0\n"
                                        "MouseMoveEvent 172 65 0 0 0 0 0\n"
                                        "MouseMoveEvent 172 66 0 0 0 0 0\n"
                                        "MouseMoveEvent 172 68 0 0 0 0 0\n"
                                        "MouseMoveEvent 171 69 0 0 0 0 0\n"
                                        "MouseMoveEvent 171 72 0 0 0 0 0\n"
                                        "MouseMoveEvent 170 73 0 0 0 0 0\n"
                                        "MouseMoveEvent 170 74 0 0 0 0 0\n"
                                        "MouseMoveEvent 169 76 0 0 0 0 0\n"
                                        "MouseMoveEvent 169 77 0 0 0 0 0\n"
                                        "MouseMoveEvent 168 80 0 0 0 0 0\n"
                                        "MouseMoveEvent 167 82 0 0 0 0 0\n"
                                        "MouseMoveEvent 167 83 0 0 0 0 0\n"
                                        "MouseMoveEvent 166 85 0 0 0 0 0\n"
                                        "MouseMoveEvent 166 86 0 0 0 0 0\n"
                                        "MouseMoveEvent 165 87 0 0 0 0 0\n"
                                        "MouseMoveEvent 165 88 0 0 0 0 0\n"
                                        "MouseMoveEvent 163 89 0 0 0 0 0\n"
                                        "MouseMoveEvent 163 90 0 0 0 0 0\n"
                                        "MouseMoveEvent 163 90 0 0 0 0 0\n"
                                        "MouseMoveEvent 163 90 0 0 0 0 0\n"
                                        "MouseMoveEvent 163 90 0 0 0 0 0\n"
                                        "MouseMoveEvent 163 90 0 0 0 0 0\n"
                                        "MouseMoveEvent 163 91 0 0 0 0 0\n"
                                        "MouseMoveEvent 162 91 0 0 0 0 0\n"
                                        "MouseMoveEvent 161 91 0 0 0 0 0\n"
                                        "MouseMoveEvent 160 92 0 0 0 0 0\n"
                                        "MouseMoveEvent 159 93 0 0 0 0 0\n"
                                        "MouseMoveEvent 157 94 0 0 0 0 0\n"
                                        "MouseMoveEvent 155 95 0 0 0 0 0\n"
                                        "MouseMoveEvent 154 96 0 0 0 0 0\n"
                                        "MouseMoveEvent 154 98 0 0 0 0 0\n"
                                        "MouseMoveEvent 154 99 0 0 0 0 0\n"
                                        "MouseMoveEvent 154 100 0 0 0 0 0\n"
                                        "MouseMoveEvent 154 101 0 0 0 0 0\n"
                                        "MouseMoveEvent 154 103 0 0 0 0 0\n"
                                        "MouseMoveEvent 155 103 0 0 0 0 0\n"
                                        "MouseMoveEvent 156 105 0 0 0 0 0\n"
                                        "MouseMoveEvent 157 106 0 0 0 0 0\n"
                                        "MouseMoveEvent 159 107 0 0 0 0 0\n"
                                        "MouseMoveEvent 160 109 0 0 0 0 0\n"
                                        "MouseMoveEvent 162 110 0 0 0 0 0\n"
                                        "MouseMoveEvent 163 111 0 0 0 0 0\n"
                                        "MouseMoveEvent 165 112 0 0 0 0 0\n"
                                        "MouseMoveEvent 166 113 0 0 0 0 0\n"
                                        "MouseMoveEvent 166 114 0 0 0 0 0\n"
                                        "MouseMoveEvent 168 115 0 0 0 0 0\n"
                                        "MouseMoveEvent 170 116 0 0 0 0 0\n"
                                        "MouseMoveEvent 173 116 0 0 0 0 0\n"
                                        "MouseMoveEvent 176 118 0 0 0 0 0\n"
                                        "MouseMoveEvent 178 119 0 0 0 0 0\n"
                                        "MouseMoveEvent 181 119 0 0 0 0 0\n"
                                        "MouseMoveEvent 183 120 0 0 0 0 0\n"
                                        "MouseMoveEvent 185 121 0 0 0 0 0\n"
                                        "MouseMoveEvent 186 122 0 0 0 0 0\n"
                                        "MouseMoveEvent 188 123 0 0 0 0 0\n"
                                        "MouseMoveEvent 189 124 0 0 0 0 0\n"
                                        "MouseMoveEvent 190 124 0 0 0 0 0\n"
                                        "MouseMoveEvent 191 125 0 0 0 0 0\n"
                                        "MouseMoveEvent 192 126 0 0 0 0 0\n"
                                        "MouseMoveEvent 193 126 0 0 0 0 0\n"
                                        "LeftButtonPressEvent 193 126 0 0 0 0 0\n"
                                        "StartInteractionEvent 193 126 0 0 0 0 0\n"
                                        "MouseMoveEvent 191 126 0 0 0 0 0\n"
                                        "MouseMoveEvent 189 125 0 0 0 0 0\n"
                                        "MouseMoveEvent 188 125 0 0 0 0 0\n"
                                        "MouseMoveEvent 187 125 0 0 0 0 0\n"
                                        "MouseMoveEvent 186 124 0 0 0 0 0\n"
                                        "MouseMoveEvent 185 124 0 0 0 0 0\n"
                                        "MouseMoveEvent 183 122 0 0 0 0 0\n"
                                        "MouseMoveEvent 181 120 0 0 0 0 0\n"
                                        "MouseMoveEvent 179 120 0 0 0 0 0\n"
                                        "MouseMoveEvent 178 118 0 0 0 0 0\n"
                                        "MouseMoveEvent 175 117 0 0 0 0 0\n"
                                        "MouseMoveEvent 174 117 0 0 0 0 0\n"
                                        "MouseMoveEvent 173 116 0 0 0 0 0\n"
                                        "MouseMoveEvent 171 115 0 0 0 0 0\n"
                                        "MouseMoveEvent 169 114 0 0 0 0 0\n"
                                        "MouseMoveEvent 167 113 0 0 0 0 0\n"
                                        "MouseMoveEvent 166 112 0 0 0 0 0\n"
                                        "MouseMoveEvent 164 112 0 0 0 0 0\n"
                                        "MouseMoveEvent 163 111 0 0 0 0 0\n"
                                        "MouseMoveEvent 161 111 0 0 0 0 0\n"
                                        "MouseMoveEvent 160 111 0 0 0 0 0\n"
                                        "MouseMoveEvent 158 111 0 0 0 0 0\n"
                                        "MouseMoveEvent 157 110 0 0 0 0 0\n"
                                        "MouseMoveEvent 155 109 0 0 0 0 0\n"
                                        "MouseMoveEvent 154 109 0 0 0 0 0\n"
                                        "MouseMoveEvent 151 109 0 0 0 0 0\n"
                                        "MouseMoveEvent 149 109 0 0 0 0 0\n"
                                        "MouseMoveEvent 146 109 0 0 0 0 0\n"
                                        "MouseMoveEvent 143 107 0 0 0 0 0\n"
                                        "MouseMoveEvent 140 105 0 0 0 0 0\n"
                                        "MouseMoveEvent 136 104 0 0 0 0 0\n"
                                        "MouseMoveEvent 133 102 0 0 0 0 0\n"
                                        "MouseMoveEvent 129 100 0 0 0 0 0\n"
                                        "MouseMoveEvent 126 98 0 0 0 0 0\n"
                                        "MouseMoveEvent 123 94 0 0 0 0 0\n"
                                        "MouseMoveEvent 119 93 0 0 0 0 0\n"
                                        "MouseMoveEvent 117 91 0 0 0 0 0\n"
                                        "MouseMoveEvent 115 90 0 0 0 0 0\n"
                                        "MouseMoveEvent 113 88 0 0 0 0 0\n"
                                        "MouseMoveEvent 112 88 0 0 0 0 0\n"
                                        "MouseMoveEvent 111 87 0 0 0 0 0\n"
                                        "MouseMoveEvent 109 86 0 0 0 0 0\n"
                                        "MouseMoveEvent 107 85 0 0 0 0 0\n"
                                        "MouseMoveEvent 105 84 0 0 0 0 0\n"
                                        "MouseMoveEvent 102 82 0 0 0 0 0\n"
                                        "MouseMoveEvent 99 81 0 0 0 0 0\n"
                                        "MouseMoveEvent 95 78 0 0 0 0 0\n"
                                        "MouseMoveEvent 92 76 0 0 0 0 0\n"
                                        "MouseMoveEvent 88 73 0 0 0 0 0\n"
                                        "MouseMoveEvent 83 70 0 0 0 0 0\n"
                                        "MouseMoveEvent 80 68 0 0 0 0 0\n"
                                        "MouseMoveEvent 78 66 0 0 0 0 0\n"
                                        "MouseMoveEvent 76 64 0 0 0 0 0\n"
                                        "MouseMoveEvent 74 62 0 0 0 0 0\n"
                                        "MouseMoveEvent 73 61 0 0 0 0 0\n"
                                        "MouseMoveEvent 71 59 0 0 0 0 0\n"
                                        "MouseMoveEvent 70 57 0 0 0 0 0\n"
                                        "MouseMoveEvent 70 44 0 0 0 0 0\n"
                                        "MouseMoveEvent 69 44 0 0 0 0 0\n"
                                        "LeftButtonReleaseEvent 69 44 0 0 0 0 0\n"
                                        "EndInteractionEvent 69 44 0 0 0 0 0\n"
                                        "MouseMoveEvent 69 44 0 0 0 0 0\n"
                                        "MouseMoveEvent 70 54 0 0 0 0 0\n"
                                        "MouseMoveEvent 72 56 0 0 0 0 0\n"
                                        "MouseMoveEvent 74 58 0 0 0 0 0\n"
                                        "MouseMoveEvent 79 61 0 0 0 0 0\n"
                                        "MouseMoveEvent 82 63 0 0 0 0 0\n"
                                        "MouseMoveEvent 88 67 0 0 0 0 0\n"
                                        "MouseMoveEvent 95 72 0 0 0 0 0\n"
                                        "MouseMoveEvent 101 75 0 0 0 0 0\n"
                                        "MouseMoveEvent 107 78 0 0 0 0 0\n"
                                        "MouseMoveEvent 113 80 0 0 0 0 0\n"
                                        "MouseMoveEvent 115 81 0 0 0 0 0\n"
                                        "MouseMoveEvent 117 82 0 0 0 0 0\n"
                                        "MouseMoveEvent 118 83 0 0 0 0 0\n"
                                        "MouseMoveEvent 118 84 0 0 0 0 0\n"
                                        "MouseMoveEvent 119 84 0 0 0 0 0\n"
                                        "MouseMoveEvent 121 85 0 0 0 0 0\n"
                                        "MouseMoveEvent 121 86 0 0 0 0 0\n"
                                        "MouseMoveEvent 122 86 0 0 0 0 0\n"
                                        "MouseMoveEvent 122 87 0 0 0 0 0\n"
                                        "RightButtonPressEvent 122 87 0 0 0 0 0\n"
                                        "StartInteractionEvent 122 87 0 0 0 0 0\n"
                                        "MouseMoveEvent 123 87 0 0 0 0 0\n"
                                        "RenderEvent 123 87 0 0 0 0 0\n"
                                        "MouseMoveEvent 124 90 0 0 0 0 0\n"
                                        "RenderEvent 124 90 0 0 0 0 0\n"
                                        "MouseMoveEvent 127 98 0 0 0 0 0\n"
                                        "RenderEvent 127 98 0 0 0 0 0\n"
                                        "MouseMoveEvent 129 108 0 0 0 0 0\n"
                                        "RenderEvent 129 108 0 0 0 0 0\n"
                                        "MouseMoveEvent 130 115 0 0 0 0 0\n"
                                        "RenderEvent 130 115 0 0 0 0 0\n"
                                        "MouseMoveEvent 130 117 0 0 0 0 0\n"
                                        "RenderEvent 130 117 0 0 0 0 0\n"
                                        "MouseMoveEvent 130 119 0 0 0 0 0\n"
                                        "RenderEvent 130 119 0 0 0 0 0\n"
                                        "MouseMoveEvent 130 121 0 0 0 0 0\n"
                                        "RenderEvent 130 121 0 0 0 0 0\n"
                                        "MouseMoveEvent 130 127 0 0 0 0 0\n"
                                        "RenderEvent 130 127 0 0 0 0 0\n"
                                        "MouseMoveEvent 130 130 0 0 0 0 0\n"
                                        "RenderEvent 130 130 0 0 0 0 0\n"
                                        "MouseMoveEvent 130 134 0 0 0 0 0\n"
                                        "RenderEvent 130 134 0 0 0 0 0\n"
                                        "MouseMoveEvent 130 139 0 0 0 0 0\n"
                                        "RenderEvent 130 139 0 0 0 0 0\n"
                                        "MouseMoveEvent 130 144 0 0 0 0 0\n"
                                        "RenderEvent 130 144 0 0 0 0 0\n"
                                        "MouseMoveEvent 131 152 0 0 0 0 0\n"
                                        "RenderEvent 131 152 0 0 0 0 0\n"
                                        "MouseMoveEvent 132 163 0 0 0 0 0\n"
                                        "RenderEvent 132 163 0 0 0 0 0\n"
                                        "MouseMoveEvent 132 169 0 0 0 0 0\n"
                                        "RenderEvent 132 169 0 0 0 0 0\n"
                                        "MouseMoveEvent 133 177 0 0 0 0 0\n"
                                        "RenderEvent 133 177 0 0 0 0 0\n"
                                        "MouseMoveEvent 133 179 0 0 0 0 0\n"
                                        "RenderEvent 133 179 0 0 0 0 0\n"
                                        "MouseMoveEvent 133 180 0 0 0 0 0\n"
                                        "RenderEvent 133 180 0 0 0 0 0\n"
                                        "MouseMoveEvent 133 179 0 0 0 0 0\n"
                                        "RenderEvent 133 179 0 0 0 0 0\n"
                                        "MouseMoveEvent 133 178 0 0 0 0 0\n"
                                        "RenderEvent 133 178 0 0 0 0 0\n"
                                        "MouseMoveEvent 133 176 0 0 0 0 0\n"
                                        "RenderEvent 133 176 0 0 0 0 0\n"
                                        "MouseMoveEvent 133 173 0 0 0 0 0\n"
                                        "RenderEvent 133 173 0 0 0 0 0\n"
                                        "MouseMoveEvent 133 171 0 0 0 0 0\n"
                                        "RenderEvent 133 171 0 0 0 0 0\n"
                                        "MouseMoveEvent 133 167 0 0 0 0 0\n"
                                        "RenderEvent 133 167 0 0 0 0 0\n"
                                        "MouseMoveEvent 133 161 0 0 0 0 0\n"
                                        "RenderEvent 133 161 0 0 0 0 0\n"
                                        "MouseMoveEvent 133 158 0 0 0 0 0\n"
                                        "RenderEvent 133 158 0 0 0 0 0\n"
                                        "MouseMoveEvent 133 155 0 0 0 0 0\n"
                                        "RenderEvent 133 155 0 0 0 0 0\n"
                                        "MouseMoveEvent 133 153 0 0 0 0 0\n"
                                        "RenderEvent 133 153 0 0 0 0 0\n"
                                        "MouseMoveEvent 133 150 0 0 0 0 0\n"
                                        "RenderEvent 133 150 0 0 0 0 0\n"
                                        "MouseMoveEvent 133 146 0 0 0 0 0\n"
                                        "RenderEvent 133 146 0 0 0 0 0\n"
                                        "MouseMoveEvent 133 143 0 0 0 0 0\n"
                                        "RenderEvent 133 143 0 0 0 0 0\n"
                                        "MouseMoveEvent 133 139 0 0 0 0 0\n"
                                        "RenderEvent 133 139 0 0 0 0 0\n"
                                        "MouseMoveEvent 133 136 0 0 0 0 0\n"
                                        "RenderEvent 133 136 0 0 0 0 0\n"
                                        "MouseMoveEvent 133 132 0 0 0 0 0\n"
                                        "RenderEvent 133 132 0 0 0 0 0\n"
                                        "MouseMoveEvent 133 129 0 0 0 0 0\n"
                                        "RenderEvent 133 129 0 0 0 0 0\n"
                                        "MouseMoveEvent 132 126 0 0 0 0 0\n"
                                        "RenderEvent 132 126 0 0 0 0 0\n"
                                        "MouseMoveEvent 132 123 0 0 0 0 0\n"
                                        "RenderEvent 132 123 0 0 0 0 0\n"
                                        "MouseMoveEvent 132 121 0 0 0 0 0\n"
                                        "RenderEvent 132 121 0 0 0 0 0\n"
                                        "MouseMoveEvent 131 117 0 0 0 0 0\n"
                                        "RenderEvent 131 117 0 0 0 0 0\n"
                                        "MouseMoveEvent 131 115 0 0 0 0 0\n"
                                        "RenderEvent 131 115 0 0 0 0 0\n"
                                        "MouseMoveEvent 130 112 0 0 0 0 0\n"
                                        "RenderEvent 130 112 0 0 0 0 0\n"
                                        "MouseMoveEvent 130 111 0 0 0 0 0\n"
                                        "RenderEvent 130 111 0 0 0 0 0\n"
                                        "MouseMoveEvent 129 107 0 0 0 0 0\n"
                                        "RenderEvent 129 107 0 0 0 0 0\n"
                                        "MouseMoveEvent 129 104 0 0 0 0 0\n"
                                        "RenderEvent 129 104 0 0 0 0 0\n"
                                        "MouseMoveEvent 128 99 0 0 0 0 0\n"
                                        "RenderEvent 128 99 0 0 0 0 0\n"
                                        "MouseMoveEvent 128 98 0 0 0 0 0\n"
                                        "RenderEvent 128 98 0 0 0 0 0\n"
                                        "MouseMoveEvent 127 97 0 0 0 0 0\n"
                                        "RenderEvent 127 97 0 0 0 0 0\n"
                                        "MouseMoveEvent 127 95 0 0 0 0 0\n"
                                        "RenderEvent 127 95 0 0 0 0 0\n"
                                        "MouseMoveEvent 126 93 0 0 0 0 0\n"
                                        "RenderEvent 126 93 0 0 0 0 0\n"
                                        "MouseMoveEvent 126 90 0 0 0 0 0\n"
                                        "RenderEvent 126 90 0 0 0 0 0\n"
                                        "MouseMoveEvent 125 87 0 0 0 0 0\n"
                                        "RenderEvent 125 87 0 0 0 0 0\n"
                                        "MouseMoveEvent 125 84 0 0 0 0 0\n"
                                        "RenderEvent 125 84 0 0 0 0 0\n"
                                        "MouseMoveEvent 125 82 0 0 0 0 0\n"
                                        "RenderEvent 125 82 0 0 0 0 0\n"
                                        "MouseMoveEvent 124 78 0 0 0 0 0\n"
                                        "RenderEvent 124 78 0 0 0 0 0\n"
                                        "MouseMoveEvent 124 75 0 0 0 0 0\n"
                                        "RenderEvent 124 75 0 0 0 0 0\n"
                                        "MouseMoveEvent 124 73 0 0 0 0 0\n"
                                        "RenderEvent 124 73 0 0 0 0 0\n"
                                        "MouseMoveEvent 124 72 0 0 0 0 0\n"
                                        "RenderEvent 124 72 0 0 0 0 0\n"
                                        "MouseMoveEvent 123 72 0 0 0 0 0\n"
                                        "RenderEvent 123 72 0 0 0 0 0\n"
                                        "MouseMoveEvent 122 71 0 0 0 0 0\n"
                                        "RenderEvent 122 71 0 0 0 0 0\n"
                                        "MouseMoveEvent 122 70 0 0 0 0 0\n"
                                        "RenderEvent 122 70 0 0 0 0 0\n"
                                        "MouseMoveEvent 121 69 0 0 0 0 0\n"
                                        "RenderEvent 121 69 0 0 0 0 0\n"
                                        "MouseMoveEvent 120 69 0 0 0 0 0\n"
                                        "RenderEvent 120 69 0 0 0 0 0\n"
                                        "MouseMoveEvent 120 68 0 0 0 0 0\n"
                                        "RenderEvent 120 68 0 0 0 0 0\n"
                                        "MouseMoveEvent 118 66 0 0 0 0 0\n"
                                        "RenderEvent 118 66 0 0 0 0 0\n"
                                        "MouseMoveEvent 118 65 0 0 0 0 0\n"
                                        "RenderEvent 118 65 0 0 0 0 0\n"
                                        "MouseMoveEvent 117 63 0 0 0 0 0\n"
                                        "RenderEvent 117 63 0 0 0 0 0\n"
                                        "MouseMoveEvent 116 62 0 0 0 0 0\n"
                                        "RenderEvent 116 62 0 0 0 0 0\n"
                                        "MouseMoveEvent 116 61 0 0 0 0 0\n"
                                        "RenderEvent 116 61 0 0 0 0 0\n"
                                        "MouseMoveEvent 115 58 0 0 0 0 0\n"
                                        "RenderEvent 115 58 0 0 0 0 0\n"
                                        "MouseMoveEvent 114 56 0 0 0 0 0\n"
                                        "RenderEvent 114 56 0 0 0 0 0\n"
                                        "MouseMoveEvent 113 55 0 0 0 0 0\n"
                                        "RenderEvent 113 55 0 0 0 0 0\n"
                                        "MouseMoveEvent 112 53 0 0 0 0 0\n"
                                        "RenderEvent 112 53 0 0 0 0 0\n"
                                        "MouseMoveEvent 111 49 0 0 0 0 0\n"
                                        "RenderEvent 111 49 0 0 0 0 0\n"
                                        "MouseMoveEvent 109 45 0 0 0 0 0\n"
                                        "RenderEvent 109 45 0 0 0 0 0\n"
                                        "MouseMoveEvent 109 47 0 0 0 0 0\n"
                                        "RenderEvent 109 47 0 0 0 0 0\n"
                                        "RightButtonReleaseEvent 109 47 0 0 0 0 0\n"
                                        "EndInteractionEvent 109 47 0 0 0 0 0\n"
                                        "MouseMoveEvent 109 53 0 0 0 0 0\n"
                                        "MouseMoveEvent 109 57 0 0 0 0 0\n"
                                        "MouseMoveEvent 109 61 0 0 0 0 0\n"
                                        "MouseMoveEvent 109 65 0 0 0 0 0\n"
                                        "MouseMoveEvent 109 69 0 0 0 0 0\n"
                                        "MouseMoveEvent 109 72 0 0 0 0 0\n"
                                        "MouseMoveEvent 110 75 0 0 0 0 0\n"
                                        "MouseMoveEvent 111 78 0 0 0 0 0\n"
                                        "MouseMoveEvent 111 82 0 0 0 0 0\n"
                                        "MouseMoveEvent 111 86 0 0 0 0 0\n"
                                        "MouseMoveEvent 112 88 0 0 0 0 0\n"
                                        "MouseMoveEvent 113 89 0 0 0 0 0\n"
                                        "MouseMoveEvent 113 90 0 0 0 0 0\n"
                                        "MouseMoveEvent 114 91 0 0 0 0 0\n"
                                        "MouseMoveEvent 115 92 0 0 0 0 0\n"
                                        "MouseMoveEvent 115 93 0 0 0 0 0\n"
                                        "MouseMoveEvent 115 94 0 0 0 0 0\n"
                                        "MiddleButtonPressEvent 115 94 0 0 0 0 0\n"
                                        "StartInteractionEvent 115 94 0 0 0 0 0\n"
                                        "MouseMoveEvent 115 95 0 0 0 0 0\n"
                                        "RenderEvent 115 95 0 0 0 0 0\n"
                                        "MouseMoveEvent 116 98 0 0 0 0 0\n"
                                        "RenderEvent 116 98 0 0 0 0 0\n"
                                        "MouseMoveEvent 118 103 0 0 0 0 0\n"
                                        "RenderEvent 118 103 0 0 0 0 0\n"
                                        "MouseMoveEvent 121 107 0 0 0 0 0\n"
                                        "RenderEvent 121 107 0 0 0 0 0\n"
                                        "MouseMoveEvent 126 113 0 0 0 0 0\n"
                                        "RenderEvent 126 113 0 0 0 0 0\n"
                                        "MouseMoveEvent 129 117 0 0 0 0 0\n"
                                        "RenderEvent 129 117 0 0 0 0 0\n"
                                        "MouseMoveEvent 139 127 0 0 0 0 0\n"
                                        "RenderEvent 139 127 0 0 0 0 0\n"
                                        "MouseMoveEvent 140 128 0 0 0 0 0\n"
                                        "RenderEvent 140 128 0 0 0 0 0\n"
                                        "MouseMoveEvent 141 128 0 0 0 0 0\n"
                                        "RenderEvent 141 128 0 0 0 0 0\n"
                                        "MouseMoveEvent 142 129 0 0 0 0 0\n"
                                        "RenderEvent 142 129 0 0 0 0 0\n"
                                        "MouseMoveEvent 142 130 0 0 0 0 0\n"
                                        "RenderEvent 142 130 0 0 0 0 0\n"
                                        "MouseMoveEvent 144 130 0 0 0 0 0\n"
                                        "RenderEvent 144 130 0 0 0 0 0\n"
                                        "MouseMoveEvent 148 130 0 0 0 0 0\n"
                                        "RenderEvent 148 130 0 0 0 0 0\n"
                                        "MouseMoveEvent 151 131 0 0 0 0 0\n"
                                        "RenderEvent 151 131 0 0 0 0 0\n"
                                        "MouseMoveEvent 152 131 0 0 0 0 0\n"
                                        "RenderEvent 152 131 0 0 0 0 0\n"
                                        "MouseMoveEvent 153 132 0 0 0 0 0\n"
                                        "RenderEvent 153 132 0 0 0 0 0\n"
                                        "MiddleButtonReleaseEvent 153 132 0 0 0 0 0\n"
                                        "EndInteractionEvent 153 132 0 0 0 0 0\n"
                                        "MouseMoveEvent 153 132 0 0 0 0 0\n"
                                        "MouseMoveEvent 156 134 0 0 0 0 0\n"
                                        "MouseMoveEvent 158 137 0 0 0 0 0\n"
                                        "MouseMoveEvent 164 139 0 0 0 0 0\n"
                                        "MouseMoveEvent 171 144 0 0 0 0 0\n"
                                        "MouseMoveEvent 180 150 0 0 0 0 0\n"
                                        "MouseMoveEvent 190 157 0 0 0 0 0\n"
                                        "MouseMoveEvent 201 165 0 0 0 0 0\n"
                                        "MouseMoveEvent 213 174 0 0 0 0 0\n"
                                        "MouseMoveEvent 222 183 0 0 0 0 0\n"
                                        "MouseMoveEvent 232 195 0 0 0 0 0\n"
                                        "MouseMoveEvent 239 206 0 0 0 0 0\n"
                                        "MouseMoveEvent 246 217 0 0 0 0 0\n"
                                        "MouseMoveEvent 251 228 0 0 0 0 0\n"
                                        "MouseMoveEvent 256 238 0 0 0 0 0\n"
                                        "MouseMoveEvent 259 247 0 0 0 0 0\n"
                                        "MouseMoveEvent 263 257 0 0 0 0 0\n"
                                        "MouseMoveEvent 266 264 0 0 0 0 0\n"
                                        "MouseMoveEvent 270 272 0 0 0 0 0\n"
                                        "MouseMoveEvent 273 276 0 0 0 0 0\n"
                                        "MouseMoveEvent 276 281 0 0 0 0 0\n"
                                        "MouseMoveEvent 278 284 0 0 0 0 0\n"
                                        "MouseMoveEvent 278 286 0 0 0 0 0\n"
                                        "MouseMoveEvent 278 287 0 0 0 0 0\n"
                                        "MouseMoveEvent 276 288 0 0 0 0 0\n"
                                        "MouseMoveEvent 276 289 0 0 0 0 0\n"
                                        "MouseMoveEvent 276 290 0 0 0 0 0\n"
                                        "MouseMoveEvent 276 291 0 0 0 0 0\n"
                                        "MouseMoveEvent 276 294 0 0 0 0 0\n"
                                        "MouseMoveEvent 276 296 0 0 0 0 0\n"
                                        "MouseMoveEvent 276 299 0 0 0 0 0\n"
                                        "LeaveEvent 276 299 0 0 0 0 0\n"
                                        "ExitEvent 276 299 0 0 0 0 0\n";

int TestGraphLayoutView(int argc, char* argv[])
{
  bool record = false;

  VTK_CREATE(vtkTesting, testHelper);
  testHelper->AddArguments(argc, const_cast<const char**>(argv));
  string dataRoot = testHelper->GetDataRoot();
  string file = dataRoot + "/Data/treetest.xml";

  VTK_CREATE(vtkXMLTreeReader, reader);
  reader->SetFileName(file.c_str());
  reader->SetMaskArrays(true);
  reader->Update();
  vtkTree* t = reader->GetOutput();
  VTK_CREATE(vtkStringArray, label);
  label->SetName("edge label");
  VTK_CREATE(vtkIdTypeArray, dist);
  dist->SetName("distance");
  for (vtkIdType i = 0; i < t->GetNumberOfEdges(); i++)
  {
    dist->InsertNextValue(i);
    switch (i % 3)
    {
      case 0:
        label->InsertNextValue("a");
        break;
      case 1:
        label->InsertNextValue("b");
        break;
      case 2:
        label->InsertNextValue("c");
        break;
    }
  }
  t->GetEdgeData()->AddArray(dist);
  t->GetEdgeData()->AddArray(label);

  VTK_CREATE(vtkStringToNumeric, numeric);
  numeric->SetInputData(t);

  // Graph layout view
  VTK_CREATE(vtkGraphLayoutView, view);
  view->DisplayHoverTextOn();
  view->SetLayoutStrategyToCircular();
  view->SetVertexLabelArrayName("name");
  view->VertexLabelVisibilityOn();
  view->SetVertexColorArrayName("size");
  view->ColorVerticesOn();
  view->SetRepresentationFromInputConnection(numeric->GetOutputPort());
  view->SetVertexScalarBarVisibility(true);
  view->SetEdgeColorArrayName("distance");
  view->ColorEdgesOn();
  view->SetEdgeLabelArrayName("edge label");
  view->EdgeLabelVisibilityOn();
  vtkRenderedGraphRepresentation* rep =
    vtkRenderedGraphRepresentation::SafeDownCast(view->GetRepresentation());
  rep->SetVertexHoverArrayName("name");
  rep->SetEdgeHoverArrayName("edge label");
  rep->GetVertexScalarBar()->GetScalarBarActor()->SetOrientation(VTK_ORIENT_HORIZONTAL);
  rep->GetVertexScalarBar()->GetScalarBarActor()->SetPosition(0.05, 0.05);
  rep->GetVertexScalarBar()->GetScalarBarActor()->SetPosition2(0.55, 0.15);

  view->ResetCamera();

  // record events
  VTK_CREATE(vtkInteractorEventRecorder, recorder);
  recorder->SetInteractor(view->GetInteractor());
  if (record)
  {
    recorder->SetFileName("record.log");
    recorder->SetEnabled(true);
    recorder->Record();
  }
  else
  {
    recorder->ReadFromInputStringOn();
    recorder->SetInputString(GraphLayoutViewEventLog);
  }

  // interact with data
  // render the image
  //
  view->GetInteractor()->Initialize();
  view->Render();
  if (!record)
  {
    recorder->Play();
    // Remove the observers so we can go interactive. Without this the "-I"
    // testing option fails.
    recorder->Off();
  }

  int retVal = vtkRegressionTestImage(view->GetRenderWindow());
  if (retVal == vtkRegressionTester::DO_INTERACTOR)
  {
    view->GetInteractor()->Initialize();
    view->GetInteractor()->Start();

    retVal = vtkRegressionTester::PASSED;
  }

  return !retVal;
}
