// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-FileCopyrightText: Copyright 2008 Sandia Corporation
// SPDX-License-Identifier: LicenseRef-BSD-3-Clause-Sandia-USGov

#include "vtkTreeMapLayoutStrategy.h"

#include "vtkAdjacentVertexIterator.h"
#include "vtkFloatArray.h"
#include "vtkTree.h"

VTK_ABI_NAMESPACE_BEGIN
vtkTreeMapLayoutStrategy::vtkTreeMapLayoutStrategy() = default;

vtkTreeMapLayoutStrategy::~vtkTreeMapLayoutStrategy() = default;

void vtkTreeMapLayoutStrategy::PrintSelf(ostream& os, vtkIndent indent)
{
  this->Superclass::PrintSelf(os, indent);
}

void vtkTreeMapLayoutStrategy::AddBorder(float* boxInfo)
{
  float dx, dy;
  dx = 0.5 * (boxInfo[1] - boxInfo[0]) * this->ShrinkPercentage;
  dy = 0.5 * (boxInfo[3] - boxInfo[2]) * this->ShrinkPercentage;
  boxInfo[0] += dx;
  boxInfo[1] -= dx;
  boxInfo[2] += dy;
  boxInfo[3] -= dy;
}

vtkIdType vtkTreeMapLayoutStrategy::FindVertex(vtkTree* otree, vtkDataArray* array, float pnt[2])
{
  // Check to see that we are in the dataset at all
  float blimits[4];

  vtkIdType vertex = otree->GetRoot();
  vtkFloatArray* boxInfo = vtkArrayDownCast<vtkFloatArray>(array);
  // Now try to find the vertex that contains the point
  boxInfo->GetTypedTuple(vertex, blimits); // Get the extents of the root
  if ((pnt[0] < blimits[0]) || (pnt[0] > blimits[1]) || (pnt[1] < blimits[2]) ||
    (pnt[1] > blimits[3]))
  {
    // Point is not in the tree at all
    return -1;
  }

  // Now traverse the children to try and find
  // the vertex that contains the point
  vtkIdType child;
#if 0
  if (binfo)
  {
    binfo[0] = blimits[0];
    binfo[1] = blimits[1];
    binfo[2] = blimits[2];
    binfo[3] = blimits[3];
  }
#endif

  vtkAdjacentVertexIterator* it = vtkAdjacentVertexIterator::New();
  otree->GetAdjacentVertices(vertex, it);
  while (it->HasNext())
  {
    child = it->Next();
    boxInfo->GetTypedTuple(child, blimits); // Get the extents of the child
    if ((pnt[0] < blimits[0]) || (pnt[0] > blimits[1]) || (pnt[1] < blimits[2]) ||
      (pnt[1] > blimits[3]))
    {
      continue;
    }
    // If we are here then the point is contained by the child
    // So recurse down the children of this vertex
    vertex = child;
    otree->GetAdjacentVertices(vertex, it);
  }
  it->Delete();

  return vertex;
}
VTK_ABI_NAMESPACE_END
