/*
 * Decompiled with CFR 0.152.
 */
import com.sun.xml.fastinfoset.sax.SAXDocumentSerializer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.helpers.DefaultHandler;

public class vtkX3DBinaryConverter {
    private ByteArrayOutputStream WriteStream;
    private SAXDocumentSerializer DocumentSerializer;

    public vtkX3DBinaryConverter(String string) throws Exception {
        System.out.println("Write X3D binary file: " + string);
        this.WriteStream = new ByteArrayOutputStream();
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string));
        this.DocumentSerializer = new SAXDocumentSerializer();
        this.DocumentSerializer.setOutputStream(bufferedOutputStream);
    }

    public void Write(byte[] byArray) throws IOException {
        this.WriteStream.write(byArray, 0, byArray.length);
    }

    public void Close() throws Exception {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.WriteStream.toByteArray());
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setNamespaceAware(true);
        SAXParser sAXParser = sAXParserFactory.newSAXParser();
        sAXParser.parse((InputStream)byteArrayInputStream, (DefaultHandler)this.DocumentSerializer);
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println("Create converter");
            vtkX3DBinaryConverter vtkX3DBinaryConverter2 = new vtkX3DBinaryConverter("out.x3db");
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream("export.x3d"));
            System.out.println("Read file: " + ((InputStream)bufferedInputStream).available());
            byte[] byArray = new byte[((InputStream)bufferedInputStream).available()];
            ((InputStream)bufferedInputStream).read(byArray);
            vtkX3DBinaryConverter2.Write(byArray);
            System.out.println("Done...");
            vtkX3DBinaryConverter2.Close();
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }
}

