/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyThresholdOpAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>

// ****************************************************************************
// Module: PyThresholdOpAttributes
//
// Purpose: 
//   This class contains attributes for the threshold operator.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a ThresholdOpAttributes.
//
struct ThresholdOpAttributesObject
{
    PyObject_HEAD
    ThresholdOpAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewThresholdOpAttributes(int);

std::string
PyThresholdOpAttributes_ToString(const ThresholdOpAttributes *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    SNPRINTF(tmpStr, 1000, "%soutputMeshType = %d\n", prefix, atts->GetOutputMeshType());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sboundsInputType = %d\n", prefix, atts->GetBoundsInputType());
    str += tmpStr;
    {   const stringVector &listedVarNames = atts->GetListedVarNames();
        SNPRINTF(tmpStr, 1000, "%slistedVarNames = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < listedVarNames.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "\"%s\"", listedVarNames[i].c_str());
            str += tmpStr;
            if(i < listedVarNames.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const intVector &zonePortions = atts->GetZonePortions();
        SNPRINTF(tmpStr, 1000, "%szonePortions = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < zonePortions.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "%d", zonePortions[i]);
            str += tmpStr;
            if(i < zonePortions.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const doubleVector &lowerBounds = atts->GetLowerBounds();
        SNPRINTF(tmpStr, 1000, "%slowerBounds = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < lowerBounds.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", lowerBounds[i]);
            str += tmpStr;
            if(i < lowerBounds.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const doubleVector &upperBounds = atts->GetUpperBounds();
        SNPRINTF(tmpStr, 1000, "%supperBounds = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < upperBounds.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", upperBounds[i]);
            str += tmpStr;
            if(i < upperBounds.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    SNPRINTF(tmpStr, 1000, "%sdefaultVarName = \"%s\"\n", prefix, atts->GetDefaultVarName().c_str());
    str += tmpStr;
    if(atts->GetDefaultVarIsScalar())
        SNPRINTF(tmpStr, 1000, "%sdefaultVarIsScalar = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sdefaultVarIsScalar = 0\n", prefix);
    str += tmpStr;
    {   const stringVector &boundsRange = atts->GetBoundsRange();
        SNPRINTF(tmpStr, 1000, "%sboundsRange = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < boundsRange.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "\"%s\"", boundsRange[i].c_str());
            str += tmpStr;
            if(i < boundsRange.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    return str;
}

static PyObject *
ThresholdOpAttributes_Notify(PyObject *self, PyObject *args)
{
    ThresholdOpAttributesObject *obj = (ThresholdOpAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ThresholdOpAttributes_SetOutputMeshType(PyObject *self, PyObject *args)
{
    ThresholdOpAttributesObject *obj = (ThresholdOpAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the outputMeshType in the object.
    obj->data->SetOutputMeshType((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ThresholdOpAttributes_GetOutputMeshType(PyObject *self, PyObject *args)
{
    ThresholdOpAttributesObject *obj = (ThresholdOpAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetOutputMeshType()));
    return retval;
}

/*static*/ PyObject *
ThresholdOpAttributes_SetBoundsInputType(PyObject *self, PyObject *args)
{
    ThresholdOpAttributesObject *obj = (ThresholdOpAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the boundsInputType in the object.
    obj->data->SetBoundsInputType((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ThresholdOpAttributes_GetBoundsInputType(PyObject *self, PyObject *args)
{
    ThresholdOpAttributesObject *obj = (ThresholdOpAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetBoundsInputType()));
    return retval;
}

/*static*/ PyObject *
ThresholdOpAttributes_SetListedVarNames(PyObject *self, PyObject *args)
{
    ThresholdOpAttributesObject *obj = (ThresholdOpAttributesObject *)self;

    stringVector  &vec = obj->data->GetListedVarNames();
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyString_Check(item))
                vec[i] = std::string(PyString_AS_STRING(item));
            else
                vec[i] = std::string("");
        }
    }
    else if(PyString_Check(tuple))
    {
        vec.resize(1);
        vec[0] = std::string(PyString_AS_STRING(tuple));
    }
    else
        return NULL;

    // Mark the listedVarNames in the object as modified.
    obj->data->SelectListedVarNames();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ThresholdOpAttributes_GetListedVarNames(PyObject *self, PyObject *args)
{
    ThresholdOpAttributesObject *obj = (ThresholdOpAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the listedVarNames.
    const stringVector &listedVarNames = obj->data->GetListedVarNames();
    PyObject *retval = PyTuple_New(listedVarNames.size());
    for(size_t i = 0; i < listedVarNames.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyString_FromString(listedVarNames[i].c_str()));
    return retval;
}

/*static*/ PyObject *
ThresholdOpAttributes_SetZonePortions(PyObject *self, PyObject *args)
{
    ThresholdOpAttributesObject *obj = (ThresholdOpAttributesObject *)self;

    intVector  &vec = obj->data->GetZonePortions();
    PyObject   *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = int(PyFloat_AS_DOUBLE(item));
            else if(PyInt_Check(item))
                vec[i] = int(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = int(PyLong_AsLong(item));
            else
                vec[i] = 0;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyFloat_AS_DOUBLE(tuple));
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyLong_AsLong(tuple));
    }
    else
        return NULL;

    // Mark the zonePortions in the object as modified.
    obj->data->SelectZonePortions();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ThresholdOpAttributes_GetZonePortions(PyObject *self, PyObject *args)
{
    ThresholdOpAttributesObject *obj = (ThresholdOpAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the zonePortions.
    const intVector &zonePortions = obj->data->GetZonePortions();
    PyObject *retval = PyTuple_New(zonePortions.size());
    for(size_t i = 0; i < zonePortions.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyInt_FromLong(long(zonePortions[i])));
    return retval;
}

/*static*/ PyObject *
ThresholdOpAttributes_SetLowerBounds(PyObject *self, PyObject *args)
{
    ThresholdOpAttributesObject *obj = (ThresholdOpAttributesObject *)self;

    doubleVector  &vec = obj->data->GetLowerBounds();
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = PyFloat_AS_DOUBLE(item);
            else if(PyInt_Check(item))
                vec[i] = double(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = PyLong_AsDouble(item);
            else
                vec[i] = 0.;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = PyFloat_AS_DOUBLE(tuple);
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = double(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = PyLong_AsDouble(tuple);
    }
    else
        return NULL;

    // Mark the lowerBounds in the object as modified.
    obj->data->SelectLowerBounds();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ThresholdOpAttributes_GetLowerBounds(PyObject *self, PyObject *args)
{
    ThresholdOpAttributesObject *obj = (ThresholdOpAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the lowerBounds.
    const doubleVector &lowerBounds = obj->data->GetLowerBounds();
    PyObject *retval = PyTuple_New(lowerBounds.size());
    for(size_t i = 0; i < lowerBounds.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(lowerBounds[i]));
    return retval;
}

/*static*/ PyObject *
ThresholdOpAttributes_SetUpperBounds(PyObject *self, PyObject *args)
{
    ThresholdOpAttributesObject *obj = (ThresholdOpAttributesObject *)self;

    doubleVector  &vec = obj->data->GetUpperBounds();
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = PyFloat_AS_DOUBLE(item);
            else if(PyInt_Check(item))
                vec[i] = double(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = PyLong_AsDouble(item);
            else
                vec[i] = 0.;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = PyFloat_AS_DOUBLE(tuple);
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = double(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = PyLong_AsDouble(tuple);
    }
    else
        return NULL;

    // Mark the upperBounds in the object as modified.
    obj->data->SelectUpperBounds();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ThresholdOpAttributes_GetUpperBounds(PyObject *self, PyObject *args)
{
    ThresholdOpAttributesObject *obj = (ThresholdOpAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the upperBounds.
    const doubleVector &upperBounds = obj->data->GetUpperBounds();
    PyObject *retval = PyTuple_New(upperBounds.size());
    for(size_t i = 0; i < upperBounds.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(upperBounds[i]));
    return retval;
}

/*static*/ PyObject *
ThresholdOpAttributes_SetDefaultVarName(PyObject *self, PyObject *args)
{
    ThresholdOpAttributesObject *obj = (ThresholdOpAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the defaultVarName in the object.
    obj->data->SetDefaultVarName(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ThresholdOpAttributes_GetDefaultVarName(PyObject *self, PyObject *args)
{
    ThresholdOpAttributesObject *obj = (ThresholdOpAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetDefaultVarName().c_str());
    return retval;
}

/*static*/ PyObject *
ThresholdOpAttributes_SetDefaultVarIsScalar(PyObject *self, PyObject *args)
{
    ThresholdOpAttributesObject *obj = (ThresholdOpAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the defaultVarIsScalar in the object.
    obj->data->SetDefaultVarIsScalar(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ThresholdOpAttributes_GetDefaultVarIsScalar(PyObject *self, PyObject *args)
{
    ThresholdOpAttributesObject *obj = (ThresholdOpAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetDefaultVarIsScalar()?1L:0L);
    return retval;
}

/*static*/ PyObject *
ThresholdOpAttributes_SetBoundsRange(PyObject *self, PyObject *args)
{
    ThresholdOpAttributesObject *obj = (ThresholdOpAttributesObject *)self;

    stringVector  &vec = obj->data->GetBoundsRange();
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyString_Check(item))
                vec[i] = std::string(PyString_AS_STRING(item));
            else
                vec[i] = std::string("");
        }
    }
    else if(PyString_Check(tuple))
    {
        vec.resize(1);
        vec[0] = std::string(PyString_AS_STRING(tuple));
    }
    else
        return NULL;

    // Mark the boundsRange in the object as modified.
    obj->data->SelectBoundsRange();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ThresholdOpAttributes_GetBoundsRange(PyObject *self, PyObject *args)
{
    ThresholdOpAttributesObject *obj = (ThresholdOpAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the boundsRange.
    const stringVector &boundsRange = obj->data->GetBoundsRange();
    PyObject *retval = PyTuple_New(boundsRange.size());
    for(size_t i = 0; i < boundsRange.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyString_FromString(boundsRange[i].c_str()));
    return retval;
}



PyMethodDef PyThresholdOpAttributes_methods[THRESHOLDOPATTRIBUTES_NMETH] = {
    {"Notify", ThresholdOpAttributes_Notify, METH_VARARGS},
    {"SetOutputMeshType", ThresholdOpAttributes_SetOutputMeshType, METH_VARARGS},
    {"GetOutputMeshType", ThresholdOpAttributes_GetOutputMeshType, METH_VARARGS},
    {"SetBoundsInputType", ThresholdOpAttributes_SetBoundsInputType, METH_VARARGS},
    {"GetBoundsInputType", ThresholdOpAttributes_GetBoundsInputType, METH_VARARGS},
    {"SetListedVarNames", ThresholdOpAttributes_SetListedVarNames, METH_VARARGS},
    {"GetListedVarNames", ThresholdOpAttributes_GetListedVarNames, METH_VARARGS},
    {"SetZonePortions", ThresholdOpAttributes_SetZonePortions, METH_VARARGS},
    {"GetZonePortions", ThresholdOpAttributes_GetZonePortions, METH_VARARGS},
    {"SetLowerBounds", ThresholdOpAttributes_SetLowerBounds, METH_VARARGS},
    {"GetLowerBounds", ThresholdOpAttributes_GetLowerBounds, METH_VARARGS},
    {"SetUpperBounds", ThresholdOpAttributes_SetUpperBounds, METH_VARARGS},
    {"GetUpperBounds", ThresholdOpAttributes_GetUpperBounds, METH_VARARGS},
    {"SetDefaultVarName", ThresholdOpAttributes_SetDefaultVarName, METH_VARARGS},
    {"GetDefaultVarName", ThresholdOpAttributes_GetDefaultVarName, METH_VARARGS},
    {"SetDefaultVarIsScalar", ThresholdOpAttributes_SetDefaultVarIsScalar, METH_VARARGS},
    {"GetDefaultVarIsScalar", ThresholdOpAttributes_GetDefaultVarIsScalar, METH_VARARGS},
    {"SetBoundsRange", ThresholdOpAttributes_SetBoundsRange, METH_VARARGS},
    {"GetBoundsRange", ThresholdOpAttributes_GetBoundsRange, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
ThresholdOpAttributes_dealloc(PyObject *v)
{
   ThresholdOpAttributesObject *obj = (ThresholdOpAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
ThresholdOpAttributes_compare(PyObject *v, PyObject *w)
{
    ThresholdOpAttributes *a = ((ThresholdOpAttributesObject *)v)->data;
    ThresholdOpAttributes *b = ((ThresholdOpAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyThresholdOpAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "outputMeshType") == 0)
        return ThresholdOpAttributes_GetOutputMeshType(self, NULL);
    if(strcmp(name, "boundsInputType") == 0)
        return ThresholdOpAttributes_GetBoundsInputType(self, NULL);
    if(strcmp(name, "listedVarNames") == 0)
        return ThresholdOpAttributes_GetListedVarNames(self, NULL);
    if(strcmp(name, "zonePortions") == 0)
        return ThresholdOpAttributes_GetZonePortions(self, NULL);
    if(strcmp(name, "lowerBounds") == 0)
        return ThresholdOpAttributes_GetLowerBounds(self, NULL);
    if(strcmp(name, "upperBounds") == 0)
        return ThresholdOpAttributes_GetUpperBounds(self, NULL);
    if(strcmp(name, "defaultVarName") == 0)
        return ThresholdOpAttributes_GetDefaultVarName(self, NULL);
    if(strcmp(name, "defaultVarIsScalar") == 0)
        return ThresholdOpAttributes_GetDefaultVarIsScalar(self, NULL);
    if(strcmp(name, "boundsRange") == 0)
        return ThresholdOpAttributes_GetBoundsRange(self, NULL);

    return Py_FindMethod(PyThresholdOpAttributes_methods, self, name);
}

int
PyThresholdOpAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "outputMeshType") == 0)
        obj = ThresholdOpAttributes_SetOutputMeshType(self, tuple);
    else if(strcmp(name, "boundsInputType") == 0)
        obj = ThresholdOpAttributes_SetBoundsInputType(self, tuple);
    else if(strcmp(name, "listedVarNames") == 0)
        obj = ThresholdOpAttributes_SetListedVarNames(self, tuple);
    else if(strcmp(name, "zonePortions") == 0)
        obj = ThresholdOpAttributes_SetZonePortions(self, tuple);
    else if(strcmp(name, "lowerBounds") == 0)
        obj = ThresholdOpAttributes_SetLowerBounds(self, tuple);
    else if(strcmp(name, "upperBounds") == 0)
        obj = ThresholdOpAttributes_SetUpperBounds(self, tuple);
    else if(strcmp(name, "defaultVarName") == 0)
        obj = ThresholdOpAttributes_SetDefaultVarName(self, tuple);
    else if(strcmp(name, "defaultVarIsScalar") == 0)
        obj = ThresholdOpAttributes_SetDefaultVarIsScalar(self, tuple);
    else if(strcmp(name, "boundsRange") == 0)
        obj = ThresholdOpAttributes_SetBoundsRange(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
ThresholdOpAttributes_print(PyObject *v, FILE *fp, int flags)
{
    ThresholdOpAttributesObject *obj = (ThresholdOpAttributesObject *)v;
    fprintf(fp, "%s", PyThresholdOpAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
ThresholdOpAttributes_str(PyObject *v)
{
    ThresholdOpAttributesObject *obj = (ThresholdOpAttributesObject *)v;
    return PyString_FromString(PyThresholdOpAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *ThresholdOpAttributes_Purpose = "This class contains attributes for the threshold operator.";
#else
static char *ThresholdOpAttributes_Purpose = "This class contains attributes for the threshold operator.";
#endif

//
// The type description structure
//
static PyTypeObject ThresholdOpAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "ThresholdOpAttributes",                    // tp_name
    sizeof(ThresholdOpAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)ThresholdOpAttributes_dealloc,  // tp_dealloc
    (printfunc)ThresholdOpAttributes_print,     // tp_print
    (getattrfunc)PyThresholdOpAttributes_getattr, // tp_getattr
    (setattrfunc)PyThresholdOpAttributes_setattr, // tp_setattr
    (cmpfunc)ThresholdOpAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)ThresholdOpAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    ThresholdOpAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static ThresholdOpAttributes *defaultAtts = 0;
static ThresholdOpAttributes *currentAtts = 0;

static PyObject *
NewThresholdOpAttributes(int useCurrent)
{
    ThresholdOpAttributesObject *newObject;
    newObject = PyObject_NEW(ThresholdOpAttributesObject, &ThresholdOpAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new ThresholdOpAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new ThresholdOpAttributes(*defaultAtts);
    else
        newObject->data = new ThresholdOpAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapThresholdOpAttributes(const ThresholdOpAttributes *attr)
{
    ThresholdOpAttributesObject *newObject;
    newObject = PyObject_NEW(ThresholdOpAttributesObject, &ThresholdOpAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (ThresholdOpAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
ThresholdOpAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewThresholdOpAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef ThresholdOpAttributesMethods[] = {
    {"ThresholdOpAttributes", ThresholdOpAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *ThresholdOpAttributesObserver = 0;

std::string
PyThresholdOpAttributes_GetLogString()
{
    std::string s("ThresholdOpAtts = ThresholdOpAttributes()\n");
    if(currentAtts != 0)
        s += PyThresholdOpAttributes_ToString(currentAtts, "ThresholdOpAtts.");
    return s;
}

static void
PyThresholdOpAttributes_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("ThresholdOpAtts = ThresholdOpAttributes()\n");
        s += PyThresholdOpAttributes_ToString(currentAtts, "ThresholdOpAtts.");
        cb(s);
    }
}

void
PyThresholdOpAttributes_StartUp(ThresholdOpAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyThresholdOpAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(ThresholdOpAttributesObserver == 0)
    {
        ThresholdOpAttributesObserver = new ObserverToCallback(subj,
            PyThresholdOpAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyThresholdOpAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete ThresholdOpAttributesObserver;
    ThresholdOpAttributesObserver = 0;
}

PyMethodDef *
PyThresholdOpAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return ThresholdOpAttributesMethods;
}

bool
PyThresholdOpAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &ThresholdOpAttributesType);
}

ThresholdOpAttributes *
PyThresholdOpAttributes_FromPyObject(PyObject *obj)
{
    ThresholdOpAttributesObject *obj2 = (ThresholdOpAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyThresholdOpAttributes_New()
{
    return NewThresholdOpAttributes(0);
}

PyObject *
PyThresholdOpAttributes_Wrap(const ThresholdOpAttributes *attr)
{
    return WrapThresholdOpAttributes(attr);
}

void
PyThresholdOpAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    ThresholdOpAttributesObject *obj2 = (ThresholdOpAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyThresholdOpAttributes_SetDefaults(const ThresholdOpAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new ThresholdOpAttributes(*atts);
}

