/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyVolumeAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>
#include <PyColorControlPointList.h>
#include <PyGaussianControlPointList.h>

// ****************************************************************************
// Module: PyVolumeAttributes
//
// Purpose: 
//   This class contains the plot attributes for the volume plot.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a VolumeAttributes.
//
struct VolumeAttributesObject
{
    PyObject_HEAD
    VolumeAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewVolumeAttributes(int);

std::string
PyVolumeAttributes_ToString(const VolumeAttributes *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    if(atts->GetOsprayShadowsEnabledFlag())
        SNPRINTF(tmpStr, 1000, "%sosprayShadowsEnabledFlag = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sosprayShadowsEnabledFlag = 0\n", prefix);
    str += tmpStr;
    if(atts->GetOsprayUseGridAcceleratorFlag())
        SNPRINTF(tmpStr, 1000, "%sosprayUseGridAcceleratorFlag = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sosprayUseGridAcceleratorFlag = 0\n", prefix);
    str += tmpStr;
    if(atts->GetOsprayPreIntegrationFlag())
        SNPRINTF(tmpStr, 1000, "%sosprayPreIntegrationFlag = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sosprayPreIntegrationFlag = 0\n", prefix);
    str += tmpStr;
    if(atts->GetOspraySingleShadeFlag())
        SNPRINTF(tmpStr, 1000, "%sospraySingleShadeFlag = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sospraySingleShadeFlag = 0\n", prefix);
    str += tmpStr;
    if(atts->GetOsprayOneSidedLightingFlag())
        SNPRINTF(tmpStr, 1000, "%sosprayOneSidedLightingFlag = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sosprayOneSidedLightingFlag = 0\n", prefix);
    str += tmpStr;
    if(atts->GetOsprayAoTransparencyEnabledFlag())
        SNPRINTF(tmpStr, 1000, "%sosprayAoTransparencyEnabledFlag = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sosprayAoTransparencyEnabledFlag = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sospraySpp = %d\n", prefix, atts->GetOspraySpp());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sosprayAoSamples = %d\n", prefix, atts->GetOsprayAoSamples());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sosprayAoDistance = %g\n", prefix, atts->GetOsprayAoDistance());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sosprayMinContribution = %g\n", prefix, atts->GetOsprayMinContribution());
    str += tmpStr;
    if(atts->GetLegendFlag())
        SNPRINTF(tmpStr, 1000, "%slegendFlag = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%slegendFlag = 0\n", prefix);
    str += tmpStr;
    if(atts->GetLightingFlag())
        SNPRINTF(tmpStr, 1000, "%slightingFlag = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%slightingFlag = 0\n", prefix);
    str += tmpStr;
    { // new scope
        std::string objPrefix(prefix);
        objPrefix += "colorControlPoints.";
        str += PyColorControlPointList_ToString(&atts->GetColorControlPoints(), objPrefix.c_str());
    }
    SNPRINTF(tmpStr, 1000, "%sopacityAttenuation = %g\n", prefix, atts->GetOpacityAttenuation());
    str += tmpStr;
    const char *opacityMode_names = "FreeformMode, GaussianMode, ColorTableMode";
    switch (atts->GetOpacityMode())
    {
      case VolumeAttributes::FreeformMode:
          SNPRINTF(tmpStr, 1000, "%sopacityMode = %sFreeformMode  # %s\n", prefix, prefix, opacityMode_names);
          str += tmpStr;
          break;
      case VolumeAttributes::GaussianMode:
          SNPRINTF(tmpStr, 1000, "%sopacityMode = %sGaussianMode  # %s\n", prefix, prefix, opacityMode_names);
          str += tmpStr;
          break;
      case VolumeAttributes::ColorTableMode:
          SNPRINTF(tmpStr, 1000, "%sopacityMode = %sColorTableMode  # %s\n", prefix, prefix, opacityMode_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    { // new scope
        std::string objPrefix(prefix);
        objPrefix += "opacityControlPoints.";
        str += PyGaussianControlPointList_ToString(&atts->GetOpacityControlPoints(), objPrefix.c_str());
    }
    if(atts->GetResampleFlag())
        SNPRINTF(tmpStr, 1000, "%sresampleFlag = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sresampleFlag = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sresampleTarget = %d\n", prefix, atts->GetResampleTarget());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sopacityVariable = \"%s\"\n", prefix, atts->GetOpacityVariable().c_str());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%scompactVariable = \"%s\"\n", prefix, atts->GetCompactVariable().c_str());
    str += tmpStr;
    {   const unsigned char *freeformOpacity = atts->GetFreeformOpacity();
        SNPRINTF(tmpStr, 1000, "%sfreeformOpacity = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 256; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%d", int(freeformOpacity[i]));
            str += tmpStr;
            if(i < 255)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    if(atts->GetUseColorVarMin())
        SNPRINTF(tmpStr, 1000, "%suseColorVarMin = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%suseColorVarMin = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%scolorVarMin = %g\n", prefix, atts->GetColorVarMin());
    str += tmpStr;
    if(atts->GetUseColorVarMax())
        SNPRINTF(tmpStr, 1000, "%suseColorVarMax = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%suseColorVarMax = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%scolorVarMax = %g\n", prefix, atts->GetColorVarMax());
    str += tmpStr;
    if(atts->GetUseOpacityVarMin())
        SNPRINTF(tmpStr, 1000, "%suseOpacityVarMin = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%suseOpacityVarMin = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sopacityVarMin = %g\n", prefix, atts->GetOpacityVarMin());
    str += tmpStr;
    if(atts->GetUseOpacityVarMax())
        SNPRINTF(tmpStr, 1000, "%suseOpacityVarMax = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%suseOpacityVarMax = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sopacityVarMax = %g\n", prefix, atts->GetOpacityVarMax());
    str += tmpStr;
    if(atts->GetSmoothData())
        SNPRINTF(tmpStr, 1000, "%ssmoothData = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%ssmoothData = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%ssamplesPerRay = %d\n", prefix, atts->GetSamplesPerRay());
    str += tmpStr;
    const char *rendererType_names = "Default, RayCasting, RayCastingIntegration, RayCastingSLIVR, RayCastingOSPRay";
    switch (atts->GetRendererType())
    {
      case VolumeAttributes::Default:
          SNPRINTF(tmpStr, 1000, "%srendererType = %sDefault  # %s\n", prefix, prefix, rendererType_names);
          str += tmpStr;
          break;
      case VolumeAttributes::RayCasting:
          SNPRINTF(tmpStr, 1000, "%srendererType = %sRayCasting  # %s\n", prefix, prefix, rendererType_names);
          str += tmpStr;
          break;
      case VolumeAttributes::RayCastingIntegration:
          SNPRINTF(tmpStr, 1000, "%srendererType = %sRayCastingIntegration  # %s\n", prefix, prefix, rendererType_names);
          str += tmpStr;
          break;
      case VolumeAttributes::RayCastingSLIVR:
          SNPRINTF(tmpStr, 1000, "%srendererType = %sRayCastingSLIVR  # %s\n", prefix, prefix, rendererType_names);
          str += tmpStr;
          break;
      case VolumeAttributes::RayCastingOSPRay:
          SNPRINTF(tmpStr, 1000, "%srendererType = %sRayCastingOSPRay  # %s\n", prefix, prefix, rendererType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    const char *gradientType_names = "CenteredDifferences, SobelOperator";
    switch (atts->GetGradientType())
    {
      case VolumeAttributes::CenteredDifferences:
          SNPRINTF(tmpStr, 1000, "%sgradientType = %sCenteredDifferences  # %s\n", prefix, prefix, gradientType_names);
          str += tmpStr;
          break;
      case VolumeAttributes::SobelOperator:
          SNPRINTF(tmpStr, 1000, "%sgradientType = %sSobelOperator  # %s\n", prefix, prefix, gradientType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    const char *scaling_names = "Linear, Log, Skew";
    switch (atts->GetScaling())
    {
      case VolumeAttributes::Linear:
          SNPRINTF(tmpStr, 1000, "%sscaling = %sLinear  # %s\n", prefix, prefix, scaling_names);
          str += tmpStr;
          break;
      case VolumeAttributes::Log:
          SNPRINTF(tmpStr, 1000, "%sscaling = %sLog  # %s\n", prefix, prefix, scaling_names);
          str += tmpStr;
          break;
      case VolumeAttributes::Skew:
          SNPRINTF(tmpStr, 1000, "%sscaling = %sSkew  # %s\n", prefix, prefix, scaling_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    SNPRINTF(tmpStr, 1000, "%sskewFactor = %g\n", prefix, atts->GetSkewFactor());
    str += tmpStr;
    const char *limitsMode_names = "OriginalData, CurrentPlot";
    switch (atts->GetLimitsMode())
    {
      case VolumeAttributes::OriginalData:
          SNPRINTF(tmpStr, 1000, "%slimitsMode = %sOriginalData  # %s\n", prefix, prefix, limitsMode_names);
          str += tmpStr;
          break;
      case VolumeAttributes::CurrentPlot:
          SNPRINTF(tmpStr, 1000, "%slimitsMode = %sCurrentPlot  # %s\n", prefix, prefix, limitsMode_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    const char *sampling_names = "KernelBased, Rasterization, Trilinear";
    switch (atts->GetSampling())
    {
      case VolumeAttributes::KernelBased:
          SNPRINTF(tmpStr, 1000, "%ssampling = %sKernelBased  # %s\n", prefix, prefix, sampling_names);
          str += tmpStr;
          break;
      case VolumeAttributes::Rasterization:
          SNPRINTF(tmpStr, 1000, "%ssampling = %sRasterization  # %s\n", prefix, prefix, sampling_names);
          str += tmpStr;
          break;
      case VolumeAttributes::Trilinear:
          SNPRINTF(tmpStr, 1000, "%ssampling = %sTrilinear  # %s\n", prefix, prefix, sampling_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    SNPRINTF(tmpStr, 1000, "%srendererSamples = %g\n", prefix, atts->GetRendererSamples());
    str += tmpStr;
    const char *lowGradientLightingReduction_names = "Off, Lowest, Lower, Low, Medium, "
        "High, Higher, Highest";
    switch (atts->GetLowGradientLightingReduction())
    {
      case VolumeAttributes::Off:
          SNPRINTF(tmpStr, 1000, "%slowGradientLightingReduction = %sOff  # %s\n", prefix, prefix, lowGradientLightingReduction_names);
          str += tmpStr;
          break;
      case VolumeAttributes::Lowest:
          SNPRINTF(tmpStr, 1000, "%slowGradientLightingReduction = %sLowest  # %s\n", prefix, prefix, lowGradientLightingReduction_names);
          str += tmpStr;
          break;
      case VolumeAttributes::Lower:
          SNPRINTF(tmpStr, 1000, "%slowGradientLightingReduction = %sLower  # %s\n", prefix, prefix, lowGradientLightingReduction_names);
          str += tmpStr;
          break;
      case VolumeAttributes::Low:
          SNPRINTF(tmpStr, 1000, "%slowGradientLightingReduction = %sLow  # %s\n", prefix, prefix, lowGradientLightingReduction_names);
          str += tmpStr;
          break;
      case VolumeAttributes::Medium:
          SNPRINTF(tmpStr, 1000, "%slowGradientLightingReduction = %sMedium  # %s\n", prefix, prefix, lowGradientLightingReduction_names);
          str += tmpStr;
          break;
      case VolumeAttributes::High:
          SNPRINTF(tmpStr, 1000, "%slowGradientLightingReduction = %sHigh  # %s\n", prefix, prefix, lowGradientLightingReduction_names);
          str += tmpStr;
          break;
      case VolumeAttributes::Higher:
          SNPRINTF(tmpStr, 1000, "%slowGradientLightingReduction = %sHigher  # %s\n", prefix, prefix, lowGradientLightingReduction_names);
          str += tmpStr;
          break;
      case VolumeAttributes::Highest:
          SNPRINTF(tmpStr, 1000, "%slowGradientLightingReduction = %sHighest  # %s\n", prefix, prefix, lowGradientLightingReduction_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    if(atts->GetLowGradientLightingClampFlag())
        SNPRINTF(tmpStr, 1000, "%slowGradientLightingClampFlag = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%slowGradientLightingClampFlag = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%slowGradientLightingClampValue = %g\n", prefix, atts->GetLowGradientLightingClampValue());
    str += tmpStr;
    {   const double *materialProperties = atts->GetMaterialProperties();
        SNPRINTF(tmpStr, 1000, "%smaterialProperties = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 4; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", materialProperties[i]);
            str += tmpStr;
            if(i < 3)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    return str;
}

static PyObject *
VolumeAttributes_Notify(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VolumeAttributes_SetOsprayShadowsEnabledFlag(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the osprayShadowsEnabledFlag in the object.
    obj->data->SetOsprayShadowsEnabledFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VolumeAttributes_GetOsprayShadowsEnabledFlag(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetOsprayShadowsEnabledFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
VolumeAttributes_SetOsprayUseGridAcceleratorFlag(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the osprayUseGridAcceleratorFlag in the object.
    obj->data->SetOsprayUseGridAcceleratorFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VolumeAttributes_GetOsprayUseGridAcceleratorFlag(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetOsprayUseGridAcceleratorFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
VolumeAttributes_SetOsprayPreIntegrationFlag(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the osprayPreIntegrationFlag in the object.
    obj->data->SetOsprayPreIntegrationFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VolumeAttributes_GetOsprayPreIntegrationFlag(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetOsprayPreIntegrationFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
VolumeAttributes_SetOspraySingleShadeFlag(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the ospraySingleShadeFlag in the object.
    obj->data->SetOspraySingleShadeFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VolumeAttributes_GetOspraySingleShadeFlag(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetOspraySingleShadeFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
VolumeAttributes_SetOsprayOneSidedLightingFlag(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the osprayOneSidedLightingFlag in the object.
    obj->data->SetOsprayOneSidedLightingFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VolumeAttributes_GetOsprayOneSidedLightingFlag(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetOsprayOneSidedLightingFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
VolumeAttributes_SetOsprayAoTransparencyEnabledFlag(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the osprayAoTransparencyEnabledFlag in the object.
    obj->data->SetOsprayAoTransparencyEnabledFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VolumeAttributes_GetOsprayAoTransparencyEnabledFlag(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetOsprayAoTransparencyEnabledFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
VolumeAttributes_SetOspraySpp(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the ospraySpp in the object.
    obj->data->SetOspraySpp((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VolumeAttributes_GetOspraySpp(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetOspraySpp()));
    return retval;
}

/*static*/ PyObject *
VolumeAttributes_SetOsprayAoSamples(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the osprayAoSamples in the object.
    obj->data->SetOsprayAoSamples((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VolumeAttributes_GetOsprayAoSamples(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetOsprayAoSamples()));
    return retval;
}

/*static*/ PyObject *
VolumeAttributes_SetOsprayAoDistance(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the osprayAoDistance in the object.
    obj->data->SetOsprayAoDistance(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VolumeAttributes_GetOsprayAoDistance(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetOsprayAoDistance());
    return retval;
}

/*static*/ PyObject *
VolumeAttributes_SetOsprayMinContribution(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the osprayMinContribution in the object.
    obj->data->SetOsprayMinContribution(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VolumeAttributes_GetOsprayMinContribution(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetOsprayMinContribution());
    return retval;
}

/*static*/ PyObject *
VolumeAttributes_SetLegendFlag(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the legendFlag in the object.
    obj->data->SetLegendFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VolumeAttributes_GetLegendFlag(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetLegendFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
VolumeAttributes_SetLightingFlag(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the lightingFlag in the object.
    obj->data->SetLightingFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VolumeAttributes_GetLightingFlag(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetLightingFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
VolumeAttributes_SetColorControlPoints(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;

    PyObject *newValue = NULL;
    if(!PyArg_ParseTuple(args, "O", &newValue))
        return NULL;
    if(!PyColorControlPointList_Check(newValue))
    {
        fprintf(stderr, "The colorControlPoints field can only be set with ColorControlPointList objects.\n");
        return NULL;
    }

    obj->data->SetColorControlPoints(*PyColorControlPointList_FromPyObject(newValue));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VolumeAttributes_GetColorControlPoints(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    // Since the new object will point to data owned by this object,
    // we need to increment the reference count.
    Py_INCREF(self);

    PyObject *retval = PyColorControlPointList_Wrap(&obj->data->GetColorControlPoints());
    // Set the object's parent so the reference to the parent can be decref'd
    // when the child goes out of scope.
    PyColorControlPointList_SetParent(retval, self);

    return retval;
}

/*static*/ PyObject *
VolumeAttributes_SetOpacityAttenuation(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;

    float fval;
    if(!PyArg_ParseTuple(args, "f", &fval))
        return NULL;

    // Set the opacityAttenuation in the object.
    obj->data->SetOpacityAttenuation(fval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VolumeAttributes_GetOpacityAttenuation(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(double(obj->data->GetOpacityAttenuation()));
    return retval;
}

/*static*/ PyObject *
VolumeAttributes_SetOpacityMode(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the opacityMode in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetOpacityMode(VolumeAttributes::OpacityModes(ival));
    else
    {
        fprintf(stderr, "An invalid opacityMode value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "FreeformMode, GaussianMode, ColorTableMode.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VolumeAttributes_GetOpacityMode(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetOpacityMode()));
    return retval;
}

/*static*/ PyObject *
VolumeAttributes_SetOpacityControlPoints(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;

    PyObject *newValue = NULL;
    if(!PyArg_ParseTuple(args, "O", &newValue))
        return NULL;
    if(!PyGaussianControlPointList_Check(newValue))
    {
        fprintf(stderr, "The opacityControlPoints field can only be set with GaussianControlPointList objects.\n");
        return NULL;
    }

    obj->data->SetOpacityControlPoints(*PyGaussianControlPointList_FromPyObject(newValue));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VolumeAttributes_GetOpacityControlPoints(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    // Since the new object will point to data owned by this object,
    // we need to increment the reference count.
    Py_INCREF(self);

    PyObject *retval = PyGaussianControlPointList_Wrap(&obj->data->GetOpacityControlPoints());
    // Set the object's parent so the reference to the parent can be decref'd
    // when the child goes out of scope.
    PyGaussianControlPointList_SetParent(retval, self);

    return retval;
}

/*static*/ PyObject *
VolumeAttributes_SetResampleFlag(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the resampleFlag in the object.
    obj->data->SetResampleFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VolumeAttributes_GetResampleFlag(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetResampleFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
VolumeAttributes_SetResampleTarget(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the resampleTarget in the object.
    obj->data->SetResampleTarget((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VolumeAttributes_GetResampleTarget(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetResampleTarget()));
    return retval;
}

/*static*/ PyObject *
VolumeAttributes_SetOpacityVariable(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the opacityVariable in the object.
    obj->data->SetOpacityVariable(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VolumeAttributes_GetOpacityVariable(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetOpacityVariable().c_str());
    return retval;
}

/*static*/ PyObject *
VolumeAttributes_SetCompactVariable(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the compactVariable in the object.
    obj->data->SetCompactVariable(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VolumeAttributes_GetCompactVariable(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetCompactVariable().c_str());
    return retval;
}

// ****************************************************************************
//  Modifications:
//    Kathleen Bonnell, Fri Oct 14 08:24:34 PDT 2005
//    Added custom code, to parse different types of args:
//    (int index, int val) -- sets the opacity value at the specified index
//    (list or tuple object) --  as long as it is numeric and has length
//    of 256, will set the opacity values to the values in the list or tuple.
//
// ****************************************************************************

static PyObject *
VolumeAttributes_SetFreeformOpacity(PyObject *self, PyObject *args)
{
//
// THIS METHOD IS CUSTOM CODED!!!!!!.
//
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;

    unsigned char *cvals = obj->data->GetFreeformOpacity();
    int opacity, index;
    if(PyArg_ParseTuple(args, "ii", &index, &opacity))
    {
        if(index >= 0 && index < 256)
        {
            if(opacity < 0) opacity = 0;
            if(opacity > 255) opacity = 255;
            cvals[index] = (unsigned char)(opacity);
        }
    }
    else
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
        {
            return NULL;
        }
        if(PyTuple_Check(tuple) || PyList_Check(tuple))
        {
            if(PySequence_Size(tuple) != 256)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PySequence_Size(tuple); ++i)
            {
                int c;
                PyObject *item = PySequence_GetItem(tuple, i);
                if(PyInt_Check(item))
                    c = int(PyInt_AS_LONG(item));
                else if(PyFloat_Check(item))
                    c = int(PyFloat_AS_DOUBLE(item));
                else if(PyLong_Check(item))
                    c = int(PyLong_AsDouble(item));
                else
                    c = 0;
                Py_DECREF(item);
                if(c < 0) c = 0;
                if(c > 255) c = 255;
                cvals[i] = (unsigned char)(c);
           }
        }
        else
            return NULL;
    }

    // Mark the freeformOpacity in the object as modified.
    obj->data->SelectFreeformOpacity();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VolumeAttributes_GetFreeformOpacity(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the freeformOpacity.
    PyObject *retval = PyTuple_New(256);
    const unsigned char *freeformOpacity = obj->data->GetFreeformOpacity();
    for(int i = 0; i < 256; ++i)
        PyTuple_SET_ITEM(retval, i, PyInt_FromLong(long(freeformOpacity[i])));
    return retval;
}

/*static*/ PyObject *
VolumeAttributes_SetUseColorVarMin(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the useColorVarMin in the object.
    obj->data->SetUseColorVarMin(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VolumeAttributes_GetUseColorVarMin(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetUseColorVarMin()?1L:0L);
    return retval;
}

/*static*/ PyObject *
VolumeAttributes_SetColorVarMin(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;

    float fval;
    if(!PyArg_ParseTuple(args, "f", &fval))
        return NULL;

    // Set the colorVarMin in the object.
    obj->data->SetColorVarMin(fval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VolumeAttributes_GetColorVarMin(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(double(obj->data->GetColorVarMin()));
    return retval;
}

/*static*/ PyObject *
VolumeAttributes_SetUseColorVarMax(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the useColorVarMax in the object.
    obj->data->SetUseColorVarMax(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VolumeAttributes_GetUseColorVarMax(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetUseColorVarMax()?1L:0L);
    return retval;
}

/*static*/ PyObject *
VolumeAttributes_SetColorVarMax(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;

    float fval;
    if(!PyArg_ParseTuple(args, "f", &fval))
        return NULL;

    // Set the colorVarMax in the object.
    obj->data->SetColorVarMax(fval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VolumeAttributes_GetColorVarMax(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(double(obj->data->GetColorVarMax()));
    return retval;
}

/*static*/ PyObject *
VolumeAttributes_SetUseOpacityVarMin(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the useOpacityVarMin in the object.
    obj->data->SetUseOpacityVarMin(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VolumeAttributes_GetUseOpacityVarMin(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetUseOpacityVarMin()?1L:0L);
    return retval;
}

/*static*/ PyObject *
VolumeAttributes_SetOpacityVarMin(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;

    float fval;
    if(!PyArg_ParseTuple(args, "f", &fval))
        return NULL;

    // Set the opacityVarMin in the object.
    obj->data->SetOpacityVarMin(fval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VolumeAttributes_GetOpacityVarMin(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(double(obj->data->GetOpacityVarMin()));
    return retval;
}

/*static*/ PyObject *
VolumeAttributes_SetUseOpacityVarMax(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the useOpacityVarMax in the object.
    obj->data->SetUseOpacityVarMax(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VolumeAttributes_GetUseOpacityVarMax(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetUseOpacityVarMax()?1L:0L);
    return retval;
}

/*static*/ PyObject *
VolumeAttributes_SetOpacityVarMax(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;

    float fval;
    if(!PyArg_ParseTuple(args, "f", &fval))
        return NULL;

    // Set the opacityVarMax in the object.
    obj->data->SetOpacityVarMax(fval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VolumeAttributes_GetOpacityVarMax(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(double(obj->data->GetOpacityVarMax()));
    return retval;
}

/*static*/ PyObject *
VolumeAttributes_SetSmoothData(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the smoothData in the object.
    obj->data->SetSmoothData(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VolumeAttributes_GetSmoothData(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetSmoothData()?1L:0L);
    return retval;
}

/*static*/ PyObject *
VolumeAttributes_SetSamplesPerRay(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the samplesPerRay in the object.
    obj->data->SetSamplesPerRay((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VolumeAttributes_GetSamplesPerRay(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetSamplesPerRay()));
    return retval;
}

/*static*/ PyObject *
VolumeAttributes_SetRendererType(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the rendererType in the object.
    if(ival >= 0 && ival < 5)
        obj->data->SetRendererType(VolumeAttributes::Renderer(ival));
    else
    {
        fprintf(stderr, "An invalid rendererType value was given. "
                        "Valid values are in the range of [0,4]. "
                        "You can also use the following names: "
                        "Default, RayCasting, RayCastingIntegration, RayCastingSLIVR, RayCastingOSPRay"
                        ".");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VolumeAttributes_GetRendererType(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetRendererType()));
    return retval;
}

/*static*/ PyObject *
VolumeAttributes_SetGradientType(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the gradientType in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetGradientType(VolumeAttributes::GradientType(ival));
    else
    {
        fprintf(stderr, "An invalid gradientType value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "CenteredDifferences, SobelOperator.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VolumeAttributes_GetGradientType(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetGradientType()));
    return retval;
}

/*static*/ PyObject *
VolumeAttributes_SetScaling(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the scaling in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetScaling(VolumeAttributes::Scaling(ival));
    else
    {
        fprintf(stderr, "An invalid scaling value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Linear, Log, Skew.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VolumeAttributes_GetScaling(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetScaling()));
    return retval;
}

/*static*/ PyObject *
VolumeAttributes_SetSkewFactor(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the skewFactor in the object.
    obj->data->SetSkewFactor(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VolumeAttributes_GetSkewFactor(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetSkewFactor());
    return retval;
}

/*static*/ PyObject *
VolumeAttributes_SetLimitsMode(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the limitsMode in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetLimitsMode(VolumeAttributes::LimitsMode(ival));
    else
    {
        fprintf(stderr, "An invalid limitsMode value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "OriginalData, CurrentPlot.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VolumeAttributes_GetLimitsMode(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetLimitsMode()));
    return retval;
}

/*static*/ PyObject *
VolumeAttributes_SetSampling(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the sampling in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetSampling(VolumeAttributes::SamplingType(ival));
    else
    {
        fprintf(stderr, "An invalid sampling value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "KernelBased, Rasterization, Trilinear.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VolumeAttributes_GetSampling(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetSampling()));
    return retval;
}

/*static*/ PyObject *
VolumeAttributes_SetRendererSamples(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;

    float fval;
    if(!PyArg_ParseTuple(args, "f", &fval))
        return NULL;

    // Set the rendererSamples in the object.
    obj->data->SetRendererSamples(fval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VolumeAttributes_GetRendererSamples(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(double(obj->data->GetRendererSamples()));
    return retval;
}

/*static*/ PyObject *
VolumeAttributes_SetLowGradientLightingReduction(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the lowGradientLightingReduction in the object.
    if(ival >= 0 && ival < 8)
        obj->data->SetLowGradientLightingReduction(VolumeAttributes::LowGradientLightingReduction(ival));
    else
    {
        fprintf(stderr, "An invalid lowGradientLightingReduction value was given. "
                        "Valid values are in the range of [0,7]. "
                        "You can also use the following names: "
                        "Off, Lowest, Lower, Low, Medium, "
                        "High, Higher, Highest.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VolumeAttributes_GetLowGradientLightingReduction(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetLowGradientLightingReduction()));
    return retval;
}

/*static*/ PyObject *
VolumeAttributes_SetLowGradientLightingClampFlag(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the lowGradientLightingClampFlag in the object.
    obj->data->SetLowGradientLightingClampFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VolumeAttributes_GetLowGradientLightingClampFlag(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetLowGradientLightingClampFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
VolumeAttributes_SetLowGradientLightingClampValue(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the lowGradientLightingClampValue in the object.
    obj->data->SetLowGradientLightingClampValue(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VolumeAttributes_GetLowGradientLightingClampValue(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetLowGradientLightingClampValue());
    return retval;
}


/*static*/ PyObject *
VolumeAttributes_SetMaterialProperties(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;

    double *dvals = obj->data->GetMaterialProperties();
    if(!PyArg_ParseTuple(args, "dddd", &dvals[0], &dvals[1], &dvals[2], &dvals[3]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 4)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the materialProperties in the object as modified.
    obj->data->SelectMaterialProperties();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
VolumeAttributes_GetMaterialProperties(PyObject *self, PyObject *args)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the materialProperties.
    PyObject *retval = PyTuple_New(4);
    const double *materialProperties = obj->data->GetMaterialProperties();
    for(int i = 0; i < 4; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(materialProperties[i]));
    return retval;
}



PyMethodDef PyVolumeAttributes_methods[VOLUMEATTRIBUTES_NMETH] = {
    {"Notify", VolumeAttributes_Notify, METH_VARARGS},
    {"SetOsprayShadowsEnabledFlag", VolumeAttributes_SetOsprayShadowsEnabledFlag, METH_VARARGS},
    {"GetOsprayShadowsEnabledFlag", VolumeAttributes_GetOsprayShadowsEnabledFlag, METH_VARARGS},
    {"SetOsprayUseGridAcceleratorFlag", VolumeAttributes_SetOsprayUseGridAcceleratorFlag, METH_VARARGS},
    {"GetOsprayUseGridAcceleratorFlag", VolumeAttributes_GetOsprayUseGridAcceleratorFlag, METH_VARARGS},
    {"SetOsprayPreIntegrationFlag", VolumeAttributes_SetOsprayPreIntegrationFlag, METH_VARARGS},
    {"GetOsprayPreIntegrationFlag", VolumeAttributes_GetOsprayPreIntegrationFlag, METH_VARARGS},
    {"SetOspraySingleShadeFlag", VolumeAttributes_SetOspraySingleShadeFlag, METH_VARARGS},
    {"GetOspraySingleShadeFlag", VolumeAttributes_GetOspraySingleShadeFlag, METH_VARARGS},
    {"SetOsprayOneSidedLightingFlag", VolumeAttributes_SetOsprayOneSidedLightingFlag, METH_VARARGS},
    {"GetOsprayOneSidedLightingFlag", VolumeAttributes_GetOsprayOneSidedLightingFlag, METH_VARARGS},
    {"SetOsprayAoTransparencyEnabledFlag", VolumeAttributes_SetOsprayAoTransparencyEnabledFlag, METH_VARARGS},
    {"GetOsprayAoTransparencyEnabledFlag", VolumeAttributes_GetOsprayAoTransparencyEnabledFlag, METH_VARARGS},
    {"SetOspraySpp", VolumeAttributes_SetOspraySpp, METH_VARARGS},
    {"GetOspraySpp", VolumeAttributes_GetOspraySpp, METH_VARARGS},
    {"SetOsprayAoSamples", VolumeAttributes_SetOsprayAoSamples, METH_VARARGS},
    {"GetOsprayAoSamples", VolumeAttributes_GetOsprayAoSamples, METH_VARARGS},
    {"SetOsprayAoDistance", VolumeAttributes_SetOsprayAoDistance, METH_VARARGS},
    {"GetOsprayAoDistance", VolumeAttributes_GetOsprayAoDistance, METH_VARARGS},
    {"SetOsprayMinContribution", VolumeAttributes_SetOsprayMinContribution, METH_VARARGS},
    {"GetOsprayMinContribution", VolumeAttributes_GetOsprayMinContribution, METH_VARARGS},
    {"SetLegendFlag", VolumeAttributes_SetLegendFlag, METH_VARARGS},
    {"GetLegendFlag", VolumeAttributes_GetLegendFlag, METH_VARARGS},
    {"SetLightingFlag", VolumeAttributes_SetLightingFlag, METH_VARARGS},
    {"GetLightingFlag", VolumeAttributes_GetLightingFlag, METH_VARARGS},
    {"SetColorControlPoints", VolumeAttributes_SetColorControlPoints, METH_VARARGS},
    {"GetColorControlPoints", VolumeAttributes_GetColorControlPoints, METH_VARARGS},
    {"SetOpacityAttenuation", VolumeAttributes_SetOpacityAttenuation, METH_VARARGS},
    {"GetOpacityAttenuation", VolumeAttributes_GetOpacityAttenuation, METH_VARARGS},
    {"SetOpacityMode", VolumeAttributes_SetOpacityMode, METH_VARARGS},
    {"GetOpacityMode", VolumeAttributes_GetOpacityMode, METH_VARARGS},
    {"SetOpacityControlPoints", VolumeAttributes_SetOpacityControlPoints, METH_VARARGS},
    {"GetOpacityControlPoints", VolumeAttributes_GetOpacityControlPoints, METH_VARARGS},
    {"SetResampleFlag", VolumeAttributes_SetResampleFlag, METH_VARARGS},
    {"GetResampleFlag", VolumeAttributes_GetResampleFlag, METH_VARARGS},
    {"SetResampleTarget", VolumeAttributes_SetResampleTarget, METH_VARARGS},
    {"GetResampleTarget", VolumeAttributes_GetResampleTarget, METH_VARARGS},
    {"SetOpacityVariable", VolumeAttributes_SetOpacityVariable, METH_VARARGS},
    {"GetOpacityVariable", VolumeAttributes_GetOpacityVariable, METH_VARARGS},
    {"SetCompactVariable", VolumeAttributes_SetCompactVariable, METH_VARARGS},
    {"GetCompactVariable", VolumeAttributes_GetCompactVariable, METH_VARARGS},
    {"SetFreeformOpacity", VolumeAttributes_SetFreeformOpacity, METH_VARARGS},
    {"GetFreeformOpacity", VolumeAttributes_GetFreeformOpacity, METH_VARARGS},
    {"SetUseColorVarMin", VolumeAttributes_SetUseColorVarMin, METH_VARARGS},
    {"GetUseColorVarMin", VolumeAttributes_GetUseColorVarMin, METH_VARARGS},
    {"SetColorVarMin", VolumeAttributes_SetColorVarMin, METH_VARARGS},
    {"GetColorVarMin", VolumeAttributes_GetColorVarMin, METH_VARARGS},
    {"SetUseColorVarMax", VolumeAttributes_SetUseColorVarMax, METH_VARARGS},
    {"GetUseColorVarMax", VolumeAttributes_GetUseColorVarMax, METH_VARARGS},
    {"SetColorVarMax", VolumeAttributes_SetColorVarMax, METH_VARARGS},
    {"GetColorVarMax", VolumeAttributes_GetColorVarMax, METH_VARARGS},
    {"SetUseOpacityVarMin", VolumeAttributes_SetUseOpacityVarMin, METH_VARARGS},
    {"GetUseOpacityVarMin", VolumeAttributes_GetUseOpacityVarMin, METH_VARARGS},
    {"SetOpacityVarMin", VolumeAttributes_SetOpacityVarMin, METH_VARARGS},
    {"GetOpacityVarMin", VolumeAttributes_GetOpacityVarMin, METH_VARARGS},
    {"SetUseOpacityVarMax", VolumeAttributes_SetUseOpacityVarMax, METH_VARARGS},
    {"GetUseOpacityVarMax", VolumeAttributes_GetUseOpacityVarMax, METH_VARARGS},
    {"SetOpacityVarMax", VolumeAttributes_SetOpacityVarMax, METH_VARARGS},
    {"GetOpacityVarMax", VolumeAttributes_GetOpacityVarMax, METH_VARARGS},
    {"SetSmoothData", VolumeAttributes_SetSmoothData, METH_VARARGS},
    {"GetSmoothData", VolumeAttributes_GetSmoothData, METH_VARARGS},
    {"SetSamplesPerRay", VolumeAttributes_SetSamplesPerRay, METH_VARARGS},
    {"GetSamplesPerRay", VolumeAttributes_GetSamplesPerRay, METH_VARARGS},
    {"SetRendererType", VolumeAttributes_SetRendererType, METH_VARARGS},
    {"GetRendererType", VolumeAttributes_GetRendererType, METH_VARARGS},
    {"SetGradientType", VolumeAttributes_SetGradientType, METH_VARARGS},
    {"GetGradientType", VolumeAttributes_GetGradientType, METH_VARARGS},
    {"SetScaling", VolumeAttributes_SetScaling, METH_VARARGS},
    {"GetScaling", VolumeAttributes_GetScaling, METH_VARARGS},
    {"SetSkewFactor", VolumeAttributes_SetSkewFactor, METH_VARARGS},
    {"GetSkewFactor", VolumeAttributes_GetSkewFactor, METH_VARARGS},
    {"SetLimitsMode", VolumeAttributes_SetLimitsMode, METH_VARARGS},
    {"GetLimitsMode", VolumeAttributes_GetLimitsMode, METH_VARARGS},
    {"SetSampling", VolumeAttributes_SetSampling, METH_VARARGS},
    {"GetSampling", VolumeAttributes_GetSampling, METH_VARARGS},
    {"SetRendererSamples", VolumeAttributes_SetRendererSamples, METH_VARARGS},
    {"GetRendererSamples", VolumeAttributes_GetRendererSamples, METH_VARARGS},
    {"SetLowGradientLightingReduction", VolumeAttributes_SetLowGradientLightingReduction, METH_VARARGS},
    {"GetLowGradientLightingReduction", VolumeAttributes_GetLowGradientLightingReduction, METH_VARARGS},
    {"SetLowGradientLightingClampFlag", VolumeAttributes_SetLowGradientLightingClampFlag, METH_VARARGS},
    {"GetLowGradientLightingClampFlag", VolumeAttributes_GetLowGradientLightingClampFlag, METH_VARARGS},
    {"SetLowGradientLightingClampValue", VolumeAttributes_SetLowGradientLightingClampValue, METH_VARARGS},
    {"GetLowGradientLightingClampValue", VolumeAttributes_GetLowGradientLightingClampValue, METH_VARARGS},
    {"SetMaterialProperties", VolumeAttributes_SetMaterialProperties, METH_VARARGS},
    {"GetMaterialProperties", VolumeAttributes_GetMaterialProperties, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
VolumeAttributes_dealloc(PyObject *v)
{
   VolumeAttributesObject *obj = (VolumeAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
VolumeAttributes_compare(PyObject *v, PyObject *w)
{
    VolumeAttributes *a = ((VolumeAttributesObject *)v)->data;
    VolumeAttributes *b = ((VolumeAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyVolumeAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "osprayShadowsEnabledFlag") == 0)
        return VolumeAttributes_GetOsprayShadowsEnabledFlag(self, NULL);
    if(strcmp(name, "osprayUseGridAcceleratorFlag") == 0)
        return VolumeAttributes_GetOsprayUseGridAcceleratorFlag(self, NULL);
    if(strcmp(name, "osprayPreIntegrationFlag") == 0)
        return VolumeAttributes_GetOsprayPreIntegrationFlag(self, NULL);
    if(strcmp(name, "ospraySingleShadeFlag") == 0)
        return VolumeAttributes_GetOspraySingleShadeFlag(self, NULL);
    if(strcmp(name, "osprayOneSidedLightingFlag") == 0)
        return VolumeAttributes_GetOsprayOneSidedLightingFlag(self, NULL);
    if(strcmp(name, "osprayAoTransparencyEnabledFlag") == 0)
        return VolumeAttributes_GetOsprayAoTransparencyEnabledFlag(self, NULL);
    if(strcmp(name, "ospraySpp") == 0)
        return VolumeAttributes_GetOspraySpp(self, NULL);
    if(strcmp(name, "osprayAoSamples") == 0)
        return VolumeAttributes_GetOsprayAoSamples(self, NULL);
    if(strcmp(name, "osprayAoDistance") == 0)
        return VolumeAttributes_GetOsprayAoDistance(self, NULL);
    if(strcmp(name, "osprayMinContribution") == 0)
        return VolumeAttributes_GetOsprayMinContribution(self, NULL);
    if(strcmp(name, "legendFlag") == 0)
        return VolumeAttributes_GetLegendFlag(self, NULL);
    if(strcmp(name, "lightingFlag") == 0)
        return VolumeAttributes_GetLightingFlag(self, NULL);
    if(strcmp(name, "colorControlPoints") == 0)
        return VolumeAttributes_GetColorControlPoints(self, NULL);
    if(strcmp(name, "opacityAttenuation") == 0)
        return VolumeAttributes_GetOpacityAttenuation(self, NULL);
    if(strcmp(name, "opacityMode") == 0)
        return VolumeAttributes_GetOpacityMode(self, NULL);
    if(strcmp(name, "FreeformMode") == 0)
        return PyInt_FromLong(long(VolumeAttributes::FreeformMode));
    if(strcmp(name, "GaussianMode") == 0)
        return PyInt_FromLong(long(VolumeAttributes::GaussianMode));
    if(strcmp(name, "ColorTableMode") == 0)
        return PyInt_FromLong(long(VolumeAttributes::ColorTableMode));

    if(strcmp(name, "opacityControlPoints") == 0)
        return VolumeAttributes_GetOpacityControlPoints(self, NULL);
    if(strcmp(name, "resampleFlag") == 0)
        return VolumeAttributes_GetResampleFlag(self, NULL);
    if(strcmp(name, "resampleTarget") == 0)
        return VolumeAttributes_GetResampleTarget(self, NULL);
    if(strcmp(name, "opacityVariable") == 0)
        return VolumeAttributes_GetOpacityVariable(self, NULL);
    if(strcmp(name, "compactVariable") == 0)
        return VolumeAttributes_GetCompactVariable(self, NULL);
    if(strcmp(name, "freeformOpacity") == 0)
        return VolumeAttributes_GetFreeformOpacity(self, NULL);
    if(strcmp(name, "useColorVarMin") == 0)
        return VolumeAttributes_GetUseColorVarMin(self, NULL);
    if(strcmp(name, "colorVarMin") == 0)
        return VolumeAttributes_GetColorVarMin(self, NULL);
    if(strcmp(name, "useColorVarMax") == 0)
        return VolumeAttributes_GetUseColorVarMax(self, NULL);
    if(strcmp(name, "colorVarMax") == 0)
        return VolumeAttributes_GetColorVarMax(self, NULL);
    if(strcmp(name, "useOpacityVarMin") == 0)
        return VolumeAttributes_GetUseOpacityVarMin(self, NULL);
    if(strcmp(name, "opacityVarMin") == 0)
        return VolumeAttributes_GetOpacityVarMin(self, NULL);
    if(strcmp(name, "useOpacityVarMax") == 0)
        return VolumeAttributes_GetUseOpacityVarMax(self, NULL);
    if(strcmp(name, "opacityVarMax") == 0)
        return VolumeAttributes_GetOpacityVarMax(self, NULL);
    if(strcmp(name, "smoothData") == 0)
        return VolumeAttributes_GetSmoothData(self, NULL);
    if(strcmp(name, "samplesPerRay") == 0)
        return VolumeAttributes_GetSamplesPerRay(self, NULL);
    if(strcmp(name, "rendererType") == 0)
        return VolumeAttributes_GetRendererType(self, NULL);
    if(strcmp(name, "Default") == 0)
        return PyInt_FromLong(long(VolumeAttributes::Default));
    if(strcmp(name, "RayCasting") == 0)
        return PyInt_FromLong(long(VolumeAttributes::RayCasting));
    if(strcmp(name, "RayCastingIntegration") == 0)
        return PyInt_FromLong(long(VolumeAttributes::RayCastingIntegration));
    if(strcmp(name, "RayCastingSLIVR") == 0)
        return PyInt_FromLong(long(VolumeAttributes::RayCastingSLIVR));
    if(strcmp(name, "RayCastingOSPRay") == 0)
        return PyInt_FromLong(long(VolumeAttributes::RayCastingOSPRay));

    if(strcmp(name, "gradientType") == 0)
        return VolumeAttributes_GetGradientType(self, NULL);
    if(strcmp(name, "CenteredDifferences") == 0)
        return PyInt_FromLong(long(VolumeAttributes::CenteredDifferences));
    if(strcmp(name, "SobelOperator") == 0)
        return PyInt_FromLong(long(VolumeAttributes::SobelOperator));

    if(strcmp(name, "scaling") == 0)
        return VolumeAttributes_GetScaling(self, NULL);
    if(strcmp(name, "Linear") == 0)
        return PyInt_FromLong(long(VolumeAttributes::Linear));
    if(strcmp(name, "Log") == 0)
        return PyInt_FromLong(long(VolumeAttributes::Log));
    if(strcmp(name, "Skew") == 0)
        return PyInt_FromLong(long(VolumeAttributes::Skew));

    if(strcmp(name, "skewFactor") == 0)
        return VolumeAttributes_GetSkewFactor(self, NULL);
    if(strcmp(name, "limitsMode") == 0)
        return VolumeAttributes_GetLimitsMode(self, NULL);
    if(strcmp(name, "OriginalData") == 0)
        return PyInt_FromLong(long(VolumeAttributes::OriginalData));
    if(strcmp(name, "CurrentPlot") == 0)
        return PyInt_FromLong(long(VolumeAttributes::CurrentPlot));

    if(strcmp(name, "sampling") == 0)
        return VolumeAttributes_GetSampling(self, NULL);
    if(strcmp(name, "KernelBased") == 0)
        return PyInt_FromLong(long(VolumeAttributes::KernelBased));
    if(strcmp(name, "Rasterization") == 0)
        return PyInt_FromLong(long(VolumeAttributes::Rasterization));
    if(strcmp(name, "Trilinear") == 0)
        return PyInt_FromLong(long(VolumeAttributes::Trilinear));

    if(strcmp(name, "rendererSamples") == 0)
        return VolumeAttributes_GetRendererSamples(self, NULL);
    if(strcmp(name, "lowGradientLightingReduction") == 0)
        return VolumeAttributes_GetLowGradientLightingReduction(self, NULL);
    if(strcmp(name, "Off") == 0)
        return PyInt_FromLong(long(VolumeAttributes::Off));
    if(strcmp(name, "Lowest") == 0)
        return PyInt_FromLong(long(VolumeAttributes::Lowest));
    if(strcmp(name, "Lower") == 0)
        return PyInt_FromLong(long(VolumeAttributes::Lower));
    if(strcmp(name, "Low") == 0)
        return PyInt_FromLong(long(VolumeAttributes::Low));
    if(strcmp(name, "Medium") == 0)
        return PyInt_FromLong(long(VolumeAttributes::Medium));
    if(strcmp(name, "High") == 0)
        return PyInt_FromLong(long(VolumeAttributes::High));
    if(strcmp(name, "Higher") == 0)
        return PyInt_FromLong(long(VolumeAttributes::Higher));
    if(strcmp(name, "Highest") == 0)
        return PyInt_FromLong(long(VolumeAttributes::Highest));

    if(strcmp(name, "lowGradientLightingClampFlag") == 0)
        return VolumeAttributes_GetLowGradientLightingClampFlag(self, NULL);
    if(strcmp(name, "lowGradientLightingClampValue") == 0)
        return VolumeAttributes_GetLowGradientLightingClampValue(self, NULL);
    if(strcmp(name, "materialProperties") == 0)
        return VolumeAttributes_GetMaterialProperties(self, NULL);

    return Py_FindMethod(PyVolumeAttributes_methods, self, name);
}

int
PyVolumeAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "osprayShadowsEnabledFlag") == 0)
        obj = VolumeAttributes_SetOsprayShadowsEnabledFlag(self, tuple);
    else if(strcmp(name, "osprayUseGridAcceleratorFlag") == 0)
        obj = VolumeAttributes_SetOsprayUseGridAcceleratorFlag(self, tuple);
    else if(strcmp(name, "osprayPreIntegrationFlag") == 0)
        obj = VolumeAttributes_SetOsprayPreIntegrationFlag(self, tuple);
    else if(strcmp(name, "ospraySingleShadeFlag") == 0)
        obj = VolumeAttributes_SetOspraySingleShadeFlag(self, tuple);
    else if(strcmp(name, "osprayOneSidedLightingFlag") == 0)
        obj = VolumeAttributes_SetOsprayOneSidedLightingFlag(self, tuple);
    else if(strcmp(name, "osprayAoTransparencyEnabledFlag") == 0)
        obj = VolumeAttributes_SetOsprayAoTransparencyEnabledFlag(self, tuple);
    else if(strcmp(name, "ospraySpp") == 0)
        obj = VolumeAttributes_SetOspraySpp(self, tuple);
    else if(strcmp(name, "osprayAoSamples") == 0)
        obj = VolumeAttributes_SetOsprayAoSamples(self, tuple);
    else if(strcmp(name, "osprayAoDistance") == 0)
        obj = VolumeAttributes_SetOsprayAoDistance(self, tuple);
    else if(strcmp(name, "osprayMinContribution") == 0)
        obj = VolumeAttributes_SetOsprayMinContribution(self, tuple);
    else if(strcmp(name, "legendFlag") == 0)
        obj = VolumeAttributes_SetLegendFlag(self, tuple);
    else if(strcmp(name, "lightingFlag") == 0)
        obj = VolumeAttributes_SetLightingFlag(self, tuple);
    else if(strcmp(name, "colorControlPoints") == 0)
        obj = VolumeAttributes_SetColorControlPoints(self, tuple);
    else if(strcmp(name, "opacityAttenuation") == 0)
        obj = VolumeAttributes_SetOpacityAttenuation(self, tuple);
    else if(strcmp(name, "opacityMode") == 0)
        obj = VolumeAttributes_SetOpacityMode(self, tuple);
    else if(strcmp(name, "opacityControlPoints") == 0)
        obj = VolumeAttributes_SetOpacityControlPoints(self, tuple);
    else if(strcmp(name, "resampleFlag") == 0)
        obj = VolumeAttributes_SetResampleFlag(self, tuple);
    else if(strcmp(name, "resampleTarget") == 0)
        obj = VolumeAttributes_SetResampleTarget(self, tuple);
    else if(strcmp(name, "opacityVariable") == 0)
        obj = VolumeAttributes_SetOpacityVariable(self, tuple);
    else if(strcmp(name, "compactVariable") == 0)
        obj = VolumeAttributes_SetCompactVariable(self, tuple);
    else if(strcmp(name, "freeformOpacity") == 0)
        obj = VolumeAttributes_SetFreeformOpacity(self, tuple);
    else if(strcmp(name, "useColorVarMin") == 0)
        obj = VolumeAttributes_SetUseColorVarMin(self, tuple);
    else if(strcmp(name, "colorVarMin") == 0)
        obj = VolumeAttributes_SetColorVarMin(self, tuple);
    else if(strcmp(name, "useColorVarMax") == 0)
        obj = VolumeAttributes_SetUseColorVarMax(self, tuple);
    else if(strcmp(name, "colorVarMax") == 0)
        obj = VolumeAttributes_SetColorVarMax(self, tuple);
    else if(strcmp(name, "useOpacityVarMin") == 0)
        obj = VolumeAttributes_SetUseOpacityVarMin(self, tuple);
    else if(strcmp(name, "opacityVarMin") == 0)
        obj = VolumeAttributes_SetOpacityVarMin(self, tuple);
    else if(strcmp(name, "useOpacityVarMax") == 0)
        obj = VolumeAttributes_SetUseOpacityVarMax(self, tuple);
    else if(strcmp(name, "opacityVarMax") == 0)
        obj = VolumeAttributes_SetOpacityVarMax(self, tuple);
    else if(strcmp(name, "smoothData") == 0)
        obj = VolumeAttributes_SetSmoothData(self, tuple);
    else if(strcmp(name, "samplesPerRay") == 0)
        obj = VolumeAttributes_SetSamplesPerRay(self, tuple);
    else if(strcmp(name, "rendererType") == 0)
        obj = VolumeAttributes_SetRendererType(self, tuple);
    else if(strcmp(name, "gradientType") == 0)
        obj = VolumeAttributes_SetGradientType(self, tuple);
    else if(strcmp(name, "scaling") == 0)
        obj = VolumeAttributes_SetScaling(self, tuple);
    else if(strcmp(name, "skewFactor") == 0)
        obj = VolumeAttributes_SetSkewFactor(self, tuple);
    else if(strcmp(name, "limitsMode") == 0)
        obj = VolumeAttributes_SetLimitsMode(self, tuple);
    else if(strcmp(name, "sampling") == 0)
        obj = VolumeAttributes_SetSampling(self, tuple);
    else if(strcmp(name, "rendererSamples") == 0)
        obj = VolumeAttributes_SetRendererSamples(self, tuple);
    else if(strcmp(name, "lowGradientLightingReduction") == 0)
        obj = VolumeAttributes_SetLowGradientLightingReduction(self, tuple);
    else if(strcmp(name, "lowGradientLightingClampFlag") == 0)
        obj = VolumeAttributes_SetLowGradientLightingClampFlag(self, tuple);
    else if(strcmp(name, "lowGradientLightingClampValue") == 0)
        obj = VolumeAttributes_SetLowGradientLightingClampValue(self, tuple);
    else if(strcmp(name, "materialProperties") == 0)
        obj = VolumeAttributes_SetMaterialProperties(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
VolumeAttributes_print(PyObject *v, FILE *fp, int flags)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)v;
    fprintf(fp, "%s", PyVolumeAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
VolumeAttributes_str(PyObject *v)
{
    VolumeAttributesObject *obj = (VolumeAttributesObject *)v;
    return PyString_FromString(PyVolumeAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *VolumeAttributes_Purpose = "This class contains the plot attributes for the volume plot.";
#else
static char *VolumeAttributes_Purpose = "This class contains the plot attributes for the volume plot.";
#endif

//
// The type description structure
//
static PyTypeObject VolumeAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "VolumeAttributes",                    // tp_name
    sizeof(VolumeAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)VolumeAttributes_dealloc,  // tp_dealloc
    (printfunc)VolumeAttributes_print,     // tp_print
    (getattrfunc)PyVolumeAttributes_getattr, // tp_getattr
    (setattrfunc)PyVolumeAttributes_setattr, // tp_setattr
    (cmpfunc)VolumeAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)VolumeAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    VolumeAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static VolumeAttributes *defaultAtts = 0;
static VolumeAttributes *currentAtts = 0;

static PyObject *
NewVolumeAttributes(int useCurrent)
{
    VolumeAttributesObject *newObject;
    newObject = PyObject_NEW(VolumeAttributesObject, &VolumeAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new VolumeAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new VolumeAttributes(*defaultAtts);
    else
        newObject->data = new VolumeAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapVolumeAttributes(const VolumeAttributes *attr)
{
    VolumeAttributesObject *newObject;
    newObject = PyObject_NEW(VolumeAttributesObject, &VolumeAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (VolumeAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
VolumeAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewVolumeAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef VolumeAttributesMethods[] = {
    {"VolumeAttributes", VolumeAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *VolumeAttributesObserver = 0;

std::string
PyVolumeAttributes_GetLogString()
{
    std::string s("VolumeAtts = VolumeAttributes()\n");
    if(currentAtts != 0)
        s += PyVolumeAttributes_ToString(currentAtts, "VolumeAtts.");
    return s;
}

static void
PyVolumeAttributes_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("VolumeAtts = VolumeAttributes()\n");
        s += PyVolumeAttributes_ToString(currentAtts, "VolumeAtts.");
        cb(s);
    }
}

void
PyVolumeAttributes_StartUp(VolumeAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyVolumeAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(VolumeAttributesObserver == 0)
    {
        VolumeAttributesObserver = new ObserverToCallback(subj,
            PyVolumeAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyVolumeAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete VolumeAttributesObserver;
    VolumeAttributesObserver = 0;
}

PyMethodDef *
PyVolumeAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return VolumeAttributesMethods;
}

bool
PyVolumeAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &VolumeAttributesType);
}

VolumeAttributes *
PyVolumeAttributes_FromPyObject(PyObject *obj)
{
    VolumeAttributesObject *obj2 = (VolumeAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyVolumeAttributes_New()
{
    return NewVolumeAttributes(0);
}

PyObject *
PyVolumeAttributes_Wrap(const VolumeAttributes *attr)
{
    return WrapVolumeAttributes(attr);
}

void
PyVolumeAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    VolumeAttributesObject *obj2 = (VolumeAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyVolumeAttributes_SetDefaults(const VolumeAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new VolumeAttributes(*atts);
}

