/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

// ************************************************************************* //
//  File: VectorViewerEnginePluginInfo.C
// ************************************************************************* //

#include <VectorPluginInfo.h>
#include <avtVectorPlot.h>
#include <VectorAttributes.h>

//
// Storage for static data elements.
//
VectorAttributes *VectorViewerEnginePluginInfo::clientAtts = NULL;
VectorAttributes *VectorViewerEnginePluginInfo::defaultAtts = NULL;

// ****************************************************************************
//  Method:  VectorViewerEnginePluginInfo::InitializeGlobalObjects
//
//  Purpose:
//    Initialize the plot atts.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************
void
VectorViewerEnginePluginInfo::InitializeGlobalObjects()
{
    VectorViewerEnginePluginInfo::clientAtts  = new VectorAttributes;
    VectorViewerEnginePluginInfo::defaultAtts = new VectorAttributes;
}

// ****************************************************************************
//  Method: VectorViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
VectorViewerEnginePluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: VectorViewerEnginePluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
VectorViewerEnginePluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: VectorViewerEnginePluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
VectorViewerEnginePluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(VectorAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: VectorViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
VectorViewerEnginePluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(VectorAttributes *)atts = *clientAtts;
}

// ****************************************************************************
//  Method: VectorViewerEnginePluginInfo::AllocAvtPlot
//
//  Purpose:
//    Return a pointer to a newly allocated avt plot.
//
//  Returns:    A pointer to the newly allocated avt plot.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

avtPlot *
VectorViewerEnginePluginInfo::AllocAvtPlot()
{
    return new avtVectorPlot;
}

// ****************************************************************************
//  Method: VectorViewerEnginePluginInfo::InitializePlotAtts
//
//  Purpose:
//    Initialize the plot attributes to the default attributes.
//
//  Arguments:
//    atts      The attribute subject to initialize.
//    plot      The viewer plot whose attributes are getting initialized.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
VectorViewerEnginePluginInfo::InitializePlotAtts(AttributeSubject *atts,
    const avtPlotMetaData &)
{
    *(VectorAttributes*)atts = *defaultAtts;
}
// ****************************************************************************
// Method: VectorViewerEnginePluginInfo::SupportsAnimation
//
// Purpose:
//   Tell VisIt that this plot supports animation.
//
// Programmer: Brad Whitlock
// Creation:   Fri Sep 13 11:29:59 PDT 2013
//
// Modifications:
//
// ****************************************************************************

bool
VectorViewerEnginePluginInfo::SupportsAnimation() const
{
    return true;
}

// ****************************************************************************
// Method: VectorViewerEnginePluginInfo::AnimationReset
//
// Purpose:
//   Resets the plot's animation.
//
// Arguments:
//   atts : The attribute subject that we may modify.
//   plot : The plot that we're animating.
//
// Returns:  True if the plot attributes changed as a result of reset.
//
// Programmer: Brad Whitlock
// Creation:   Fri Sep 13 11:29:59 PDT 2013
//
// Modifications:
//
// ****************************************************************************
#include <avtPlotMetaData.h>

bool
VectorViewerEnginePluginInfo::AnimationReset(AttributeSubject *atts, const avtPlotMetaData &)
{
    VectorAttributes *cAtts = (VectorAttributes *)atts;
    cAtts->SetAnimationStep(0);
    return true;
}

// ****************************************************************************
// Method: VectorViewerEnginePluginInfo::AnimationStep
//
// Purpose:
//   Take an animation step.
//
// Arguments:
//   atts : The attribute subject that we may modify.
//   plot : The plot that we're animating.
//
// Returns:  True if the plot attributes changed.
//
// Programmer: Brad Whitlock
// Creation:   Fri Sep 13 11:29:59 PDT 2013
//
// Modifications:
//
// ****************************************************************************

bool
VectorViewerEnginePluginInfo::AnimationStep(AttributeSubject *atts, const avtPlotMetaData &)
{
    VectorAttributes *cAtts = (VectorAttributes *)atts;
    cAtts->SetAnimationStep(cAtts->GetAnimationStep()+1);
    return true;
}

// ****************************************************************************
//  Method: VectorViewerEnginePluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the viewer menus.
//
//  Returns:    A pointer to the name to use in the viewer menus.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
VectorViewerEnginePluginInfo::GetMenuName() const
{
    return "Vector";
}

