/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyBoundaryAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>
#include <ColorAttribute.h>
#include <PyColorAttributeList.h>

// ****************************************************************************
// Module: PyBoundaryAttributes
//
// Purpose: 
//   This class contains the plot attributes for the boundary plot.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a BoundaryAttributes.
//
struct BoundaryAttributesObject
{
    PyObject_HEAD
    BoundaryAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewBoundaryAttributes(int);

std::string
PyBoundaryAttributes_ToString(const BoundaryAttributes *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    const char *colorType_names = "ColorBySingleColor, ColorByMultipleColors, ColorByColorTable";
    switch (atts->GetColorType())
    {
      case BoundaryAttributes::ColorBySingleColor:
          SNPRINTF(tmpStr, 1000, "%scolorType = %sColorBySingleColor  # %s\n", prefix, prefix, colorType_names);
          str += tmpStr;
          break;
      case BoundaryAttributes::ColorByMultipleColors:
          SNPRINTF(tmpStr, 1000, "%scolorType = %sColorByMultipleColors  # %s\n", prefix, prefix, colorType_names);
          str += tmpStr;
          break;
      case BoundaryAttributes::ColorByColorTable:
          SNPRINTF(tmpStr, 1000, "%scolorType = %sColorByColorTable  # %s\n", prefix, prefix, colorType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    SNPRINTF(tmpStr, 1000, "%scolorTableName = \"%s\"\n", prefix, atts->GetColorTableName().c_str());
    str += tmpStr;
    if(atts->GetInvertColorTable())
        SNPRINTF(tmpStr, 1000, "%sinvertColorTable = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sinvertColorTable = 0\n", prefix);
    str += tmpStr;
    if(atts->GetLegendFlag())
        SNPRINTF(tmpStr, 1000, "%slegendFlag = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%slegendFlag = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%slineWidth = %d\n", prefix, atts->GetLineWidth());
    str += tmpStr;
    const unsigned char *singleColor = atts->GetSingleColor().GetColor();
    SNPRINTF(tmpStr, 1000, "%ssingleColor = (%d, %d, %d, %d)\n", prefix, int(singleColor[0]), int(singleColor[1]), int(singleColor[2]), int(singleColor[3]));
    str += tmpStr;
    { const ColorAttributeList &cL = atts->GetMultiColor();
        const char *comment = (prefix==0 || strcmp(prefix,"")==0) ? "# " : "";
        for(int i = 0; i < cL.GetNumColors(); ++i)
        {
            const unsigned char *c = cL[i].GetColor();
            SNPRINTF(tmpStr, 1000, "%s%sSetMultiColor(%d, (%d, %d, %d, %d))\n",
                     comment, prefix, i, int(c[0]), int(c[1]), int(c[2]), int(c[3]));
            str += tmpStr;
        }
    }
    {   const stringVector &boundaryNames = atts->GetBoundaryNames();
        SNPRINTF(tmpStr, 1000, "%sboundaryNames = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < boundaryNames.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "\"%s\"", boundaryNames[i].c_str());
            str += tmpStr;
            if(i < boundaryNames.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    SNPRINTF(tmpStr, 1000, "%sopacity = %g\n", prefix, atts->GetOpacity());
    str += tmpStr;
    if(atts->GetWireframe())
        SNPRINTF(tmpStr, 1000, "%swireframe = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%swireframe = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%ssmoothingLevel = %d\n", prefix, atts->GetSmoothingLevel());
    str += tmpStr;
    return str;
}

static PyObject *
BoundaryAttributes_Notify(PyObject *self, PyObject *args)
{
    BoundaryAttributesObject *obj = (BoundaryAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
BoundaryAttributes_SetColorType(PyObject *self, PyObject *args)
{
    BoundaryAttributesObject *obj = (BoundaryAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the colorType in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetColorType(BoundaryAttributes::ColoringMethod(ival));
    else
    {
        fprintf(stderr, "An invalid colorType value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "ColorBySingleColor, ColorByMultipleColors, ColorByColorTable.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
BoundaryAttributes_GetColorType(PyObject *self, PyObject *args)
{
    BoundaryAttributesObject *obj = (BoundaryAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetColorType()));
    return retval;
}

/*static*/ PyObject *
BoundaryAttributes_SetColorTableName(PyObject *self, PyObject *args)
{
    BoundaryAttributesObject *obj = (BoundaryAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the colorTableName in the object.
    obj->data->SetColorTableName(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
BoundaryAttributes_GetColorTableName(PyObject *self, PyObject *args)
{
    BoundaryAttributesObject *obj = (BoundaryAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetColorTableName().c_str());
    return retval;
}

/*static*/ PyObject *
BoundaryAttributes_SetInvertColorTable(PyObject *self, PyObject *args)
{
    BoundaryAttributesObject *obj = (BoundaryAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the invertColorTable in the object.
    obj->data->SetInvertColorTable(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
BoundaryAttributes_GetInvertColorTable(PyObject *self, PyObject *args)
{
    BoundaryAttributesObject *obj = (BoundaryAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetInvertColorTable()?1L:0L);
    return retval;
}

/*static*/ PyObject *
BoundaryAttributes_SetLegendFlag(PyObject *self, PyObject *args)
{
    BoundaryAttributesObject *obj = (BoundaryAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the legendFlag in the object.
    obj->data->SetLegendFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
BoundaryAttributes_GetLegendFlag(PyObject *self, PyObject *args)
{
    BoundaryAttributesObject *obj = (BoundaryAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetLegendFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
BoundaryAttributes_SetLineWidth(PyObject *self, PyObject *args)
{
    BoundaryAttributesObject *obj = (BoundaryAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the lineWidth in the object.
    obj->data->SetLineWidth(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
BoundaryAttributes_GetLineWidth(PyObject *self, PyObject *args)
{
    BoundaryAttributesObject *obj = (BoundaryAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetLineWidth()));
    return retval;
}

/*static*/ PyObject *
BoundaryAttributes_SetSingleColor(PyObject *self, PyObject *args)
{
    BoundaryAttributesObject *obj = (BoundaryAttributesObject *)self;

    int c[4];
    if(!PyArg_ParseTuple(args, "iiii", &c[0], &c[1], &c[2], &c[3]))
    {
        c[3] = 255;
        if(!PyArg_ParseTuple(args, "iii", &c[0], &c[1], &c[2]))
        {
            double dr, dg, db, da;
            if(PyArg_ParseTuple(args, "dddd", &dr, &dg, &db, &da))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = int(da);
            }
            else if(PyArg_ParseTuple(args, "ddd", &dr, &dg, &db))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = 255;
            }
            else
            {
                PyObject *tuple = NULL;
                if(!PyArg_ParseTuple(args, "O", &tuple))
                    return NULL;

                if(!PyTuple_Check(tuple))
                    return NULL;

                // Make sure that the tuple is the right size.
                if(PyTuple_Size(tuple) < 3 || PyTuple_Size(tuple) > 4)
                    return NULL;

                // Make sure that all elements in the tuple are ints.
                for(int i = 0; i < PyTuple_Size(tuple); ++i)
                {
                    PyObject *item = PyTuple_GET_ITEM(tuple, i);
                    if(PyInt_Check(item))
                        c[i] = int(PyInt_AS_LONG(PyTuple_GET_ITEM(tuple, i)));
                    else if(PyFloat_Check(item))
                        c[i] = int(PyFloat_AS_DOUBLE(PyTuple_GET_ITEM(tuple, i)));
                    else
                        return NULL;
                }
            }
        }
        PyErr_Clear();
    }

    // Set the singleColor in the object.
    ColorAttribute ca(c[0], c[1], c[2], c[3]);
    obj->data->SetSingleColor(ca);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
BoundaryAttributes_GetSingleColor(PyObject *self, PyObject *args)
{
    BoundaryAttributesObject *obj = (BoundaryAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the singleColor.
    PyObject *retval = PyTuple_New(4);
    const unsigned char *singleColor = obj->data->GetSingleColor().GetColor();
    PyTuple_SET_ITEM(retval, 0, PyInt_FromLong(long(singleColor[0])));
    PyTuple_SET_ITEM(retval, 1, PyInt_FromLong(long(singleColor[1])));
    PyTuple_SET_ITEM(retval, 2, PyInt_FromLong(long(singleColor[2])));
    PyTuple_SET_ITEM(retval, 3, PyInt_FromLong(long(singleColor[3])));
    return retval;
}

/*static*/ PyObject *
BoundaryAttributes_SetMultiColor(PyObject *self, PyObject *args)
{
    BoundaryAttributesObject *obj = (BoundaryAttributesObject *)self;

    PyObject *pyobj = NULL;
    ColorAttributeList &cL = obj->data->GetMultiColor();
    int index = 0;
    int c[4] = {0,0,0,255};
    bool setTheColor = true;

    if(!PyArg_ParseTuple(args, "iiiii", &index, &c[0], &c[1], &c[2], &c[3]))
    {
        if(!PyArg_ParseTuple(args, "iiii", &index, &c[0], &c[1], &c[2]))
        {
            double dr, dg, db, da;
            if(PyArg_ParseTuple(args, "idddd", &index, &dr, &dg, &db, &da))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = int(da);
            }
            else if(PyArg_ParseTuple(args, "iddd", &index, &dr, &dg, &db))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = 255;
            }
            else
            {
                if(!PyArg_ParseTuple(args, "iO", &index, &pyobj))
                {
                    if(PyArg_ParseTuple(args, "O", &pyobj))
                    {
                        setTheColor = false;
                        if(PyTuple_Check(pyobj))
                        {
                            // Make sure that the tuple is the right size.
                            if(PyTuple_Size(pyobj) < cL.GetNumColors())
                                return NULL;

                            // Make sure that the tuple is the right size.
                            bool badInput = false;
                            int *C = new int[4 * cL.GetNumColors()];
                            for(int i = 0; i < PyTuple_Size(pyobj) && !badInput; ++i)
                            {
                                PyObject *item = PyTuple_GET_ITEM(pyobj, i);
                                if(PyTuple_Check(item) &&
                                   (PyTuple_Size(item) == 3 || PyTuple_Size(item) == 4))
                                {
                                    C[i*4] = 0;
                                    C[i*4+1] = 0;
                                    C[i*4+2] = 0;
                                    C[i*4+3] = 255;
                                    for(int j = 0; j < PyTuple_Size(item) && !badInput; ++j)
                                    {
                                        PyObject *colorcomp = PyTuple_GET_ITEM(item, j);
                                        if(PyInt_Check(colorcomp))
                                           C[i*4+j] = int(PyInt_AS_LONG(colorcomp));
                                        else if(PyFloat_Check(colorcomp))
                                           C[i*4+j] = int(PyFloat_AS_DOUBLE(colorcomp));
                                        else
                                           badInput = true;
                                    }
                                }
                                else
                                    badInput = true;
                            }

                            if(badInput)
                            {
                                delete [] C;
                                return NULL;
                            }

                            for(int i = 0; i < cL.GetNumColors(); ++i)
                                cL[i].SetRgba(C[i*4], C[i*4+1], C[i*4+2], C[i*4+3]);
                            delete [] C;
                        }
                        else if(PyList_Check(pyobj))
                        {
                            // Make sure that the list is the right size.
                            if(PyList_Size(pyobj) < cL.GetNumColors())
                                return NULL;

                            // Make sure that the tuple is the right size.
                            bool badInput = false;
                            int *C = new int[4 * cL.GetNumColors()];
                            for(int i = 0; i < PyList_Size(pyobj) && !badInput; ++i)
                            {
                                PyObject *item = PyList_GET_ITEM(pyobj, i);
                                if(PyTuple_Check(item) &&
                                   (PyTuple_Size(item) == 3 || PyTuple_Size(item) == 4))
                                {
                                    C[i*4] = 0;
                                    C[i*4+1] = 0;
                                    C[i*4+2] = 0;
                                    C[i*4+3] = 255;
                                    for(int j = 0; j < PyTuple_Size(item) && !badInput; ++j)
                                    {
                                        PyObject *colorcomp = PyTuple_GET_ITEM(item, j);
                                        if(PyInt_Check(colorcomp))
                                           C[i*4+j] = int(PyInt_AS_LONG(colorcomp));
                                        else if(PyFloat_Check(colorcomp))
                                           C[i*4+j] = int(PyFloat_AS_DOUBLE(colorcomp));
                                        else
                                           badInput = true;
                                    }
                                }
                                else
                                    badInput = true;
                            }

                            if(badInput)
                            {
                                delete [] C;
                                return NULL;
                            }

                            for(int i = 0; i < cL.GetNumColors(); ++i)
                                cL[i].SetRgba(C[i*4], C[i*4+1], C[i*4+2], C[i*4+3]);

                            delete [] C;
                        }
                        else
                            return NULL;
                    }
                }
                else
                {
                    if(!PyTuple_Check(pyobj))
                        return NULL;

                    // Make sure that the tuple is the right size.
                    if(PyTuple_Size(pyobj) < 3 || PyTuple_Size(pyobj) > 4)
                        return NULL;

                    // Make sure that all elements in the tuple are ints.
                    for(int i = 0; i < PyTuple_Size(pyobj); ++i)
                    {
                        PyObject *item = PyTuple_GET_ITEM(pyobj, i);
                        if(PyInt_Check(item))
                            c[i] = int(PyInt_AS_LONG(PyTuple_GET_ITEM(pyobj, i)));
                        else if(PyFloat_Check(item))
                            c[i] = int(PyFloat_AS_DOUBLE(PyTuple_GET_ITEM(pyobj, i)));
                        else
                            return NULL;
                    }
                }
            }
        }
        PyErr_Clear();
    }

    if(index < 0 || index >= cL.GetNumColors())
        return NULL;

    // Set the color in the object.
    if(setTheColor)
        cL[index] = ColorAttribute(c[0], c[1], c[2], c[3]);
    cL.SelectColors();
    obj->data->SelectMultiColor();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
BoundaryAttributes_GetMultiColor(PyObject *self, PyObject *args)
{
    BoundaryAttributesObject *obj = (BoundaryAttributesObject *)self;
    PyObject *retval = NULL;
    ColorAttributeList &cL = obj->data->GetMultiColor();

    int index = 0;
    if(PyArg_ParseTuple(args, "i", &index))
    {
        if(index < 0 || index >= cL.GetNumColors())
            return NULL;

        // Allocate a tuple the with enough entries to hold the singleColor.
        retval = PyTuple_New(4);
        const unsigned char *c = cL.GetColors(index).GetColor();
        PyTuple_SET_ITEM(retval, 0, PyInt_FromLong(long(c[0])));
        PyTuple_SET_ITEM(retval, 1, PyInt_FromLong(long(c[1])));
        PyTuple_SET_ITEM(retval, 2, PyInt_FromLong(long(c[2])));
        PyTuple_SET_ITEM(retval, 3, PyInt_FromLong(long(c[3])));
    }
    else
    {
        PyErr_Clear();

        // Return the whole thing.
        retval = PyList_New(cL.GetNumColors());
        for(int i = 0; i < cL.GetNumColors(); ++i)
        {
            const unsigned char *c = cL.GetColors(i).GetColor();

            PyObject *t = PyTuple_New(4);
            PyTuple_SET_ITEM(t, 0, PyInt_FromLong(long(c[0])));
            PyTuple_SET_ITEM(t, 1, PyInt_FromLong(long(c[1])));
            PyTuple_SET_ITEM(t, 2, PyInt_FromLong(long(c[2])));
            PyTuple_SET_ITEM(t, 3, PyInt_FromLong(long(c[3])));

            PyList_SET_ITEM(retval, i, t);
        }
    }
    return retval;
}

/*static*/ PyObject *
BoundaryAttributes_SetBoundaryNames(PyObject *self, PyObject *args)
{
    BoundaryAttributesObject *obj = (BoundaryAttributesObject *)self;

    stringVector  &vec = obj->data->GetBoundaryNames();
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyString_Check(item))
                vec[i] = std::string(PyString_AS_STRING(item));
            else
                vec[i] = std::string("");
        }
    }
    else if(PyString_Check(tuple))
    {
        vec.resize(1);
        vec[0] = std::string(PyString_AS_STRING(tuple));
    }
    else
        return NULL;

    // Mark the boundaryNames in the object as modified.
    obj->data->SelectBoundaryNames();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
BoundaryAttributes_GetBoundaryNames(PyObject *self, PyObject *args)
{
    BoundaryAttributesObject *obj = (BoundaryAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the boundaryNames.
    const stringVector &boundaryNames = obj->data->GetBoundaryNames();
    PyObject *retval = PyTuple_New(boundaryNames.size());
    for(size_t i = 0; i < boundaryNames.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyString_FromString(boundaryNames[i].c_str()));
    return retval;
}

/*static*/ PyObject *
BoundaryAttributes_SetOpacity(PyObject *self, PyObject *args)
{
    BoundaryAttributesObject *obj = (BoundaryAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the opacity in the object.
    obj->data->SetOpacity(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
BoundaryAttributes_GetOpacity(PyObject *self, PyObject *args)
{
    BoundaryAttributesObject *obj = (BoundaryAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetOpacity());
    return retval;
}

/*static*/ PyObject *
BoundaryAttributes_SetWireframe(PyObject *self, PyObject *args)
{
    BoundaryAttributesObject *obj = (BoundaryAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the wireframe in the object.
    obj->data->SetWireframe(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
BoundaryAttributes_GetWireframe(PyObject *self, PyObject *args)
{
    BoundaryAttributesObject *obj = (BoundaryAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetWireframe()?1L:0L);
    return retval;
}

/*static*/ PyObject *
BoundaryAttributes_SetSmoothingLevel(PyObject *self, PyObject *args)
{
    BoundaryAttributesObject *obj = (BoundaryAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the smoothingLevel in the object.
    obj->data->SetSmoothingLevel((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
BoundaryAttributes_GetSmoothingLevel(PyObject *self, PyObject *args)
{
    BoundaryAttributesObject *obj = (BoundaryAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetSmoothingLevel()));
    return retval;
}



PyMethodDef PyBoundaryAttributes_methods[BOUNDARYATTRIBUTES_NMETH] = {
    {"Notify", BoundaryAttributes_Notify, METH_VARARGS},
    {"SetColorType", BoundaryAttributes_SetColorType, METH_VARARGS},
    {"GetColorType", BoundaryAttributes_GetColorType, METH_VARARGS},
    {"SetColorTableName", BoundaryAttributes_SetColorTableName, METH_VARARGS},
    {"GetColorTableName", BoundaryAttributes_GetColorTableName, METH_VARARGS},
    {"SetInvertColorTable", BoundaryAttributes_SetInvertColorTable, METH_VARARGS},
    {"GetInvertColorTable", BoundaryAttributes_GetInvertColorTable, METH_VARARGS},
    {"SetLegendFlag", BoundaryAttributes_SetLegendFlag, METH_VARARGS},
    {"GetLegendFlag", BoundaryAttributes_GetLegendFlag, METH_VARARGS},
    {"SetLineWidth", BoundaryAttributes_SetLineWidth, METH_VARARGS},
    {"GetLineWidth", BoundaryAttributes_GetLineWidth, METH_VARARGS},
    {"SetSingleColor", BoundaryAttributes_SetSingleColor, METH_VARARGS},
    {"GetSingleColor", BoundaryAttributes_GetSingleColor, METH_VARARGS},
    {"SetMultiColor", BoundaryAttributes_SetMultiColor, METH_VARARGS},
    {"GetMultiColor", BoundaryAttributes_GetMultiColor, METH_VARARGS},
    {"SetBoundaryNames", BoundaryAttributes_SetBoundaryNames, METH_VARARGS},
    {"GetBoundaryNames", BoundaryAttributes_GetBoundaryNames, METH_VARARGS},
    {"SetOpacity", BoundaryAttributes_SetOpacity, METH_VARARGS},
    {"GetOpacity", BoundaryAttributes_GetOpacity, METH_VARARGS},
    {"SetWireframe", BoundaryAttributes_SetWireframe, METH_VARARGS},
    {"GetWireframe", BoundaryAttributes_GetWireframe, METH_VARARGS},
    {"SetSmoothingLevel", BoundaryAttributes_SetSmoothingLevel, METH_VARARGS},
    {"GetSmoothingLevel", BoundaryAttributes_GetSmoothingLevel, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
BoundaryAttributes_dealloc(PyObject *v)
{
   BoundaryAttributesObject *obj = (BoundaryAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
BoundaryAttributes_compare(PyObject *v, PyObject *w)
{
    BoundaryAttributes *a = ((BoundaryAttributesObject *)v)->data;
    BoundaryAttributes *b = ((BoundaryAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyBoundaryAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "colorType") == 0)
        return BoundaryAttributes_GetColorType(self, NULL);
    if(strcmp(name, "ColorBySingleColor") == 0)
        return PyInt_FromLong(long(BoundaryAttributes::ColorBySingleColor));
    if(strcmp(name, "ColorByMultipleColors") == 0)
        return PyInt_FromLong(long(BoundaryAttributes::ColorByMultipleColors));
    if(strcmp(name, "ColorByColorTable") == 0)
        return PyInt_FromLong(long(BoundaryAttributes::ColorByColorTable));

    if(strcmp(name, "colorTableName") == 0)
        return BoundaryAttributes_GetColorTableName(self, NULL);
    if(strcmp(name, "invertColorTable") == 0)
        return BoundaryAttributes_GetInvertColorTable(self, NULL);
    if(strcmp(name, "legendFlag") == 0)
        return BoundaryAttributes_GetLegendFlag(self, NULL);
    if(strcmp(name, "lineWidth") == 0)
        return BoundaryAttributes_GetLineWidth(self, NULL);
    if(strcmp(name, "singleColor") == 0)
        return BoundaryAttributes_GetSingleColor(self, NULL);
    if(strcmp(name, "multiColor") == 0)
        return BoundaryAttributes_GetMultiColor(self, NULL);
    if(strcmp(name, "boundaryNames") == 0)
        return BoundaryAttributes_GetBoundaryNames(self, NULL);
    if(strcmp(name, "opacity") == 0)
        return BoundaryAttributes_GetOpacity(self, NULL);
    if(strcmp(name, "wireframe") == 0)
        return BoundaryAttributes_GetWireframe(self, NULL);
    if(strcmp(name, "smoothingLevel") == 0)
        return BoundaryAttributes_GetSmoothingLevel(self, NULL);

    // Try and handle legacy fields

#define DEPRECATED_MESSAGE(type) \
    fprintf(stdout, "%s is no longer a valid Boundary attribute.\n" \
                    "It's value is being ignored, " \
                    "please remove it from your script.\n", type);

    // boundaryType and it's possible enumerations
    bool boundaryTypeFound = false;
    if (strcmp(name, "boundaryType") == 0)
    {
        boundaryTypeFound = true;
    }
    else if (strcmp(name, "Domain") == 0)
    {
        boundaryTypeFound = true;
    }
    else if (strcmp(name, "Group") == 0)
    {
        boundaryTypeFound = true;
    }
    else if (strcmp(name, "Material") == 0)
    {
        boundaryTypeFound = true;
    }
    else if (strcmp(name, "Unknown") == 0)
    {
        boundaryTypeFound = true;
    }
    if (boundaryTypeFound)
    {
        DEPRECATED_MESSAGE("boundaryType");
        return PyInt_FromLong(0L);
    }
    // pointType and it's possible enumerations
    bool pointTypeFound = false;
    if (strcmp(name, "pointType") == 0)
    {
        pointTypeFound = true;
    }
    else if (strcmp(name, "Box") == 0)
    {
        pointTypeFound = true;
    }
    else if (strcmp(name, "Axis") == 0)
    {
        pointTypeFound = true;
    }
    else if (strcmp(name, "Icosahedron") == 0)
    {
        pointTypeFound = true;
    }
    else if (strcmp(name, "Octahedron") == 0)
    {
        pointTypeFound = true;
    }
    else if (strcmp(name, "Tetrahedron") == 0)
    {
        pointTypeFound = true;
    }
    else if (strcmp(name, "SphereGeometry") == 0)
    {
        pointTypeFound = true;
    }
    else if (strcmp(name, "Point") == 0)
    {
        pointTypeFound = true;
    }
    else if (strcmp(name, "Sphere") == 0)
    {
        pointTypeFound = true;
    }
    if (pointTypeFound)
    {
        DEPRECATED_MESSAGE("pointType");
        return PyInt_FromLong(0L);
    }
    if (strcmp(name, "pointSize") == 0)
    {
        DEPRECATED_MESSAGE("pointSize");
        return PyInt_FromLong(0L);
    }
    else if (strcmp(name, "pointSizePixels") == 0)
    {
        DEPRECATED_MESSAGE("pointSizePixels");
        return PyInt_FromLong(0L);
    }
    else if (strcmp(name, "pointSizeVarEnabled") == 0)
    {
        DEPRECATED_MESSAGE("pointSizeVarEnabled");
        return PyInt_FromLong(0L);
    }
    else if (strcmp(name, "pointSizeVar") == 0)
    {
        DEPRECATED_MESSAGE("pointSizeVar");
        return PyInt_FromLong(0L);
    }
    else if (strcmp(name, "filledFlag") == 0)
    {
        DEPRECATED_MESSAGE("filledFlag");
        return PyInt_FromLong(0L);
    }

    // lineStyle and it's possible enumerations
    bool lineStyleFound = false;
    if (strcmp(name, "lineStyle") == 0)
    {
        lineStyleFound = true;
    }
    else if (strcmp(name, "SOLID") == 0)
    {
        lineStyleFound = true;
    }
    else if (strcmp(name, "DASH") == 0)
    {
        lineStyleFound = true;
    }
    else if (strcmp(name, "DOT") == 0)
    {
        lineStyleFound = true;
    }
    else if (strcmp(name, "DOTDASH") == 0)
    {
        lineStyleFound = true;
    }
    if (lineStyleFound)
    {
        DEPRECATED_MESSAGE("lineStyle");
        return PyInt_FromLong(0L);
    }
    return Py_FindMethod(PyBoundaryAttributes_methods, self, name);
}

int
PyBoundaryAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "colorType") == 0)
        obj = BoundaryAttributes_SetColorType(self, tuple);
    else if(strcmp(name, "colorTableName") == 0)
        obj = BoundaryAttributes_SetColorTableName(self, tuple);
    else if(strcmp(name, "invertColorTable") == 0)
        obj = BoundaryAttributes_SetInvertColorTable(self, tuple);
    else if(strcmp(name, "legendFlag") == 0)
        obj = BoundaryAttributes_SetLegendFlag(self, tuple);
    else if(strcmp(name, "lineWidth") == 0)
        obj = BoundaryAttributes_SetLineWidth(self, tuple);
    else if(strcmp(name, "singleColor") == 0)
        obj = BoundaryAttributes_SetSingleColor(self, tuple);
    else if(strcmp(name, "multiColor") == 0)
        obj = BoundaryAttributes_SetMultiColor(self, tuple);
    else if(strcmp(name, "boundaryNames") == 0)
        obj = BoundaryAttributes_SetBoundaryNames(self, tuple);
    else if(strcmp(name, "opacity") == 0)
        obj = BoundaryAttributes_SetOpacity(self, tuple);
    else if(strcmp(name, "wireframe") == 0)
        obj = BoundaryAttributes_SetWireframe(self, tuple);
    else if(strcmp(name, "smoothingLevel") == 0)
        obj = BoundaryAttributes_SetSmoothingLevel(self, tuple);

    // Try and handle legacy fields
    if(obj == NULL)
    {
        if(strcmp(name, "filledFlag") == 0)
        {
            Py_INCREF(Py_None);
            obj = Py_None;
        }
        else if(strcmp(name, "boundaryType") == 0)
        {
            Py_INCREF(Py_None);
            obj = Py_None;
        }
        else if(strcmp(name, "pointType") == 0)
        {
            Py_INCREF(Py_None);
            obj = Py_None;
        }
        else if(strcmp(name, "pointSize") == 0)
        {
            Py_INCREF(Py_None);
            obj = Py_None;
        }
        else if(strcmp(name, "pointSizePixels") == 0)
        {
            Py_INCREF(Py_None);
            obj = Py_None;
        }
        else if(strcmp(name, "pointSizeVarEnabled") == 0)
        {
            Py_INCREF(Py_None);
            obj = Py_None;
        }
        else if(strcmp(name, "pointSizeVar") == 0)
        {
            Py_INCREF(Py_None);
            obj = Py_None;
        }
        else if(strcmp(name, "lineStyle") == 0)
        {
            Py_INCREF(Py_None);
            obj = Py_None;
        }
    }
    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
BoundaryAttributes_print(PyObject *v, FILE *fp, int flags)
{
    BoundaryAttributesObject *obj = (BoundaryAttributesObject *)v;
    fprintf(fp, "%s", PyBoundaryAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
BoundaryAttributes_str(PyObject *v)
{
    BoundaryAttributesObject *obj = (BoundaryAttributesObject *)v;
    return PyString_FromString(PyBoundaryAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *BoundaryAttributes_Purpose = "This class contains the plot attributes for the boundary plot.";
#else
static char *BoundaryAttributes_Purpose = "This class contains the plot attributes for the boundary plot.";
#endif

//
// The type description structure
//
static PyTypeObject BoundaryAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "BoundaryAttributes",                    // tp_name
    sizeof(BoundaryAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)BoundaryAttributes_dealloc,  // tp_dealloc
    (printfunc)BoundaryAttributes_print,     // tp_print
    (getattrfunc)PyBoundaryAttributes_getattr, // tp_getattr
    (setattrfunc)PyBoundaryAttributes_setattr, // tp_setattr
    (cmpfunc)BoundaryAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)BoundaryAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    BoundaryAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static BoundaryAttributes *defaultAtts = 0;
static BoundaryAttributes *currentAtts = 0;

static PyObject *
NewBoundaryAttributes(int useCurrent)
{
    BoundaryAttributesObject *newObject;
    newObject = PyObject_NEW(BoundaryAttributesObject, &BoundaryAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new BoundaryAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new BoundaryAttributes(*defaultAtts);
    else
        newObject->data = new BoundaryAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapBoundaryAttributes(const BoundaryAttributes *attr)
{
    BoundaryAttributesObject *newObject;
    newObject = PyObject_NEW(BoundaryAttributesObject, &BoundaryAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (BoundaryAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
BoundaryAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewBoundaryAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef BoundaryAttributesMethods[] = {
    {"BoundaryAttributes", BoundaryAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *BoundaryAttributesObserver = 0;

std::string
PyBoundaryAttributes_GetLogString()
{
    std::string s("BoundaryAtts = BoundaryAttributes()\n");
    if(currentAtts != 0)
        s += PyBoundaryAttributes_ToString(currentAtts, "BoundaryAtts.");
    return s;
}

static void
PyBoundaryAttributes_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("BoundaryAtts = BoundaryAttributes()\n");
        s += PyBoundaryAttributes_ToString(currentAtts, "BoundaryAtts.");
        cb(s);
    }
}

void
PyBoundaryAttributes_StartUp(BoundaryAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyBoundaryAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(BoundaryAttributesObserver == 0)
    {
        BoundaryAttributesObserver = new ObserverToCallback(subj,
            PyBoundaryAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyBoundaryAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete BoundaryAttributesObserver;
    BoundaryAttributesObserver = 0;
}

PyMethodDef *
PyBoundaryAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return BoundaryAttributesMethods;
}

bool
PyBoundaryAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &BoundaryAttributesType);
}

BoundaryAttributes *
PyBoundaryAttributes_FromPyObject(PyObject *obj)
{
    BoundaryAttributesObject *obj2 = (BoundaryAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyBoundaryAttributes_New()
{
    return NewBoundaryAttributes(0);
}

PyObject *
PyBoundaryAttributes_Wrap(const BoundaryAttributes *attr)
{
    return WrapBoundaryAttributes(attr);
}

void
PyBoundaryAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    BoundaryAttributesObject *obj2 = (BoundaryAttributesObject *)obj;
    obj2->parent = parent;
}

// ****************************************************************************
//  Modifications:
//    Kathleen Bonnell, Mon Dec  2 18:06:04 PST 2002
//    Make defaultAtts point to the passed atts directly.
//
// ****************************************************************************
void
PyBoundaryAttributes_SetDefaults(const BoundaryAttributes *atts)
{
    defaultAtts = const_cast<BoundaryAttributes*>(atts);
}

