/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include "QvisToroidalPoloidalProjectionWindow.h"

#include <ToroidalPoloidalProjection.h>

#include <QCheckBox>
#include <QLabel>
#include <QLayout>
#include <QLineEdit>
#include <QButtonGroup>
#include <QRadioButton>


// ****************************************************************************
// Method: QvisToroidalPoloidalProjectionWindow::QvisToroidalPoloidalProjectionWindow
//
// Purpose: 
//   Constructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisToroidalPoloidalProjectionWindow::QvisToroidalPoloidalProjectionWindow(const int type,
                         ToroidalPoloidalProjection *subj,
                         const QString &caption,
                         const QString &shortName,
                         QvisNotepadArea *notepad)
    : QvisOperatorWindow(type,subj, caption, shortName, notepad)
{
    atts = subj;
}


// ****************************************************************************
// Method: QvisToroidalPoloidalProjectionWindow::~QvisToroidalPoloidalProjectionWindow
//
// Purpose: 
//   Destructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisToroidalPoloidalProjectionWindow::~QvisToroidalPoloidalProjectionWindow()
{
}


// ****************************************************************************
// Method: QvisToroidalPoloidalProjectionWindow::CreateWindowContents
//
// Purpose: 
//   Creates the widgets for the window.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisToroidalPoloidalProjectionWindow::CreateWindowContents()
{
    QGridLayout *mainLayout = new QGridLayout(0);
    topLayout->addLayout(mainLayout);

//     R0Label = new QLabel(tr("R0: toroidal radius"), central);
//     mainLayout->addWidget(R0Label,0,0);
//     R0 = new QLineEdit(central);
//     connect(R0, SIGNAL(returnPressed()),
//             this, SLOT(R0ProcessText()));
//     mainLayout->addWidget(R0, 0,1);

//     rLabel = new QLabel(tr("r: poloidal radius"), central);
//     mainLayout->addWidget(rLabel,1,0);
//     r = new QLineEdit(central);
//     connect(r, SIGNAL(returnPressed()),
//             this, SLOT(rProcessText()));
//     mainLayout->addWidget(r, 1,1);

    centroidSourceLabel = new QLabel(tr("Centroid Source"), central);
    mainLayout->addWidget(centroidSourceLabel,2,0);
    centroidSource = new QWidget(central);
    centroidSourceButtonGroup= new QButtonGroup(centroidSource);
    QHBoxLayout *centroidSourceLayout = new QHBoxLayout(centroidSource);
    centroidSourceLayout->setMargin(0);
    centroidSourceLayout->setSpacing(10);
    QRadioButton *centroidSourceCentroidSourceManual = new QRadioButton(tr("Manual"), centroidSource);
    centroidSourceButtonGroup->addButton(centroidSourceCentroidSourceManual,0);
    centroidSourceLayout->addWidget(centroidSourceCentroidSourceManual);
    QRadioButton *centroidSourceCentroidSourceAuto = new QRadioButton(tr("Auto"), centroidSource);
    centroidSourceButtonGroup->addButton(centroidSourceCentroidSourceAuto,1);
    centroidSourceLayout->addWidget(centroidSourceCentroidSourceAuto);
    connect(centroidSourceButtonGroup, SIGNAL(buttonClicked(int)),
            this, SLOT(centroidSourceChanged(int)));
    mainLayout->addWidget(centroidSource, 2,1);

    centroidLabel = new QLabel(tr("Centroid (R,phi,Z)"), central);
    mainLayout->addWidget(centroidLabel,3,0);
    centroid = new QLineEdit(central);
    connect(centroid, SIGNAL(returnPressed()),
            this, SLOT(centroidProcessText()));
    mainLayout->addWidget(centroid, 3,1);

    project2D = new QCheckBox(tr("Project to XY plane"), central);
    connect(project2D, SIGNAL(toggled(bool)),
            this, SLOT(project2DChanged(bool)));
    mainLayout->addWidget(project2D, 4,0);

}


// ****************************************************************************
// Method: QvisToroidalPoloidalProjectionWindow::UpdateWindow
//
// Purpose: 
//   Updates the widgets in the window when the subject changes.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisToroidalPoloidalProjectionWindow::UpdateWindow(bool doAll)
{

    for(int i = 0; i < atts->NumAttributes(); ++i)
    {
        if(!doAll)
        {
            if(!atts->IsSelected(i))
            {
                continue;
            }
        }

        switch(i)
        {
//           case ToroidalPoloidalProjection::ID_R0:
//             R0->setText(DoubleToQString(atts->GetR0()));
//             break;
//           case ToroidalPoloidalProjection::ID_r:
//             r->setText(DoubleToQString(atts->GetR()));
//             break;
          case ToroidalPoloidalProjection::ID_centroidSource:
            if (atts->GetCentroidSource() == ToroidalPoloidalProjection::Manual)
            {
                centroid->setEnabled(true);
                if(centroidLabel)
                    centroidLabel->setEnabled(true);
            }
            else
            {
                centroid->setEnabled(false);
                if(centroidLabel)
                    centroidLabel->setEnabled(false);
            }
            centroidSourceButtonGroup->blockSignals(true);
            if(centroidSourceButtonGroup->button((int)atts->GetCentroidSource()) != 0)
                centroidSourceButtonGroup->button((int)atts->GetCentroidSource())->setChecked(true);
            centroidSourceButtonGroup->blockSignals(false);
            break;
          case ToroidalPoloidalProjection::ID_centroid:
            centroid->setText(DoublesToQString(atts->GetCentroid(), 3));
            break;
          case ToroidalPoloidalProjection::ID_project2D:
            project2D->blockSignals(true);
            project2D->setChecked(atts->GetProject2D());
            project2D->blockSignals(false);
            break;
        }
    }
}


// ****************************************************************************
// Method: QvisToroidalPoloidalProjectionWindow::GetCurrentValues
//
// Purpose: 
//   Gets values from certain widgets and stores them in the subject.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisToroidalPoloidalProjectionWindow::GetCurrentValues(int which_widget)
{
    bool doAll = (which_widget == -1);

    // Do R0
//     if(which_widget == ToroidalPoloidalProjection::ID_R0 || doAll)
//     {
//         double val;
//         if(LineEditGetDouble(R0, val))
//             atts->SetR0(val);
//         else
//         {
//             ResettingError(tr("R0: toroidal radius"),
//                 DoubleToQString(atts->GetR0()));
//             atts->SetR0(atts->GetR0());
//         }
//     }

    // Do r
//     if(which_widget == ToroidalPoloidalProjection::ID_r || doAll)
//     {
//         double val;
//         if(LineEditGetDouble(r, val))
//             atts->SetR(val);
//         else
//         {
//             ResettingError(tr("r: poloidal radius"),
//                 DoubleToQString(atts->GetR()));
//             atts->SetR(atts->GetR());
//         }
//     }

    // Do centroid
    if(which_widget == ToroidalPoloidalProjection::ID_centroid || doAll)
    {
        double val[3];
        if(LineEditGetDoubles(centroid, val, 3))
            atts->SetCentroid(val);
        else
        {
            ResettingError(tr("Centroid (R,phi,Z)"),
                DoublesToQString(atts->GetCentroid(),3));
            atts->SetCentroid(atts->GetCentroid());
        }
    }

}


//
// Qt Slot functions
//


// void
// QvisToroidalPoloidalProjectionWindow::R0ProcessText()
// {
//     GetCurrentValues(ToroidalPoloidalProjection::ID_R0);
//     Apply();
// }


// void
// QvisToroidalPoloidalProjectionWindow::rProcessText()
// {
//     GetCurrentValues(ToroidalPoloidalProjection::ID_r);
//     Apply();
// }


void
QvisToroidalPoloidalProjectionWindow::centroidSourceChanged(int val)
{
    if(val != atts->GetCentroidSource())
    {
        atts->SetCentroidSource(ToroidalPoloidalProjection::CentroidSource(val));
        Apply();
    }
}


void
QvisToroidalPoloidalProjectionWindow::centroidProcessText()
{
    GetCurrentValues(ToroidalPoloidalProjection::ID_centroid);
    Apply();
}


void
QvisToroidalPoloidalProjectionWindow::project2DChanged(bool val)
{
    atts->SetProject2D(val);
    SetUpdate(false);
    Apply();
}


