/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

// ************************************************************************* //
//  File: StatisticalTrendsViewerEnginePluginInfo.C
// ************************************************************************* //

#include <StatisticalTrendsPluginInfo.h>
#include <StatisticalTrendsAttributes.h>

//
// Storage for static data elements.
//
StatisticalTrendsAttributes *StatisticalTrendsViewerEnginePluginInfo::clientAtts = NULL;
StatisticalTrendsAttributes *StatisticalTrendsViewerEnginePluginInfo::defaultAtts = NULL;

// ****************************************************************************
//  Method:  StatisticalTrendsViewerEnginePluginInfo::InitializeGlobalObjects
//
//  Purpose:
//    Initialize the operator atts.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************
void
StatisticalTrendsViewerEnginePluginInfo::InitializeGlobalObjects()
{
    StatisticalTrendsViewerEnginePluginInfo::clientAtts  = new StatisticalTrendsAttributes;
    StatisticalTrendsViewerEnginePluginInfo::defaultAtts = new StatisticalTrendsAttributes;
}

// ****************************************************************************
//  Method: StatisticalTrendsViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
StatisticalTrendsViewerEnginePluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: StatisticalTrendsViewerEnginePluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
StatisticalTrendsViewerEnginePluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: StatisticalTrendsViewerEnginePluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
StatisticalTrendsViewerEnginePluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(StatisticalTrendsAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: StatisticalTrendsViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
StatisticalTrendsViewerEnginePluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(StatisticalTrendsAttributes *)atts = *clientAtts;
}

// ****************************************************************************
//  Method: StatisticalTrendsViewerEnginePluginInfo::InitializeOperatorAtts
//
//  Purpose:
//    Initialize the operator attributes to the default attributes.
//
//  Arguments:
//    atts        The attribute subject to initialize.
//    plot        The viewer plot that owns the operator.
//    fromDefault True to initialize the attributes from the defaults. False
//                to initialize from the current attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
StatisticalTrendsViewerEnginePluginInfo::InitializeOperatorAtts(AttributeSubject *atts,
                                              const avtPlotMetaData &plot,
                                              const bool fromDefault)
{
    if (fromDefault)
        *(StatisticalTrendsAttributes*)atts = *defaultAtts;
    else
        *(StatisticalTrendsAttributes*)atts = *clientAtts;

    UpdateOperatorAtts(atts, plot);
}

// ****************************************************************************
//  Method: StatisticalTrendsViewerEnginePluginInfo::UpdateOperatorAtts
//
//  Purpose:
//    Update the operator attributes when using operator expressions.
//
//  Arguments:
//    atts        The attribute subject to update.
//    plot        The viewer plot that owns the operator.
//
//  Programmer: Allen Sanderson
//  Creation:   9 April 2013
//
// ****************************************************************************

#include <avtPlotMetaData.h>
#include <cstring>
void
StatisticalTrendsViewerEnginePluginInfo::UpdateOperatorAtts(AttributeSubject *atts,
                                                      const avtPlotMetaData &plot)
{
    StatisticalTrendsAttributes *atts_in = (StatisticalTrendsAttributes *)atts;

    const char numTypes = 6;
    const char *typeString[6] = { "Sum", "Mean", "Variance",
                                  "Std. Dev.", "Slope", "Residuals" };

    std::string var = plot.GetVariableName();

    if( strncmp(var.c_str(), "operators/StatisticalTrends/",
                strlen("operators/StatisticalTrends/")) == 0)
    {
      std::string operatorWithVar =
          var.substr(strlen("operators/StatisticalTrends/"));

      for (int t = 0; t < numTypes; ++t)
      { 
        if( strncmp(operatorWithVar.c_str(), typeString[t],
                    strlen(typeString[t])) == 0)
        {
          if( t != atts_in->GetStatisticType() )
            atts_in->SetStatisticType( (StatisticalTrendsAttributes::StatisticTypeEnum) t );

          if( atts_in->GetVariableSource() != StatisticalTrendsAttributes::OperatorExpression )
            atts_in->SetVariableSource( StatisticalTrendsAttributes::OperatorExpression );
          var = operatorWithVar.substr(strlen(typeString[t])+1);
        }
      }
    }
    else
    {
      if( atts_in->GetVariableSource() != StatisticalTrendsAttributes::Default )
        atts_in->SetVariableSource( StatisticalTrendsAttributes::Default );
    }
}

// ****************************************************************************
//  Method: StatisticalTrendsViewerEnginePluginInfo::GetOperatorVarDescription
//
//  Purpose:
//    Return the operator variable description.
//
//  Arguments:
//    atts        The attribute subject to initialize.
//    plot        The viewer plot that owns the operator.
//
//  Programmer: Allen Sanderson
//  Creation:   9 April 2013
//
// ****************************************************************************

#include <avtPlotMetaData.h>

std::string
StatisticalTrendsViewerEnginePluginInfo::GetOperatorVarDescription(AttributeSubject *atts,
                                                                   const avtPlotMetaData &plot)
{
    StatisticalTrendsAttributes *atts_in = (StatisticalTrendsAttributes *)atts;
    const char numTypes = 6;
    const char *typeString[6] = { "Sum", "Mean", "Variance",
                                  "Std. Dev.", "Slope", "Residuals" };

    std::string var = plot.GetVariableName();

    if( strncmp(var.c_str(), "operators/StatisticalTrends/",
                strlen("operators/StatisticalTrends/")) == 0)
    {
      std::string operatorWithVar =
          var.substr(strlen("operators/StatisticalTrends/"));

      for (int t = 0; t < numTypes; ++t)
      { 
        if( strncmp(operatorWithVar.c_str(), typeString[t],
                    strlen(typeString[t])) == 0)
        {
          var = operatorWithVar.substr(strlen(typeString[t])+1);

          var += std::string(" ") + std::string(typeString[t]);
        }
      }
    }
    else
    {
      var += std::string(" ") +
        std::string(typeString[atts_in->GetStatisticType()]);
    }

    return var;
}

// ****************************************************************************
//  Method: StatisticalTrendsViewerEnginePluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the viewer menus.
//
//  Returns:    A pointer to the name to use in the viewer menus.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
StatisticalTrendsViewerEnginePluginInfo::GetMenuName() const
{
    return "StatisticalTrends";
}

