/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PySliceAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>

// ****************************************************************************
// Module: PySliceAttributes
//
// Purpose: 
//   This class contains attributes for the arbitrary slice.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a SliceAttributes.
//
struct SliceAttributesObject
{
    PyObject_HEAD
    SliceAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewSliceAttributes(int);

std::string
PySliceAttributes_ToString(const SliceAttributes *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    const char *originType_names = "Point, Intercept, Percent, Zone, Node";
    switch (atts->GetOriginType())
    {
      case SliceAttributes::Point:
          SNPRINTF(tmpStr, 1000, "%soriginType = %sPoint  # %s\n", prefix, prefix, originType_names);
          str += tmpStr;
          break;
      case SliceAttributes::Intercept:
          SNPRINTF(tmpStr, 1000, "%soriginType = %sIntercept  # %s\n", prefix, prefix, originType_names);
          str += tmpStr;
          break;
      case SliceAttributes::Percent:
          SNPRINTF(tmpStr, 1000, "%soriginType = %sPercent  # %s\n", prefix, prefix, originType_names);
          str += tmpStr;
          break;
      case SliceAttributes::Zone:
          SNPRINTF(tmpStr, 1000, "%soriginType = %sZone  # %s\n", prefix, prefix, originType_names);
          str += tmpStr;
          break;
      case SliceAttributes::Node:
          SNPRINTF(tmpStr, 1000, "%soriginType = %sNode  # %s\n", prefix, prefix, originType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    {   const double *originPoint = atts->GetOriginPoint();
        SNPRINTF(tmpStr, 1000, "%soriginPoint = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", originPoint[i]);
            str += tmpStr;
            if(i < 2)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    SNPRINTF(tmpStr, 1000, "%soriginIntercept = %g\n", prefix, atts->GetOriginIntercept());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%soriginPercent = %g\n", prefix, atts->GetOriginPercent());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%soriginZone = %d\n", prefix, atts->GetOriginZone());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%soriginNode = %d\n", prefix, atts->GetOriginNode());
    str += tmpStr;
    {   const double *normal = atts->GetNormal();
        SNPRINTF(tmpStr, 1000, "%snormal = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", normal[i]);
            str += tmpStr;
            if(i < 2)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    const char *axisType_names = "XAxis, YAxis, ZAxis, Arbitrary, ThetaPhi";
    switch (atts->GetAxisType())
    {
      case SliceAttributes::XAxis:
          SNPRINTF(tmpStr, 1000, "%saxisType = %sXAxis  # %s\n", prefix, prefix, axisType_names);
          str += tmpStr;
          break;
      case SliceAttributes::YAxis:
          SNPRINTF(tmpStr, 1000, "%saxisType = %sYAxis  # %s\n", prefix, prefix, axisType_names);
          str += tmpStr;
          break;
      case SliceAttributes::ZAxis:
          SNPRINTF(tmpStr, 1000, "%saxisType = %sZAxis  # %s\n", prefix, prefix, axisType_names);
          str += tmpStr;
          break;
      case SliceAttributes::Arbitrary:
          SNPRINTF(tmpStr, 1000, "%saxisType = %sArbitrary  # %s\n", prefix, prefix, axisType_names);
          str += tmpStr;
          break;
      case SliceAttributes::ThetaPhi:
          SNPRINTF(tmpStr, 1000, "%saxisType = %sThetaPhi  # %s\n", prefix, prefix, axisType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    {   const double *upAxis = atts->GetUpAxis();
        SNPRINTF(tmpStr, 1000, "%supAxis = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", upAxis[i]);
            str += tmpStr;
            if(i < 2)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    if(atts->GetProject2d())
        SNPRINTF(tmpStr, 1000, "%sproject2d = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sproject2d = 0\n", prefix);
    str += tmpStr;
    if(atts->GetInteractive())
        SNPRINTF(tmpStr, 1000, "%sinteractive = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sinteractive = 0\n", prefix);
    str += tmpStr;
    if(atts->GetFlip())
        SNPRINTF(tmpStr, 1000, "%sflip = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sflip = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%soriginZoneDomain = %d\n", prefix, atts->GetOriginZoneDomain());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%soriginNodeDomain = %d\n", prefix, atts->GetOriginNodeDomain());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%smeshName = \"%s\"\n", prefix, atts->GetMeshName().c_str());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%stheta = %g\n", prefix, atts->GetTheta());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sphi = %g\n", prefix, atts->GetPhi());
    str += tmpStr;
    return str;
}

static PyObject *
SliceAttributes_Notify(PyObject *self, PyObject *args)
{
    SliceAttributesObject *obj = (SliceAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SliceAttributes_SetOriginType(PyObject *self, PyObject *args)
{
    SliceAttributesObject *obj = (SliceAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the originType in the object.
    if(ival >= 0 && ival < 5)
        obj->data->SetOriginType(SliceAttributes::OriginType(ival));
    else
    {
        fprintf(stderr, "An invalid originType value was given. "
                        "Valid values are in the range of [0,4]. "
                        "You can also use the following names: "
                        "Point, Intercept, Percent, Zone, Node"
                        ".");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SliceAttributes_GetOriginType(PyObject *self, PyObject *args)
{
    SliceAttributesObject *obj = (SliceAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetOriginType()));
    return retval;
}

/*static*/ PyObject *
SliceAttributes_SetOriginPoint(PyObject *self, PyObject *args)
{
    SliceAttributesObject *obj = (SliceAttributesObject *)self;

    double *dvals = obj->data->GetOriginPoint();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the originPoint in the object as modified.
    obj->data->SelectOriginPoint();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SliceAttributes_GetOriginPoint(PyObject *self, PyObject *args)
{
    SliceAttributesObject *obj = (SliceAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the originPoint.
    PyObject *retval = PyTuple_New(3);
    const double *originPoint = obj->data->GetOriginPoint();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(originPoint[i]));
    return retval;
}

/*static*/ PyObject *
SliceAttributes_SetOriginIntercept(PyObject *self, PyObject *args)
{
    SliceAttributesObject *obj = (SliceAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the originIntercept in the object.
    obj->data->SetOriginIntercept(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SliceAttributes_GetOriginIntercept(PyObject *self, PyObject *args)
{
    SliceAttributesObject *obj = (SliceAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetOriginIntercept());
    return retval;
}

/*static*/ PyObject *
SliceAttributes_SetOriginPercent(PyObject *self, PyObject *args)
{
    SliceAttributesObject *obj = (SliceAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the originPercent in the object.
    obj->data->SetOriginPercent(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SliceAttributes_GetOriginPercent(PyObject *self, PyObject *args)
{
    SliceAttributesObject *obj = (SliceAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetOriginPercent());
    return retval;
}

/*static*/ PyObject *
SliceAttributes_SetOriginZone(PyObject *self, PyObject *args)
{
    SliceAttributesObject *obj = (SliceAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the originZone in the object.
    obj->data->SetOriginZone((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SliceAttributes_GetOriginZone(PyObject *self, PyObject *args)
{
    SliceAttributesObject *obj = (SliceAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetOriginZone()));
    return retval;
}

/*static*/ PyObject *
SliceAttributes_SetOriginNode(PyObject *self, PyObject *args)
{
    SliceAttributesObject *obj = (SliceAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the originNode in the object.
    obj->data->SetOriginNode((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SliceAttributes_GetOriginNode(PyObject *self, PyObject *args)
{
    SliceAttributesObject *obj = (SliceAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetOriginNode()));
    return retval;
}

/*static*/ PyObject *
SliceAttributes_SetNormal(PyObject *self, PyObject *args)
{
    SliceAttributesObject *obj = (SliceAttributesObject *)self;

    double *dvals = obj->data->GetNormal();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the normal in the object as modified.
    obj->data->SelectNormal();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SliceAttributes_GetNormal(PyObject *self, PyObject *args)
{
    SliceAttributesObject *obj = (SliceAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the normal.
    PyObject *retval = PyTuple_New(3);
    const double *normal = obj->data->GetNormal();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(normal[i]));
    return retval;
}

/*static*/ PyObject *
SliceAttributes_SetAxisType(PyObject *self, PyObject *args)
{
    SliceAttributesObject *obj = (SliceAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the axisType in the object.
    if(ival >= 0 && ival < 5)
        obj->data->SetAxisType(SliceAttributes::AxisType(ival));
    else
    {
        fprintf(stderr, "An invalid axisType value was given. "
                        "Valid values are in the range of [0,4]. "
                        "You can also use the following names: "
                        "XAxis, YAxis, ZAxis, Arbitrary, ThetaPhi"
                        ".");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SliceAttributes_GetAxisType(PyObject *self, PyObject *args)
{
    SliceAttributesObject *obj = (SliceAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetAxisType()));
    return retval;
}

/*static*/ PyObject *
SliceAttributes_SetUpAxis(PyObject *self, PyObject *args)
{
    SliceAttributesObject *obj = (SliceAttributesObject *)self;

    double *dvals = obj->data->GetUpAxis();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the upAxis in the object as modified.
    obj->data->SelectUpAxis();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SliceAttributes_GetUpAxis(PyObject *self, PyObject *args)
{
    SliceAttributesObject *obj = (SliceAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the upAxis.
    PyObject *retval = PyTuple_New(3);
    const double *upAxis = obj->data->GetUpAxis();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(upAxis[i]));
    return retval;
}

/*static*/ PyObject *
SliceAttributes_SetProject2d(PyObject *self, PyObject *args)
{
    SliceAttributesObject *obj = (SliceAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the project2d in the object.
    obj->data->SetProject2d(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SliceAttributes_GetProject2d(PyObject *self, PyObject *args)
{
    SliceAttributesObject *obj = (SliceAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetProject2d()?1L:0L);
    return retval;
}

/*static*/ PyObject *
SliceAttributes_SetInteractive(PyObject *self, PyObject *args)
{
    SliceAttributesObject *obj = (SliceAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the interactive in the object.
    obj->data->SetInteractive(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SliceAttributes_GetInteractive(PyObject *self, PyObject *args)
{
    SliceAttributesObject *obj = (SliceAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetInteractive()?1L:0L);
    return retval;
}

/*static*/ PyObject *
SliceAttributes_SetFlip(PyObject *self, PyObject *args)
{
    SliceAttributesObject *obj = (SliceAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the flip in the object.
    obj->data->SetFlip(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SliceAttributes_GetFlip(PyObject *self, PyObject *args)
{
    SliceAttributesObject *obj = (SliceAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetFlip()?1L:0L);
    return retval;
}

/*static*/ PyObject *
SliceAttributes_SetOriginZoneDomain(PyObject *self, PyObject *args)
{
    SliceAttributesObject *obj = (SliceAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the originZoneDomain in the object.
    obj->data->SetOriginZoneDomain((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SliceAttributes_GetOriginZoneDomain(PyObject *self, PyObject *args)
{
    SliceAttributesObject *obj = (SliceAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetOriginZoneDomain()));
    return retval;
}

/*static*/ PyObject *
SliceAttributes_SetOriginNodeDomain(PyObject *self, PyObject *args)
{
    SliceAttributesObject *obj = (SliceAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the originNodeDomain in the object.
    obj->data->SetOriginNodeDomain((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SliceAttributes_GetOriginNodeDomain(PyObject *self, PyObject *args)
{
    SliceAttributesObject *obj = (SliceAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetOriginNodeDomain()));
    return retval;
}

/*static*/ PyObject *
SliceAttributes_SetMeshName(PyObject *self, PyObject *args)
{
    SliceAttributesObject *obj = (SliceAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the meshName in the object.
    obj->data->SetMeshName(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SliceAttributes_GetMeshName(PyObject *self, PyObject *args)
{
    SliceAttributesObject *obj = (SliceAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetMeshName().c_str());
    return retval;
}

/*static*/ PyObject *
SliceAttributes_SetTheta(PyObject *self, PyObject *args)
{
    SliceAttributesObject *obj = (SliceAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the theta in the object.
    obj->data->SetTheta(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SliceAttributes_GetTheta(PyObject *self, PyObject *args)
{
    SliceAttributesObject *obj = (SliceAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetTheta());
    return retval;
}

/*static*/ PyObject *
SliceAttributes_SetPhi(PyObject *self, PyObject *args)
{
    SliceAttributesObject *obj = (SliceAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the phi in the object.
    obj->data->SetPhi(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SliceAttributes_GetPhi(PyObject *self, PyObject *args)
{
    SliceAttributesObject *obj = (SliceAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetPhi());
    return retval;
}



PyMethodDef PySliceAttributes_methods[SLICEATTRIBUTES_NMETH] = {
    {"Notify", SliceAttributes_Notify, METH_VARARGS},
    {"SetOriginType", SliceAttributes_SetOriginType, METH_VARARGS},
    {"GetOriginType", SliceAttributes_GetOriginType, METH_VARARGS},
    {"SetOriginPoint", SliceAttributes_SetOriginPoint, METH_VARARGS},
    {"GetOriginPoint", SliceAttributes_GetOriginPoint, METH_VARARGS},
    {"SetOriginIntercept", SliceAttributes_SetOriginIntercept, METH_VARARGS},
    {"GetOriginIntercept", SliceAttributes_GetOriginIntercept, METH_VARARGS},
    {"SetOriginPercent", SliceAttributes_SetOriginPercent, METH_VARARGS},
    {"GetOriginPercent", SliceAttributes_GetOriginPercent, METH_VARARGS},
    {"SetOriginZone", SliceAttributes_SetOriginZone, METH_VARARGS},
    {"GetOriginZone", SliceAttributes_GetOriginZone, METH_VARARGS},
    {"SetOriginNode", SliceAttributes_SetOriginNode, METH_VARARGS},
    {"GetOriginNode", SliceAttributes_GetOriginNode, METH_VARARGS},
    {"SetNormal", SliceAttributes_SetNormal, METH_VARARGS},
    {"GetNormal", SliceAttributes_GetNormal, METH_VARARGS},
    {"SetAxisType", SliceAttributes_SetAxisType, METH_VARARGS},
    {"GetAxisType", SliceAttributes_GetAxisType, METH_VARARGS},
    {"SetUpAxis", SliceAttributes_SetUpAxis, METH_VARARGS},
    {"GetUpAxis", SliceAttributes_GetUpAxis, METH_VARARGS},
    {"SetProject2d", SliceAttributes_SetProject2d, METH_VARARGS},
    {"GetProject2d", SliceAttributes_GetProject2d, METH_VARARGS},
    {"SetInteractive", SliceAttributes_SetInteractive, METH_VARARGS},
    {"GetInteractive", SliceAttributes_GetInteractive, METH_VARARGS},
    {"SetFlip", SliceAttributes_SetFlip, METH_VARARGS},
    {"GetFlip", SliceAttributes_GetFlip, METH_VARARGS},
    {"SetOriginZoneDomain", SliceAttributes_SetOriginZoneDomain, METH_VARARGS},
    {"GetOriginZoneDomain", SliceAttributes_GetOriginZoneDomain, METH_VARARGS},
    {"SetOriginNodeDomain", SliceAttributes_SetOriginNodeDomain, METH_VARARGS},
    {"GetOriginNodeDomain", SliceAttributes_GetOriginNodeDomain, METH_VARARGS},
    {"SetMeshName", SliceAttributes_SetMeshName, METH_VARARGS},
    {"GetMeshName", SliceAttributes_GetMeshName, METH_VARARGS},
    {"SetTheta", SliceAttributes_SetTheta, METH_VARARGS},
    {"GetTheta", SliceAttributes_GetTheta, METH_VARARGS},
    {"SetPhi", SliceAttributes_SetPhi, METH_VARARGS},
    {"GetPhi", SliceAttributes_GetPhi, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
SliceAttributes_dealloc(PyObject *v)
{
   SliceAttributesObject *obj = (SliceAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
SliceAttributes_compare(PyObject *v, PyObject *w)
{
    SliceAttributes *a = ((SliceAttributesObject *)v)->data;
    SliceAttributes *b = ((SliceAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PySliceAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "originType") == 0)
        return SliceAttributes_GetOriginType(self, NULL);
    if(strcmp(name, "Point") == 0)
        return PyInt_FromLong(long(SliceAttributes::Point));
    if(strcmp(name, "Intercept") == 0)
        return PyInt_FromLong(long(SliceAttributes::Intercept));
    if(strcmp(name, "Percent") == 0)
        return PyInt_FromLong(long(SliceAttributes::Percent));
    if(strcmp(name, "Zone") == 0)
        return PyInt_FromLong(long(SliceAttributes::Zone));
    if(strcmp(name, "Node") == 0)
        return PyInt_FromLong(long(SliceAttributes::Node));

    if(strcmp(name, "originPoint") == 0)
        return SliceAttributes_GetOriginPoint(self, NULL);
    if(strcmp(name, "originIntercept") == 0)
        return SliceAttributes_GetOriginIntercept(self, NULL);
    if(strcmp(name, "originPercent") == 0)
        return SliceAttributes_GetOriginPercent(self, NULL);
    if(strcmp(name, "originZone") == 0)
        return SliceAttributes_GetOriginZone(self, NULL);
    if(strcmp(name, "originNode") == 0)
        return SliceAttributes_GetOriginNode(self, NULL);
    if(strcmp(name, "normal") == 0)
        return SliceAttributes_GetNormal(self, NULL);
    if(strcmp(name, "axisType") == 0)
        return SliceAttributes_GetAxisType(self, NULL);
    if(strcmp(name, "XAxis") == 0)
        return PyInt_FromLong(long(SliceAttributes::XAxis));
    if(strcmp(name, "YAxis") == 0)
        return PyInt_FromLong(long(SliceAttributes::YAxis));
    if(strcmp(name, "ZAxis") == 0)
        return PyInt_FromLong(long(SliceAttributes::ZAxis));
    if(strcmp(name, "Arbitrary") == 0)
        return PyInt_FromLong(long(SliceAttributes::Arbitrary));
    if(strcmp(name, "ThetaPhi") == 0)
        return PyInt_FromLong(long(SliceAttributes::ThetaPhi));

    if(strcmp(name, "upAxis") == 0)
        return SliceAttributes_GetUpAxis(self, NULL);
    if(strcmp(name, "project2d") == 0)
        return SliceAttributes_GetProject2d(self, NULL);
    if(strcmp(name, "interactive") == 0)
        return SliceAttributes_GetInteractive(self, NULL);
    if(strcmp(name, "flip") == 0)
        return SliceAttributes_GetFlip(self, NULL);
    if(strcmp(name, "originZoneDomain") == 0)
        return SliceAttributes_GetOriginZoneDomain(self, NULL);
    if(strcmp(name, "originNodeDomain") == 0)
        return SliceAttributes_GetOriginNodeDomain(self, NULL);
    if(strcmp(name, "meshName") == 0)
        return SliceAttributes_GetMeshName(self, NULL);
    if(strcmp(name, "theta") == 0)
        return SliceAttributes_GetTheta(self, NULL);
    if(strcmp(name, "phi") == 0)
        return SliceAttributes_GetPhi(self, NULL);

    return Py_FindMethod(PySliceAttributes_methods, self, name);
}

int
PySliceAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "originType") == 0)
        obj = SliceAttributes_SetOriginType(self, tuple);
    else if(strcmp(name, "originPoint") == 0)
        obj = SliceAttributes_SetOriginPoint(self, tuple);
    else if(strcmp(name, "originIntercept") == 0)
        obj = SliceAttributes_SetOriginIntercept(self, tuple);
    else if(strcmp(name, "originPercent") == 0)
        obj = SliceAttributes_SetOriginPercent(self, tuple);
    else if(strcmp(name, "originZone") == 0)
        obj = SliceAttributes_SetOriginZone(self, tuple);
    else if(strcmp(name, "originNode") == 0)
        obj = SliceAttributes_SetOriginNode(self, tuple);
    else if(strcmp(name, "normal") == 0)
        obj = SliceAttributes_SetNormal(self, tuple);
    else if(strcmp(name, "axisType") == 0)
        obj = SliceAttributes_SetAxisType(self, tuple);
    else if(strcmp(name, "upAxis") == 0)
        obj = SliceAttributes_SetUpAxis(self, tuple);
    else if(strcmp(name, "project2d") == 0)
        obj = SliceAttributes_SetProject2d(self, tuple);
    else if(strcmp(name, "interactive") == 0)
        obj = SliceAttributes_SetInteractive(self, tuple);
    else if(strcmp(name, "flip") == 0)
        obj = SliceAttributes_SetFlip(self, tuple);
    else if(strcmp(name, "originZoneDomain") == 0)
        obj = SliceAttributes_SetOriginZoneDomain(self, tuple);
    else if(strcmp(name, "originNodeDomain") == 0)
        obj = SliceAttributes_SetOriginNodeDomain(self, tuple);
    else if(strcmp(name, "meshName") == 0)
        obj = SliceAttributes_SetMeshName(self, tuple);
    else if(strcmp(name, "theta") == 0)
        obj = SliceAttributes_SetTheta(self, tuple);
    else if(strcmp(name, "phi") == 0)
        obj = SliceAttributes_SetPhi(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
SliceAttributes_print(PyObject *v, FILE *fp, int flags)
{
    SliceAttributesObject *obj = (SliceAttributesObject *)v;
    fprintf(fp, "%s", PySliceAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
SliceAttributes_str(PyObject *v)
{
    SliceAttributesObject *obj = (SliceAttributesObject *)v;
    return PyString_FromString(PySliceAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *SliceAttributes_Purpose = "This class contains attributes for the arbitrary slice.";
#else
static char *SliceAttributes_Purpose = "This class contains attributes for the arbitrary slice.";
#endif

//
// The type description structure
//
static PyTypeObject SliceAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "SliceAttributes",                    // tp_name
    sizeof(SliceAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)SliceAttributes_dealloc,  // tp_dealloc
    (printfunc)SliceAttributes_print,     // tp_print
    (getattrfunc)PySliceAttributes_getattr, // tp_getattr
    (setattrfunc)PySliceAttributes_setattr, // tp_setattr
    (cmpfunc)SliceAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)SliceAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    SliceAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static SliceAttributes *defaultAtts = 0;
static SliceAttributes *currentAtts = 0;

static PyObject *
NewSliceAttributes(int useCurrent)
{
    SliceAttributesObject *newObject;
    newObject = PyObject_NEW(SliceAttributesObject, &SliceAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new SliceAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new SliceAttributes(*defaultAtts);
    else
        newObject->data = new SliceAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapSliceAttributes(const SliceAttributes *attr)
{
    SliceAttributesObject *newObject;
    newObject = PyObject_NEW(SliceAttributesObject, &SliceAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (SliceAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
SliceAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewSliceAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef SliceAttributesMethods[] = {
    {"SliceAttributes", SliceAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *SliceAttributesObserver = 0;

std::string
PySliceAttributes_GetLogString()
{
    std::string s("SliceAtts = SliceAttributes()\n");
    if(currentAtts != 0)
        s += PySliceAttributes_ToString(currentAtts, "SliceAtts.");
    return s;
}

static void
PySliceAttributes_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("SliceAtts = SliceAttributes()\n");
        s += PySliceAttributes_ToString(currentAtts, "SliceAtts.");
        cb(s);
    }
}

void
PySliceAttributes_StartUp(SliceAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PySliceAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(SliceAttributesObserver == 0)
    {
        SliceAttributesObserver = new ObserverToCallback(subj,
            PySliceAttributes_CallLogRoutine, (void *)data);
    }

}

void
PySliceAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete SliceAttributesObserver;
    SliceAttributesObserver = 0;
}

PyMethodDef *
PySliceAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return SliceAttributesMethods;
}

bool
PySliceAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &SliceAttributesType);
}

SliceAttributes *
PySliceAttributes_FromPyObject(PyObject *obj)
{
    SliceAttributesObject *obj2 = (SliceAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PySliceAttributes_New()
{
    return NewSliceAttributes(0);
}

PyObject *
PySliceAttributes_Wrap(const SliceAttributes *attr)
{
    return WrapSliceAttributes(attr);
}

void
PySliceAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    SliceAttributesObject *obj2 = (SliceAttributesObject *)obj;
    obj2->parent = parent;
}

void
PySliceAttributes_SetDefaults(const SliceAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new SliceAttributes(*atts);
}

