/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PersistentParticlesAttributes.h>
#include <DataNode.h>

//
// Enum conversion methods for PersistentParticlesAttributes::PathTypeEnum
//

static const char *PathTypeEnum_strings[] = {
"Absolute", "Relative"};

std::string
PersistentParticlesAttributes::PathTypeEnum_ToString(PersistentParticlesAttributes::PathTypeEnum t)
{
    int index = int(t);
    if(index < 0 || index >= 2) index = 0;
    return PathTypeEnum_strings[index];
}

std::string
PersistentParticlesAttributes::PathTypeEnum_ToString(int t)
{
    int index = (t < 0 || t >= 2) ? 0 : t;
    return PathTypeEnum_strings[index];
}

bool
PersistentParticlesAttributes::PathTypeEnum_FromString(const std::string &s, PersistentParticlesAttributes::PathTypeEnum &val)
{
    val = PersistentParticlesAttributes::Absolute;
    for(int i = 0; i < 2; ++i)
    {
        if(s == PathTypeEnum_strings[i])
        {
            val = (PathTypeEnum)i;
            return true;
        }
    }
    return false;
}

// ****************************************************************************
// Method: PersistentParticlesAttributes::PersistentParticlesAttributes
//
// Purpose: 
//   Init utility for the PersistentParticlesAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void PersistentParticlesAttributes::Init()
{
    startIndex = 0;
    stopIndex = 1;
    stride = 1;
    startPathType = Absolute;
    stopPathType = Absolute;
    connectParticles = false;
    showPoints = false;

    PersistentParticlesAttributes::SelectAll();
}

// ****************************************************************************
// Method: PersistentParticlesAttributes::PersistentParticlesAttributes
//
// Purpose: 
//   Copy utility for the PersistentParticlesAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void PersistentParticlesAttributes::Copy(const PersistentParticlesAttributes &obj)
{
    startIndex = obj.startIndex;
    stopIndex = obj.stopIndex;
    stride = obj.stride;
    startPathType = obj.startPathType;
    stopPathType = obj.stopPathType;
    traceVariableX = obj.traceVariableX;
    traceVariableY = obj.traceVariableY;
    traceVariableZ = obj.traceVariableZ;
    connectParticles = obj.connectParticles;
    showPoints = obj.showPoints;
    indexVariable = obj.indexVariable;

    PersistentParticlesAttributes::SelectAll();
}

// Type map format string
const char *PersistentParticlesAttributes::TypeMapFormatString = PERSISTENTPARTICLESATTRIBUTES_TMFS;
const AttributeGroup::private_tmfs_t PersistentParticlesAttributes::TmfsStruct = {PERSISTENTPARTICLESATTRIBUTES_TMFS};


// ****************************************************************************
// Method: PersistentParticlesAttributes::PersistentParticlesAttributes
//
// Purpose: 
//   Default constructor for the PersistentParticlesAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

PersistentParticlesAttributes::PersistentParticlesAttributes() : 
    AttributeSubject(PersistentParticlesAttributes::TypeMapFormatString),
    traceVariableX("default"), traceVariableY("default"), 
    traceVariableZ("default"), indexVariable("default")
{
    PersistentParticlesAttributes::Init();
}

// ****************************************************************************
// Method: PersistentParticlesAttributes::PersistentParticlesAttributes
//
// Purpose: 
//   Constructor for the derived classes of PersistentParticlesAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

PersistentParticlesAttributes::PersistentParticlesAttributes(private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs),
    traceVariableX("default"), traceVariableY("default"), 
    traceVariableZ("default"), indexVariable("default")
{
    PersistentParticlesAttributes::Init();
}

// ****************************************************************************
// Method: PersistentParticlesAttributes::PersistentParticlesAttributes
//
// Purpose: 
//   Copy constructor for the PersistentParticlesAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

PersistentParticlesAttributes::PersistentParticlesAttributes(const PersistentParticlesAttributes &obj) : 
    AttributeSubject(PersistentParticlesAttributes::TypeMapFormatString)
{
    PersistentParticlesAttributes::Copy(obj);
}

// ****************************************************************************
// Method: PersistentParticlesAttributes::PersistentParticlesAttributes
//
// Purpose: 
//   Copy constructor for derived classes of the PersistentParticlesAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

PersistentParticlesAttributes::PersistentParticlesAttributes(const PersistentParticlesAttributes &obj, private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    PersistentParticlesAttributes::Copy(obj);
}

// ****************************************************************************
// Method: PersistentParticlesAttributes::~PersistentParticlesAttributes
//
// Purpose: 
//   Destructor for the PersistentParticlesAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

PersistentParticlesAttributes::~PersistentParticlesAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: PersistentParticlesAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the PersistentParticlesAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

PersistentParticlesAttributes& 
PersistentParticlesAttributes::operator = (const PersistentParticlesAttributes &obj)
{
    if (this == &obj) return *this;

    PersistentParticlesAttributes::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: PersistentParticlesAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the PersistentParticlesAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
PersistentParticlesAttributes::operator == (const PersistentParticlesAttributes &obj) const
{
    // Create the return value
    return ((startIndex == obj.startIndex) &&
            (stopIndex == obj.stopIndex) &&
            (stride == obj.stride) &&
            (startPathType == obj.startPathType) &&
            (stopPathType == obj.stopPathType) &&
            (traceVariableX == obj.traceVariableX) &&
            (traceVariableY == obj.traceVariableY) &&
            (traceVariableZ == obj.traceVariableZ) &&
            (connectParticles == obj.connectParticles) &&
            (showPoints == obj.showPoints) &&
            (indexVariable == obj.indexVariable));
}

// ****************************************************************************
// Method: PersistentParticlesAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the PersistentParticlesAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
PersistentParticlesAttributes::operator != (const PersistentParticlesAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: PersistentParticlesAttributes::TypeName
//
// Purpose: 
//   Type name method for the PersistentParticlesAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
PersistentParticlesAttributes::TypeName() const
{
    return "PersistentParticlesAttributes";
}

// ****************************************************************************
// Method: PersistentParticlesAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the PersistentParticlesAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
PersistentParticlesAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const PersistentParticlesAttributes *tmp = (const PersistentParticlesAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: PersistentParticlesAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the PersistentParticlesAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
PersistentParticlesAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new PersistentParticlesAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: PersistentParticlesAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the PersistentParticlesAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
PersistentParticlesAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new PersistentParticlesAttributes(*this);
    else
        retval = new PersistentParticlesAttributes;

    return retval;
}

// ****************************************************************************
// Method: PersistentParticlesAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
PersistentParticlesAttributes::SelectAll()
{
    Select(ID_startIndex,       (void *)&startIndex);
    Select(ID_stopIndex,        (void *)&stopIndex);
    Select(ID_stride,           (void *)&stride);
    Select(ID_startPathType,    (void *)&startPathType);
    Select(ID_stopPathType,     (void *)&stopPathType);
    Select(ID_traceVariableX,   (void *)&traceVariableX);
    Select(ID_traceVariableY,   (void *)&traceVariableY);
    Select(ID_traceVariableZ,   (void *)&traceVariableZ);
    Select(ID_connectParticles, (void *)&connectParticles);
    Select(ID_showPoints,       (void *)&showPoints);
    Select(ID_indexVariable,    (void *)&indexVariable);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: PersistentParticlesAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
PersistentParticlesAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    PersistentParticlesAttributes defaultObject;
    bool addToParent = false;
    // Create a node for PersistentParticlesAttributes.
    DataNode *node = new DataNode("PersistentParticlesAttributes");

    if(completeSave || !FieldsEqual(ID_startIndex, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("startIndex", startIndex));
    }

    if(completeSave || !FieldsEqual(ID_stopIndex, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("stopIndex", stopIndex));
    }

    if(completeSave || !FieldsEqual(ID_stride, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("stride", stride));
    }

    if(completeSave || !FieldsEqual(ID_startPathType, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("startPathType", PathTypeEnum_ToString(startPathType)));
    }

    if(completeSave || !FieldsEqual(ID_stopPathType, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("stopPathType", PathTypeEnum_ToString(stopPathType)));
    }

    if(completeSave || !FieldsEqual(ID_traceVariableX, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("traceVariableX", traceVariableX));
    }

    if(completeSave || !FieldsEqual(ID_traceVariableY, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("traceVariableY", traceVariableY));
    }

    if(completeSave || !FieldsEqual(ID_traceVariableZ, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("traceVariableZ", traceVariableZ));
    }

    if(completeSave || !FieldsEqual(ID_connectParticles, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("connectParticles", connectParticles));
    }

    if(completeSave || !FieldsEqual(ID_showPoints, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("showPoints", showPoints));
    }

    if(completeSave || !FieldsEqual(ID_indexVariable, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("indexVariable", indexVariable));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: PersistentParticlesAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
PersistentParticlesAttributes::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("PersistentParticlesAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("startIndex")) != 0)
        SetStartIndex(node->AsInt());
    if((node = searchNode->GetNode("stopIndex")) != 0)
        SetStopIndex(node->AsInt());
    if((node = searchNode->GetNode("stride")) != 0)
        SetStride(node->AsInt());
    if((node = searchNode->GetNode("startPathType")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 2)
                SetStartPathType(PathTypeEnum(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            PathTypeEnum value;
            if(PathTypeEnum_FromString(node->AsString(), value))
                SetStartPathType(value);
        }
    }
    if((node = searchNode->GetNode("stopPathType")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 2)
                SetStopPathType(PathTypeEnum(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            PathTypeEnum value;
            if(PathTypeEnum_FromString(node->AsString(), value))
                SetStopPathType(value);
        }
    }
    if((node = searchNode->GetNode("traceVariableX")) != 0)
        SetTraceVariableX(node->AsString());
    if((node = searchNode->GetNode("traceVariableY")) != 0)
        SetTraceVariableY(node->AsString());
    if((node = searchNode->GetNode("traceVariableZ")) != 0)
        SetTraceVariableZ(node->AsString());
    if((node = searchNode->GetNode("connectParticles")) != 0)
        SetConnectParticles(node->AsBool());
    if((node = searchNode->GetNode("showPoints")) != 0)
        SetShowPoints(node->AsBool());
    if((node = searchNode->GetNode("indexVariable")) != 0)
        SetIndexVariable(node->AsString());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
PersistentParticlesAttributes::SetStartIndex(int startIndex_)
{
    startIndex = startIndex_;
    Select(ID_startIndex, (void *)&startIndex);
}

void
PersistentParticlesAttributes::SetStopIndex(int stopIndex_)
{
    stopIndex = stopIndex_;
    Select(ID_stopIndex, (void *)&stopIndex);
}

void
PersistentParticlesAttributes::SetStride(int stride_)
{
    stride = stride_;
    Select(ID_stride, (void *)&stride);
}

void
PersistentParticlesAttributes::SetStartPathType(PersistentParticlesAttributes::PathTypeEnum startPathType_)
{
    startPathType = startPathType_;
    Select(ID_startPathType, (void *)&startPathType);
}

void
PersistentParticlesAttributes::SetStopPathType(PersistentParticlesAttributes::PathTypeEnum stopPathType_)
{
    stopPathType = stopPathType_;
    Select(ID_stopPathType, (void *)&stopPathType);
}

void
PersistentParticlesAttributes::SetTraceVariableX(const std::string &traceVariableX_)
{
    traceVariableX = traceVariableX_;
    Select(ID_traceVariableX, (void *)&traceVariableX);
}

void
PersistentParticlesAttributes::SetTraceVariableY(const std::string &traceVariableY_)
{
    traceVariableY = traceVariableY_;
    Select(ID_traceVariableY, (void *)&traceVariableY);
}

void
PersistentParticlesAttributes::SetTraceVariableZ(const std::string &traceVariableZ_)
{
    traceVariableZ = traceVariableZ_;
    Select(ID_traceVariableZ, (void *)&traceVariableZ);
}

void
PersistentParticlesAttributes::SetConnectParticles(bool connectParticles_)
{
    connectParticles = connectParticles_;
    Select(ID_connectParticles, (void *)&connectParticles);
}

void
PersistentParticlesAttributes::SetShowPoints(bool showPoints_)
{
    showPoints = showPoints_;
    Select(ID_showPoints, (void *)&showPoints);
}

void
PersistentParticlesAttributes::SetIndexVariable(const std::string &indexVariable_)
{
    indexVariable = indexVariable_;
    Select(ID_indexVariable, (void *)&indexVariable);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

int
PersistentParticlesAttributes::GetStartIndex() const
{
    return startIndex;
}

int
PersistentParticlesAttributes::GetStopIndex() const
{
    return stopIndex;
}

int
PersistentParticlesAttributes::GetStride() const
{
    return stride;
}

PersistentParticlesAttributes::PathTypeEnum
PersistentParticlesAttributes::GetStartPathType() const
{
    return PathTypeEnum(startPathType);
}

PersistentParticlesAttributes::PathTypeEnum
PersistentParticlesAttributes::GetStopPathType() const
{
    return PathTypeEnum(stopPathType);
}

const std::string &
PersistentParticlesAttributes::GetTraceVariableX() const
{
    return traceVariableX;
}

std::string &
PersistentParticlesAttributes::GetTraceVariableX()
{
    return traceVariableX;
}

const std::string &
PersistentParticlesAttributes::GetTraceVariableY() const
{
    return traceVariableY;
}

std::string &
PersistentParticlesAttributes::GetTraceVariableY()
{
    return traceVariableY;
}

const std::string &
PersistentParticlesAttributes::GetTraceVariableZ() const
{
    return traceVariableZ;
}

std::string &
PersistentParticlesAttributes::GetTraceVariableZ()
{
    return traceVariableZ;
}

bool
PersistentParticlesAttributes::GetConnectParticles() const
{
    return connectParticles;
}

bool
PersistentParticlesAttributes::GetShowPoints() const
{
    return showPoints;
}

const std::string &
PersistentParticlesAttributes::GetIndexVariable() const
{
    return indexVariable;
}

std::string &
PersistentParticlesAttributes::GetIndexVariable()
{
    return indexVariable;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
PersistentParticlesAttributes::SelectTraceVariableX()
{
    Select(ID_traceVariableX, (void *)&traceVariableX);
}

void
PersistentParticlesAttributes::SelectTraceVariableY()
{
    Select(ID_traceVariableY, (void *)&traceVariableY);
}

void
PersistentParticlesAttributes::SelectTraceVariableZ()
{
    Select(ID_traceVariableZ, (void *)&traceVariableZ);
}

void
PersistentParticlesAttributes::SelectIndexVariable()
{
    Select(ID_indexVariable, (void *)&indexVariable);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: PersistentParticlesAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
PersistentParticlesAttributes::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_startIndex:       return "startIndex";
    case ID_stopIndex:        return "stopIndex";
    case ID_stride:           return "stride";
    case ID_startPathType:    return "startPathType";
    case ID_stopPathType:     return "stopPathType";
    case ID_traceVariableX:   return "traceVariableX";
    case ID_traceVariableY:   return "traceVariableY";
    case ID_traceVariableZ:   return "traceVariableZ";
    case ID_connectParticles: return "connectParticles";
    case ID_showPoints:       return "showPoints";
    case ID_indexVariable:    return "indexVariable";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: PersistentParticlesAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
PersistentParticlesAttributes::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_startIndex:       return FieldType_int;
    case ID_stopIndex:        return FieldType_int;
    case ID_stride:           return FieldType_int;
    case ID_startPathType:    return FieldType_enum;
    case ID_stopPathType:     return FieldType_enum;
    case ID_traceVariableX:   return FieldType_variablename;
    case ID_traceVariableY:   return FieldType_variablename;
    case ID_traceVariableZ:   return FieldType_variablename;
    case ID_connectParticles: return FieldType_bool;
    case ID_showPoints:       return FieldType_bool;
    case ID_indexVariable:    return FieldType_variablename;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: PersistentParticlesAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
PersistentParticlesAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_startIndex:       return "int";
    case ID_stopIndex:        return "int";
    case ID_stride:           return "int";
    case ID_startPathType:    return "enum";
    case ID_stopPathType:     return "enum";
    case ID_traceVariableX:   return "variablename";
    case ID_traceVariableY:   return "variablename";
    case ID_traceVariableZ:   return "variablename";
    case ID_connectParticles: return "bool";
    case ID_showPoints:       return "bool";
    case ID_indexVariable:    return "variablename";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: PersistentParticlesAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
PersistentParticlesAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const PersistentParticlesAttributes &obj = *((const PersistentParticlesAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_startIndex:
        {  // new scope
        retval = (startIndex == obj.startIndex);
        }
        break;
    case ID_stopIndex:
        {  // new scope
        retval = (stopIndex == obj.stopIndex);
        }
        break;
    case ID_stride:
        {  // new scope
        retval = (stride == obj.stride);
        }
        break;
    case ID_startPathType:
        {  // new scope
        retval = (startPathType == obj.startPathType);
        }
        break;
    case ID_stopPathType:
        {  // new scope
        retval = (stopPathType == obj.stopPathType);
        }
        break;
    case ID_traceVariableX:
        {  // new scope
        retval = (traceVariableX == obj.traceVariableX);
        }
        break;
    case ID_traceVariableY:
        {  // new scope
        retval = (traceVariableY == obj.traceVariableY);
        }
        break;
    case ID_traceVariableZ:
        {  // new scope
        retval = (traceVariableZ == obj.traceVariableZ);
        }
        break;
    case ID_connectParticles:
        {  // new scope
        retval = (connectParticles == obj.connectParticles);
        }
        break;
    case ID_showPoints:
        {  // new scope
        retval = (showPoints == obj.showPoints);
        }
        break;
    case ID_indexVariable:
        {  // new scope
        retval = (indexVariable == obj.indexVariable);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

