/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyLineSamplerAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>

// ****************************************************************************
// Module: PyLineSamplerAttributes
//
// Purpose: 
//   This class contains attributes for the line sampler operator.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a LineSamplerAttributes.
//
struct LineSamplerAttributesObject
{
    PyObject_HEAD
    LineSamplerAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewLineSamplerAttributes(int);

std::string
PyLineSamplerAttributes_ToString(const LineSamplerAttributes *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    const char *meshGeometry_names = "Cartesian, Cylindrical, Toroidal";
    switch (atts->GetMeshGeometry())
    {
      case LineSamplerAttributes::Cartesian:
          SNPRINTF(tmpStr, 1000, "%smeshGeometry = %sCartesian  # %s\n", prefix, prefix, meshGeometry_names);
          str += tmpStr;
          break;
      case LineSamplerAttributes::Cylindrical:
          SNPRINTF(tmpStr, 1000, "%smeshGeometry = %sCylindrical  # %s\n", prefix, prefix, meshGeometry_names);
          str += tmpStr;
          break;
      case LineSamplerAttributes::Toroidal:
          SNPRINTF(tmpStr, 1000, "%smeshGeometry = %sToroidal  # %s\n", prefix, prefix, meshGeometry_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    const char *arrayConfiguration_names = "Geometry, Manual";
    switch (atts->GetArrayConfiguration())
    {
      case LineSamplerAttributes::Geometry:
          SNPRINTF(tmpStr, 1000, "%sarrayConfiguration = %sGeometry  # %s\n", prefix, prefix, arrayConfiguration_names);
          str += tmpStr;
          break;
      case LineSamplerAttributes::Manual:
          SNPRINTF(tmpStr, 1000, "%sarrayConfiguration = %sManual  # %s\n", prefix, prefix, arrayConfiguration_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    const char *boundary_names = "Data, Wall";
    switch (atts->GetBoundary())
    {
      case LineSamplerAttributes::Data:
          SNPRINTF(tmpStr, 1000, "%sboundary = %sData  # %s\n", prefix, prefix, boundary_names);
          str += tmpStr;
          break;
      case LineSamplerAttributes::Wall:
          SNPRINTF(tmpStr, 1000, "%sboundary = %sWall  # %s\n", prefix, prefix, boundary_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    SNPRINTF(tmpStr, 1000, "%sinstanceId = %d\n", prefix, atts->GetInstanceId());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%snArrays = %d\n", prefix, atts->GetNArrays());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%storoidalArrayAngle = %g\n", prefix, atts->GetToroidalArrayAngle());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%snChannels = %d\n", prefix, atts->GetNChannels());
    str += tmpStr;
    const char *channelProjection_names = "Divergent, Parallel, Grid";
    switch (atts->GetChannelProjection())
    {
      case LineSamplerAttributes::Divergent:
          SNPRINTF(tmpStr, 1000, "%schannelProjection = %sDivergent  # %s\n", prefix, prefix, channelProjection_names);
          str += tmpStr;
          break;
      case LineSamplerAttributes::Parallel:
          SNPRINTF(tmpStr, 1000, "%schannelProjection = %sParallel  # %s\n", prefix, prefix, channelProjection_names);
          str += tmpStr;
          break;
      case LineSamplerAttributes::Grid:
          SNPRINTF(tmpStr, 1000, "%schannelProjection = %sGrid  # %s\n", prefix, prefix, channelProjection_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    const char *channelLayoutType_names = "ChannelAbsolute, ChannelRelative";
    switch (atts->GetChannelLayoutType())
    {
      case LineSamplerAttributes::ChannelAbsolute:
          SNPRINTF(tmpStr, 1000, "%schannelLayoutType = %sChannelAbsolute  # %s\n", prefix, prefix, channelLayoutType_names);
          str += tmpStr;
          break;
      case LineSamplerAttributes::ChannelRelative:
          SNPRINTF(tmpStr, 1000, "%schannelLayoutType = %sChannelRelative  # %s\n", prefix, prefix, channelLayoutType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    SNPRINTF(tmpStr, 1000, "%schannelOffset = %g\n", prefix, atts->GetChannelOffset());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%schannelAngle = %g\n", prefix, atts->GetChannelAngle());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%snRows = %d\n", prefix, atts->GetNRows());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%srowOffset = %g\n", prefix, atts->GetRowOffset());
    str += tmpStr;
    {   const double *arrayOrigin = atts->GetArrayOrigin();
        SNPRINTF(tmpStr, 1000, "%sarrayOrigin = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", arrayOrigin[i]);
            str += tmpStr;
            if(i < 2)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    const char *arrayAxis_names = "R, Z";
    switch (atts->GetArrayAxis())
    {
      case LineSamplerAttributes::R:
          SNPRINTF(tmpStr, 1000, "%sarrayAxis = %sR  # %s\n", prefix, prefix, arrayAxis_names);
          str += tmpStr;
          break;
      case LineSamplerAttributes::Z:
          SNPRINTF(tmpStr, 1000, "%sarrayAxis = %sZ  # %s\n", prefix, prefix, arrayAxis_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    SNPRINTF(tmpStr, 1000, "%spoloidalAngleStart = %g\n", prefix, atts->GetPoloidalAngleStart());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%spoloidalAngleStop = %g\n", prefix, atts->GetPoloidalAngleStop());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%spoloialAngle = %g\n", prefix, atts->GetPoloialAngle());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%spoloialRTilt = %g\n", prefix, atts->GetPoloialRTilt());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%spoloialZTilt = %g\n", prefix, atts->GetPoloialZTilt());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%storoidalAngle = %g\n", prefix, atts->GetToroidalAngle());
    str += tmpStr;
    if(atts->GetFlipToroidalAngle())
        SNPRINTF(tmpStr, 1000, "%sflipToroidalAngle = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sflipToroidalAngle = 0\n", prefix);
    str += tmpStr;
    const char *viewGeometry_names = "Points, Lines, Surfaces";
    switch (atts->GetViewGeometry())
    {
      case LineSamplerAttributes::Points:
          SNPRINTF(tmpStr, 1000, "%sviewGeometry = %sPoints  # %s\n", prefix, prefix, viewGeometry_names);
          str += tmpStr;
          break;
      case LineSamplerAttributes::Lines:
          SNPRINTF(tmpStr, 1000, "%sviewGeometry = %sLines  # %s\n", prefix, prefix, viewGeometry_names);
          str += tmpStr;
          break;
      case LineSamplerAttributes::Surfaces:
          SNPRINTF(tmpStr, 1000, "%sviewGeometry = %sSurfaces  # %s\n", prefix, prefix, viewGeometry_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    const char *viewDimension_names = "One, Two, Three";
    switch (atts->GetViewDimension())
    {
      case LineSamplerAttributes::One:
          SNPRINTF(tmpStr, 1000, "%sviewDimension = %sOne  # %s\n", prefix, prefix, viewDimension_names);
          str += tmpStr;
          break;
      case LineSamplerAttributes::Two:
          SNPRINTF(tmpStr, 1000, "%sviewDimension = %sTwo  # %s\n", prefix, prefix, viewDimension_names);
          str += tmpStr;
          break;
      case LineSamplerAttributes::Three:
          SNPRINTF(tmpStr, 1000, "%sviewDimension = %sThree  # %s\n", prefix, prefix, viewDimension_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    if(atts->GetDonotApplyToAll())
        SNPRINTF(tmpStr, 1000, "%sdonotApplyToAll = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sdonotApplyToAll = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sheightPlotScale = %g\n", prefix, atts->GetHeightPlotScale());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%schannelPlotOffset = %g\n", prefix, atts->GetChannelPlotOffset());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sarrayPlotOffset = %g\n", prefix, atts->GetArrayPlotOffset());
    str += tmpStr;
    const char *displayTime_names = "Step, Time, Cycle";
    switch (atts->GetDisplayTime())
    {
      case LineSamplerAttributes::Step:
          SNPRINTF(tmpStr, 1000, "%sdisplayTime = %sStep  # %s\n", prefix, prefix, displayTime_names);
          str += tmpStr;
          break;
      case LineSamplerAttributes::Time:
          SNPRINTF(tmpStr, 1000, "%sdisplayTime = %sTime  # %s\n", prefix, prefix, displayTime_names);
          str += tmpStr;
          break;
      case LineSamplerAttributes::Cycle:
          SNPRINTF(tmpStr, 1000, "%sdisplayTime = %sCycle  # %s\n", prefix, prefix, displayTime_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    const char *channelGeometry_names = "Point, Line, Cylinder, Cone";
    switch (atts->GetChannelGeometry())
    {
      case LineSamplerAttributes::Point:
          SNPRINTF(tmpStr, 1000, "%schannelGeometry = %sPoint  # %s\n", prefix, prefix, channelGeometry_names);
          str += tmpStr;
          break;
      case LineSamplerAttributes::Line:
          SNPRINTF(tmpStr, 1000, "%schannelGeometry = %sLine  # %s\n", prefix, prefix, channelGeometry_names);
          str += tmpStr;
          break;
      case LineSamplerAttributes::Cylinder:
          SNPRINTF(tmpStr, 1000, "%schannelGeometry = %sCylinder  # %s\n", prefix, prefix, channelGeometry_names);
          str += tmpStr;
          break;
      case LineSamplerAttributes::Cone:
          SNPRINTF(tmpStr, 1000, "%schannelGeometry = %sCone  # %s\n", prefix, prefix, channelGeometry_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    SNPRINTF(tmpStr, 1000, "%sradius = %g\n", prefix, atts->GetRadius());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sdivergence = %g\n", prefix, atts->GetDivergence());
    str += tmpStr;
    const char *channelProfile_names = "TopHat, Gaussian";
    switch (atts->GetChannelProfile())
    {
      case LineSamplerAttributes::TopHat:
          SNPRINTF(tmpStr, 1000, "%schannelProfile = %sTopHat  # %s\n", prefix, prefix, channelProfile_names);
          str += tmpStr;
          break;
      case LineSamplerAttributes::Gaussian:
          SNPRINTF(tmpStr, 1000, "%schannelProfile = %sGaussian  # %s\n", prefix, prefix, channelProfile_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    SNPRINTF(tmpStr, 1000, "%sstandardDeviation = %g\n", prefix, atts->GetStandardDeviation());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%ssampleDistance = %g\n", prefix, atts->GetSampleDistance());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%ssampleVolume = %g\n", prefix, atts->GetSampleVolume());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%ssampleArc = %g\n", prefix, atts->GetSampleArc());
    str += tmpStr;
    const char *channelIntegration_names = "NoChannelIntegration, IntegrateAlongChannel";
    switch (atts->GetChannelIntegration())
    {
      case LineSamplerAttributes::NoChannelIntegration:
          SNPRINTF(tmpStr, 1000, "%schannelIntegration = %sNoChannelIntegration  # %s\n", prefix, prefix, channelIntegration_names);
          str += tmpStr;
          break;
      case LineSamplerAttributes::IntegrateAlongChannel:
          SNPRINTF(tmpStr, 1000, "%schannelIntegration = %sIntegrateAlongChannel  # %s\n", prefix, prefix, channelIntegration_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    const char *toroidalIntegration_names = "NoToroidalIntegration, ToroidalTimeSample, IntegrateToroidally";
    switch (atts->GetToroidalIntegration())
    {
      case LineSamplerAttributes::NoToroidalIntegration:
          SNPRINTF(tmpStr, 1000, "%storoidalIntegration = %sNoToroidalIntegration  # %s\n", prefix, prefix, toroidalIntegration_names);
          str += tmpStr;
          break;
      case LineSamplerAttributes::ToroidalTimeSample:
          SNPRINTF(tmpStr, 1000, "%storoidalIntegration = %sToroidalTimeSample  # %s\n", prefix, prefix, toroidalIntegration_names);
          str += tmpStr;
          break;
      case LineSamplerAttributes::IntegrateToroidally:
          SNPRINTF(tmpStr, 1000, "%storoidalIntegration = %sIntegrateToroidally  # %s\n", prefix, prefix, toroidalIntegration_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    const char *toroidalAngleSampling_names = "ToroidalAngleAbsoluteSampling, ToroidalAngleRelativeSampling";
    switch (atts->GetToroidalAngleSampling())
    {
      case LineSamplerAttributes::ToroidalAngleAbsoluteSampling:
          SNPRINTF(tmpStr, 1000, "%storoidalAngleSampling = %sToroidalAngleAbsoluteSampling  # %s\n", prefix, prefix, toroidalAngleSampling_names);
          str += tmpStr;
          break;
      case LineSamplerAttributes::ToroidalAngleRelativeSampling:
          SNPRINTF(tmpStr, 1000, "%storoidalAngleSampling = %sToroidalAngleRelativeSampling  # %s\n", prefix, prefix, toroidalAngleSampling_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    SNPRINTF(tmpStr, 1000, "%storoidalAngleStart = %g\n", prefix, atts->GetToroidalAngleStart());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%storoidalAngleStop = %g\n", prefix, atts->GetToroidalAngleStop());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%storoidalAngleStride = %g\n", prefix, atts->GetToroidalAngleStride());
    str += tmpStr;
    const char *timeSampling_names = "CurrentTimeStep, MultipleTimeSteps";
    switch (atts->GetTimeSampling())
    {
      case LineSamplerAttributes::CurrentTimeStep:
          SNPRINTF(tmpStr, 1000, "%stimeSampling = %sCurrentTimeStep  # %s\n", prefix, prefix, timeSampling_names);
          str += tmpStr;
          break;
      case LineSamplerAttributes::MultipleTimeSteps:
          SNPRINTF(tmpStr, 1000, "%stimeSampling = %sMultipleTimeSteps  # %s\n", prefix, prefix, timeSampling_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    SNPRINTF(tmpStr, 1000, "%stimeStepStart = %d\n", prefix, atts->GetTimeStepStart());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%stimeStepStop = %d\n", prefix, atts->GetTimeStepStop());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%stimeStepStride = %d\n", prefix, atts->GetTimeStepStride());
    str += tmpStr;
    {   const doubleVector &channelList = atts->GetChannelList();
        SNPRINTF(tmpStr, 1000, "%schannelList = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < channelList.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", channelList[i]);
            str += tmpStr;
            if(i < channelList.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const doubleVector &wallList = atts->GetWallList();
        SNPRINTF(tmpStr, 1000, "%swallList = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < wallList.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", wallList[i]);
            str += tmpStr;
            if(i < wallList.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    SNPRINTF(tmpStr, 1000, "%snChannelListArrays = %d\n", prefix, atts->GetNChannelListArrays());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%schannelListToroidalArrayAngle = %g\n", prefix, atts->GetChannelListToroidalArrayAngle());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%schannelListToroidalAngle = %g\n", prefix, atts->GetChannelListToroidalAngle());
    str += tmpStr;
    return str;
}

static PyObject *
LineSamplerAttributes_Notify(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LineSamplerAttributes_SetMeshGeometry(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the meshGeometry in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetMeshGeometry(LineSamplerAttributes::MeshGeometry(ival));
    else
    {
        fprintf(stderr, "An invalid meshGeometry value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Cartesian, Cylindrical, Toroidal.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LineSamplerAttributes_GetMeshGeometry(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetMeshGeometry()));
    return retval;
}

/*static*/ PyObject *
LineSamplerAttributes_SetArrayConfiguration(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the arrayConfiguration in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetArrayConfiguration(LineSamplerAttributes::ArrayConfiguration(ival));
    else
    {
        fprintf(stderr, "An invalid arrayConfiguration value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "Geometry, Manual.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LineSamplerAttributes_GetArrayConfiguration(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetArrayConfiguration()));
    return retval;
}

/*static*/ PyObject *
LineSamplerAttributes_SetBoundary(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the boundary in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetBoundary(LineSamplerAttributes::Boundary(ival));
    else
    {
        fprintf(stderr, "An invalid boundary value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "Data, Wall.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LineSamplerAttributes_GetBoundary(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetBoundary()));
    return retval;
}

/*static*/ PyObject *
LineSamplerAttributes_SetInstanceId(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the instanceId in the object.
    obj->data->SetInstanceId((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LineSamplerAttributes_GetInstanceId(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetInstanceId()));
    return retval;
}

/*static*/ PyObject *
LineSamplerAttributes_SetNArrays(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the nArrays in the object.
    obj->data->SetNArrays((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LineSamplerAttributes_GetNArrays(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetNArrays()));
    return retval;
}

/*static*/ PyObject *
LineSamplerAttributes_SetToroidalArrayAngle(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the toroidalArrayAngle in the object.
    obj->data->SetToroidalArrayAngle(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LineSamplerAttributes_GetToroidalArrayAngle(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetToroidalArrayAngle());
    return retval;
}

/*static*/ PyObject *
LineSamplerAttributes_SetNChannels(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the nChannels in the object.
    obj->data->SetNChannels((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LineSamplerAttributes_GetNChannels(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetNChannels()));
    return retval;
}

/*static*/ PyObject *
LineSamplerAttributes_SetChannelProjection(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the channelProjection in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetChannelProjection(LineSamplerAttributes::ChannelProjection(ival));
    else
    {
        fprintf(stderr, "An invalid channelProjection value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Divergent, Parallel, Grid.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LineSamplerAttributes_GetChannelProjection(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetChannelProjection()));
    return retval;
}

/*static*/ PyObject *
LineSamplerAttributes_SetChannelLayoutType(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the channelLayoutType in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetChannelLayoutType(LineSamplerAttributes::ChannelLayoutType(ival));
    else
    {
        fprintf(stderr, "An invalid channelLayoutType value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "ChannelAbsolute, ChannelRelative.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LineSamplerAttributes_GetChannelLayoutType(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetChannelLayoutType()));
    return retval;
}

/*static*/ PyObject *
LineSamplerAttributes_SetChannelOffset(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the channelOffset in the object.
    obj->data->SetChannelOffset(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LineSamplerAttributes_GetChannelOffset(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetChannelOffset());
    return retval;
}

/*static*/ PyObject *
LineSamplerAttributes_SetChannelAngle(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the channelAngle in the object.
    obj->data->SetChannelAngle(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LineSamplerAttributes_GetChannelAngle(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetChannelAngle());
    return retval;
}

/*static*/ PyObject *
LineSamplerAttributes_SetNRows(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the nRows in the object.
    obj->data->SetNRows((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LineSamplerAttributes_GetNRows(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetNRows()));
    return retval;
}

/*static*/ PyObject *
LineSamplerAttributes_SetRowOffset(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the rowOffset in the object.
    obj->data->SetRowOffset(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LineSamplerAttributes_GetRowOffset(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetRowOffset());
    return retval;
}

/*static*/ PyObject *
LineSamplerAttributes_SetArrayOrigin(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;

    double *dvals = obj->data->GetArrayOrigin();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the arrayOrigin in the object as modified.
    obj->data->SelectArrayOrigin();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LineSamplerAttributes_GetArrayOrigin(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the arrayOrigin.
    PyObject *retval = PyTuple_New(3);
    const double *arrayOrigin = obj->data->GetArrayOrigin();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(arrayOrigin[i]));
    return retval;
}

/*static*/ PyObject *
LineSamplerAttributes_SetArrayAxis(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the arrayAxis in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetArrayAxis(LineSamplerAttributes::ArrayAxis(ival));
    else
    {
        fprintf(stderr, "An invalid arrayAxis value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "R, Z.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LineSamplerAttributes_GetArrayAxis(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetArrayAxis()));
    return retval;
}

/*static*/ PyObject *
LineSamplerAttributes_SetPoloidalAngleStart(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the poloidalAngleStart in the object.
    obj->data->SetPoloidalAngleStart(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LineSamplerAttributes_GetPoloidalAngleStart(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetPoloidalAngleStart());
    return retval;
}

/*static*/ PyObject *
LineSamplerAttributes_SetPoloidalAngleStop(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the poloidalAngleStop in the object.
    obj->data->SetPoloidalAngleStop(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LineSamplerAttributes_GetPoloidalAngleStop(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetPoloidalAngleStop());
    return retval;
}

/*static*/ PyObject *
LineSamplerAttributes_SetPoloialAngle(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the poloialAngle in the object.
    obj->data->SetPoloialAngle(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LineSamplerAttributes_GetPoloialAngle(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetPoloialAngle());
    return retval;
}

/*static*/ PyObject *
LineSamplerAttributes_SetPoloialRTilt(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the poloialRTilt in the object.
    obj->data->SetPoloialRTilt(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LineSamplerAttributes_GetPoloialRTilt(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetPoloialRTilt());
    return retval;
}

/*static*/ PyObject *
LineSamplerAttributes_SetPoloialZTilt(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the poloialZTilt in the object.
    obj->data->SetPoloialZTilt(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LineSamplerAttributes_GetPoloialZTilt(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetPoloialZTilt());
    return retval;
}

/*static*/ PyObject *
LineSamplerAttributes_SetToroidalAngle(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the toroidalAngle in the object.
    obj->data->SetToroidalAngle(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LineSamplerAttributes_GetToroidalAngle(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetToroidalAngle());
    return retval;
}

/*static*/ PyObject *
LineSamplerAttributes_SetFlipToroidalAngle(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the flipToroidalAngle in the object.
    obj->data->SetFlipToroidalAngle(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LineSamplerAttributes_GetFlipToroidalAngle(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetFlipToroidalAngle()?1L:0L);
    return retval;
}

/*static*/ PyObject *
LineSamplerAttributes_SetViewGeometry(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the viewGeometry in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetViewGeometry(LineSamplerAttributes::ViewGeometry(ival));
    else
    {
        fprintf(stderr, "An invalid viewGeometry value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Points, Lines, Surfaces.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LineSamplerAttributes_GetViewGeometry(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetViewGeometry()));
    return retval;
}

/*static*/ PyObject *
LineSamplerAttributes_SetViewDimension(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the viewDimension in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetViewDimension(LineSamplerAttributes::ViewDimension(ival));
    else
    {
        fprintf(stderr, "An invalid viewDimension value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "One, Two, Three.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LineSamplerAttributes_GetViewDimension(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetViewDimension()));
    return retval;
}

/*static*/ PyObject *
LineSamplerAttributes_SetDonotApplyToAll(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the donotApplyToAll in the object.
    obj->data->SetDonotApplyToAll(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LineSamplerAttributes_GetDonotApplyToAll(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetDonotApplyToAll()?1L:0L);
    return retval;
}

/*static*/ PyObject *
LineSamplerAttributes_SetHeightPlotScale(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the heightPlotScale in the object.
    obj->data->SetHeightPlotScale(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LineSamplerAttributes_GetHeightPlotScale(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetHeightPlotScale());
    return retval;
}

/*static*/ PyObject *
LineSamplerAttributes_SetChannelPlotOffset(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the channelPlotOffset in the object.
    obj->data->SetChannelPlotOffset(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LineSamplerAttributes_GetChannelPlotOffset(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetChannelPlotOffset());
    return retval;
}

/*static*/ PyObject *
LineSamplerAttributes_SetArrayPlotOffset(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the arrayPlotOffset in the object.
    obj->data->SetArrayPlotOffset(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LineSamplerAttributes_GetArrayPlotOffset(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetArrayPlotOffset());
    return retval;
}

/*static*/ PyObject *
LineSamplerAttributes_SetDisplayTime(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the displayTime in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetDisplayTime(LineSamplerAttributes::DisplayTime(ival));
    else
    {
        fprintf(stderr, "An invalid displayTime value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Step, Time, Cycle.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LineSamplerAttributes_GetDisplayTime(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetDisplayTime()));
    return retval;
}

/*static*/ PyObject *
LineSamplerAttributes_SetChannelGeometry(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the channelGeometry in the object.
    if(ival >= 0 && ival < 4)
        obj->data->SetChannelGeometry(LineSamplerAttributes::ChannelGeometry(ival));
    else
    {
        fprintf(stderr, "An invalid channelGeometry value was given. "
                        "Valid values are in the range of [0,3]. "
                        "You can also use the following names: "
                        "Point, Line, Cylinder, Cone.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LineSamplerAttributes_GetChannelGeometry(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetChannelGeometry()));
    return retval;
}

/*static*/ PyObject *
LineSamplerAttributes_SetRadius(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the radius in the object.
    obj->data->SetRadius(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LineSamplerAttributes_GetRadius(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetRadius());
    return retval;
}

/*static*/ PyObject *
LineSamplerAttributes_SetDivergence(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the divergence in the object.
    obj->data->SetDivergence(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LineSamplerAttributes_GetDivergence(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetDivergence());
    return retval;
}

/*static*/ PyObject *
LineSamplerAttributes_SetChannelProfile(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the channelProfile in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetChannelProfile(LineSamplerAttributes::ChannelProfile(ival));
    else
    {
        fprintf(stderr, "An invalid channelProfile value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "TopHat, Gaussian.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LineSamplerAttributes_GetChannelProfile(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetChannelProfile()));
    return retval;
}

/*static*/ PyObject *
LineSamplerAttributes_SetStandardDeviation(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the standardDeviation in the object.
    obj->data->SetStandardDeviation(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LineSamplerAttributes_GetStandardDeviation(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetStandardDeviation());
    return retval;
}

/*static*/ PyObject *
LineSamplerAttributes_SetSampleDistance(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the sampleDistance in the object.
    obj->data->SetSampleDistance(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LineSamplerAttributes_GetSampleDistance(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetSampleDistance());
    return retval;
}

/*static*/ PyObject *
LineSamplerAttributes_SetSampleVolume(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the sampleVolume in the object.
    obj->data->SetSampleVolume(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LineSamplerAttributes_GetSampleVolume(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetSampleVolume());
    return retval;
}

/*static*/ PyObject *
LineSamplerAttributes_SetSampleArc(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the sampleArc in the object.
    obj->data->SetSampleArc(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LineSamplerAttributes_GetSampleArc(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetSampleArc());
    return retval;
}

/*static*/ PyObject *
LineSamplerAttributes_SetChannelIntegration(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the channelIntegration in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetChannelIntegration(LineSamplerAttributes::ChannelIntegration(ival));
    else
    {
        fprintf(stderr, "An invalid channelIntegration value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "NoChannelIntegration, IntegrateAlongChannel.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LineSamplerAttributes_GetChannelIntegration(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetChannelIntegration()));
    return retval;
}

/*static*/ PyObject *
LineSamplerAttributes_SetToroidalIntegration(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the toroidalIntegration in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetToroidalIntegration(LineSamplerAttributes::ToroidalIntegration(ival));
    else
    {
        fprintf(stderr, "An invalid toroidalIntegration value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "NoToroidalIntegration, ToroidalTimeSample, IntegrateToroidally.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LineSamplerAttributes_GetToroidalIntegration(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetToroidalIntegration()));
    return retval;
}

/*static*/ PyObject *
LineSamplerAttributes_SetToroidalAngleSampling(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the toroidalAngleSampling in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetToroidalAngleSampling(LineSamplerAttributes::ToroidalAngleSampling(ival));
    else
    {
        fprintf(stderr, "An invalid toroidalAngleSampling value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "ToroidalAngleAbsoluteSampling, ToroidalAngleRelativeSampling.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LineSamplerAttributes_GetToroidalAngleSampling(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetToroidalAngleSampling()));
    return retval;
}

/*static*/ PyObject *
LineSamplerAttributes_SetToroidalAngleStart(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the toroidalAngleStart in the object.
    obj->data->SetToroidalAngleStart(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LineSamplerAttributes_GetToroidalAngleStart(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetToroidalAngleStart());
    return retval;
}

/*static*/ PyObject *
LineSamplerAttributes_SetToroidalAngleStop(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the toroidalAngleStop in the object.
    obj->data->SetToroidalAngleStop(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LineSamplerAttributes_GetToroidalAngleStop(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetToroidalAngleStop());
    return retval;
}

/*static*/ PyObject *
LineSamplerAttributes_SetToroidalAngleStride(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the toroidalAngleStride in the object.
    obj->data->SetToroidalAngleStride(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LineSamplerAttributes_GetToroidalAngleStride(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetToroidalAngleStride());
    return retval;
}

/*static*/ PyObject *
LineSamplerAttributes_SetTimeSampling(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the timeSampling in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetTimeSampling(LineSamplerAttributes::TimeSampling(ival));
    else
    {
        fprintf(stderr, "An invalid timeSampling value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "CurrentTimeStep, MultipleTimeSteps.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LineSamplerAttributes_GetTimeSampling(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetTimeSampling()));
    return retval;
}

/*static*/ PyObject *
LineSamplerAttributes_SetTimeStepStart(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the timeStepStart in the object.
    obj->data->SetTimeStepStart((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LineSamplerAttributes_GetTimeStepStart(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetTimeStepStart()));
    return retval;
}

/*static*/ PyObject *
LineSamplerAttributes_SetTimeStepStop(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the timeStepStop in the object.
    obj->data->SetTimeStepStop((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LineSamplerAttributes_GetTimeStepStop(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetTimeStepStop()));
    return retval;
}

/*static*/ PyObject *
LineSamplerAttributes_SetTimeStepStride(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the timeStepStride in the object.
    obj->data->SetTimeStepStride((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LineSamplerAttributes_GetTimeStepStride(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetTimeStepStride()));
    return retval;
}

/*static*/ PyObject *
LineSamplerAttributes_SetChannelList(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;

    doubleVector  &vec = obj->data->GetChannelList();
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = PyFloat_AS_DOUBLE(item);
            else if(PyInt_Check(item))
                vec[i] = double(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = PyLong_AsDouble(item);
            else
                vec[i] = 0.;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = PyFloat_AS_DOUBLE(tuple);
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = double(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = PyLong_AsDouble(tuple);
    }
    else
        return NULL;

    // Mark the channelList in the object as modified.
    obj->data->SelectChannelList();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LineSamplerAttributes_GetChannelList(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the channelList.
    const doubleVector &channelList = obj->data->GetChannelList();
    PyObject *retval = PyTuple_New(channelList.size());
    for(size_t i = 0; i < channelList.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(channelList[i]));
    return retval;
}

/*static*/ PyObject *
LineSamplerAttributes_SetWallList(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;

    doubleVector  &vec = obj->data->GetWallList();
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = PyFloat_AS_DOUBLE(item);
            else if(PyInt_Check(item))
                vec[i] = double(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = PyLong_AsDouble(item);
            else
                vec[i] = 0.;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = PyFloat_AS_DOUBLE(tuple);
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = double(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = PyLong_AsDouble(tuple);
    }
    else
        return NULL;

    // Mark the wallList in the object as modified.
    obj->data->SelectWallList();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LineSamplerAttributes_GetWallList(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the wallList.
    const doubleVector &wallList = obj->data->GetWallList();
    PyObject *retval = PyTuple_New(wallList.size());
    for(size_t i = 0; i < wallList.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(wallList[i]));
    return retval;
}

/*static*/ PyObject *
LineSamplerAttributes_SetNChannelListArrays(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the nChannelListArrays in the object.
    obj->data->SetNChannelListArrays((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LineSamplerAttributes_GetNChannelListArrays(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetNChannelListArrays()));
    return retval;
}

/*static*/ PyObject *
LineSamplerAttributes_SetChannelListToroidalArrayAngle(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the channelListToroidalArrayAngle in the object.
    obj->data->SetChannelListToroidalArrayAngle(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LineSamplerAttributes_GetChannelListToroidalArrayAngle(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetChannelListToroidalArrayAngle());
    return retval;
}

/*static*/ PyObject *
LineSamplerAttributes_SetChannelListToroidalAngle(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the channelListToroidalAngle in the object.
    obj->data->SetChannelListToroidalAngle(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LineSamplerAttributes_GetChannelListToroidalAngle(PyObject *self, PyObject *args)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetChannelListToroidalAngle());
    return retval;
}



PyMethodDef PyLineSamplerAttributes_methods[LINESAMPLERATTRIBUTES_NMETH] = {
    {"Notify", LineSamplerAttributes_Notify, METH_VARARGS},
    {"SetMeshGeometry", LineSamplerAttributes_SetMeshGeometry, METH_VARARGS},
    {"GetMeshGeometry", LineSamplerAttributes_GetMeshGeometry, METH_VARARGS},
    {"SetArrayConfiguration", LineSamplerAttributes_SetArrayConfiguration, METH_VARARGS},
    {"GetArrayConfiguration", LineSamplerAttributes_GetArrayConfiguration, METH_VARARGS},
    {"SetBoundary", LineSamplerAttributes_SetBoundary, METH_VARARGS},
    {"GetBoundary", LineSamplerAttributes_GetBoundary, METH_VARARGS},
    {"SetInstanceId", LineSamplerAttributes_SetInstanceId, METH_VARARGS},
    {"GetInstanceId", LineSamplerAttributes_GetInstanceId, METH_VARARGS},
    {"SetNArrays", LineSamplerAttributes_SetNArrays, METH_VARARGS},
    {"GetNArrays", LineSamplerAttributes_GetNArrays, METH_VARARGS},
    {"SetToroidalArrayAngle", LineSamplerAttributes_SetToroidalArrayAngle, METH_VARARGS},
    {"GetToroidalArrayAngle", LineSamplerAttributes_GetToroidalArrayAngle, METH_VARARGS},
    {"SetNChannels", LineSamplerAttributes_SetNChannels, METH_VARARGS},
    {"GetNChannels", LineSamplerAttributes_GetNChannels, METH_VARARGS},
    {"SetChannelProjection", LineSamplerAttributes_SetChannelProjection, METH_VARARGS},
    {"GetChannelProjection", LineSamplerAttributes_GetChannelProjection, METH_VARARGS},
    {"SetChannelLayoutType", LineSamplerAttributes_SetChannelLayoutType, METH_VARARGS},
    {"GetChannelLayoutType", LineSamplerAttributes_GetChannelLayoutType, METH_VARARGS},
    {"SetChannelOffset", LineSamplerAttributes_SetChannelOffset, METH_VARARGS},
    {"GetChannelOffset", LineSamplerAttributes_GetChannelOffset, METH_VARARGS},
    {"SetChannelAngle", LineSamplerAttributes_SetChannelAngle, METH_VARARGS},
    {"GetChannelAngle", LineSamplerAttributes_GetChannelAngle, METH_VARARGS},
    {"SetNRows", LineSamplerAttributes_SetNRows, METH_VARARGS},
    {"GetNRows", LineSamplerAttributes_GetNRows, METH_VARARGS},
    {"SetRowOffset", LineSamplerAttributes_SetRowOffset, METH_VARARGS},
    {"GetRowOffset", LineSamplerAttributes_GetRowOffset, METH_VARARGS},
    {"SetArrayOrigin", LineSamplerAttributes_SetArrayOrigin, METH_VARARGS},
    {"GetArrayOrigin", LineSamplerAttributes_GetArrayOrigin, METH_VARARGS},
    {"SetArrayAxis", LineSamplerAttributes_SetArrayAxis, METH_VARARGS},
    {"GetArrayAxis", LineSamplerAttributes_GetArrayAxis, METH_VARARGS},
    {"SetPoloidalAngleStart", LineSamplerAttributes_SetPoloidalAngleStart, METH_VARARGS},
    {"GetPoloidalAngleStart", LineSamplerAttributes_GetPoloidalAngleStart, METH_VARARGS},
    {"SetPoloidalAngleStop", LineSamplerAttributes_SetPoloidalAngleStop, METH_VARARGS},
    {"GetPoloidalAngleStop", LineSamplerAttributes_GetPoloidalAngleStop, METH_VARARGS},
    {"SetPoloialAngle", LineSamplerAttributes_SetPoloialAngle, METH_VARARGS},
    {"GetPoloialAngle", LineSamplerAttributes_GetPoloialAngle, METH_VARARGS},
    {"SetPoloialRTilt", LineSamplerAttributes_SetPoloialRTilt, METH_VARARGS},
    {"GetPoloialRTilt", LineSamplerAttributes_GetPoloialRTilt, METH_VARARGS},
    {"SetPoloialZTilt", LineSamplerAttributes_SetPoloialZTilt, METH_VARARGS},
    {"GetPoloialZTilt", LineSamplerAttributes_GetPoloialZTilt, METH_VARARGS},
    {"SetToroidalAngle", LineSamplerAttributes_SetToroidalAngle, METH_VARARGS},
    {"GetToroidalAngle", LineSamplerAttributes_GetToroidalAngle, METH_VARARGS},
    {"SetFlipToroidalAngle", LineSamplerAttributes_SetFlipToroidalAngle, METH_VARARGS},
    {"GetFlipToroidalAngle", LineSamplerAttributes_GetFlipToroidalAngle, METH_VARARGS},
    {"SetViewGeometry", LineSamplerAttributes_SetViewGeometry, METH_VARARGS},
    {"GetViewGeometry", LineSamplerAttributes_GetViewGeometry, METH_VARARGS},
    {"SetViewDimension", LineSamplerAttributes_SetViewDimension, METH_VARARGS},
    {"GetViewDimension", LineSamplerAttributes_GetViewDimension, METH_VARARGS},
    {"SetDonotApplyToAll", LineSamplerAttributes_SetDonotApplyToAll, METH_VARARGS},
    {"GetDonotApplyToAll", LineSamplerAttributes_GetDonotApplyToAll, METH_VARARGS},
    {"SetHeightPlotScale", LineSamplerAttributes_SetHeightPlotScale, METH_VARARGS},
    {"GetHeightPlotScale", LineSamplerAttributes_GetHeightPlotScale, METH_VARARGS},
    {"SetChannelPlotOffset", LineSamplerAttributes_SetChannelPlotOffset, METH_VARARGS},
    {"GetChannelPlotOffset", LineSamplerAttributes_GetChannelPlotOffset, METH_VARARGS},
    {"SetArrayPlotOffset", LineSamplerAttributes_SetArrayPlotOffset, METH_VARARGS},
    {"GetArrayPlotOffset", LineSamplerAttributes_GetArrayPlotOffset, METH_VARARGS},
    {"SetDisplayTime", LineSamplerAttributes_SetDisplayTime, METH_VARARGS},
    {"GetDisplayTime", LineSamplerAttributes_GetDisplayTime, METH_VARARGS},
    {"SetChannelGeometry", LineSamplerAttributes_SetChannelGeometry, METH_VARARGS},
    {"GetChannelGeometry", LineSamplerAttributes_GetChannelGeometry, METH_VARARGS},
    {"SetRadius", LineSamplerAttributes_SetRadius, METH_VARARGS},
    {"GetRadius", LineSamplerAttributes_GetRadius, METH_VARARGS},
    {"SetDivergence", LineSamplerAttributes_SetDivergence, METH_VARARGS},
    {"GetDivergence", LineSamplerAttributes_GetDivergence, METH_VARARGS},
    {"SetChannelProfile", LineSamplerAttributes_SetChannelProfile, METH_VARARGS},
    {"GetChannelProfile", LineSamplerAttributes_GetChannelProfile, METH_VARARGS},
    {"SetStandardDeviation", LineSamplerAttributes_SetStandardDeviation, METH_VARARGS},
    {"GetStandardDeviation", LineSamplerAttributes_GetStandardDeviation, METH_VARARGS},
    {"SetSampleDistance", LineSamplerAttributes_SetSampleDistance, METH_VARARGS},
    {"GetSampleDistance", LineSamplerAttributes_GetSampleDistance, METH_VARARGS},
    {"SetSampleVolume", LineSamplerAttributes_SetSampleVolume, METH_VARARGS},
    {"GetSampleVolume", LineSamplerAttributes_GetSampleVolume, METH_VARARGS},
    {"SetSampleArc", LineSamplerAttributes_SetSampleArc, METH_VARARGS},
    {"GetSampleArc", LineSamplerAttributes_GetSampleArc, METH_VARARGS},
    {"SetChannelIntegration", LineSamplerAttributes_SetChannelIntegration, METH_VARARGS},
    {"GetChannelIntegration", LineSamplerAttributes_GetChannelIntegration, METH_VARARGS},
    {"SetToroidalIntegration", LineSamplerAttributes_SetToroidalIntegration, METH_VARARGS},
    {"GetToroidalIntegration", LineSamplerAttributes_GetToroidalIntegration, METH_VARARGS},
    {"SetToroidalAngleSampling", LineSamplerAttributes_SetToroidalAngleSampling, METH_VARARGS},
    {"GetToroidalAngleSampling", LineSamplerAttributes_GetToroidalAngleSampling, METH_VARARGS},
    {"SetToroidalAngleStart", LineSamplerAttributes_SetToroidalAngleStart, METH_VARARGS},
    {"GetToroidalAngleStart", LineSamplerAttributes_GetToroidalAngleStart, METH_VARARGS},
    {"SetToroidalAngleStop", LineSamplerAttributes_SetToroidalAngleStop, METH_VARARGS},
    {"GetToroidalAngleStop", LineSamplerAttributes_GetToroidalAngleStop, METH_VARARGS},
    {"SetToroidalAngleStride", LineSamplerAttributes_SetToroidalAngleStride, METH_VARARGS},
    {"GetToroidalAngleStride", LineSamplerAttributes_GetToroidalAngleStride, METH_VARARGS},
    {"SetTimeSampling", LineSamplerAttributes_SetTimeSampling, METH_VARARGS},
    {"GetTimeSampling", LineSamplerAttributes_GetTimeSampling, METH_VARARGS},
    {"SetTimeStepStart", LineSamplerAttributes_SetTimeStepStart, METH_VARARGS},
    {"GetTimeStepStart", LineSamplerAttributes_GetTimeStepStart, METH_VARARGS},
    {"SetTimeStepStop", LineSamplerAttributes_SetTimeStepStop, METH_VARARGS},
    {"GetTimeStepStop", LineSamplerAttributes_GetTimeStepStop, METH_VARARGS},
    {"SetTimeStepStride", LineSamplerAttributes_SetTimeStepStride, METH_VARARGS},
    {"GetTimeStepStride", LineSamplerAttributes_GetTimeStepStride, METH_VARARGS},
    {"SetChannelList", LineSamplerAttributes_SetChannelList, METH_VARARGS},
    {"GetChannelList", LineSamplerAttributes_GetChannelList, METH_VARARGS},
    {"SetWallList", LineSamplerAttributes_SetWallList, METH_VARARGS},
    {"GetWallList", LineSamplerAttributes_GetWallList, METH_VARARGS},
    {"SetNChannelListArrays", LineSamplerAttributes_SetNChannelListArrays, METH_VARARGS},
    {"GetNChannelListArrays", LineSamplerAttributes_GetNChannelListArrays, METH_VARARGS},
    {"SetChannelListToroidalArrayAngle", LineSamplerAttributes_SetChannelListToroidalArrayAngle, METH_VARARGS},
    {"GetChannelListToroidalArrayAngle", LineSamplerAttributes_GetChannelListToroidalArrayAngle, METH_VARARGS},
    {"SetChannelListToroidalAngle", LineSamplerAttributes_SetChannelListToroidalAngle, METH_VARARGS},
    {"GetChannelListToroidalAngle", LineSamplerAttributes_GetChannelListToroidalAngle, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
LineSamplerAttributes_dealloc(PyObject *v)
{
   LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
LineSamplerAttributes_compare(PyObject *v, PyObject *w)
{
    LineSamplerAttributes *a = ((LineSamplerAttributesObject *)v)->data;
    LineSamplerAttributes *b = ((LineSamplerAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyLineSamplerAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "meshGeometry") == 0)
        return LineSamplerAttributes_GetMeshGeometry(self, NULL);
    if(strcmp(name, "Cartesian") == 0)
        return PyInt_FromLong(long(LineSamplerAttributes::Cartesian));
    if(strcmp(name, "Cylindrical") == 0)
        return PyInt_FromLong(long(LineSamplerAttributes::Cylindrical));
    if(strcmp(name, "Toroidal") == 0)
        return PyInt_FromLong(long(LineSamplerAttributes::Toroidal));

    if(strcmp(name, "arrayConfiguration") == 0)
        return LineSamplerAttributes_GetArrayConfiguration(self, NULL);
    if(strcmp(name, "Geometry") == 0)
        return PyInt_FromLong(long(LineSamplerAttributes::Geometry));
    if(strcmp(name, "Manual") == 0)
        return PyInt_FromLong(long(LineSamplerAttributes::Manual));

    if(strcmp(name, "boundary") == 0)
        return LineSamplerAttributes_GetBoundary(self, NULL);
    if(strcmp(name, "Data") == 0)
        return PyInt_FromLong(long(LineSamplerAttributes::Data));
    if(strcmp(name, "Wall") == 0)
        return PyInt_FromLong(long(LineSamplerAttributes::Wall));

    if(strcmp(name, "instanceId") == 0)
        return LineSamplerAttributes_GetInstanceId(self, NULL);
    if(strcmp(name, "nArrays") == 0)
        return LineSamplerAttributes_GetNArrays(self, NULL);
    if(strcmp(name, "toroidalArrayAngle") == 0)
        return LineSamplerAttributes_GetToroidalArrayAngle(self, NULL);
    if(strcmp(name, "nChannels") == 0)
        return LineSamplerAttributes_GetNChannels(self, NULL);
    if(strcmp(name, "channelProjection") == 0)
        return LineSamplerAttributes_GetChannelProjection(self, NULL);
    if(strcmp(name, "Divergent") == 0)
        return PyInt_FromLong(long(LineSamplerAttributes::Divergent));
    if(strcmp(name, "Parallel") == 0)
        return PyInt_FromLong(long(LineSamplerAttributes::Parallel));
    if(strcmp(name, "Grid") == 0)
        return PyInt_FromLong(long(LineSamplerAttributes::Grid));

    if(strcmp(name, "channelLayoutType") == 0)
        return LineSamplerAttributes_GetChannelLayoutType(self, NULL);
    if(strcmp(name, "ChannelAbsolute") == 0)
        return PyInt_FromLong(long(LineSamplerAttributes::ChannelAbsolute));
    if(strcmp(name, "ChannelRelative") == 0)
        return PyInt_FromLong(long(LineSamplerAttributes::ChannelRelative));

    if(strcmp(name, "channelOffset") == 0)
        return LineSamplerAttributes_GetChannelOffset(self, NULL);
    if(strcmp(name, "channelAngle") == 0)
        return LineSamplerAttributes_GetChannelAngle(self, NULL);
    if(strcmp(name, "nRows") == 0)
        return LineSamplerAttributes_GetNRows(self, NULL);
    if(strcmp(name, "rowOffset") == 0)
        return LineSamplerAttributes_GetRowOffset(self, NULL);
    if(strcmp(name, "arrayOrigin") == 0)
        return LineSamplerAttributes_GetArrayOrigin(self, NULL);
    if(strcmp(name, "arrayAxis") == 0)
        return LineSamplerAttributes_GetArrayAxis(self, NULL);
    if(strcmp(name, "R") == 0)
        return PyInt_FromLong(long(LineSamplerAttributes::R));
    if(strcmp(name, "Z") == 0)
        return PyInt_FromLong(long(LineSamplerAttributes::Z));

    if(strcmp(name, "poloidalAngleStart") == 0)
        return LineSamplerAttributes_GetPoloidalAngleStart(self, NULL);
    if(strcmp(name, "poloidalAngleStop") == 0)
        return LineSamplerAttributes_GetPoloidalAngleStop(self, NULL);
    if(strcmp(name, "poloialAngle") == 0)
        return LineSamplerAttributes_GetPoloialAngle(self, NULL);
    if(strcmp(name, "poloialRTilt") == 0)
        return LineSamplerAttributes_GetPoloialRTilt(self, NULL);
    if(strcmp(name, "poloialZTilt") == 0)
        return LineSamplerAttributes_GetPoloialZTilt(self, NULL);
    if(strcmp(name, "toroidalAngle") == 0)
        return LineSamplerAttributes_GetToroidalAngle(self, NULL);
    if(strcmp(name, "flipToroidalAngle") == 0)
        return LineSamplerAttributes_GetFlipToroidalAngle(self, NULL);
    if(strcmp(name, "viewGeometry") == 0)
        return LineSamplerAttributes_GetViewGeometry(self, NULL);
    if(strcmp(name, "Points") == 0)
        return PyInt_FromLong(long(LineSamplerAttributes::Points));
    if(strcmp(name, "Lines") == 0)
        return PyInt_FromLong(long(LineSamplerAttributes::Lines));
    if(strcmp(name, "Surfaces") == 0)
        return PyInt_FromLong(long(LineSamplerAttributes::Surfaces));

    if(strcmp(name, "viewDimension") == 0)
        return LineSamplerAttributes_GetViewDimension(self, NULL);
    if(strcmp(name, "One") == 0)
        return PyInt_FromLong(long(LineSamplerAttributes::One));
    if(strcmp(name, "Two") == 0)
        return PyInt_FromLong(long(LineSamplerAttributes::Two));
    if(strcmp(name, "Three") == 0)
        return PyInt_FromLong(long(LineSamplerAttributes::Three));

    if(strcmp(name, "donotApplyToAll") == 0)
        return LineSamplerAttributes_GetDonotApplyToAll(self, NULL);
    if(strcmp(name, "heightPlotScale") == 0)
        return LineSamplerAttributes_GetHeightPlotScale(self, NULL);
    if(strcmp(name, "channelPlotOffset") == 0)
        return LineSamplerAttributes_GetChannelPlotOffset(self, NULL);
    if(strcmp(name, "arrayPlotOffset") == 0)
        return LineSamplerAttributes_GetArrayPlotOffset(self, NULL);
    if(strcmp(name, "displayTime") == 0)
        return LineSamplerAttributes_GetDisplayTime(self, NULL);
    if(strcmp(name, "Step") == 0)
        return PyInt_FromLong(long(LineSamplerAttributes::Step));
    if(strcmp(name, "Time") == 0)
        return PyInt_FromLong(long(LineSamplerAttributes::Time));
    if(strcmp(name, "Cycle") == 0)
        return PyInt_FromLong(long(LineSamplerAttributes::Cycle));

    if(strcmp(name, "channelGeometry") == 0)
        return LineSamplerAttributes_GetChannelGeometry(self, NULL);
    if(strcmp(name, "Point") == 0)
        return PyInt_FromLong(long(LineSamplerAttributes::Point));
    if(strcmp(name, "Line") == 0)
        return PyInt_FromLong(long(LineSamplerAttributes::Line));
    if(strcmp(name, "Cylinder") == 0)
        return PyInt_FromLong(long(LineSamplerAttributes::Cylinder));
    if(strcmp(name, "Cone") == 0)
        return PyInt_FromLong(long(LineSamplerAttributes::Cone));

    if(strcmp(name, "radius") == 0)
        return LineSamplerAttributes_GetRadius(self, NULL);
    if(strcmp(name, "divergence") == 0)
        return LineSamplerAttributes_GetDivergence(self, NULL);
    if(strcmp(name, "channelProfile") == 0)
        return LineSamplerAttributes_GetChannelProfile(self, NULL);
    if(strcmp(name, "TopHat") == 0)
        return PyInt_FromLong(long(LineSamplerAttributes::TopHat));
    if(strcmp(name, "Gaussian") == 0)
        return PyInt_FromLong(long(LineSamplerAttributes::Gaussian));

    if(strcmp(name, "standardDeviation") == 0)
        return LineSamplerAttributes_GetStandardDeviation(self, NULL);
    if(strcmp(name, "sampleDistance") == 0)
        return LineSamplerAttributes_GetSampleDistance(self, NULL);
    if(strcmp(name, "sampleVolume") == 0)
        return LineSamplerAttributes_GetSampleVolume(self, NULL);
    if(strcmp(name, "sampleArc") == 0)
        return LineSamplerAttributes_GetSampleArc(self, NULL);
    if(strcmp(name, "channelIntegration") == 0)
        return LineSamplerAttributes_GetChannelIntegration(self, NULL);
    if(strcmp(name, "NoChannelIntegration") == 0)
        return PyInt_FromLong(long(LineSamplerAttributes::NoChannelIntegration));
    if(strcmp(name, "IntegrateAlongChannel") == 0)
        return PyInt_FromLong(long(LineSamplerAttributes::IntegrateAlongChannel));

    if(strcmp(name, "toroidalIntegration") == 0)
        return LineSamplerAttributes_GetToroidalIntegration(self, NULL);
    if(strcmp(name, "NoToroidalIntegration") == 0)
        return PyInt_FromLong(long(LineSamplerAttributes::NoToroidalIntegration));
    if(strcmp(name, "ToroidalTimeSample") == 0)
        return PyInt_FromLong(long(LineSamplerAttributes::ToroidalTimeSample));
    if(strcmp(name, "IntegrateToroidally") == 0)
        return PyInt_FromLong(long(LineSamplerAttributes::IntegrateToroidally));

    if(strcmp(name, "toroidalAngleSampling") == 0)
        return LineSamplerAttributes_GetToroidalAngleSampling(self, NULL);
    if(strcmp(name, "ToroidalAngleAbsoluteSampling") == 0)
        return PyInt_FromLong(long(LineSamplerAttributes::ToroidalAngleAbsoluteSampling));
    if(strcmp(name, "ToroidalAngleRelativeSampling") == 0)
        return PyInt_FromLong(long(LineSamplerAttributes::ToroidalAngleRelativeSampling));

    if(strcmp(name, "toroidalAngleStart") == 0)
        return LineSamplerAttributes_GetToroidalAngleStart(self, NULL);
    if(strcmp(name, "toroidalAngleStop") == 0)
        return LineSamplerAttributes_GetToroidalAngleStop(self, NULL);
    if(strcmp(name, "toroidalAngleStride") == 0)
        return LineSamplerAttributes_GetToroidalAngleStride(self, NULL);
    if(strcmp(name, "timeSampling") == 0)
        return LineSamplerAttributes_GetTimeSampling(self, NULL);
    if(strcmp(name, "CurrentTimeStep") == 0)
        return PyInt_FromLong(long(LineSamplerAttributes::CurrentTimeStep));
    if(strcmp(name, "MultipleTimeSteps") == 0)
        return PyInt_FromLong(long(LineSamplerAttributes::MultipleTimeSteps));

    if(strcmp(name, "timeStepStart") == 0)
        return LineSamplerAttributes_GetTimeStepStart(self, NULL);
    if(strcmp(name, "timeStepStop") == 0)
        return LineSamplerAttributes_GetTimeStepStop(self, NULL);
    if(strcmp(name, "timeStepStride") == 0)
        return LineSamplerAttributes_GetTimeStepStride(self, NULL);
    if(strcmp(name, "channelList") == 0)
        return LineSamplerAttributes_GetChannelList(self, NULL);
    if(strcmp(name, "wallList") == 0)
        return LineSamplerAttributes_GetWallList(self, NULL);
    if(strcmp(name, "nChannelListArrays") == 0)
        return LineSamplerAttributes_GetNChannelListArrays(self, NULL);
    if(strcmp(name, "channelListToroidalArrayAngle") == 0)
        return LineSamplerAttributes_GetChannelListToroidalArrayAngle(self, NULL);
    if(strcmp(name, "channelListToroidalAngle") == 0)
        return LineSamplerAttributes_GetChannelListToroidalAngle(self, NULL);

    return Py_FindMethod(PyLineSamplerAttributes_methods, self, name);
}

int
PyLineSamplerAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "meshGeometry") == 0)
        obj = LineSamplerAttributes_SetMeshGeometry(self, tuple);
    else if(strcmp(name, "arrayConfiguration") == 0)
        obj = LineSamplerAttributes_SetArrayConfiguration(self, tuple);
    else if(strcmp(name, "boundary") == 0)
        obj = LineSamplerAttributes_SetBoundary(self, tuple);
    else if(strcmp(name, "instanceId") == 0)
        obj = LineSamplerAttributes_SetInstanceId(self, tuple);
    else if(strcmp(name, "nArrays") == 0)
        obj = LineSamplerAttributes_SetNArrays(self, tuple);
    else if(strcmp(name, "toroidalArrayAngle") == 0)
        obj = LineSamplerAttributes_SetToroidalArrayAngle(self, tuple);
    else if(strcmp(name, "nChannels") == 0)
        obj = LineSamplerAttributes_SetNChannels(self, tuple);
    else if(strcmp(name, "channelProjection") == 0)
        obj = LineSamplerAttributes_SetChannelProjection(self, tuple);
    else if(strcmp(name, "channelLayoutType") == 0)
        obj = LineSamplerAttributes_SetChannelLayoutType(self, tuple);
    else if(strcmp(name, "channelOffset") == 0)
        obj = LineSamplerAttributes_SetChannelOffset(self, tuple);
    else if(strcmp(name, "channelAngle") == 0)
        obj = LineSamplerAttributes_SetChannelAngle(self, tuple);
    else if(strcmp(name, "nRows") == 0)
        obj = LineSamplerAttributes_SetNRows(self, tuple);
    else if(strcmp(name, "rowOffset") == 0)
        obj = LineSamplerAttributes_SetRowOffset(self, tuple);
    else if(strcmp(name, "arrayOrigin") == 0)
        obj = LineSamplerAttributes_SetArrayOrigin(self, tuple);
    else if(strcmp(name, "arrayAxis") == 0)
        obj = LineSamplerAttributes_SetArrayAxis(self, tuple);
    else if(strcmp(name, "poloidalAngleStart") == 0)
        obj = LineSamplerAttributes_SetPoloidalAngleStart(self, tuple);
    else if(strcmp(name, "poloidalAngleStop") == 0)
        obj = LineSamplerAttributes_SetPoloidalAngleStop(self, tuple);
    else if(strcmp(name, "poloialAngle") == 0)
        obj = LineSamplerAttributes_SetPoloialAngle(self, tuple);
    else if(strcmp(name, "poloialRTilt") == 0)
        obj = LineSamplerAttributes_SetPoloialRTilt(self, tuple);
    else if(strcmp(name, "poloialZTilt") == 0)
        obj = LineSamplerAttributes_SetPoloialZTilt(self, tuple);
    else if(strcmp(name, "toroidalAngle") == 0)
        obj = LineSamplerAttributes_SetToroidalAngle(self, tuple);
    else if(strcmp(name, "flipToroidalAngle") == 0)
        obj = LineSamplerAttributes_SetFlipToroidalAngle(self, tuple);
    else if(strcmp(name, "viewGeometry") == 0)
        obj = LineSamplerAttributes_SetViewGeometry(self, tuple);
    else if(strcmp(name, "viewDimension") == 0)
        obj = LineSamplerAttributes_SetViewDimension(self, tuple);
    else if(strcmp(name, "donotApplyToAll") == 0)
        obj = LineSamplerAttributes_SetDonotApplyToAll(self, tuple);
    else if(strcmp(name, "heightPlotScale") == 0)
        obj = LineSamplerAttributes_SetHeightPlotScale(self, tuple);
    else if(strcmp(name, "channelPlotOffset") == 0)
        obj = LineSamplerAttributes_SetChannelPlotOffset(self, tuple);
    else if(strcmp(name, "arrayPlotOffset") == 0)
        obj = LineSamplerAttributes_SetArrayPlotOffset(self, tuple);
    else if(strcmp(name, "displayTime") == 0)
        obj = LineSamplerAttributes_SetDisplayTime(self, tuple);
    else if(strcmp(name, "channelGeometry") == 0)
        obj = LineSamplerAttributes_SetChannelGeometry(self, tuple);
    else if(strcmp(name, "radius") == 0)
        obj = LineSamplerAttributes_SetRadius(self, tuple);
    else if(strcmp(name, "divergence") == 0)
        obj = LineSamplerAttributes_SetDivergence(self, tuple);
    else if(strcmp(name, "channelProfile") == 0)
        obj = LineSamplerAttributes_SetChannelProfile(self, tuple);
    else if(strcmp(name, "standardDeviation") == 0)
        obj = LineSamplerAttributes_SetStandardDeviation(self, tuple);
    else if(strcmp(name, "sampleDistance") == 0)
        obj = LineSamplerAttributes_SetSampleDistance(self, tuple);
    else if(strcmp(name, "sampleVolume") == 0)
        obj = LineSamplerAttributes_SetSampleVolume(self, tuple);
    else if(strcmp(name, "sampleArc") == 0)
        obj = LineSamplerAttributes_SetSampleArc(self, tuple);
    else if(strcmp(name, "channelIntegration") == 0)
        obj = LineSamplerAttributes_SetChannelIntegration(self, tuple);
    else if(strcmp(name, "toroidalIntegration") == 0)
        obj = LineSamplerAttributes_SetToroidalIntegration(self, tuple);
    else if(strcmp(name, "toroidalAngleSampling") == 0)
        obj = LineSamplerAttributes_SetToroidalAngleSampling(self, tuple);
    else if(strcmp(name, "toroidalAngleStart") == 0)
        obj = LineSamplerAttributes_SetToroidalAngleStart(self, tuple);
    else if(strcmp(name, "toroidalAngleStop") == 0)
        obj = LineSamplerAttributes_SetToroidalAngleStop(self, tuple);
    else if(strcmp(name, "toroidalAngleStride") == 0)
        obj = LineSamplerAttributes_SetToroidalAngleStride(self, tuple);
    else if(strcmp(name, "timeSampling") == 0)
        obj = LineSamplerAttributes_SetTimeSampling(self, tuple);
    else if(strcmp(name, "timeStepStart") == 0)
        obj = LineSamplerAttributes_SetTimeStepStart(self, tuple);
    else if(strcmp(name, "timeStepStop") == 0)
        obj = LineSamplerAttributes_SetTimeStepStop(self, tuple);
    else if(strcmp(name, "timeStepStride") == 0)
        obj = LineSamplerAttributes_SetTimeStepStride(self, tuple);
    else if(strcmp(name, "channelList") == 0)
        obj = LineSamplerAttributes_SetChannelList(self, tuple);
    else if(strcmp(name, "wallList") == 0)
        obj = LineSamplerAttributes_SetWallList(self, tuple);
    else if(strcmp(name, "nChannelListArrays") == 0)
        obj = LineSamplerAttributes_SetNChannelListArrays(self, tuple);
    else if(strcmp(name, "channelListToroidalArrayAngle") == 0)
        obj = LineSamplerAttributes_SetChannelListToroidalArrayAngle(self, tuple);
    else if(strcmp(name, "channelListToroidalAngle") == 0)
        obj = LineSamplerAttributes_SetChannelListToroidalAngle(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
LineSamplerAttributes_print(PyObject *v, FILE *fp, int flags)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)v;
    fprintf(fp, "%s", PyLineSamplerAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
LineSamplerAttributes_str(PyObject *v)
{
    LineSamplerAttributesObject *obj = (LineSamplerAttributesObject *)v;
    return PyString_FromString(PyLineSamplerAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *LineSamplerAttributes_Purpose = "This class contains attributes for the line sampler operator.";
#else
static char *LineSamplerAttributes_Purpose = "This class contains attributes for the line sampler operator.";
#endif

//
// The type description structure
//
static PyTypeObject LineSamplerAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "LineSamplerAttributes",                    // tp_name
    sizeof(LineSamplerAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)LineSamplerAttributes_dealloc,  // tp_dealloc
    (printfunc)LineSamplerAttributes_print,     // tp_print
    (getattrfunc)PyLineSamplerAttributes_getattr, // tp_getattr
    (setattrfunc)PyLineSamplerAttributes_setattr, // tp_setattr
    (cmpfunc)LineSamplerAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)LineSamplerAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    LineSamplerAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static LineSamplerAttributes *defaultAtts = 0;
static LineSamplerAttributes *currentAtts = 0;

static PyObject *
NewLineSamplerAttributes(int useCurrent)
{
    LineSamplerAttributesObject *newObject;
    newObject = PyObject_NEW(LineSamplerAttributesObject, &LineSamplerAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new LineSamplerAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new LineSamplerAttributes(*defaultAtts);
    else
        newObject->data = new LineSamplerAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapLineSamplerAttributes(const LineSamplerAttributes *attr)
{
    LineSamplerAttributesObject *newObject;
    newObject = PyObject_NEW(LineSamplerAttributesObject, &LineSamplerAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (LineSamplerAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
LineSamplerAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewLineSamplerAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef LineSamplerAttributesMethods[] = {
    {"LineSamplerAttributes", LineSamplerAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *LineSamplerAttributesObserver = 0;

std::string
PyLineSamplerAttributes_GetLogString()
{
    std::string s("LineSamplerAtts = LineSamplerAttributes()\n");
    if(currentAtts != 0)
        s += PyLineSamplerAttributes_ToString(currentAtts, "LineSamplerAtts.");
    return s;
}

static void
PyLineSamplerAttributes_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("LineSamplerAtts = LineSamplerAttributes()\n");
        s += PyLineSamplerAttributes_ToString(currentAtts, "LineSamplerAtts.");
        cb(s);
    }
}

void
PyLineSamplerAttributes_StartUp(LineSamplerAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyLineSamplerAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(LineSamplerAttributesObserver == 0)
    {
        LineSamplerAttributesObserver = new ObserverToCallback(subj,
            PyLineSamplerAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyLineSamplerAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete LineSamplerAttributesObserver;
    LineSamplerAttributesObserver = 0;
}

PyMethodDef *
PyLineSamplerAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return LineSamplerAttributesMethods;
}

bool
PyLineSamplerAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &LineSamplerAttributesType);
}

LineSamplerAttributes *
PyLineSamplerAttributes_FromPyObject(PyObject *obj)
{
    LineSamplerAttributesObject *obj2 = (LineSamplerAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyLineSamplerAttributes_New()
{
    return NewLineSamplerAttributes(0);
}

PyObject *
PyLineSamplerAttributes_Wrap(const LineSamplerAttributes *attr)
{
    return WrapLineSamplerAttributes(attr);
}

void
PyLineSamplerAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    LineSamplerAttributesObject *obj2 = (LineSamplerAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyLineSamplerAttributes_SetDefaults(const LineSamplerAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new LineSamplerAttributes(*atts);
}

