/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#ifndef LAGRANGIANATTRIBUTES_H
#define LAGRANGIANATTRIBUTES_H
#include <string>
#include <AttributeSubject.h>


// ****************************************************************************
// Class: LagrangianAttributes
//
// Purpose:
//    Attributes for Lagrangian operator
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

class LagrangianAttributes : public AttributeSubject
{
public:
    enum sampleType
    {
        Step,
        Time,
        ArcLength,
        Speed,
        Vorticity,
        Variable
    };

    // These constructors are for objects of this class
    LagrangianAttributes();
    LagrangianAttributes(const LagrangianAttributes &obj);
protected:
    // These constructors are for objects derived from this class
    LagrangianAttributes(private_tmfs_t tmfs);
    LagrangianAttributes(const LagrangianAttributes &obj, private_tmfs_t tmfs);
public:
    virtual ~LagrangianAttributes();

    virtual LagrangianAttributes& operator = (const LagrangianAttributes &obj);
    virtual bool operator == (const LagrangianAttributes &obj) const;
    virtual bool operator != (const LagrangianAttributes &obj) const;
private:
    void Init();
    void Copy(const LagrangianAttributes &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectSeedPoint();
    void SelectVariable();

    // Property setting methods
    void SetSeedPoint(const double *seedPoint_);
    void SetNumSteps(int numSteps_);
    void SetXAxisSample(sampleType XAxisSample_);
    void SetYAxisSample(sampleType YAxisSample_);
    void SetVariable(const std::string &variable_);

    // Property getting methods
    const double      *GetSeedPoint() const;
          double      *GetSeedPoint();
    int               GetNumSteps() const;
    sampleType        GetXAxisSample() const;
    sampleType        GetYAxisSample() const;
    const std::string &GetVariable() const;
          std::string &GetVariable();

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);

    // Enum conversion functions
    static std::string sampleType_ToString(sampleType);
    static bool sampleType_FromString(const std::string &, sampleType &);
protected:
    static std::string sampleType_ToString(int);
public:

    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;


    // IDs that can be used to identify fields in case statements
    enum {
        ID_seedPoint = 0,
        ID_numSteps,
        ID_XAxisSample,
        ID_YAxisSample,
        ID_variable,
        ID__LAST
    };

private:
    double      seedPoint[3];
    int         numSteps;
    int         XAxisSample;
    int         YAxisSample;
    std::string variable;

    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define LAGRANGIANATTRIBUTES_TMFS "Diiis"

#endif
