/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include "QvisIsovolumeWindow.h"

#include <IsovolumeAttributes.h>

#include <QLabel>
#include <QLayout>
#include <QLineEdit>
#include <QvisVariableButton.h>


// ****************************************************************************
// Method: QvisIsovolumeWindow::QvisIsovolumeWindow
//
// Purpose: 
//   Constructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisIsovolumeWindow::QvisIsovolumeWindow(const int type,
                         IsovolumeAttributes *subj,
                         const QString &caption,
                         const QString &shortName,
                         QvisNotepadArea *notepad)
    : QvisOperatorWindow(type,subj, caption, shortName, notepad)
{
    atts = subj;
}


// ****************************************************************************
// Method: QvisIsovolumeWindow::~QvisIsovolumeWindow
//
// Purpose: 
//   Destructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisIsovolumeWindow::~QvisIsovolumeWindow()
{
}


// ****************************************************************************
// Method: QvisIsovolumeWindow::CreateWindowContents
//
// Purpose: 
//   Creates the widgets for the window.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//
//   Dave Pugmire, Thu Oct 30 08:40:26 EDT 2008
//   Swapped the min/max.
//
//   Hank Childs, Mon Mar  8 19:49:28 PST 2010
//   Make the min/max be left/right.
//
// ****************************************************************************

void
QvisIsovolumeWindow::CreateWindowContents()
{
    QGridLayout *mainLayout = new QGridLayout(0);
    topLayout->addLayout(mainLayout);

    lboundLabel = new QLabel(tr("Lower bound"), central);
    mainLayout->addWidget(lboundLabel, 0,0);
    lbound = new QLineEdit(central);
    connect(lbound, SIGNAL(returnPressed()),
            this, SLOT(lboundProcessText()));
    mainLayout->addWidget(lbound, 0,1);

    uboundLabel = new QLabel(tr("Upper bound"), central);
    mainLayout->addWidget(uboundLabel,0,2);
    ubound = new QLineEdit(central);
    connect(ubound, SIGNAL(returnPressed()),
            this, SLOT(uboundProcessText()));
    mainLayout->addWidget(ubound, 0,3);

    variableLabel = new QLabel(tr("Variable"), central);
    mainLayout->addWidget(variableLabel,1,0);
    int variableMask = QvisVariableButton::Scalars;
    variable = new QvisVariableButton(true, true, true, variableMask, central);
    variable->setDefaultVariable("default");
    connect(variable, SIGNAL(activated(const QString&)),
            this, SLOT(variableChanged(const QString&)));
    mainLayout->addWidget(variable, 1,1);
}


// ****************************************************************************
// Method: QvisIsovolumeWindow::UpdateWindow
//
// Purpose: 
//   Updates the widgets in the window when the subject changes.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   Cyrus Harrison, Tue Aug 19 10:42:07 PDT 2008
//   Qt4 Port - Autogen + logic for "min" & "max"
//
// ****************************************************************************

void
QvisIsovolumeWindow::UpdateWindow(bool doAll)
{

    for(int i = 0; i < atts->NumAttributes(); ++i)
    {
        if(!doAll)
        {
            if(!atts->IsSelected(i))
            {
                continue;
            }
        }

        switch(i)
        {
          case IsovolumeAttributes::ID_lbound:
            {
                double val = atts->GetLbound();
                if(val == -1e+37)
                    lbound->setText("min");
                else
                    lbound->setText(DoubleToQString(val));
            }
            break;
          case IsovolumeAttributes::ID_ubound:
            {
                double val = atts->GetUbound();
                if(val == 1e+37)
                    ubound->setText("max");
                else
                    ubound->setText(DoubleToQString(val));
            }
            break;
          case IsovolumeAttributes::ID_variable:
            variable->blockSignals(true);
            variable->setText(QString(atts->GetVariable().c_str()));
            variable->blockSignals(false);
            break;
        }
    }
}


// ****************************************************************************
// Method: QvisIsovolumeWindow::GetCurrentValues
//
// Purpose: 
//   Gets values from certain widgets and stores them in the subject.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   Cyrus Harrison, Tue Aug 19 10:42:07 PDT 2008
//   Qt4 Port - Autogen + logic for "min" & "max"
//
// ****************************************************************************

void
QvisIsovolumeWindow::GetCurrentValues(int which_widget)
{
    bool doAll = (which_widget == -1);
    QString temp;
    
    // Do lbound
    if(which_widget == IsovolumeAttributes::ID_lbound || doAll)
    {
        temp = lbound->displayText().simplified();
        if (temp == QString("min"))
        {
            atts->SetLbound(-1e+37);
        }
        else
        {
            double val;
            if(LineEditGetDouble(lbound, val))
                atts->SetLbound(val);
            else
            {
                ResettingError(tr("Lower bound"),
                    DoubleToQString(atts->GetLbound()));
                atts->SetLbound(atts->GetLbound());
            }
        }
    }

    // Do ubound
    if(which_widget == IsovolumeAttributes::ID_ubound || doAll)
    {
        temp = ubound->displayText().simplified();
        if (temp == QString("max"))
        {
            atts->SetUbound(1e+37);
        }
        else
        {
            double val;
            if(LineEditGetDouble(ubound, val))
                atts->SetUbound(val);
            else
            {
                ResettingError(tr("Upper bound"),
                    DoubleToQString(atts->GetUbound()));
                atts->SetUbound(atts->GetUbound());
            }
        }
    }

}


//
// Qt Slot functions
//


void
QvisIsovolumeWindow::lboundProcessText()
{
    GetCurrentValues(IsovolumeAttributes::ID_lbound);
    Apply();
}


void
QvisIsovolumeWindow::uboundProcessText()
{
    GetCurrentValues(IsovolumeAttributes::ID_ubound);
    Apply();
}


void
QvisIsovolumeWindow::variableChanged(const QString &varName)
{
    atts->SetVariable(varName.toStdString());
    SetUpdate(false);
    Apply();
}


