/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyIsovolumeAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>

// ****************************************************************************
// Module: PyIsovolumeAttributes
//
// Purpose: 
//   This class contains attributes for the isovolume operator.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a IsovolumeAttributes.
//
struct IsovolumeAttributesObject
{
    PyObject_HEAD
    IsovolumeAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewIsovolumeAttributes(int);

std::string
PyIsovolumeAttributes_ToString(const IsovolumeAttributes *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    SNPRINTF(tmpStr, 1000, "%slbound = %g\n", prefix, atts->GetLbound());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%subound = %g\n", prefix, atts->GetUbound());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%svariable = \"%s\"\n", prefix, atts->GetVariable().c_str());
    str += tmpStr;
    return str;
}

static PyObject *
IsovolumeAttributes_Notify(PyObject *self, PyObject *args)
{
    IsovolumeAttributesObject *obj = (IsovolumeAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IsovolumeAttributes_SetLbound(PyObject *self, PyObject *args)
{
    IsovolumeAttributesObject *obj = (IsovolumeAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the lbound in the object.
    obj->data->SetLbound(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IsovolumeAttributes_GetLbound(PyObject *self, PyObject *args)
{
    IsovolumeAttributesObject *obj = (IsovolumeAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetLbound());
    return retval;
}

/*static*/ PyObject *
IsovolumeAttributes_SetUbound(PyObject *self, PyObject *args)
{
    IsovolumeAttributesObject *obj = (IsovolumeAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the ubound in the object.
    obj->data->SetUbound(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IsovolumeAttributes_GetUbound(PyObject *self, PyObject *args)
{
    IsovolumeAttributesObject *obj = (IsovolumeAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetUbound());
    return retval;
}

/*static*/ PyObject *
IsovolumeAttributes_SetVariable(PyObject *self, PyObject *args)
{
    IsovolumeAttributesObject *obj = (IsovolumeAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the variable in the object.
    obj->data->SetVariable(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
IsovolumeAttributes_GetVariable(PyObject *self, PyObject *args)
{
    IsovolumeAttributesObject *obj = (IsovolumeAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetVariable().c_str());
    return retval;
}



PyMethodDef PyIsovolumeAttributes_methods[ISOVOLUMEATTRIBUTES_NMETH] = {
    {"Notify", IsovolumeAttributes_Notify, METH_VARARGS},
    {"SetLbound", IsovolumeAttributes_SetLbound, METH_VARARGS},
    {"GetLbound", IsovolumeAttributes_GetLbound, METH_VARARGS},
    {"SetUbound", IsovolumeAttributes_SetUbound, METH_VARARGS},
    {"GetUbound", IsovolumeAttributes_GetUbound, METH_VARARGS},
    {"SetVariable", IsovolumeAttributes_SetVariable, METH_VARARGS},
    {"GetVariable", IsovolumeAttributes_GetVariable, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
IsovolumeAttributes_dealloc(PyObject *v)
{
   IsovolumeAttributesObject *obj = (IsovolumeAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
IsovolumeAttributes_compare(PyObject *v, PyObject *w)
{
    IsovolumeAttributes *a = ((IsovolumeAttributesObject *)v)->data;
    IsovolumeAttributes *b = ((IsovolumeAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyIsovolumeAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "lbound") == 0)
        return IsovolumeAttributes_GetLbound(self, NULL);
    if(strcmp(name, "ubound") == 0)
        return IsovolumeAttributes_GetUbound(self, NULL);
    if(strcmp(name, "variable") == 0)
        return IsovolumeAttributes_GetVariable(self, NULL);

    return Py_FindMethod(PyIsovolumeAttributes_methods, self, name);
}

int
PyIsovolumeAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "lbound") == 0)
        obj = IsovolumeAttributes_SetLbound(self, tuple);
    else if(strcmp(name, "ubound") == 0)
        obj = IsovolumeAttributes_SetUbound(self, tuple);
    else if(strcmp(name, "variable") == 0)
        obj = IsovolumeAttributes_SetVariable(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
IsovolumeAttributes_print(PyObject *v, FILE *fp, int flags)
{
    IsovolumeAttributesObject *obj = (IsovolumeAttributesObject *)v;
    fprintf(fp, "%s", PyIsovolumeAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
IsovolumeAttributes_str(PyObject *v)
{
    IsovolumeAttributesObject *obj = (IsovolumeAttributesObject *)v;
    return PyString_FromString(PyIsovolumeAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *IsovolumeAttributes_Purpose = "This class contains attributes for the isovolume operator.";
#else
static char *IsovolumeAttributes_Purpose = "This class contains attributes for the isovolume operator.";
#endif

//
// The type description structure
//
static PyTypeObject IsovolumeAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "IsovolumeAttributes",                    // tp_name
    sizeof(IsovolumeAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)IsovolumeAttributes_dealloc,  // tp_dealloc
    (printfunc)IsovolumeAttributes_print,     // tp_print
    (getattrfunc)PyIsovolumeAttributes_getattr, // tp_getattr
    (setattrfunc)PyIsovolumeAttributes_setattr, // tp_setattr
    (cmpfunc)IsovolumeAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)IsovolumeAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    IsovolumeAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static IsovolumeAttributes *defaultAtts = 0;
static IsovolumeAttributes *currentAtts = 0;

static PyObject *
NewIsovolumeAttributes(int useCurrent)
{
    IsovolumeAttributesObject *newObject;
    newObject = PyObject_NEW(IsovolumeAttributesObject, &IsovolumeAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new IsovolumeAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new IsovolumeAttributes(*defaultAtts);
    else
        newObject->data = new IsovolumeAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapIsovolumeAttributes(const IsovolumeAttributes *attr)
{
    IsovolumeAttributesObject *newObject;
    newObject = PyObject_NEW(IsovolumeAttributesObject, &IsovolumeAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (IsovolumeAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
IsovolumeAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewIsovolumeAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef IsovolumeAttributesMethods[] = {
    {"IsovolumeAttributes", IsovolumeAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *IsovolumeAttributesObserver = 0;

std::string
PyIsovolumeAttributes_GetLogString()
{
    std::string s("IsovolumeAtts = IsovolumeAttributes()\n");
    if(currentAtts != 0)
        s += PyIsovolumeAttributes_ToString(currentAtts, "IsovolumeAtts.");
    return s;
}

static void
PyIsovolumeAttributes_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("IsovolumeAtts = IsovolumeAttributes()\n");
        s += PyIsovolumeAttributes_ToString(currentAtts, "IsovolumeAtts.");
        cb(s);
    }
}

void
PyIsovolumeAttributes_StartUp(IsovolumeAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyIsovolumeAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(IsovolumeAttributesObserver == 0)
    {
        IsovolumeAttributesObserver = new ObserverToCallback(subj,
            PyIsovolumeAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyIsovolumeAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete IsovolumeAttributesObserver;
    IsovolumeAttributesObserver = 0;
}

PyMethodDef *
PyIsovolumeAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return IsovolumeAttributesMethods;
}

bool
PyIsovolumeAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &IsovolumeAttributesType);
}

IsovolumeAttributes *
PyIsovolumeAttributes_FromPyObject(PyObject *obj)
{
    IsovolumeAttributesObject *obj2 = (IsovolumeAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyIsovolumeAttributes_New()
{
    return NewIsovolumeAttributes(0);
}

PyObject *
PyIsovolumeAttributes_Wrap(const IsovolumeAttributes *attr)
{
    return WrapIsovolumeAttributes(attr);
}

void
PyIsovolumeAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    IsovolumeAttributesObject *obj2 = (IsovolumeAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyIsovolumeAttributes_SetDefaults(const IsovolumeAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new IsovolumeAttributes(*atts);
}

