/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

// ************************************************************************* //
//  File: avtDisplacePluginFilter.C
// ************************************************************************* //

#include <avtDisplacePluginFilter.h>

#include <avtDisplaceFilter.h>
#include <DisplaceAttributes.h>

// ****************************************************************************
//  Method: avtDisplacePluginFilter constructor
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   May 18, 2007
//
// ****************************************************************************

avtDisplacePluginFilter::avtDisplacePluginFilter()
{
    displacer = NULL;
}


// ****************************************************************************
//  Method: avtDisplacePluginFilter destructor
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   May 18, 2007
//
//  Modifications:
//
// ****************************************************************************

avtDisplacePluginFilter::~avtDisplacePluginFilter()
{
    if (displacer != NULL)
    {
        delete displacer;
        displacer = NULL;
    }
}


// ****************************************************************************
//  Method:  avtDisplacePluginFilter::Create
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   May 18, 2007
//
// ****************************************************************************

avtFilter *
avtDisplacePluginFilter::Create()
{
    return new avtDisplacePluginFilter();
}


// ****************************************************************************
//  Method:      avtDisplacePluginFilter::SetAtts
//
//  Purpose:
//      Sets the state of the filter based on the attribute object.
//
//  Arguments:
//      a        The attributes to use.
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   May 18, 2007
//
//  Modifications:
//
//    Hank Childs, Fri Sep 30 09:16:06 PDT 2005
//    Add support for distributed resampling.
//
//    Brad Whitlock, Wed Mar 19 14:14:53 PDT 2014
//    Add callback to the facade filter.
//
// ****************************************************************************

void
avtDisplacePluginFilter::SetAtts(const AttributeGroup *a)
{
    atts = *(const DisplaceAttributes*)a;

    //
    // Construct a new resample filter based on these attributes.
    //
    if (displacer != NULL)
    {
        delete displacer;
    }

    displacer = new avtDisplaceFilter();
    displacer->SetVariable(atts.GetVariable());
    displacer->SetFactor(atts.GetFactor());
    displacer->SetUpdateDataObjectInfoCallback(UpdateDataObjectInfoCB, (void*)this);
}


// ****************************************************************************
//  Method: avtDisplacePluginFilter::Equivalent
//
//  Purpose:
//      Returns true if creating a new avtDisplacePluginFilter with the given
//      parameters would result in an equivalent avtDisplacePluginFilter.
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   May 18, 2007
//
// ****************************************************************************

bool
avtDisplacePluginFilter::Equivalent(const AttributeGroup *a)
{
    return (atts == *(DisplaceAttributes*)a);
}


// ****************************************************************************
//  Method: avtDisplacePluginFilter::GetFacadedFilter
//
//  Purpose:
//      Gets the filter that the filter that we are a facade of.
//
//  Programmer: Hank Childs
//  Creation:   May 18, 2007
//
// ****************************************************************************

avtFilter *
avtDisplacePluginFilter::GetFacadedFilter(void)
{
    return displacer;
}


// ****************************************************************************
//  Method: avtDisplacePluginFilter::GetFacadedFilter
//
//  Purpose:
//      Gets the filter that the filter that we are a facade of.
//
//  Programmer: Tom Fogal
//  Creation:   June 23, 2009
//
// ****************************************************************************

const avtFilter *
avtDisplacePluginFilter::GetFacadedFilter(void) const
{
    return displacer;
}

// ****************************************************************************
// Method: avtDisplacePluginFilter::UpdateDataObjectInfoCB
//
// Purpose:
//   Update the data object information.
//
// Note:       Work partially supported by DOE Grant SC0007548.
//
// Programmer: Brad Whitlock
// Creation:   Tue Mar 18 10:53:05 PDT 2014
//
// Modifications:
//
// ****************************************************************************

void
avtDisplacePluginFilter::UpdateDataObjectInfoCB(avtDataObject_p &input,
    avtDataObject_p &output, void *This)
{
    avtDataAttributes &outAtts = output->GetInfo().GetAttributes();
    outAtts.AddFilterMetaData("Displace");
}
