/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <CreateBondsAttributes.h>
#include <DataNode.h>

// ****************************************************************************
// Method: CreateBondsAttributes::CreateBondsAttributes
//
// Purpose: 
//   Init utility for the CreateBondsAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void CreateBondsAttributes::Init()
{
    atomicNumber1.push_back(1);
    atomicNumber1.push_back(-1);
    atomicNumber2.push_back(-1);
    atomicNumber2.push_back(-1);
    minDist.push_back(0.4);
    minDist.push_back(0.4);
    maxDist.push_back(1.2);
    maxDist.push_back(1.9);
    maxBondsClamp = 10;
    addPeriodicBonds = false;
    useUnitCellVectors = true;
    periodicInX = true;
    periodicInY = true;
    periodicInZ = true;
    xVector[0] = 1;
    xVector[1] = 0;
    xVector[2] = 0;
    yVector[0] = 0;
    yVector[1] = 1;
    yVector[2] = 0;
    zVector[0] = 0;
    zVector[1] = 0;
    zVector[2] = 1;

    CreateBondsAttributes::SelectAll();
}

// ****************************************************************************
// Method: CreateBondsAttributes::CreateBondsAttributes
//
// Purpose: 
//   Copy utility for the CreateBondsAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void CreateBondsAttributes::Copy(const CreateBondsAttributes &obj)
{
    elementVariable = obj.elementVariable;
    atomicNumber1 = obj.atomicNumber1;
    atomicNumber2 = obj.atomicNumber2;
    minDist = obj.minDist;
    maxDist = obj.maxDist;
    maxBondsClamp = obj.maxBondsClamp;
    addPeriodicBonds = obj.addPeriodicBonds;
    useUnitCellVectors = obj.useUnitCellVectors;
    periodicInX = obj.periodicInX;
    periodicInY = obj.periodicInY;
    periodicInZ = obj.periodicInZ;
    xVector[0] = obj.xVector[0];
    xVector[1] = obj.xVector[1];
    xVector[2] = obj.xVector[2];

    yVector[0] = obj.yVector[0];
    yVector[1] = obj.yVector[1];
    yVector[2] = obj.yVector[2];

    zVector[0] = obj.zVector[0];
    zVector[1] = obj.zVector[1];
    zVector[2] = obj.zVector[2];


    CreateBondsAttributes::SelectAll();
}

// Type map format string
const char *CreateBondsAttributes::TypeMapFormatString = CREATEBONDSATTRIBUTES_TMFS;
const AttributeGroup::private_tmfs_t CreateBondsAttributes::TmfsStruct = {CREATEBONDSATTRIBUTES_TMFS};


// ****************************************************************************
// Method: CreateBondsAttributes::CreateBondsAttributes
//
// Purpose: 
//   Default constructor for the CreateBondsAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

CreateBondsAttributes::CreateBondsAttributes() : 
    AttributeSubject(CreateBondsAttributes::TypeMapFormatString),
    elementVariable("element")
{
    CreateBondsAttributes::Init();
}

// ****************************************************************************
// Method: CreateBondsAttributes::CreateBondsAttributes
//
// Purpose: 
//   Constructor for the derived classes of CreateBondsAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

CreateBondsAttributes::CreateBondsAttributes(private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs),
    elementVariable("element")
{
    CreateBondsAttributes::Init();
}

// ****************************************************************************
// Method: CreateBondsAttributes::CreateBondsAttributes
//
// Purpose: 
//   Copy constructor for the CreateBondsAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

CreateBondsAttributes::CreateBondsAttributes(const CreateBondsAttributes &obj) : 
    AttributeSubject(CreateBondsAttributes::TypeMapFormatString)
{
    CreateBondsAttributes::Copy(obj);
}

// ****************************************************************************
// Method: CreateBondsAttributes::CreateBondsAttributes
//
// Purpose: 
//   Copy constructor for derived classes of the CreateBondsAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

CreateBondsAttributes::CreateBondsAttributes(const CreateBondsAttributes &obj, private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    CreateBondsAttributes::Copy(obj);
}

// ****************************************************************************
// Method: CreateBondsAttributes::~CreateBondsAttributes
//
// Purpose: 
//   Destructor for the CreateBondsAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

CreateBondsAttributes::~CreateBondsAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: CreateBondsAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the CreateBondsAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

CreateBondsAttributes& 
CreateBondsAttributes::operator = (const CreateBondsAttributes &obj)
{
    if (this == &obj) return *this;

    CreateBondsAttributes::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: CreateBondsAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the CreateBondsAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
CreateBondsAttributes::operator == (const CreateBondsAttributes &obj) const
{
    // Compare the xVector arrays.
    bool xVector_equal = true;
    for(int i = 0; i < 3 && xVector_equal; ++i)
        xVector_equal = (xVector[i] == obj.xVector[i]);

    // Compare the yVector arrays.
    bool yVector_equal = true;
    for(int i = 0; i < 3 && yVector_equal; ++i)
        yVector_equal = (yVector[i] == obj.yVector[i]);

    // Compare the zVector arrays.
    bool zVector_equal = true;
    for(int i = 0; i < 3 && zVector_equal; ++i)
        zVector_equal = (zVector[i] == obj.zVector[i]);

    // Create the return value
    return ((elementVariable == obj.elementVariable) &&
            (atomicNumber1 == obj.atomicNumber1) &&
            (atomicNumber2 == obj.atomicNumber2) &&
            (minDist == obj.minDist) &&
            (maxDist == obj.maxDist) &&
            (maxBondsClamp == obj.maxBondsClamp) &&
            (addPeriodicBonds == obj.addPeriodicBonds) &&
            (useUnitCellVectors == obj.useUnitCellVectors) &&
            (periodicInX == obj.periodicInX) &&
            (periodicInY == obj.periodicInY) &&
            (periodicInZ == obj.periodicInZ) &&
            xVector_equal &&
            yVector_equal &&
            zVector_equal);
}

// ****************************************************************************
// Method: CreateBondsAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the CreateBondsAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
CreateBondsAttributes::operator != (const CreateBondsAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: CreateBondsAttributes::TypeName
//
// Purpose: 
//   Type name method for the CreateBondsAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
CreateBondsAttributes::TypeName() const
{
    return "CreateBondsAttributes";
}

// ****************************************************************************
// Method: CreateBondsAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the CreateBondsAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
CreateBondsAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const CreateBondsAttributes *tmp = (const CreateBondsAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: CreateBondsAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the CreateBondsAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
CreateBondsAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new CreateBondsAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: CreateBondsAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the CreateBondsAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
CreateBondsAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new CreateBondsAttributes(*this);
    else
        retval = new CreateBondsAttributes;

    return retval;
}

// ****************************************************************************
// Method: CreateBondsAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
CreateBondsAttributes::SelectAll()
{
    Select(ID_elementVariable,    (void *)&elementVariable);
    Select(ID_atomicNumber1,      (void *)&atomicNumber1);
    Select(ID_atomicNumber2,      (void *)&atomicNumber2);
    Select(ID_minDist,            (void *)&minDist);
    Select(ID_maxDist,            (void *)&maxDist);
    Select(ID_maxBondsClamp,      (void *)&maxBondsClamp);
    Select(ID_addPeriodicBonds,   (void *)&addPeriodicBonds);
    Select(ID_useUnitCellVectors, (void *)&useUnitCellVectors);
    Select(ID_periodicInX,        (void *)&periodicInX);
    Select(ID_periodicInY,        (void *)&periodicInY);
    Select(ID_periodicInZ,        (void *)&periodicInZ);
    Select(ID_xVector,            (void *)xVector, 3);
    Select(ID_yVector,            (void *)yVector, 3);
    Select(ID_zVector,            (void *)zVector, 3);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: CreateBondsAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
CreateBondsAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    CreateBondsAttributes defaultObject;
    bool addToParent = false;
    // Create a node for CreateBondsAttributes.
    DataNode *node = new DataNode("CreateBondsAttributes");

    if(completeSave || !FieldsEqual(ID_elementVariable, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("elementVariable", elementVariable));
    }

    if(completeSave || !FieldsEqual(ID_atomicNumber1, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("atomicNumber1", atomicNumber1));
    }

    if(completeSave || !FieldsEqual(ID_atomicNumber2, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("atomicNumber2", atomicNumber2));
    }

    if(completeSave || !FieldsEqual(ID_minDist, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("minDist", minDist));
    }

    if(completeSave || !FieldsEqual(ID_maxDist, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("maxDist", maxDist));
    }

    if(completeSave || !FieldsEqual(ID_maxBondsClamp, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("maxBondsClamp", maxBondsClamp));
    }

    if(completeSave || !FieldsEqual(ID_addPeriodicBonds, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("addPeriodicBonds", addPeriodicBonds));
    }

    if(completeSave || !FieldsEqual(ID_useUnitCellVectors, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("useUnitCellVectors", useUnitCellVectors));
    }

    if(completeSave || !FieldsEqual(ID_periodicInX, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("periodicInX", periodicInX));
    }

    if(completeSave || !FieldsEqual(ID_periodicInY, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("periodicInY", periodicInY));
    }

    if(completeSave || !FieldsEqual(ID_periodicInZ, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("periodicInZ", periodicInZ));
    }

    if(completeSave || !FieldsEqual(ID_xVector, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("xVector", xVector, 3));
    }

    if(completeSave || !FieldsEqual(ID_yVector, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("yVector", yVector, 3));
    }

    if(completeSave || !FieldsEqual(ID_zVector, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("zVector", zVector, 3));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: CreateBondsAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
CreateBondsAttributes::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("CreateBondsAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("elementVariable")) != 0)
        SetElementVariable(node->AsString());
    if((node = searchNode->GetNode("atomicNumber1")) != 0)
        SetAtomicNumber1(node->AsIntVector());
    if((node = searchNode->GetNode("atomicNumber2")) != 0)
        SetAtomicNumber2(node->AsIntVector());
    if((node = searchNode->GetNode("minDist")) != 0)
        SetMinDist(node->AsDoubleVector());
    if((node = searchNode->GetNode("maxDist")) != 0)
        SetMaxDist(node->AsDoubleVector());
    if((node = searchNode->GetNode("maxBondsClamp")) != 0)
        SetMaxBondsClamp(node->AsInt());
    if((node = searchNode->GetNode("addPeriodicBonds")) != 0)
        SetAddPeriodicBonds(node->AsBool());
    if((node = searchNode->GetNode("useUnitCellVectors")) != 0)
        SetUseUnitCellVectors(node->AsBool());
    if((node = searchNode->GetNode("periodicInX")) != 0)
        SetPeriodicInX(node->AsBool());
    if((node = searchNode->GetNode("periodicInY")) != 0)
        SetPeriodicInY(node->AsBool());
    if((node = searchNode->GetNode("periodicInZ")) != 0)
        SetPeriodicInZ(node->AsBool());
    if((node = searchNode->GetNode("xVector")) != 0)
        SetXVector(node->AsDoubleArray());
    if((node = searchNode->GetNode("yVector")) != 0)
        SetYVector(node->AsDoubleArray());
    if((node = searchNode->GetNode("zVector")) != 0)
        SetZVector(node->AsDoubleArray());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
CreateBondsAttributes::SetElementVariable(const std::string &elementVariable_)
{
    elementVariable = elementVariable_;
    Select(ID_elementVariable, (void *)&elementVariable);
}

void
CreateBondsAttributes::SetAtomicNumber1(const intVector &atomicNumber1_)
{
    atomicNumber1 = atomicNumber1_;
    Select(ID_atomicNumber1, (void *)&atomicNumber1);
}

void
CreateBondsAttributes::SetAtomicNumber2(const intVector &atomicNumber2_)
{
    atomicNumber2 = atomicNumber2_;
    Select(ID_atomicNumber2, (void *)&atomicNumber2);
}

void
CreateBondsAttributes::SetMinDist(const doubleVector &minDist_)
{
    minDist = minDist_;
    Select(ID_minDist, (void *)&minDist);
}

void
CreateBondsAttributes::SetMaxDist(const doubleVector &maxDist_)
{
    maxDist = maxDist_;
    Select(ID_maxDist, (void *)&maxDist);
}

void
CreateBondsAttributes::SetMaxBondsClamp(int maxBondsClamp_)
{
    maxBondsClamp = maxBondsClamp_;
    Select(ID_maxBondsClamp, (void *)&maxBondsClamp);
}

void
CreateBondsAttributes::SetAddPeriodicBonds(bool addPeriodicBonds_)
{
    addPeriodicBonds = addPeriodicBonds_;
    Select(ID_addPeriodicBonds, (void *)&addPeriodicBonds);
}

void
CreateBondsAttributes::SetUseUnitCellVectors(bool useUnitCellVectors_)
{
    useUnitCellVectors = useUnitCellVectors_;
    Select(ID_useUnitCellVectors, (void *)&useUnitCellVectors);
}

void
CreateBondsAttributes::SetPeriodicInX(bool periodicInX_)
{
    periodicInX = periodicInX_;
    Select(ID_periodicInX, (void *)&periodicInX);
}

void
CreateBondsAttributes::SetPeriodicInY(bool periodicInY_)
{
    periodicInY = periodicInY_;
    Select(ID_periodicInY, (void *)&periodicInY);
}

void
CreateBondsAttributes::SetPeriodicInZ(bool periodicInZ_)
{
    periodicInZ = periodicInZ_;
    Select(ID_periodicInZ, (void *)&periodicInZ);
}

void
CreateBondsAttributes::SetXVector(const double *xVector_)
{
    xVector[0] = xVector_[0];
    xVector[1] = xVector_[1];
    xVector[2] = xVector_[2];
    Select(ID_xVector, (void *)xVector, 3);
}

void
CreateBondsAttributes::SetYVector(const double *yVector_)
{
    yVector[0] = yVector_[0];
    yVector[1] = yVector_[1];
    yVector[2] = yVector_[2];
    Select(ID_yVector, (void *)yVector, 3);
}

void
CreateBondsAttributes::SetZVector(const double *zVector_)
{
    zVector[0] = zVector_[0];
    zVector[1] = zVector_[1];
    zVector[2] = zVector_[2];
    Select(ID_zVector, (void *)zVector, 3);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

const std::string &
CreateBondsAttributes::GetElementVariable() const
{
    return elementVariable;
}

std::string &
CreateBondsAttributes::GetElementVariable()
{
    return elementVariable;
}

const intVector &
CreateBondsAttributes::GetAtomicNumber1() const
{
    return atomicNumber1;
}

intVector &
CreateBondsAttributes::GetAtomicNumber1()
{
    return atomicNumber1;
}

const intVector &
CreateBondsAttributes::GetAtomicNumber2() const
{
    return atomicNumber2;
}

intVector &
CreateBondsAttributes::GetAtomicNumber2()
{
    return atomicNumber2;
}

const doubleVector &
CreateBondsAttributes::GetMinDist() const
{
    return minDist;
}

doubleVector &
CreateBondsAttributes::GetMinDist()
{
    return minDist;
}

const doubleVector &
CreateBondsAttributes::GetMaxDist() const
{
    return maxDist;
}

doubleVector &
CreateBondsAttributes::GetMaxDist()
{
    return maxDist;
}

int
CreateBondsAttributes::GetMaxBondsClamp() const
{
    return maxBondsClamp;
}

bool
CreateBondsAttributes::GetAddPeriodicBonds() const
{
    return addPeriodicBonds;
}

bool
CreateBondsAttributes::GetUseUnitCellVectors() const
{
    return useUnitCellVectors;
}

bool
CreateBondsAttributes::GetPeriodicInX() const
{
    return periodicInX;
}

bool
CreateBondsAttributes::GetPeriodicInY() const
{
    return periodicInY;
}

bool
CreateBondsAttributes::GetPeriodicInZ() const
{
    return periodicInZ;
}

const double *
CreateBondsAttributes::GetXVector() const
{
    return xVector;
}

double *
CreateBondsAttributes::GetXVector()
{
    return xVector;
}

const double *
CreateBondsAttributes::GetYVector() const
{
    return yVector;
}

double *
CreateBondsAttributes::GetYVector()
{
    return yVector;
}

const double *
CreateBondsAttributes::GetZVector() const
{
    return zVector;
}

double *
CreateBondsAttributes::GetZVector()
{
    return zVector;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
CreateBondsAttributes::SelectElementVariable()
{
    Select(ID_elementVariable, (void *)&elementVariable);
}

void
CreateBondsAttributes::SelectAtomicNumber1()
{
    Select(ID_atomicNumber1, (void *)&atomicNumber1);
}

void
CreateBondsAttributes::SelectAtomicNumber2()
{
    Select(ID_atomicNumber2, (void *)&atomicNumber2);
}

void
CreateBondsAttributes::SelectMinDist()
{
    Select(ID_minDist, (void *)&minDist);
}

void
CreateBondsAttributes::SelectMaxDist()
{
    Select(ID_maxDist, (void *)&maxDist);
}

void
CreateBondsAttributes::SelectXVector()
{
    Select(ID_xVector, (void *)xVector, 3);
}

void
CreateBondsAttributes::SelectYVector()
{
    Select(ID_yVector, (void *)yVector, 3);
}

void
CreateBondsAttributes::SelectZVector()
{
    Select(ID_zVector, (void *)zVector, 3);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: CreateBondsAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
CreateBondsAttributes::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_elementVariable:    return "elementVariable";
    case ID_atomicNumber1:      return "atomicNumber1";
    case ID_atomicNumber2:      return "atomicNumber2";
    case ID_minDist:            return "minDist";
    case ID_maxDist:            return "maxDist";
    case ID_maxBondsClamp:      return "maxBondsClamp";
    case ID_addPeriodicBonds:   return "addPeriodicBonds";
    case ID_useUnitCellVectors: return "useUnitCellVectors";
    case ID_periodicInX:        return "periodicInX";
    case ID_periodicInY:        return "periodicInY";
    case ID_periodicInZ:        return "periodicInZ";
    case ID_xVector:            return "xVector";
    case ID_yVector:            return "yVector";
    case ID_zVector:            return "zVector";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: CreateBondsAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
CreateBondsAttributes::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_elementVariable:    return FieldType_variablename;
    case ID_atomicNumber1:      return FieldType_intVector;
    case ID_atomicNumber2:      return FieldType_intVector;
    case ID_minDist:            return FieldType_doubleVector;
    case ID_maxDist:            return FieldType_doubleVector;
    case ID_maxBondsClamp:      return FieldType_int;
    case ID_addPeriodicBonds:   return FieldType_bool;
    case ID_useUnitCellVectors: return FieldType_bool;
    case ID_periodicInX:        return FieldType_bool;
    case ID_periodicInY:        return FieldType_bool;
    case ID_periodicInZ:        return FieldType_bool;
    case ID_xVector:            return FieldType_doubleArray;
    case ID_yVector:            return FieldType_doubleArray;
    case ID_zVector:            return FieldType_doubleArray;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: CreateBondsAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
CreateBondsAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_elementVariable:    return "variablename";
    case ID_atomicNumber1:      return "intVector";
    case ID_atomicNumber2:      return "intVector";
    case ID_minDist:            return "doubleVector";
    case ID_maxDist:            return "doubleVector";
    case ID_maxBondsClamp:      return "int";
    case ID_addPeriodicBonds:   return "bool";
    case ID_useUnitCellVectors: return "bool";
    case ID_periodicInX:        return "bool";
    case ID_periodicInY:        return "bool";
    case ID_periodicInZ:        return "bool";
    case ID_xVector:            return "doubleArray";
    case ID_yVector:            return "doubleArray";
    case ID_zVector:            return "doubleArray";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: CreateBondsAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
CreateBondsAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const CreateBondsAttributes &obj = *((const CreateBondsAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_elementVariable:
        {  // new scope
        retval = (elementVariable == obj.elementVariable);
        }
        break;
    case ID_atomicNumber1:
        {  // new scope
        retval = (atomicNumber1 == obj.atomicNumber1);
        }
        break;
    case ID_atomicNumber2:
        {  // new scope
        retval = (atomicNumber2 == obj.atomicNumber2);
        }
        break;
    case ID_minDist:
        {  // new scope
        retval = (minDist == obj.minDist);
        }
        break;
    case ID_maxDist:
        {  // new scope
        retval = (maxDist == obj.maxDist);
        }
        break;
    case ID_maxBondsClamp:
        {  // new scope
        retval = (maxBondsClamp == obj.maxBondsClamp);
        }
        break;
    case ID_addPeriodicBonds:
        {  // new scope
        retval = (addPeriodicBonds == obj.addPeriodicBonds);
        }
        break;
    case ID_useUnitCellVectors:
        {  // new scope
        retval = (useUnitCellVectors == obj.useUnitCellVectors);
        }
        break;
    case ID_periodicInX:
        {  // new scope
        retval = (periodicInX == obj.periodicInX);
        }
        break;
    case ID_periodicInY:
        {  // new scope
        retval = (periodicInY == obj.periodicInY);
        }
        break;
    case ID_periodicInZ:
        {  // new scope
        retval = (periodicInZ == obj.periodicInZ);
        }
        break;
    case ID_xVector:
        {  // new scope
        // Compare the xVector arrays.
        bool xVector_equal = true;
        for(int i = 0; i < 3 && xVector_equal; ++i)
            xVector_equal = (xVector[i] == obj.xVector[i]);

        retval = xVector_equal;
        }
        break;
    case ID_yVector:
        {  // new scope
        // Compare the yVector arrays.
        bool yVector_equal = true;
        for(int i = 0; i < 3 && yVector_equal; ++i)
            yVector_equal = (yVector[i] == obj.yVector[i]);

        retval = yVector_equal;
        }
        break;
    case ID_zVector:
        {  // new scope
        // Compare the zVector arrays.
        bool zVector_equal = true;
        for(int i = 0; i < 3 && zVector_equal; ++i)
            zVector_equal = (zVector[i] == obj.zVector[i]);

        retval = zVector_equal;
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

