/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyContextAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>

// ****************************************************************************
// Module: PyContextAttributes
//
// Purpose: 
//   This class contains attributes for the context operator.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a ContextAttributes.
//
struct ContextAttributesObject
{
    PyObject_HEAD
    ContextAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewContextAttributes(int);

std::string
PyContextAttributes_ToString(const ContextAttributes *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    SNPRINTF(tmpStr, 1000, "%soffset = %g\n", prefix, atts->GetOffset());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%slow = %g\n", prefix, atts->GetLow());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%shi = %g\n", prefix, atts->GetHi());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%scontext = \"%s\"\n", prefix, atts->GetContext().c_str());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%scutoff = %g\n", prefix, atts->GetCutoff());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sbelow = %g\n", prefix, atts->GetBelow());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sabove = %g\n", prefix, atts->GetAbove());
    str += tmpStr;
    return str;
}

static PyObject *
ContextAttributes_Notify(PyObject *self, PyObject *args)
{
    ContextAttributesObject *obj = (ContextAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ContextAttributes_SetOffset(PyObject *self, PyObject *args)
{
    ContextAttributesObject *obj = (ContextAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the offset in the object.
    obj->data->SetOffset(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ContextAttributes_GetOffset(PyObject *self, PyObject *args)
{
    ContextAttributesObject *obj = (ContextAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetOffset());
    return retval;
}

/*static*/ PyObject *
ContextAttributes_SetLow(PyObject *self, PyObject *args)
{
    ContextAttributesObject *obj = (ContextAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the low in the object.
    obj->data->SetLow(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ContextAttributes_GetLow(PyObject *self, PyObject *args)
{
    ContextAttributesObject *obj = (ContextAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetLow());
    return retval;
}

/*static*/ PyObject *
ContextAttributes_SetHi(PyObject *self, PyObject *args)
{
    ContextAttributesObject *obj = (ContextAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the hi in the object.
    obj->data->SetHi(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ContextAttributes_GetHi(PyObject *self, PyObject *args)
{
    ContextAttributesObject *obj = (ContextAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetHi());
    return retval;
}

/*static*/ PyObject *
ContextAttributes_SetContext(PyObject *self, PyObject *args)
{
    ContextAttributesObject *obj = (ContextAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the context in the object.
    obj->data->SetContext(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ContextAttributes_GetContext(PyObject *self, PyObject *args)
{
    ContextAttributesObject *obj = (ContextAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetContext().c_str());
    return retval;
}

/*static*/ PyObject *
ContextAttributes_SetCutoff(PyObject *self, PyObject *args)
{
    ContextAttributesObject *obj = (ContextAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the cutoff in the object.
    obj->data->SetCutoff(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ContextAttributes_GetCutoff(PyObject *self, PyObject *args)
{
    ContextAttributesObject *obj = (ContextAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetCutoff());
    return retval;
}

/*static*/ PyObject *
ContextAttributes_SetBelow(PyObject *self, PyObject *args)
{
    ContextAttributesObject *obj = (ContextAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the below in the object.
    obj->data->SetBelow(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ContextAttributes_GetBelow(PyObject *self, PyObject *args)
{
    ContextAttributesObject *obj = (ContextAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetBelow());
    return retval;
}

/*static*/ PyObject *
ContextAttributes_SetAbove(PyObject *self, PyObject *args)
{
    ContextAttributesObject *obj = (ContextAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the above in the object.
    obj->data->SetAbove(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ContextAttributes_GetAbove(PyObject *self, PyObject *args)
{
    ContextAttributesObject *obj = (ContextAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetAbove());
    return retval;
}



PyMethodDef PyContextAttributes_methods[CONTEXTATTRIBUTES_NMETH] = {
    {"Notify", ContextAttributes_Notify, METH_VARARGS},
    {"SetOffset", ContextAttributes_SetOffset, METH_VARARGS},
    {"GetOffset", ContextAttributes_GetOffset, METH_VARARGS},
    {"SetLow", ContextAttributes_SetLow, METH_VARARGS},
    {"GetLow", ContextAttributes_GetLow, METH_VARARGS},
    {"SetHi", ContextAttributes_SetHi, METH_VARARGS},
    {"GetHi", ContextAttributes_GetHi, METH_VARARGS},
    {"SetContext", ContextAttributes_SetContext, METH_VARARGS},
    {"GetContext", ContextAttributes_GetContext, METH_VARARGS},
    {"SetCutoff", ContextAttributes_SetCutoff, METH_VARARGS},
    {"GetCutoff", ContextAttributes_GetCutoff, METH_VARARGS},
    {"SetBelow", ContextAttributes_SetBelow, METH_VARARGS},
    {"GetBelow", ContextAttributes_GetBelow, METH_VARARGS},
    {"SetAbove", ContextAttributes_SetAbove, METH_VARARGS},
    {"GetAbove", ContextAttributes_GetAbove, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
ContextAttributes_dealloc(PyObject *v)
{
   ContextAttributesObject *obj = (ContextAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
ContextAttributes_compare(PyObject *v, PyObject *w)
{
    ContextAttributes *a = ((ContextAttributesObject *)v)->data;
    ContextAttributes *b = ((ContextAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyContextAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "offset") == 0)
        return ContextAttributes_GetOffset(self, NULL);
    if(strcmp(name, "low") == 0)
        return ContextAttributes_GetLow(self, NULL);
    if(strcmp(name, "hi") == 0)
        return ContextAttributes_GetHi(self, NULL);
    if(strcmp(name, "context") == 0)
        return ContextAttributes_GetContext(self, NULL);
    if(strcmp(name, "cutoff") == 0)
        return ContextAttributes_GetCutoff(self, NULL);
    if(strcmp(name, "below") == 0)
        return ContextAttributes_GetBelow(self, NULL);
    if(strcmp(name, "above") == 0)
        return ContextAttributes_GetAbove(self, NULL);

    return Py_FindMethod(PyContextAttributes_methods, self, name);
}

int
PyContextAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "offset") == 0)
        obj = ContextAttributes_SetOffset(self, tuple);
    else if(strcmp(name, "low") == 0)
        obj = ContextAttributes_SetLow(self, tuple);
    else if(strcmp(name, "hi") == 0)
        obj = ContextAttributes_SetHi(self, tuple);
    else if(strcmp(name, "context") == 0)
        obj = ContextAttributes_SetContext(self, tuple);
    else if(strcmp(name, "cutoff") == 0)
        obj = ContextAttributes_SetCutoff(self, tuple);
    else if(strcmp(name, "below") == 0)
        obj = ContextAttributes_SetBelow(self, tuple);
    else if(strcmp(name, "above") == 0)
        obj = ContextAttributes_SetAbove(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
ContextAttributes_print(PyObject *v, FILE *fp, int flags)
{
    ContextAttributesObject *obj = (ContextAttributesObject *)v;
    fprintf(fp, "%s", PyContextAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
ContextAttributes_str(PyObject *v)
{
    ContextAttributesObject *obj = (ContextAttributesObject *)v;
    return PyString_FromString(PyContextAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *ContextAttributes_Purpose = "This class contains attributes for the context operator.";
#else
static char *ContextAttributes_Purpose = "This class contains attributes for the context operator.";
#endif

//
// The type description structure
//
static PyTypeObject ContextAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "ContextAttributes",                    // tp_name
    sizeof(ContextAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)ContextAttributes_dealloc,  // tp_dealloc
    (printfunc)ContextAttributes_print,     // tp_print
    (getattrfunc)PyContextAttributes_getattr, // tp_getattr
    (setattrfunc)PyContextAttributes_setattr, // tp_setattr
    (cmpfunc)ContextAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)ContextAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    ContextAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static ContextAttributes *defaultAtts = 0;
static ContextAttributes *currentAtts = 0;

static PyObject *
NewContextAttributes(int useCurrent)
{
    ContextAttributesObject *newObject;
    newObject = PyObject_NEW(ContextAttributesObject, &ContextAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new ContextAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new ContextAttributes(*defaultAtts);
    else
        newObject->data = new ContextAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapContextAttributes(const ContextAttributes *attr)
{
    ContextAttributesObject *newObject;
    newObject = PyObject_NEW(ContextAttributesObject, &ContextAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (ContextAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
ContextAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewContextAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef ContextAttributesMethods[] = {
    {"ContextAttributes", ContextAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *ContextAttributesObserver = 0;

std::string
PyContextAttributes_GetLogString()
{
    std::string s("ContextAtts = ContextAttributes()\n");
    if(currentAtts != 0)
        s += PyContextAttributes_ToString(currentAtts, "ContextAtts.");
    return s;
}

static void
PyContextAttributes_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("ContextAtts = ContextAttributes()\n");
        s += PyContextAttributes_ToString(currentAtts, "ContextAtts.");
        cb(s);
    }
}

void
PyContextAttributes_StartUp(ContextAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyContextAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(ContextAttributesObserver == 0)
    {
        ContextAttributesObserver = new ObserverToCallback(subj,
            PyContextAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyContextAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete ContextAttributesObserver;
    ContextAttributesObserver = 0;
}

PyMethodDef *
PyContextAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return ContextAttributesMethods;
}

bool
PyContextAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &ContextAttributesType);
}

ContextAttributes *
PyContextAttributes_FromPyObject(PyObject *obj)
{
    ContextAttributesObject *obj2 = (ContextAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyContextAttributes_New()
{
    return NewContextAttributes(0);
}

PyObject *
PyContextAttributes_Wrap(const ContextAttributes *attr)
{
    return WrapContextAttributes(attr);
}

void
PyContextAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    ContextAttributesObject *obj2 = (ContextAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyContextAttributes_SetDefaults(const ContextAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new ContextAttributes(*atts);
}

