// ***************************************************************************
//
// Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
// Produced at the Lawrence Livermore National Laboratory
// LLNL-CODE-442911
// All rights reserved.
//
// This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
// full copyright notice is contained in the file COPYRIGHT located at the root
// of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
//
// Redistribution  and  use  in  source  and  binary  forms,  with  or  without
// modification, are permitted provided that the following conditions are met:
//
//  - Redistributions of  source code must  retain the above  copyright notice,
//    this list of conditions and the disclaimer below.
//  - Redistributions in binary form must reproduce the above copyright notice,
//    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
//    documentation and/or other materials provided with the distribution.
//  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
//    be used to endorse or promote products derived from this software without
//    specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
// ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
// LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
// DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
// SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
// CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
// LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
// OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
// DAMAGE.
//
// ***************************************************************************

package llnl.visit;


// ****************************************************************************
// Class: CinemaAttributes
//
// Purpose:
//    This class contains the attributes used for saving Cinema
//
// Notes:      Autogenerated by xml2java.
//
// Programmer: xml2java
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

public class CinemaAttributes extends AttributeSubject
{
    private static int CinemaAttributes_numAdditionalAtts = 14;

    public CinemaAttributes()
    {
        super(CinemaAttributes_numAdditionalAtts);

        specification = new String("A");
        fileName = new String("visit.cdb");
        cameraMode = new String("phi-theta");
        theta = 7;
        phi = 12;
        roll = 1;
        format = new String("png");
        composite = false;
        useScreenCapture = false;
        width = 600;
        height = 600;
        frameStart = 0;
        frameEnd = -1;
        frameStride = 1;
    }

    public CinemaAttributes(int nMoreFields)
    {
        super(CinemaAttributes_numAdditionalAtts + nMoreFields);

        specification = new String("A");
        fileName = new String("visit.cdb");
        cameraMode = new String("phi-theta");
        theta = 7;
        phi = 12;
        roll = 1;
        format = new String("png");
        composite = false;
        useScreenCapture = false;
        width = 600;
        height = 600;
        frameStart = 0;
        frameEnd = -1;
        frameStride = 1;
    }

    public CinemaAttributes(CinemaAttributes obj)
    {
        super(obj);

        specification = new String(obj.specification);
        fileName = new String(obj.fileName);
        cameraMode = new String(obj.cameraMode);
        theta = obj.theta;
        phi = obj.phi;
        roll = obj.roll;
        format = new String(obj.format);
        composite = obj.composite;
        useScreenCapture = obj.useScreenCapture;
        width = obj.width;
        height = obj.height;
        frameStart = obj.frameStart;
        frameEnd = obj.frameEnd;
        frameStride = obj.frameStride;

        SelectAll();
    }

    public int Offset()
    {
        return super.Offset() + super.GetNumAdditionalAttributes();
    }

    public int GetNumAdditionalAttributes()
    {
        return CinemaAttributes_numAdditionalAtts;
    }

    public boolean equals(CinemaAttributes obj)
    {
        // Create the return value
        return ((specification.equals(obj.specification)) &&
                (fileName.equals(obj.fileName)) &&
                (cameraMode.equals(obj.cameraMode)) &&
                (theta == obj.theta) &&
                (phi == obj.phi) &&
                (roll == obj.roll) &&
                (format.equals(obj.format)) &&
                (composite == obj.composite) &&
                (useScreenCapture == obj.useScreenCapture) &&
                (width == obj.width) &&
                (height == obj.height) &&
                (frameStart == obj.frameStart) &&
                (frameEnd == obj.frameEnd) &&
                (frameStride == obj.frameStride));
    }

    // Property setting methods
    public void SetSpecification(String specification_)
    {
        specification = specification_;
        Select(0);
    }

    public void SetFileName(String fileName_)
    {
        fileName = fileName_;
        Select(1);
    }

    public void SetCameraMode(String cameraMode_)
    {
        cameraMode = cameraMode_;
        Select(2);
    }

    public void SetTheta(int theta_)
    {
        theta = theta_;
        Select(3);
    }

    public void SetPhi(int phi_)
    {
        phi = phi_;
        Select(4);
    }

    public void SetRoll(int roll_)
    {
        roll = roll_;
        Select(5);
    }

    public void SetFormat(String format_)
    {
        format = format_;
        Select(6);
    }

    public void SetComposite(boolean composite_)
    {
        composite = composite_;
        Select(7);
    }

    public void SetUseScreenCapture(boolean useScreenCapture_)
    {
        useScreenCapture = useScreenCapture_;
        Select(8);
    }

    public void SetWidth(int width_)
    {
        width = width_;
        Select(9);
    }

    public void SetHeight(int height_)
    {
        height = height_;
        Select(10);
    }

    public void SetFrameStart(int frameStart_)
    {
        frameStart = frameStart_;
        Select(11);
    }

    public void SetFrameEnd(int frameEnd_)
    {
        frameEnd = frameEnd_;
        Select(12);
    }

    public void SetFrameStride(int frameStride_)
    {
        frameStride = frameStride_;
        Select(13);
    }

    // Property getting methods
    public String  GetSpecification() { return specification; }
    public String  GetFileName() { return fileName; }
    public String  GetCameraMode() { return cameraMode; }
    public int     GetTheta() { return theta; }
    public int     GetPhi() { return phi; }
    public int     GetRoll() { return roll; }
    public String  GetFormat() { return format; }
    public boolean GetComposite() { return composite; }
    public boolean GetUseScreenCapture() { return useScreenCapture; }
    public int     GetWidth() { return width; }
    public int     GetHeight() { return height; }
    public int     GetFrameStart() { return frameStart; }
    public int     GetFrameEnd() { return frameEnd; }
    public int     GetFrameStride() { return frameStride; }

    // Write and read methods.
    public void WriteAtts(CommunicationBuffer buf)
    {
        if(WriteSelect(0, buf))
            buf.WriteString(specification);
        if(WriteSelect(1, buf))
            buf.WriteString(fileName);
        if(WriteSelect(2, buf))
            buf.WriteString(cameraMode);
        if(WriteSelect(3, buf))
            buf.WriteInt(theta);
        if(WriteSelect(4, buf))
            buf.WriteInt(phi);
        if(WriteSelect(5, buf))
            buf.WriteInt(roll);
        if(WriteSelect(6, buf))
            buf.WriteString(format);
        if(WriteSelect(7, buf))
            buf.WriteBool(composite);
        if(WriteSelect(8, buf))
            buf.WriteBool(useScreenCapture);
        if(WriteSelect(9, buf))
            buf.WriteInt(width);
        if(WriteSelect(10, buf))
            buf.WriteInt(height);
        if(WriteSelect(11, buf))
            buf.WriteInt(frameStart);
        if(WriteSelect(12, buf))
            buf.WriteInt(frameEnd);
        if(WriteSelect(13, buf))
            buf.WriteInt(frameStride);
    }

    public void ReadAtts(int index, CommunicationBuffer buf)
    {
        switch(index)
        {
        case 0:
            SetSpecification(buf.ReadString());
            break;
        case 1:
            SetFileName(buf.ReadString());
            break;
        case 2:
            SetCameraMode(buf.ReadString());
            break;
        case 3:
            SetTheta(buf.ReadInt());
            break;
        case 4:
            SetPhi(buf.ReadInt());
            break;
        case 5:
            SetRoll(buf.ReadInt());
            break;
        case 6:
            SetFormat(buf.ReadString());
            break;
        case 7:
            SetComposite(buf.ReadBool());
            break;
        case 8:
            SetUseScreenCapture(buf.ReadBool());
            break;
        case 9:
            SetWidth(buf.ReadInt());
            break;
        case 10:
            SetHeight(buf.ReadInt());
            break;
        case 11:
            SetFrameStart(buf.ReadInt());
            break;
        case 12:
            SetFrameEnd(buf.ReadInt());
            break;
        case 13:
            SetFrameStride(buf.ReadInt());
            break;
        }
    }

    public String toString(String indent)
    {
        String str = new String();
        str = str + stringToString("specification", specification, indent) + "\n";
        str = str + stringToString("fileName", fileName, indent) + "\n";
        str = str + stringToString("cameraMode", cameraMode, indent) + "\n";
        str = str + intToString("theta", theta, indent) + "\n";
        str = str + intToString("phi", phi, indent) + "\n";
        str = str + intToString("roll", roll, indent) + "\n";
        str = str + stringToString("format", format, indent) + "\n";
        str = str + boolToString("composite", composite, indent) + "\n";
        str = str + boolToString("useScreenCapture", useScreenCapture, indent) + "\n";
        str = str + intToString("width", width, indent) + "\n";
        str = str + intToString("height", height, indent) + "\n";
        str = str + intToString("frameStart", frameStart, indent) + "\n";
        str = str + intToString("frameEnd", frameEnd, indent) + "\n";
        str = str + intToString("frameStride", frameStride, indent) + "\n";
        return str;
    }


    // Attributes
    private String  specification;
    private String  fileName;
    private String  cameraMode;
    private int     theta;
    private int     phi;
    private int     roll;
    private String  format;
    private boolean composite;
    private boolean useScreenCapture;
    private int     width;
    private int     height;
    private int     frameStart;
    private int     frameEnd;
    private int     frameStride;
}

