/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

// ************************************************************************* //
//                              avtVTKOptions.C                              //
// ************************************************************************* //

#include <avtVTKOptions.h>

#include <DBOptionsAttributes.h>

#include <string>
#include <vector>

using std::string;
using std::vector;

// ****************************************************************************
//  Function: GetVTKReadOptions
//
//  Purpose:
//      Creates the options for VTK readers.
//
//  Important Note:
//      The code below sets up empty options.  If your format 
//      does not require read options, no modifications are 
//      necessary.
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   Tue May 24 16:43:26 PST 2005
//
// ****************************************************************************

DBOptionsAttributes *
GetVTKReadOptions(void)
{
    DBOptionsAttributes *rv = new DBOptionsAttributes;
    return rv;
}


// ****************************************************************************
//  Function: GetVTKWriteOptions
//
//  Purpose:
//      Creates the options for VTK writers.
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   Tue May 24 16:43:26 PST 2005
//
//  Modifications:
//    Kathleen Biagas, Thu Dec 18 14:51:46 PST 2014
//    Added "XML Format".
//
//    Kathleen Biagas, Fri Feb 17 15:50:34 PST 2017
//    New options so as to be more explicit.
//
// ****************************************************************************

DBOptionsAttributes *
GetVTKWriteOptions(void)
{
    DBOptionsAttributes *rv = new DBOptionsAttributes;
    vector<string> fileFormat;
    fileFormat.push_back("Legacy Ascii");
    fileFormat.push_back("Legacy Binary");
    fileFormat.push_back("XML Ascii");
    fileFormat.push_back("XML Binary");
    rv->SetEnum("FileFormat", 0);
    rv->SetEnumStrings("FileFormat", fileFormat);

    rv->SetObsolete("Binary format");
    rv->SetObsolete("XML format");

    return rv;
}
