/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PySeedMeAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>

// ****************************************************************************
// Module: PySeedMeAttributes
//
// Purpose: 
//   This class contains the attributes needed to interact with SeedMe.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a SeedMeAttributes.
//
struct SeedMeAttributesObject
{
    PyObject_HEAD
    SeedMeAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewSeedMeAttributes(int);

std::string
PySeedMeAttributes_ToString(const SeedMeAttributes *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    const char *collectionMode_names = "COLLECTION_NEW, COLLECTION_UPDATE";
    switch (atts->GetCollectionMode())
    {
      case SeedMeAttributes::COLLECTION_NEW:
          SNPRINTF(tmpStr, 1000, "%scollectionMode = %sCOLLECTION_NEW  # %s\n", prefix, prefix, collectionMode_names);
          str += tmpStr;
          break;
      case SeedMeAttributes::COLLECTION_UPDATE:
          SNPRINTF(tmpStr, 1000, "%scollectionMode = %sCOLLECTION_UPDATE  # %s\n", prefix, prefix, collectionMode_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    SNPRINTF(tmpStr, 1000, "%scollectionID = %d\n", prefix, atts->GetCollectionID());
    str += tmpStr;
    const char *sharing_names = "SHARING_PRIVATE, SHARING_GROUP, SHARING_PUBLIC";
    switch (atts->GetSharing())
    {
      case SeedMeAttributes::SHARING_PRIVATE:
          SNPRINTF(tmpStr, 1000, "%ssharing = %sSHARING_PRIVATE  # %s\n", prefix, prefix, sharing_names);
          str += tmpStr;
          break;
      case SeedMeAttributes::SHARING_GROUP:
          SNPRINTF(tmpStr, 1000, "%ssharing = %sSHARING_GROUP  # %s\n", prefix, prefix, sharing_names);
          str += tmpStr;
          break;
      case SeedMeAttributes::SHARING_PUBLIC:
          SNPRINTF(tmpStr, 1000, "%ssharing = %sSHARING_PUBLIC  # %s\n", prefix, prefix, sharing_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    SNPRINTF(tmpStr, 1000, "%scollectionTitle = \"%s\"\n", prefix, atts->GetCollectionTitle().c_str());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%scollectionDescription = \"%s\"\n", prefix, atts->GetCollectionDescription().c_str());
    str += tmpStr;
    if(atts->GetOverwriteFiles())
        SNPRINTF(tmpStr, 1000, "%soverwriteFiles = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%soverwriteFiles = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%skeyValue = \"%s\"\n", prefix, atts->GetKeyValue().c_str());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%scollectionEmails = \"%s\"\n", prefix, atts->GetCollectionEmails().c_str());
    str += tmpStr;
    if(atts->GetUploadCurrentFile())
        SNPRINTF(tmpStr, 1000, "%suploadCurrentFile = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%suploadCurrentFile = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%scurrentTitle = \"%s\"\n", prefix, atts->GetCurrentTitle().c_str());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%scurrentDescription = \"%s\"\n", prefix, atts->GetCurrentDescription().c_str());
    str += tmpStr;
    if(atts->GetUploadSequenceFile())
        SNPRINTF(tmpStr, 1000, "%suploadSequenceFile = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%suploadSequenceFile = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%ssequenceTitle = \"%s\"\n", prefix, atts->GetSequenceTitle().c_str());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%ssequenceDescription = \"%s\"\n", prefix, atts->GetSequenceDescription().c_str());
    str += tmpStr;
    if(atts->GetCreateVideo())
        SNPRINTF(tmpStr, 1000, "%screateVideo = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%screateVideo = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sframeRate = %d\n", prefix, atts->GetFrameRate());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%soperationResult = \"%s\"\n", prefix, atts->GetOperationResult().c_str());
    str += tmpStr;
    const char *queryAction_names = "LIST_COL, FIND_COL, QUERY_COL";
    switch (atts->GetQueryAction())
    {
      case SeedMeAttributes::LIST_COL:
          SNPRINTF(tmpStr, 1000, "%squeryAction = %sLIST_COL  # %s\n", prefix, prefix, queryAction_names);
          str += tmpStr;
          break;
      case SeedMeAttributes::FIND_COL:
          SNPRINTF(tmpStr, 1000, "%squeryAction = %sFIND_COL  # %s\n", prefix, prefix, queryAction_names);
          str += tmpStr;
          break;
      case SeedMeAttributes::QUERY_COL:
          SNPRINTF(tmpStr, 1000, "%squeryAction = %sQUERY_COL  # %s\n", prefix, prefix, queryAction_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    SNPRINTF(tmpStr, 1000, "%squeryColID = \"%s\"\n", prefix, atts->GetQueryColID().c_str());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%squeryKeyValue = \"%s\"\n", prefix, atts->GetQueryKeyValue().c_str());
    str += tmpStr;
    const char *queryCollectionValues_names = "QUERY_ALL, QUERY_KEY_VALUE, QUERY_TICKER, QUERY_URL";
    switch (atts->GetQueryCollectionValues())
    {
      case SeedMeAttributes::QUERY_ALL:
          SNPRINTF(tmpStr, 1000, "%squeryCollectionValues = %sQUERY_ALL  # %s\n", prefix, prefix, queryCollectionValues_names);
          str += tmpStr;
          break;
      case SeedMeAttributes::QUERY_KEY_VALUE:
          SNPRINTF(tmpStr, 1000, "%squeryCollectionValues = %sQUERY_KEY_VALUE  # %s\n", prefix, prefix, queryCollectionValues_names);
          str += tmpStr;
          break;
      case SeedMeAttributes::QUERY_TICKER:
          SNPRINTF(tmpStr, 1000, "%squeryCollectionValues = %sQUERY_TICKER  # %s\n", prefix, prefix, queryCollectionValues_names);
          str += tmpStr;
          break;
      case SeedMeAttributes::QUERY_URL:
          SNPRINTF(tmpStr, 1000, "%squeryCollectionValues = %sQUERY_URL  # %s\n", prefix, prefix, queryCollectionValues_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    SNPRINTF(tmpStr, 1000, "%sdownloadCollectionID = %d\n", prefix, atts->GetDownloadCollectionID());
    str += tmpStr;
    const char *downloadType_names = "DOWNLOAD_ALL, DOWNLOAD_VIDEO, DOWNLOAD_NAME";
    switch (atts->GetDownloadType())
    {
      case SeedMeAttributes::DOWNLOAD_ALL:
          SNPRINTF(tmpStr, 1000, "%sdownloadType = %sDOWNLOAD_ALL  # %s\n", prefix, prefix, downloadType_names);
          str += tmpStr;
          break;
      case SeedMeAttributes::DOWNLOAD_VIDEO:
          SNPRINTF(tmpStr, 1000, "%sdownloadType = %sDOWNLOAD_VIDEO  # %s\n", prefix, prefix, downloadType_names);
          str += tmpStr;
          break;
      case SeedMeAttributes::DOWNLOAD_NAME:
          SNPRINTF(tmpStr, 1000, "%sdownloadType = %sDOWNLOAD_NAME  # %s\n", prefix, prefix, downloadType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    SNPRINTF(tmpStr, 1000, "%sdownloadName = \"%s\"\n", prefix, atts->GetDownloadName().c_str());
    str += tmpStr;
    const char *quickSharing_names = "SHARING_PRIVATE, SHARING_GROUP, SHARING_PUBLIC";
    switch (atts->GetQuickSharing())
    {
      case SeedMeAttributes::SHARING_PRIVATE:
          SNPRINTF(tmpStr, 1000, "%squickSharing = %sSHARING_PRIVATE  # %s\n", prefix, prefix, quickSharing_names);
          str += tmpStr;
          break;
      case SeedMeAttributes::SHARING_GROUP:
          SNPRINTF(tmpStr, 1000, "%squickSharing = %sSHARING_GROUP  # %s\n", prefix, prefix, quickSharing_names);
          str += tmpStr;
          break;
      case SeedMeAttributes::SHARING_PUBLIC:
          SNPRINTF(tmpStr, 1000, "%squickSharing = %sSHARING_PUBLIC  # %s\n", prefix, prefix, quickSharing_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    SNPRINTF(tmpStr, 1000, "%squickCollectionTitle = \"%s\"\n", prefix, atts->GetQuickCollectionTitle().c_str());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%squickCollectionEmails = \"%s\"\n", prefix, atts->GetQuickCollectionEmails().c_str());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%squickFrameRate = %d\n", prefix, atts->GetQuickFrameRate());
    str += tmpStr;
    const char *quickDownloadType_names = "DOWNLOAD_Q_ALL, DOWNLOAD_Q_BEST, DOWNLOAD_Q_HIGHEST, DOWNLOAD_Q_HIGH, DOWNLOAD_Q_MEDIUM, "
        "DOWNLOAD_Q_LOW, DOWNLOAD_Q_LOWEST";
    switch (atts->GetQuickDownloadType())
    {
      case SeedMeAttributes::DOWNLOAD_Q_ALL:
          SNPRINTF(tmpStr, 1000, "%squickDownloadType = %sDOWNLOAD_Q_ALL  # %s\n", prefix, prefix, quickDownloadType_names);
          str += tmpStr;
          break;
      case SeedMeAttributes::DOWNLOAD_Q_BEST:
          SNPRINTF(tmpStr, 1000, "%squickDownloadType = %sDOWNLOAD_Q_BEST  # %s\n", prefix, prefix, quickDownloadType_names);
          str += tmpStr;
          break;
      case SeedMeAttributes::DOWNLOAD_Q_HIGHEST:
          SNPRINTF(tmpStr, 1000, "%squickDownloadType = %sDOWNLOAD_Q_HIGHEST  # %s\n", prefix, prefix, quickDownloadType_names);
          str += tmpStr;
          break;
      case SeedMeAttributes::DOWNLOAD_Q_HIGH:
          SNPRINTF(tmpStr, 1000, "%squickDownloadType = %sDOWNLOAD_Q_HIGH  # %s\n", prefix, prefix, quickDownloadType_names);
          str += tmpStr;
          break;
      case SeedMeAttributes::DOWNLOAD_Q_MEDIUM:
          SNPRINTF(tmpStr, 1000, "%squickDownloadType = %sDOWNLOAD_Q_MEDIUM  # %s\n", prefix, prefix, quickDownloadType_names);
          str += tmpStr;
          break;
      case SeedMeAttributes::DOWNLOAD_Q_LOW:
          SNPRINTF(tmpStr, 1000, "%squickDownloadType = %sDOWNLOAD_Q_LOW  # %s\n", prefix, prefix, quickDownloadType_names);
          str += tmpStr;
          break;
      case SeedMeAttributes::DOWNLOAD_Q_LOWEST:
          SNPRINTF(tmpStr, 1000, "%squickDownloadType = %sDOWNLOAD_Q_LOWEST  # %s\n", prefix, prefix, quickDownloadType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    if(atts->GetClearAllTabsOnClose())
        SNPRINTF(tmpStr, 1000, "%sclearAllTabsOnClose = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sclearAllTabsOnClose = 0\n", prefix);
    str += tmpStr;
    return str;
}

static PyObject *
SeedMeAttributes_Notify(PyObject *self, PyObject *args)
{
    SeedMeAttributesObject *obj = (SeedMeAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SeedMeAttributes_SetCollectionMode(PyObject *self, PyObject *args)
{
    SeedMeAttributesObject *obj = (SeedMeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the collectionMode in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetCollectionMode(SeedMeAttributes::CollectionMode(ival));
    else
    {
        fprintf(stderr, "An invalid collectionMode value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "COLLECTION_NEW, COLLECTION_UPDATE.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SeedMeAttributes_GetCollectionMode(PyObject *self, PyObject *args)
{
    SeedMeAttributesObject *obj = (SeedMeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetCollectionMode()));
    return retval;
}

/*static*/ PyObject *
SeedMeAttributes_SetCollectionID(PyObject *self, PyObject *args)
{
    SeedMeAttributesObject *obj = (SeedMeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the collectionID in the object.
    obj->data->SetCollectionID((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SeedMeAttributes_GetCollectionID(PyObject *self, PyObject *args)
{
    SeedMeAttributesObject *obj = (SeedMeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetCollectionID()));
    return retval;
}

/*static*/ PyObject *
SeedMeAttributes_SetSharing(PyObject *self, PyObject *args)
{
    SeedMeAttributesObject *obj = (SeedMeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the sharing in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetSharing(SeedMeAttributes::Sharing(ival));
    else
    {
        fprintf(stderr, "An invalid sharing value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "SHARING_PRIVATE, SHARING_GROUP, SHARING_PUBLIC.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SeedMeAttributes_GetSharing(PyObject *self, PyObject *args)
{
    SeedMeAttributesObject *obj = (SeedMeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetSharing()));
    return retval;
}

/*static*/ PyObject *
SeedMeAttributes_SetCollectionTitle(PyObject *self, PyObject *args)
{
    SeedMeAttributesObject *obj = (SeedMeAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the collectionTitle in the object.
    obj->data->SetCollectionTitle(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SeedMeAttributes_GetCollectionTitle(PyObject *self, PyObject *args)
{
    SeedMeAttributesObject *obj = (SeedMeAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetCollectionTitle().c_str());
    return retval;
}

/*static*/ PyObject *
SeedMeAttributes_SetCollectionDescription(PyObject *self, PyObject *args)
{
    SeedMeAttributesObject *obj = (SeedMeAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the collectionDescription in the object.
    obj->data->SetCollectionDescription(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SeedMeAttributes_GetCollectionDescription(PyObject *self, PyObject *args)
{
    SeedMeAttributesObject *obj = (SeedMeAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetCollectionDescription().c_str());
    return retval;
}

/*static*/ PyObject *
SeedMeAttributes_SetOverwriteFiles(PyObject *self, PyObject *args)
{
    SeedMeAttributesObject *obj = (SeedMeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the overwriteFiles in the object.
    obj->data->SetOverwriteFiles(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SeedMeAttributes_GetOverwriteFiles(PyObject *self, PyObject *args)
{
    SeedMeAttributesObject *obj = (SeedMeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetOverwriteFiles()?1L:0L);
    return retval;
}

/*static*/ PyObject *
SeedMeAttributes_SetKeyValue(PyObject *self, PyObject *args)
{
    SeedMeAttributesObject *obj = (SeedMeAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the keyValue in the object.
    obj->data->SetKeyValue(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SeedMeAttributes_GetKeyValue(PyObject *self, PyObject *args)
{
    SeedMeAttributesObject *obj = (SeedMeAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetKeyValue().c_str());
    return retval;
}

/*static*/ PyObject *
SeedMeAttributes_SetCollectionEmails(PyObject *self, PyObject *args)
{
    SeedMeAttributesObject *obj = (SeedMeAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the collectionEmails in the object.
    obj->data->SetCollectionEmails(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SeedMeAttributes_GetCollectionEmails(PyObject *self, PyObject *args)
{
    SeedMeAttributesObject *obj = (SeedMeAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetCollectionEmails().c_str());
    return retval;
}

/*static*/ PyObject *
SeedMeAttributes_SetUploadCurrentFile(PyObject *self, PyObject *args)
{
    SeedMeAttributesObject *obj = (SeedMeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the uploadCurrentFile in the object.
    obj->data->SetUploadCurrentFile(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SeedMeAttributes_GetUploadCurrentFile(PyObject *self, PyObject *args)
{
    SeedMeAttributesObject *obj = (SeedMeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetUploadCurrentFile()?1L:0L);
    return retval;
}

/*static*/ PyObject *
SeedMeAttributes_SetCurrentTitle(PyObject *self, PyObject *args)
{
    SeedMeAttributesObject *obj = (SeedMeAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the currentTitle in the object.
    obj->data->SetCurrentTitle(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SeedMeAttributes_GetCurrentTitle(PyObject *self, PyObject *args)
{
    SeedMeAttributesObject *obj = (SeedMeAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetCurrentTitle().c_str());
    return retval;
}

/*static*/ PyObject *
SeedMeAttributes_SetCurrentDescription(PyObject *self, PyObject *args)
{
    SeedMeAttributesObject *obj = (SeedMeAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the currentDescription in the object.
    obj->data->SetCurrentDescription(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SeedMeAttributes_GetCurrentDescription(PyObject *self, PyObject *args)
{
    SeedMeAttributesObject *obj = (SeedMeAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetCurrentDescription().c_str());
    return retval;
}

/*static*/ PyObject *
SeedMeAttributes_SetUploadSequenceFile(PyObject *self, PyObject *args)
{
    SeedMeAttributesObject *obj = (SeedMeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the uploadSequenceFile in the object.
    obj->data->SetUploadSequenceFile(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SeedMeAttributes_GetUploadSequenceFile(PyObject *self, PyObject *args)
{
    SeedMeAttributesObject *obj = (SeedMeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetUploadSequenceFile()?1L:0L);
    return retval;
}

/*static*/ PyObject *
SeedMeAttributes_SetSequenceTitle(PyObject *self, PyObject *args)
{
    SeedMeAttributesObject *obj = (SeedMeAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the sequenceTitle in the object.
    obj->data->SetSequenceTitle(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SeedMeAttributes_GetSequenceTitle(PyObject *self, PyObject *args)
{
    SeedMeAttributesObject *obj = (SeedMeAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetSequenceTitle().c_str());
    return retval;
}

/*static*/ PyObject *
SeedMeAttributes_SetSequenceDescription(PyObject *self, PyObject *args)
{
    SeedMeAttributesObject *obj = (SeedMeAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the sequenceDescription in the object.
    obj->data->SetSequenceDescription(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SeedMeAttributes_GetSequenceDescription(PyObject *self, PyObject *args)
{
    SeedMeAttributesObject *obj = (SeedMeAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetSequenceDescription().c_str());
    return retval;
}

/*static*/ PyObject *
SeedMeAttributes_SetCreateVideo(PyObject *self, PyObject *args)
{
    SeedMeAttributesObject *obj = (SeedMeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the createVideo in the object.
    obj->data->SetCreateVideo(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SeedMeAttributes_GetCreateVideo(PyObject *self, PyObject *args)
{
    SeedMeAttributesObject *obj = (SeedMeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetCreateVideo()?1L:0L);
    return retval;
}

/*static*/ PyObject *
SeedMeAttributes_SetFrameRate(PyObject *self, PyObject *args)
{
    SeedMeAttributesObject *obj = (SeedMeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the frameRate in the object.
    obj->data->SetFrameRate((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SeedMeAttributes_GetFrameRate(PyObject *self, PyObject *args)
{
    SeedMeAttributesObject *obj = (SeedMeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetFrameRate()));
    return retval;
}

/*static*/ PyObject *
SeedMeAttributes_SetOperationResult(PyObject *self, PyObject *args)
{
    SeedMeAttributesObject *obj = (SeedMeAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the operationResult in the object.
    obj->data->SetOperationResult(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SeedMeAttributes_GetOperationResult(PyObject *self, PyObject *args)
{
    SeedMeAttributesObject *obj = (SeedMeAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetOperationResult().c_str());
    return retval;
}

/*static*/ PyObject *
SeedMeAttributes_SetQueryAction(PyObject *self, PyObject *args)
{
    SeedMeAttributesObject *obj = (SeedMeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the queryAction in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetQueryAction(SeedMeAttributes::QueryAction(ival));
    else
    {
        fprintf(stderr, "An invalid queryAction value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "LIST_COL, FIND_COL, QUERY_COL.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SeedMeAttributes_GetQueryAction(PyObject *self, PyObject *args)
{
    SeedMeAttributesObject *obj = (SeedMeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetQueryAction()));
    return retval;
}

/*static*/ PyObject *
SeedMeAttributes_SetQueryColID(PyObject *self, PyObject *args)
{
    SeedMeAttributesObject *obj = (SeedMeAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the queryColID in the object.
    obj->data->SetQueryColID(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SeedMeAttributes_GetQueryColID(PyObject *self, PyObject *args)
{
    SeedMeAttributesObject *obj = (SeedMeAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetQueryColID().c_str());
    return retval;
}

/*static*/ PyObject *
SeedMeAttributes_SetQueryKeyValue(PyObject *self, PyObject *args)
{
    SeedMeAttributesObject *obj = (SeedMeAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the queryKeyValue in the object.
    obj->data->SetQueryKeyValue(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SeedMeAttributes_GetQueryKeyValue(PyObject *self, PyObject *args)
{
    SeedMeAttributesObject *obj = (SeedMeAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetQueryKeyValue().c_str());
    return retval;
}

/*static*/ PyObject *
SeedMeAttributes_SetQueryCollectionValues(PyObject *self, PyObject *args)
{
    SeedMeAttributesObject *obj = (SeedMeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the queryCollectionValues in the object.
    if(ival >= 0 && ival < 4)
        obj->data->SetQueryCollectionValues(SeedMeAttributes::QueryCollectionValues(ival));
    else
    {
        fprintf(stderr, "An invalid queryCollectionValues value was given. "
                        "Valid values are in the range of [0,3]. "
                        "You can also use the following names: "
                        "QUERY_ALL, QUERY_KEY_VALUE, QUERY_TICKER, QUERY_URL.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SeedMeAttributes_GetQueryCollectionValues(PyObject *self, PyObject *args)
{
    SeedMeAttributesObject *obj = (SeedMeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetQueryCollectionValues()));
    return retval;
}

/*static*/ PyObject *
SeedMeAttributes_SetDownloadCollectionID(PyObject *self, PyObject *args)
{
    SeedMeAttributesObject *obj = (SeedMeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the downloadCollectionID in the object.
    obj->data->SetDownloadCollectionID((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SeedMeAttributes_GetDownloadCollectionID(PyObject *self, PyObject *args)
{
    SeedMeAttributesObject *obj = (SeedMeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetDownloadCollectionID()));
    return retval;
}

/*static*/ PyObject *
SeedMeAttributes_SetDownloadType(PyObject *self, PyObject *args)
{
    SeedMeAttributesObject *obj = (SeedMeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the downloadType in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetDownloadType(SeedMeAttributes::Download(ival));
    else
    {
        fprintf(stderr, "An invalid downloadType value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "DOWNLOAD_ALL, DOWNLOAD_VIDEO, DOWNLOAD_NAME.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SeedMeAttributes_GetDownloadType(PyObject *self, PyObject *args)
{
    SeedMeAttributesObject *obj = (SeedMeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetDownloadType()));
    return retval;
}

/*static*/ PyObject *
SeedMeAttributes_SetDownloadName(PyObject *self, PyObject *args)
{
    SeedMeAttributesObject *obj = (SeedMeAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the downloadName in the object.
    obj->data->SetDownloadName(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SeedMeAttributes_GetDownloadName(PyObject *self, PyObject *args)
{
    SeedMeAttributesObject *obj = (SeedMeAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetDownloadName().c_str());
    return retval;
}

/*static*/ PyObject *
SeedMeAttributes_SetQuickSharing(PyObject *self, PyObject *args)
{
    SeedMeAttributesObject *obj = (SeedMeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the quickSharing in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetQuickSharing(SeedMeAttributes::Sharing(ival));
    else
    {
        fprintf(stderr, "An invalid quickSharing value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "SHARING_PRIVATE, SHARING_GROUP, SHARING_PUBLIC.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SeedMeAttributes_GetQuickSharing(PyObject *self, PyObject *args)
{
    SeedMeAttributesObject *obj = (SeedMeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetQuickSharing()));
    return retval;
}

/*static*/ PyObject *
SeedMeAttributes_SetQuickCollectionTitle(PyObject *self, PyObject *args)
{
    SeedMeAttributesObject *obj = (SeedMeAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the quickCollectionTitle in the object.
    obj->data->SetQuickCollectionTitle(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SeedMeAttributes_GetQuickCollectionTitle(PyObject *self, PyObject *args)
{
    SeedMeAttributesObject *obj = (SeedMeAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetQuickCollectionTitle().c_str());
    return retval;
}

/*static*/ PyObject *
SeedMeAttributes_SetQuickCollectionEmails(PyObject *self, PyObject *args)
{
    SeedMeAttributesObject *obj = (SeedMeAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the quickCollectionEmails in the object.
    obj->data->SetQuickCollectionEmails(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SeedMeAttributes_GetQuickCollectionEmails(PyObject *self, PyObject *args)
{
    SeedMeAttributesObject *obj = (SeedMeAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetQuickCollectionEmails().c_str());
    return retval;
}

/*static*/ PyObject *
SeedMeAttributes_SetQuickFrameRate(PyObject *self, PyObject *args)
{
    SeedMeAttributesObject *obj = (SeedMeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the quickFrameRate in the object.
    obj->data->SetQuickFrameRate((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SeedMeAttributes_GetQuickFrameRate(PyObject *self, PyObject *args)
{
    SeedMeAttributesObject *obj = (SeedMeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetQuickFrameRate()));
    return retval;
}

/*static*/ PyObject *
SeedMeAttributes_SetQuickDownloadType(PyObject *self, PyObject *args)
{
    SeedMeAttributesObject *obj = (SeedMeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the quickDownloadType in the object.
    if(ival >= 0 && ival < 7)
        obj->data->SetQuickDownloadType(SeedMeAttributes::DownloadQuality(ival));
    else
    {
        fprintf(stderr, "An invalid quickDownloadType value was given. "
                        "Valid values are in the range of [0,6]. "
                        "You can also use the following names: "
                        "DOWNLOAD_Q_ALL, DOWNLOAD_Q_BEST, DOWNLOAD_Q_HIGHEST, DOWNLOAD_Q_HIGH, DOWNLOAD_Q_MEDIUM, "
                        "DOWNLOAD_Q_LOW, DOWNLOAD_Q_LOWEST.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SeedMeAttributes_GetQuickDownloadType(PyObject *self, PyObject *args)
{
    SeedMeAttributesObject *obj = (SeedMeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetQuickDownloadType()));
    return retval;
}

/*static*/ PyObject *
SeedMeAttributes_SetClearAllTabsOnClose(PyObject *self, PyObject *args)
{
    SeedMeAttributesObject *obj = (SeedMeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the clearAllTabsOnClose in the object.
    obj->data->SetClearAllTabsOnClose(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SeedMeAttributes_GetClearAllTabsOnClose(PyObject *self, PyObject *args)
{
    SeedMeAttributesObject *obj = (SeedMeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetClearAllTabsOnClose()?1L:0L);
    return retval;
}



PyMethodDef PySeedMeAttributes_methods[SEEDMEATTRIBUTES_NMETH] = {
    {"Notify", SeedMeAttributes_Notify, METH_VARARGS},
    {"SetCollectionMode", SeedMeAttributes_SetCollectionMode, METH_VARARGS},
    {"GetCollectionMode", SeedMeAttributes_GetCollectionMode, METH_VARARGS},
    {"SetCollectionID", SeedMeAttributes_SetCollectionID, METH_VARARGS},
    {"GetCollectionID", SeedMeAttributes_GetCollectionID, METH_VARARGS},
    {"SetSharing", SeedMeAttributes_SetSharing, METH_VARARGS},
    {"GetSharing", SeedMeAttributes_GetSharing, METH_VARARGS},
    {"SetCollectionTitle", SeedMeAttributes_SetCollectionTitle, METH_VARARGS},
    {"GetCollectionTitle", SeedMeAttributes_GetCollectionTitle, METH_VARARGS},
    {"SetCollectionDescription", SeedMeAttributes_SetCollectionDescription, METH_VARARGS},
    {"GetCollectionDescription", SeedMeAttributes_GetCollectionDescription, METH_VARARGS},
    {"SetOverwriteFiles", SeedMeAttributes_SetOverwriteFiles, METH_VARARGS},
    {"GetOverwriteFiles", SeedMeAttributes_GetOverwriteFiles, METH_VARARGS},
    {"SetKeyValue", SeedMeAttributes_SetKeyValue, METH_VARARGS},
    {"GetKeyValue", SeedMeAttributes_GetKeyValue, METH_VARARGS},
    {"SetCollectionEmails", SeedMeAttributes_SetCollectionEmails, METH_VARARGS},
    {"GetCollectionEmails", SeedMeAttributes_GetCollectionEmails, METH_VARARGS},
    {"SetUploadCurrentFile", SeedMeAttributes_SetUploadCurrentFile, METH_VARARGS},
    {"GetUploadCurrentFile", SeedMeAttributes_GetUploadCurrentFile, METH_VARARGS},
    {"SetCurrentTitle", SeedMeAttributes_SetCurrentTitle, METH_VARARGS},
    {"GetCurrentTitle", SeedMeAttributes_GetCurrentTitle, METH_VARARGS},
    {"SetCurrentDescription", SeedMeAttributes_SetCurrentDescription, METH_VARARGS},
    {"GetCurrentDescription", SeedMeAttributes_GetCurrentDescription, METH_VARARGS},
    {"SetUploadSequenceFile", SeedMeAttributes_SetUploadSequenceFile, METH_VARARGS},
    {"GetUploadSequenceFile", SeedMeAttributes_GetUploadSequenceFile, METH_VARARGS},
    {"SetSequenceTitle", SeedMeAttributes_SetSequenceTitle, METH_VARARGS},
    {"GetSequenceTitle", SeedMeAttributes_GetSequenceTitle, METH_VARARGS},
    {"SetSequenceDescription", SeedMeAttributes_SetSequenceDescription, METH_VARARGS},
    {"GetSequenceDescription", SeedMeAttributes_GetSequenceDescription, METH_VARARGS},
    {"SetCreateVideo", SeedMeAttributes_SetCreateVideo, METH_VARARGS},
    {"GetCreateVideo", SeedMeAttributes_GetCreateVideo, METH_VARARGS},
    {"SetFrameRate", SeedMeAttributes_SetFrameRate, METH_VARARGS},
    {"GetFrameRate", SeedMeAttributes_GetFrameRate, METH_VARARGS},
    {"SetOperationResult", SeedMeAttributes_SetOperationResult, METH_VARARGS},
    {"GetOperationResult", SeedMeAttributes_GetOperationResult, METH_VARARGS},
    {"SetQueryAction", SeedMeAttributes_SetQueryAction, METH_VARARGS},
    {"GetQueryAction", SeedMeAttributes_GetQueryAction, METH_VARARGS},
    {"SetQueryColID", SeedMeAttributes_SetQueryColID, METH_VARARGS},
    {"GetQueryColID", SeedMeAttributes_GetQueryColID, METH_VARARGS},
    {"SetQueryKeyValue", SeedMeAttributes_SetQueryKeyValue, METH_VARARGS},
    {"GetQueryKeyValue", SeedMeAttributes_GetQueryKeyValue, METH_VARARGS},
    {"SetQueryCollectionValues", SeedMeAttributes_SetQueryCollectionValues, METH_VARARGS},
    {"GetQueryCollectionValues", SeedMeAttributes_GetQueryCollectionValues, METH_VARARGS},
    {"SetDownloadCollectionID", SeedMeAttributes_SetDownloadCollectionID, METH_VARARGS},
    {"GetDownloadCollectionID", SeedMeAttributes_GetDownloadCollectionID, METH_VARARGS},
    {"SetDownloadType", SeedMeAttributes_SetDownloadType, METH_VARARGS},
    {"GetDownloadType", SeedMeAttributes_GetDownloadType, METH_VARARGS},
    {"SetDownloadName", SeedMeAttributes_SetDownloadName, METH_VARARGS},
    {"GetDownloadName", SeedMeAttributes_GetDownloadName, METH_VARARGS},
    {"SetQuickSharing", SeedMeAttributes_SetQuickSharing, METH_VARARGS},
    {"GetQuickSharing", SeedMeAttributes_GetQuickSharing, METH_VARARGS},
    {"SetQuickCollectionTitle", SeedMeAttributes_SetQuickCollectionTitle, METH_VARARGS},
    {"GetQuickCollectionTitle", SeedMeAttributes_GetQuickCollectionTitle, METH_VARARGS},
    {"SetQuickCollectionEmails", SeedMeAttributes_SetQuickCollectionEmails, METH_VARARGS},
    {"GetQuickCollectionEmails", SeedMeAttributes_GetQuickCollectionEmails, METH_VARARGS},
    {"SetQuickFrameRate", SeedMeAttributes_SetQuickFrameRate, METH_VARARGS},
    {"GetQuickFrameRate", SeedMeAttributes_GetQuickFrameRate, METH_VARARGS},
    {"SetQuickDownloadType", SeedMeAttributes_SetQuickDownloadType, METH_VARARGS},
    {"GetQuickDownloadType", SeedMeAttributes_GetQuickDownloadType, METH_VARARGS},
    {"SetClearAllTabsOnClose", SeedMeAttributes_SetClearAllTabsOnClose, METH_VARARGS},
    {"GetClearAllTabsOnClose", SeedMeAttributes_GetClearAllTabsOnClose, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
SeedMeAttributes_dealloc(PyObject *v)
{
   SeedMeAttributesObject *obj = (SeedMeAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
SeedMeAttributes_compare(PyObject *v, PyObject *w)
{
    SeedMeAttributes *a = ((SeedMeAttributesObject *)v)->data;
    SeedMeAttributes *b = ((SeedMeAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PySeedMeAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "collectionMode") == 0)
        return SeedMeAttributes_GetCollectionMode(self, NULL);
    if(strcmp(name, "COLLECTION_NEW") == 0)
        return PyInt_FromLong(long(SeedMeAttributes::COLLECTION_NEW));
    if(strcmp(name, "COLLECTION_UPDATE") == 0)
        return PyInt_FromLong(long(SeedMeAttributes::COLLECTION_UPDATE));

    if(strcmp(name, "collectionID") == 0)
        return SeedMeAttributes_GetCollectionID(self, NULL);
    if(strcmp(name, "sharing") == 0)
        return SeedMeAttributes_GetSharing(self, NULL);
    if(strcmp(name, "SHARING_PRIVATE") == 0)
        return PyInt_FromLong(long(SeedMeAttributes::SHARING_PRIVATE));
    if(strcmp(name, "SHARING_GROUP") == 0)
        return PyInt_FromLong(long(SeedMeAttributes::SHARING_GROUP));
    if(strcmp(name, "SHARING_PUBLIC") == 0)
        return PyInt_FromLong(long(SeedMeAttributes::SHARING_PUBLIC));

    if(strcmp(name, "collectionTitle") == 0)
        return SeedMeAttributes_GetCollectionTitle(self, NULL);
    if(strcmp(name, "collectionDescription") == 0)
        return SeedMeAttributes_GetCollectionDescription(self, NULL);
    if(strcmp(name, "overwriteFiles") == 0)
        return SeedMeAttributes_GetOverwriteFiles(self, NULL);
    if(strcmp(name, "keyValue") == 0)
        return SeedMeAttributes_GetKeyValue(self, NULL);
    if(strcmp(name, "collectionEmails") == 0)
        return SeedMeAttributes_GetCollectionEmails(self, NULL);
    if(strcmp(name, "uploadCurrentFile") == 0)
        return SeedMeAttributes_GetUploadCurrentFile(self, NULL);
    if(strcmp(name, "currentTitle") == 0)
        return SeedMeAttributes_GetCurrentTitle(self, NULL);
    if(strcmp(name, "currentDescription") == 0)
        return SeedMeAttributes_GetCurrentDescription(self, NULL);
    if(strcmp(name, "uploadSequenceFile") == 0)
        return SeedMeAttributes_GetUploadSequenceFile(self, NULL);
    if(strcmp(name, "sequenceTitle") == 0)
        return SeedMeAttributes_GetSequenceTitle(self, NULL);
    if(strcmp(name, "sequenceDescription") == 0)
        return SeedMeAttributes_GetSequenceDescription(self, NULL);
    if(strcmp(name, "createVideo") == 0)
        return SeedMeAttributes_GetCreateVideo(self, NULL);
    if(strcmp(name, "frameRate") == 0)
        return SeedMeAttributes_GetFrameRate(self, NULL);
    if(strcmp(name, "operationResult") == 0)
        return SeedMeAttributes_GetOperationResult(self, NULL);
    if(strcmp(name, "queryAction") == 0)
        return SeedMeAttributes_GetQueryAction(self, NULL);
    if(strcmp(name, "LIST_COL") == 0)
        return PyInt_FromLong(long(SeedMeAttributes::LIST_COL));
    if(strcmp(name, "FIND_COL") == 0)
        return PyInt_FromLong(long(SeedMeAttributes::FIND_COL));
    if(strcmp(name, "QUERY_COL") == 0)
        return PyInt_FromLong(long(SeedMeAttributes::QUERY_COL));

    if(strcmp(name, "queryColID") == 0)
        return SeedMeAttributes_GetQueryColID(self, NULL);
    if(strcmp(name, "queryKeyValue") == 0)
        return SeedMeAttributes_GetQueryKeyValue(self, NULL);
    if(strcmp(name, "queryCollectionValues") == 0)
        return SeedMeAttributes_GetQueryCollectionValues(self, NULL);
    if(strcmp(name, "QUERY_ALL") == 0)
        return PyInt_FromLong(long(SeedMeAttributes::QUERY_ALL));
    if(strcmp(name, "QUERY_KEY_VALUE") == 0)
        return PyInt_FromLong(long(SeedMeAttributes::QUERY_KEY_VALUE));
    if(strcmp(name, "QUERY_TICKER") == 0)
        return PyInt_FromLong(long(SeedMeAttributes::QUERY_TICKER));
    if(strcmp(name, "QUERY_URL") == 0)
        return PyInt_FromLong(long(SeedMeAttributes::QUERY_URL));

    if(strcmp(name, "downloadCollectionID") == 0)
        return SeedMeAttributes_GetDownloadCollectionID(self, NULL);
    if(strcmp(name, "downloadType") == 0)
        return SeedMeAttributes_GetDownloadType(self, NULL);
    if(strcmp(name, "DOWNLOAD_ALL") == 0)
        return PyInt_FromLong(long(SeedMeAttributes::DOWNLOAD_ALL));
    if(strcmp(name, "DOWNLOAD_VIDEO") == 0)
        return PyInt_FromLong(long(SeedMeAttributes::DOWNLOAD_VIDEO));
    if(strcmp(name, "DOWNLOAD_NAME") == 0)
        return PyInt_FromLong(long(SeedMeAttributes::DOWNLOAD_NAME));

    if(strcmp(name, "downloadName") == 0)
        return SeedMeAttributes_GetDownloadName(self, NULL);
    if(strcmp(name, "quickSharing") == 0)
        return SeedMeAttributes_GetQuickSharing(self, NULL);
    if(strcmp(name, "SHARING_PRIVATE") == 0)
        return PyInt_FromLong(long(SeedMeAttributes::SHARING_PRIVATE));
    if(strcmp(name, "SHARING_GROUP") == 0)
        return PyInt_FromLong(long(SeedMeAttributes::SHARING_GROUP));
    if(strcmp(name, "SHARING_PUBLIC") == 0)
        return PyInt_FromLong(long(SeedMeAttributes::SHARING_PUBLIC));

    if(strcmp(name, "quickCollectionTitle") == 0)
        return SeedMeAttributes_GetQuickCollectionTitle(self, NULL);
    if(strcmp(name, "quickCollectionEmails") == 0)
        return SeedMeAttributes_GetQuickCollectionEmails(self, NULL);
    if(strcmp(name, "quickFrameRate") == 0)
        return SeedMeAttributes_GetQuickFrameRate(self, NULL);
    if(strcmp(name, "quickDownloadType") == 0)
        return SeedMeAttributes_GetQuickDownloadType(self, NULL);
    if(strcmp(name, "DOWNLOAD_Q_ALL") == 0)
        return PyInt_FromLong(long(SeedMeAttributes::DOWNLOAD_Q_ALL));
    if(strcmp(name, "DOWNLOAD_Q_BEST") == 0)
        return PyInt_FromLong(long(SeedMeAttributes::DOWNLOAD_Q_BEST));
    if(strcmp(name, "DOWNLOAD_Q_HIGHEST") == 0)
        return PyInt_FromLong(long(SeedMeAttributes::DOWNLOAD_Q_HIGHEST));
    if(strcmp(name, "DOWNLOAD_Q_HIGH") == 0)
        return PyInt_FromLong(long(SeedMeAttributes::DOWNLOAD_Q_HIGH));
    if(strcmp(name, "DOWNLOAD_Q_MEDIUM") == 0)
        return PyInt_FromLong(long(SeedMeAttributes::DOWNLOAD_Q_MEDIUM));
    if(strcmp(name, "DOWNLOAD_Q_LOW") == 0)
        return PyInt_FromLong(long(SeedMeAttributes::DOWNLOAD_Q_LOW));
    if(strcmp(name, "DOWNLOAD_Q_LOWEST") == 0)
        return PyInt_FromLong(long(SeedMeAttributes::DOWNLOAD_Q_LOWEST));

    if(strcmp(name, "clearAllTabsOnClose") == 0)
        return SeedMeAttributes_GetClearAllTabsOnClose(self, NULL);

    return Py_FindMethod(PySeedMeAttributes_methods, self, name);
}

int
PySeedMeAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "collectionMode") == 0)
        obj = SeedMeAttributes_SetCollectionMode(self, tuple);
    else if(strcmp(name, "collectionID") == 0)
        obj = SeedMeAttributes_SetCollectionID(self, tuple);
    else if(strcmp(name, "sharing") == 0)
        obj = SeedMeAttributes_SetSharing(self, tuple);
    else if(strcmp(name, "collectionTitle") == 0)
        obj = SeedMeAttributes_SetCollectionTitle(self, tuple);
    else if(strcmp(name, "collectionDescription") == 0)
        obj = SeedMeAttributes_SetCollectionDescription(self, tuple);
    else if(strcmp(name, "overwriteFiles") == 0)
        obj = SeedMeAttributes_SetOverwriteFiles(self, tuple);
    else if(strcmp(name, "keyValue") == 0)
        obj = SeedMeAttributes_SetKeyValue(self, tuple);
    else if(strcmp(name, "collectionEmails") == 0)
        obj = SeedMeAttributes_SetCollectionEmails(self, tuple);
    else if(strcmp(name, "uploadCurrentFile") == 0)
        obj = SeedMeAttributes_SetUploadCurrentFile(self, tuple);
    else if(strcmp(name, "currentTitle") == 0)
        obj = SeedMeAttributes_SetCurrentTitle(self, tuple);
    else if(strcmp(name, "currentDescription") == 0)
        obj = SeedMeAttributes_SetCurrentDescription(self, tuple);
    else if(strcmp(name, "uploadSequenceFile") == 0)
        obj = SeedMeAttributes_SetUploadSequenceFile(self, tuple);
    else if(strcmp(name, "sequenceTitle") == 0)
        obj = SeedMeAttributes_SetSequenceTitle(self, tuple);
    else if(strcmp(name, "sequenceDescription") == 0)
        obj = SeedMeAttributes_SetSequenceDescription(self, tuple);
    else if(strcmp(name, "createVideo") == 0)
        obj = SeedMeAttributes_SetCreateVideo(self, tuple);
    else if(strcmp(name, "frameRate") == 0)
        obj = SeedMeAttributes_SetFrameRate(self, tuple);
    else if(strcmp(name, "operationResult") == 0)
        obj = SeedMeAttributes_SetOperationResult(self, tuple);
    else if(strcmp(name, "queryAction") == 0)
        obj = SeedMeAttributes_SetQueryAction(self, tuple);
    else if(strcmp(name, "queryColID") == 0)
        obj = SeedMeAttributes_SetQueryColID(self, tuple);
    else if(strcmp(name, "queryKeyValue") == 0)
        obj = SeedMeAttributes_SetQueryKeyValue(self, tuple);
    else if(strcmp(name, "queryCollectionValues") == 0)
        obj = SeedMeAttributes_SetQueryCollectionValues(self, tuple);
    else if(strcmp(name, "downloadCollectionID") == 0)
        obj = SeedMeAttributes_SetDownloadCollectionID(self, tuple);
    else if(strcmp(name, "downloadType") == 0)
        obj = SeedMeAttributes_SetDownloadType(self, tuple);
    else if(strcmp(name, "downloadName") == 0)
        obj = SeedMeAttributes_SetDownloadName(self, tuple);
    else if(strcmp(name, "quickSharing") == 0)
        obj = SeedMeAttributes_SetQuickSharing(self, tuple);
    else if(strcmp(name, "quickCollectionTitle") == 0)
        obj = SeedMeAttributes_SetQuickCollectionTitle(self, tuple);
    else if(strcmp(name, "quickCollectionEmails") == 0)
        obj = SeedMeAttributes_SetQuickCollectionEmails(self, tuple);
    else if(strcmp(name, "quickFrameRate") == 0)
        obj = SeedMeAttributes_SetQuickFrameRate(self, tuple);
    else if(strcmp(name, "quickDownloadType") == 0)
        obj = SeedMeAttributes_SetQuickDownloadType(self, tuple);
    else if(strcmp(name, "clearAllTabsOnClose") == 0)
        obj = SeedMeAttributes_SetClearAllTabsOnClose(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
SeedMeAttributes_print(PyObject *v, FILE *fp, int flags)
{
    SeedMeAttributesObject *obj = (SeedMeAttributesObject *)v;
    fprintf(fp, "%s", PySeedMeAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
SeedMeAttributes_str(PyObject *v)
{
    SeedMeAttributesObject *obj = (SeedMeAttributesObject *)v;
    return PyString_FromString(PySeedMeAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *SeedMeAttributes_Purpose = "This class contains the attributes needed to interact with SeedMe.";
#else
static char *SeedMeAttributes_Purpose = "This class contains the attributes needed to interact with SeedMe.";
#endif

//
// The type description structure
//
static PyTypeObject SeedMeAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "SeedMeAttributes",                    // tp_name
    sizeof(SeedMeAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)SeedMeAttributes_dealloc,  // tp_dealloc
    (printfunc)SeedMeAttributes_print,     // tp_print
    (getattrfunc)PySeedMeAttributes_getattr, // tp_getattr
    (setattrfunc)PySeedMeAttributes_setattr, // tp_setattr
    (cmpfunc)SeedMeAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)SeedMeAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    SeedMeAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static SeedMeAttributes *defaultAtts = 0;
static SeedMeAttributes *currentAtts = 0;

static PyObject *
NewSeedMeAttributes(int useCurrent)
{
    SeedMeAttributesObject *newObject;
    newObject = PyObject_NEW(SeedMeAttributesObject, &SeedMeAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new SeedMeAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new SeedMeAttributes(*defaultAtts);
    else
        newObject->data = new SeedMeAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapSeedMeAttributes(const SeedMeAttributes *attr)
{
    SeedMeAttributesObject *newObject;
    newObject = PyObject_NEW(SeedMeAttributesObject, &SeedMeAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (SeedMeAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
SeedMeAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewSeedMeAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef SeedMeAttributesMethods[] = {
    {"SeedMeAttributes", SeedMeAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *SeedMeAttributesObserver = 0;

std::string
PySeedMeAttributes_GetLogString()
{
    std::string s("SeedMeAtts = SeedMeAttributes()\n");
    if(currentAtts != 0)
        s += PySeedMeAttributes_ToString(currentAtts, "SeedMeAtts.");
    return s;
}

static void
PySeedMeAttributes_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("SeedMeAtts = SeedMeAttributes()\n");
        s += PySeedMeAttributes_ToString(currentAtts, "SeedMeAtts.");
        cb(s);
    }
}

void
PySeedMeAttributes_StartUp(SeedMeAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PySeedMeAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(SeedMeAttributesObserver == 0)
    {
        SeedMeAttributesObserver = new ObserverToCallback(subj,
            PySeedMeAttributes_CallLogRoutine, (void *)data);
    }

}

void
PySeedMeAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete SeedMeAttributesObserver;
    SeedMeAttributesObserver = 0;
}

PyMethodDef *
PySeedMeAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return SeedMeAttributesMethods;
}

bool
PySeedMeAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &SeedMeAttributesType);
}

SeedMeAttributes *
PySeedMeAttributes_FromPyObject(PyObject *obj)
{
    SeedMeAttributesObject *obj2 = (SeedMeAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PySeedMeAttributes_New()
{
    return NewSeedMeAttributes(0);
}

PyObject *
PySeedMeAttributes_Wrap(const SeedMeAttributes *attr)
{
    return WrapSeedMeAttributes(attr);
}

void
PySeedMeAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    SeedMeAttributesObject *obj2 = (SeedMeAttributesObject *)obj;
    obj2->parent = parent;
}

void
PySeedMeAttributes_SetDefaults(const SeedMeAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new SeedMeAttributes(*atts);
}

