/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PySaveSubWindowsAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>
#include <PySaveSubWindowAttributes.h>
#include <PySaveSubWindowAttributes.h>
#include <PySaveSubWindowAttributes.h>
#include <PySaveSubWindowAttributes.h>
#include <PySaveSubWindowAttributes.h>
#include <PySaveSubWindowAttributes.h>
#include <PySaveSubWindowAttributes.h>
#include <PySaveSubWindowAttributes.h>
#include <PySaveSubWindowAttributes.h>
#include <PySaveSubWindowAttributes.h>
#include <PySaveSubWindowAttributes.h>
#include <PySaveSubWindowAttributes.h>
#include <PySaveSubWindowAttributes.h>
#include <PySaveSubWindowAttributes.h>
#include <PySaveSubWindowAttributes.h>
#include <PySaveSubWindowAttributes.h>

// ****************************************************************************
// Module: PySaveSubWindowsAttributes
//
// Purpose: 
//   
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a SaveSubWindowsAttributes.
//
struct SaveSubWindowsAttributesObject
{
    PyObject_HEAD
    SaveSubWindowsAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewSaveSubWindowsAttributes(int);

std::string
PySaveSubWindowsAttributes_ToString(const SaveSubWindowsAttributes *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    // To squelch a warning
    (void)tmpStr;
    { // new scope
        std::string objPrefix(prefix);
        objPrefix += "win1.";
        str += PySaveSubWindowAttributes_ToString(&atts->GetWin1(), objPrefix.c_str());
    }
    { // new scope
        std::string objPrefix(prefix);
        objPrefix += "win2.";
        str += PySaveSubWindowAttributes_ToString(&atts->GetWin2(), objPrefix.c_str());
    }
    { // new scope
        std::string objPrefix(prefix);
        objPrefix += "win3.";
        str += PySaveSubWindowAttributes_ToString(&atts->GetWin3(), objPrefix.c_str());
    }
    { // new scope
        std::string objPrefix(prefix);
        objPrefix += "win4.";
        str += PySaveSubWindowAttributes_ToString(&atts->GetWin4(), objPrefix.c_str());
    }
    { // new scope
        std::string objPrefix(prefix);
        objPrefix += "win5.";
        str += PySaveSubWindowAttributes_ToString(&atts->GetWin5(), objPrefix.c_str());
    }
    { // new scope
        std::string objPrefix(prefix);
        objPrefix += "win6.";
        str += PySaveSubWindowAttributes_ToString(&atts->GetWin6(), objPrefix.c_str());
    }
    { // new scope
        std::string objPrefix(prefix);
        objPrefix += "win7.";
        str += PySaveSubWindowAttributes_ToString(&atts->GetWin7(), objPrefix.c_str());
    }
    { // new scope
        std::string objPrefix(prefix);
        objPrefix += "win8.";
        str += PySaveSubWindowAttributes_ToString(&atts->GetWin8(), objPrefix.c_str());
    }
    { // new scope
        std::string objPrefix(prefix);
        objPrefix += "win9.";
        str += PySaveSubWindowAttributes_ToString(&atts->GetWin9(), objPrefix.c_str());
    }
    { // new scope
        std::string objPrefix(prefix);
        objPrefix += "win10.";
        str += PySaveSubWindowAttributes_ToString(&atts->GetWin10(), objPrefix.c_str());
    }
    { // new scope
        std::string objPrefix(prefix);
        objPrefix += "win11.";
        str += PySaveSubWindowAttributes_ToString(&atts->GetWin11(), objPrefix.c_str());
    }
    { // new scope
        std::string objPrefix(prefix);
        objPrefix += "win12.";
        str += PySaveSubWindowAttributes_ToString(&atts->GetWin12(), objPrefix.c_str());
    }
    { // new scope
        std::string objPrefix(prefix);
        objPrefix += "win13.";
        str += PySaveSubWindowAttributes_ToString(&atts->GetWin13(), objPrefix.c_str());
    }
    { // new scope
        std::string objPrefix(prefix);
        objPrefix += "win14.";
        str += PySaveSubWindowAttributes_ToString(&atts->GetWin14(), objPrefix.c_str());
    }
    { // new scope
        std::string objPrefix(prefix);
        objPrefix += "win15.";
        str += PySaveSubWindowAttributes_ToString(&atts->GetWin15(), objPrefix.c_str());
    }
    { // new scope
        std::string objPrefix(prefix);
        objPrefix += "win16.";
        str += PySaveSubWindowAttributes_ToString(&atts->GetWin16(), objPrefix.c_str());
    }
    return str;
}

static PyObject *
SaveSubWindowsAttributes_Notify(PyObject *self, PyObject *args)
{
    SaveSubWindowsAttributesObject *obj = (SaveSubWindowsAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SaveSubWindowsAttributes_SetWin1(PyObject *self, PyObject *args)
{
    SaveSubWindowsAttributesObject *obj = (SaveSubWindowsAttributesObject *)self;

    PyObject *newValue = NULL;
    if(!PyArg_ParseTuple(args, "O", &newValue))
        return NULL;
    if(!PySaveSubWindowAttributes_Check(newValue))
    {
        fprintf(stderr, "The win1 field can only be set with SaveSubWindowAttributes objects.\n");
        return NULL;
    }

    obj->data->SetWin1(*PySaveSubWindowAttributes_FromPyObject(newValue));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SaveSubWindowsAttributes_GetWin1(PyObject *self, PyObject *args)
{
    SaveSubWindowsAttributesObject *obj = (SaveSubWindowsAttributesObject *)self;
    // Since the new object will point to data owned by this object,
    // we need to increment the reference count.
    Py_INCREF(self);

    PyObject *retval = PySaveSubWindowAttributes_Wrap(&obj->data->GetWin1());
    // Set the object's parent so the reference to the parent can be decref'd
    // when the child goes out of scope.
    PySaveSubWindowAttributes_SetParent(retval, self);

    return retval;
}

/*static*/ PyObject *
SaveSubWindowsAttributes_SetWin2(PyObject *self, PyObject *args)
{
    SaveSubWindowsAttributesObject *obj = (SaveSubWindowsAttributesObject *)self;

    PyObject *newValue = NULL;
    if(!PyArg_ParseTuple(args, "O", &newValue))
        return NULL;
    if(!PySaveSubWindowAttributes_Check(newValue))
    {
        fprintf(stderr, "The win2 field can only be set with SaveSubWindowAttributes objects.\n");
        return NULL;
    }

    obj->data->SetWin2(*PySaveSubWindowAttributes_FromPyObject(newValue));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SaveSubWindowsAttributes_GetWin2(PyObject *self, PyObject *args)
{
    SaveSubWindowsAttributesObject *obj = (SaveSubWindowsAttributesObject *)self;
    // Since the new object will point to data owned by this object,
    // we need to increment the reference count.
    Py_INCREF(self);

    PyObject *retval = PySaveSubWindowAttributes_Wrap(&obj->data->GetWin2());
    // Set the object's parent so the reference to the parent can be decref'd
    // when the child goes out of scope.
    PySaveSubWindowAttributes_SetParent(retval, self);

    return retval;
}

/*static*/ PyObject *
SaveSubWindowsAttributes_SetWin3(PyObject *self, PyObject *args)
{
    SaveSubWindowsAttributesObject *obj = (SaveSubWindowsAttributesObject *)self;

    PyObject *newValue = NULL;
    if(!PyArg_ParseTuple(args, "O", &newValue))
        return NULL;
    if(!PySaveSubWindowAttributes_Check(newValue))
    {
        fprintf(stderr, "The win3 field can only be set with SaveSubWindowAttributes objects.\n");
        return NULL;
    }

    obj->data->SetWin3(*PySaveSubWindowAttributes_FromPyObject(newValue));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SaveSubWindowsAttributes_GetWin3(PyObject *self, PyObject *args)
{
    SaveSubWindowsAttributesObject *obj = (SaveSubWindowsAttributesObject *)self;
    // Since the new object will point to data owned by this object,
    // we need to increment the reference count.
    Py_INCREF(self);

    PyObject *retval = PySaveSubWindowAttributes_Wrap(&obj->data->GetWin3());
    // Set the object's parent so the reference to the parent can be decref'd
    // when the child goes out of scope.
    PySaveSubWindowAttributes_SetParent(retval, self);

    return retval;
}

/*static*/ PyObject *
SaveSubWindowsAttributes_SetWin4(PyObject *self, PyObject *args)
{
    SaveSubWindowsAttributesObject *obj = (SaveSubWindowsAttributesObject *)self;

    PyObject *newValue = NULL;
    if(!PyArg_ParseTuple(args, "O", &newValue))
        return NULL;
    if(!PySaveSubWindowAttributes_Check(newValue))
    {
        fprintf(stderr, "The win4 field can only be set with SaveSubWindowAttributes objects.\n");
        return NULL;
    }

    obj->data->SetWin4(*PySaveSubWindowAttributes_FromPyObject(newValue));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SaveSubWindowsAttributes_GetWin4(PyObject *self, PyObject *args)
{
    SaveSubWindowsAttributesObject *obj = (SaveSubWindowsAttributesObject *)self;
    // Since the new object will point to data owned by this object,
    // we need to increment the reference count.
    Py_INCREF(self);

    PyObject *retval = PySaveSubWindowAttributes_Wrap(&obj->data->GetWin4());
    // Set the object's parent so the reference to the parent can be decref'd
    // when the child goes out of scope.
    PySaveSubWindowAttributes_SetParent(retval, self);

    return retval;
}

/*static*/ PyObject *
SaveSubWindowsAttributes_SetWin5(PyObject *self, PyObject *args)
{
    SaveSubWindowsAttributesObject *obj = (SaveSubWindowsAttributesObject *)self;

    PyObject *newValue = NULL;
    if(!PyArg_ParseTuple(args, "O", &newValue))
        return NULL;
    if(!PySaveSubWindowAttributes_Check(newValue))
    {
        fprintf(stderr, "The win5 field can only be set with SaveSubWindowAttributes objects.\n");
        return NULL;
    }

    obj->data->SetWin5(*PySaveSubWindowAttributes_FromPyObject(newValue));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SaveSubWindowsAttributes_GetWin5(PyObject *self, PyObject *args)
{
    SaveSubWindowsAttributesObject *obj = (SaveSubWindowsAttributesObject *)self;
    // Since the new object will point to data owned by this object,
    // we need to increment the reference count.
    Py_INCREF(self);

    PyObject *retval = PySaveSubWindowAttributes_Wrap(&obj->data->GetWin5());
    // Set the object's parent so the reference to the parent can be decref'd
    // when the child goes out of scope.
    PySaveSubWindowAttributes_SetParent(retval, self);

    return retval;
}

/*static*/ PyObject *
SaveSubWindowsAttributes_SetWin6(PyObject *self, PyObject *args)
{
    SaveSubWindowsAttributesObject *obj = (SaveSubWindowsAttributesObject *)self;

    PyObject *newValue = NULL;
    if(!PyArg_ParseTuple(args, "O", &newValue))
        return NULL;
    if(!PySaveSubWindowAttributes_Check(newValue))
    {
        fprintf(stderr, "The win6 field can only be set with SaveSubWindowAttributes objects.\n");
        return NULL;
    }

    obj->data->SetWin6(*PySaveSubWindowAttributes_FromPyObject(newValue));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SaveSubWindowsAttributes_GetWin6(PyObject *self, PyObject *args)
{
    SaveSubWindowsAttributesObject *obj = (SaveSubWindowsAttributesObject *)self;
    // Since the new object will point to data owned by this object,
    // we need to increment the reference count.
    Py_INCREF(self);

    PyObject *retval = PySaveSubWindowAttributes_Wrap(&obj->data->GetWin6());
    // Set the object's parent so the reference to the parent can be decref'd
    // when the child goes out of scope.
    PySaveSubWindowAttributes_SetParent(retval, self);

    return retval;
}

/*static*/ PyObject *
SaveSubWindowsAttributes_SetWin7(PyObject *self, PyObject *args)
{
    SaveSubWindowsAttributesObject *obj = (SaveSubWindowsAttributesObject *)self;

    PyObject *newValue = NULL;
    if(!PyArg_ParseTuple(args, "O", &newValue))
        return NULL;
    if(!PySaveSubWindowAttributes_Check(newValue))
    {
        fprintf(stderr, "The win7 field can only be set with SaveSubWindowAttributes objects.\n");
        return NULL;
    }

    obj->data->SetWin7(*PySaveSubWindowAttributes_FromPyObject(newValue));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SaveSubWindowsAttributes_GetWin7(PyObject *self, PyObject *args)
{
    SaveSubWindowsAttributesObject *obj = (SaveSubWindowsAttributesObject *)self;
    // Since the new object will point to data owned by this object,
    // we need to increment the reference count.
    Py_INCREF(self);

    PyObject *retval = PySaveSubWindowAttributes_Wrap(&obj->data->GetWin7());
    // Set the object's parent so the reference to the parent can be decref'd
    // when the child goes out of scope.
    PySaveSubWindowAttributes_SetParent(retval, self);

    return retval;
}

/*static*/ PyObject *
SaveSubWindowsAttributes_SetWin8(PyObject *self, PyObject *args)
{
    SaveSubWindowsAttributesObject *obj = (SaveSubWindowsAttributesObject *)self;

    PyObject *newValue = NULL;
    if(!PyArg_ParseTuple(args, "O", &newValue))
        return NULL;
    if(!PySaveSubWindowAttributes_Check(newValue))
    {
        fprintf(stderr, "The win8 field can only be set with SaveSubWindowAttributes objects.\n");
        return NULL;
    }

    obj->data->SetWin8(*PySaveSubWindowAttributes_FromPyObject(newValue));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SaveSubWindowsAttributes_GetWin8(PyObject *self, PyObject *args)
{
    SaveSubWindowsAttributesObject *obj = (SaveSubWindowsAttributesObject *)self;
    // Since the new object will point to data owned by this object,
    // we need to increment the reference count.
    Py_INCREF(self);

    PyObject *retval = PySaveSubWindowAttributes_Wrap(&obj->data->GetWin8());
    // Set the object's parent so the reference to the parent can be decref'd
    // when the child goes out of scope.
    PySaveSubWindowAttributes_SetParent(retval, self);

    return retval;
}

/*static*/ PyObject *
SaveSubWindowsAttributes_SetWin9(PyObject *self, PyObject *args)
{
    SaveSubWindowsAttributesObject *obj = (SaveSubWindowsAttributesObject *)self;

    PyObject *newValue = NULL;
    if(!PyArg_ParseTuple(args, "O", &newValue))
        return NULL;
    if(!PySaveSubWindowAttributes_Check(newValue))
    {
        fprintf(stderr, "The win9 field can only be set with SaveSubWindowAttributes objects.\n");
        return NULL;
    }

    obj->data->SetWin9(*PySaveSubWindowAttributes_FromPyObject(newValue));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SaveSubWindowsAttributes_GetWin9(PyObject *self, PyObject *args)
{
    SaveSubWindowsAttributesObject *obj = (SaveSubWindowsAttributesObject *)self;
    // Since the new object will point to data owned by this object,
    // we need to increment the reference count.
    Py_INCREF(self);

    PyObject *retval = PySaveSubWindowAttributes_Wrap(&obj->data->GetWin9());
    // Set the object's parent so the reference to the parent can be decref'd
    // when the child goes out of scope.
    PySaveSubWindowAttributes_SetParent(retval, self);

    return retval;
}

/*static*/ PyObject *
SaveSubWindowsAttributes_SetWin10(PyObject *self, PyObject *args)
{
    SaveSubWindowsAttributesObject *obj = (SaveSubWindowsAttributesObject *)self;

    PyObject *newValue = NULL;
    if(!PyArg_ParseTuple(args, "O", &newValue))
        return NULL;
    if(!PySaveSubWindowAttributes_Check(newValue))
    {
        fprintf(stderr, "The win10 field can only be set with SaveSubWindowAttributes objects.\n");
        return NULL;
    }

    obj->data->SetWin10(*PySaveSubWindowAttributes_FromPyObject(newValue));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SaveSubWindowsAttributes_GetWin10(PyObject *self, PyObject *args)
{
    SaveSubWindowsAttributesObject *obj = (SaveSubWindowsAttributesObject *)self;
    // Since the new object will point to data owned by this object,
    // we need to increment the reference count.
    Py_INCREF(self);

    PyObject *retval = PySaveSubWindowAttributes_Wrap(&obj->data->GetWin10());
    // Set the object's parent so the reference to the parent can be decref'd
    // when the child goes out of scope.
    PySaveSubWindowAttributes_SetParent(retval, self);

    return retval;
}

/*static*/ PyObject *
SaveSubWindowsAttributes_SetWin11(PyObject *self, PyObject *args)
{
    SaveSubWindowsAttributesObject *obj = (SaveSubWindowsAttributesObject *)self;

    PyObject *newValue = NULL;
    if(!PyArg_ParseTuple(args, "O", &newValue))
        return NULL;
    if(!PySaveSubWindowAttributes_Check(newValue))
    {
        fprintf(stderr, "The win11 field can only be set with SaveSubWindowAttributes objects.\n");
        return NULL;
    }

    obj->data->SetWin11(*PySaveSubWindowAttributes_FromPyObject(newValue));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SaveSubWindowsAttributes_GetWin11(PyObject *self, PyObject *args)
{
    SaveSubWindowsAttributesObject *obj = (SaveSubWindowsAttributesObject *)self;
    // Since the new object will point to data owned by this object,
    // we need to increment the reference count.
    Py_INCREF(self);

    PyObject *retval = PySaveSubWindowAttributes_Wrap(&obj->data->GetWin11());
    // Set the object's parent so the reference to the parent can be decref'd
    // when the child goes out of scope.
    PySaveSubWindowAttributes_SetParent(retval, self);

    return retval;
}

/*static*/ PyObject *
SaveSubWindowsAttributes_SetWin12(PyObject *self, PyObject *args)
{
    SaveSubWindowsAttributesObject *obj = (SaveSubWindowsAttributesObject *)self;

    PyObject *newValue = NULL;
    if(!PyArg_ParseTuple(args, "O", &newValue))
        return NULL;
    if(!PySaveSubWindowAttributes_Check(newValue))
    {
        fprintf(stderr, "The win12 field can only be set with SaveSubWindowAttributes objects.\n");
        return NULL;
    }

    obj->data->SetWin12(*PySaveSubWindowAttributes_FromPyObject(newValue));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SaveSubWindowsAttributes_GetWin12(PyObject *self, PyObject *args)
{
    SaveSubWindowsAttributesObject *obj = (SaveSubWindowsAttributesObject *)self;
    // Since the new object will point to data owned by this object,
    // we need to increment the reference count.
    Py_INCREF(self);

    PyObject *retval = PySaveSubWindowAttributes_Wrap(&obj->data->GetWin12());
    // Set the object's parent so the reference to the parent can be decref'd
    // when the child goes out of scope.
    PySaveSubWindowAttributes_SetParent(retval, self);

    return retval;
}

/*static*/ PyObject *
SaveSubWindowsAttributes_SetWin13(PyObject *self, PyObject *args)
{
    SaveSubWindowsAttributesObject *obj = (SaveSubWindowsAttributesObject *)self;

    PyObject *newValue = NULL;
    if(!PyArg_ParseTuple(args, "O", &newValue))
        return NULL;
    if(!PySaveSubWindowAttributes_Check(newValue))
    {
        fprintf(stderr, "The win13 field can only be set with SaveSubWindowAttributes objects.\n");
        return NULL;
    }

    obj->data->SetWin13(*PySaveSubWindowAttributes_FromPyObject(newValue));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SaveSubWindowsAttributes_GetWin13(PyObject *self, PyObject *args)
{
    SaveSubWindowsAttributesObject *obj = (SaveSubWindowsAttributesObject *)self;
    // Since the new object will point to data owned by this object,
    // we need to increment the reference count.
    Py_INCREF(self);

    PyObject *retval = PySaveSubWindowAttributes_Wrap(&obj->data->GetWin13());
    // Set the object's parent so the reference to the parent can be decref'd
    // when the child goes out of scope.
    PySaveSubWindowAttributes_SetParent(retval, self);

    return retval;
}

/*static*/ PyObject *
SaveSubWindowsAttributes_SetWin14(PyObject *self, PyObject *args)
{
    SaveSubWindowsAttributesObject *obj = (SaveSubWindowsAttributesObject *)self;

    PyObject *newValue = NULL;
    if(!PyArg_ParseTuple(args, "O", &newValue))
        return NULL;
    if(!PySaveSubWindowAttributes_Check(newValue))
    {
        fprintf(stderr, "The win14 field can only be set with SaveSubWindowAttributes objects.\n");
        return NULL;
    }

    obj->data->SetWin14(*PySaveSubWindowAttributes_FromPyObject(newValue));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SaveSubWindowsAttributes_GetWin14(PyObject *self, PyObject *args)
{
    SaveSubWindowsAttributesObject *obj = (SaveSubWindowsAttributesObject *)self;
    // Since the new object will point to data owned by this object,
    // we need to increment the reference count.
    Py_INCREF(self);

    PyObject *retval = PySaveSubWindowAttributes_Wrap(&obj->data->GetWin14());
    // Set the object's parent so the reference to the parent can be decref'd
    // when the child goes out of scope.
    PySaveSubWindowAttributes_SetParent(retval, self);

    return retval;
}

/*static*/ PyObject *
SaveSubWindowsAttributes_SetWin15(PyObject *self, PyObject *args)
{
    SaveSubWindowsAttributesObject *obj = (SaveSubWindowsAttributesObject *)self;

    PyObject *newValue = NULL;
    if(!PyArg_ParseTuple(args, "O", &newValue))
        return NULL;
    if(!PySaveSubWindowAttributes_Check(newValue))
    {
        fprintf(stderr, "The win15 field can only be set with SaveSubWindowAttributes objects.\n");
        return NULL;
    }

    obj->data->SetWin15(*PySaveSubWindowAttributes_FromPyObject(newValue));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SaveSubWindowsAttributes_GetWin15(PyObject *self, PyObject *args)
{
    SaveSubWindowsAttributesObject *obj = (SaveSubWindowsAttributesObject *)self;
    // Since the new object will point to data owned by this object,
    // we need to increment the reference count.
    Py_INCREF(self);

    PyObject *retval = PySaveSubWindowAttributes_Wrap(&obj->data->GetWin15());
    // Set the object's parent so the reference to the parent can be decref'd
    // when the child goes out of scope.
    PySaveSubWindowAttributes_SetParent(retval, self);

    return retval;
}

/*static*/ PyObject *
SaveSubWindowsAttributes_SetWin16(PyObject *self, PyObject *args)
{
    SaveSubWindowsAttributesObject *obj = (SaveSubWindowsAttributesObject *)self;

    PyObject *newValue = NULL;
    if(!PyArg_ParseTuple(args, "O", &newValue))
        return NULL;
    if(!PySaveSubWindowAttributes_Check(newValue))
    {
        fprintf(stderr, "The win16 field can only be set with SaveSubWindowAttributes objects.\n");
        return NULL;
    }

    obj->data->SetWin16(*PySaveSubWindowAttributes_FromPyObject(newValue));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SaveSubWindowsAttributes_GetWin16(PyObject *self, PyObject *args)
{
    SaveSubWindowsAttributesObject *obj = (SaveSubWindowsAttributesObject *)self;
    // Since the new object will point to data owned by this object,
    // we need to increment the reference count.
    Py_INCREF(self);

    PyObject *retval = PySaveSubWindowAttributes_Wrap(&obj->data->GetWin16());
    // Set the object's parent so the reference to the parent can be decref'd
    // when the child goes out of scope.
    PySaveSubWindowAttributes_SetParent(retval, self);

    return retval;
}



PyMethodDef PySaveSubWindowsAttributes_methods[SAVESUBWINDOWSATTRIBUTES_NMETH] = {
    {"Notify", SaveSubWindowsAttributes_Notify, METH_VARARGS},
    {"SetWin1", SaveSubWindowsAttributes_SetWin1, METH_VARARGS},
    {"GetWin1", SaveSubWindowsAttributes_GetWin1, METH_VARARGS},
    {"SetWin2", SaveSubWindowsAttributes_SetWin2, METH_VARARGS},
    {"GetWin2", SaveSubWindowsAttributes_GetWin2, METH_VARARGS},
    {"SetWin3", SaveSubWindowsAttributes_SetWin3, METH_VARARGS},
    {"GetWin3", SaveSubWindowsAttributes_GetWin3, METH_VARARGS},
    {"SetWin4", SaveSubWindowsAttributes_SetWin4, METH_VARARGS},
    {"GetWin4", SaveSubWindowsAttributes_GetWin4, METH_VARARGS},
    {"SetWin5", SaveSubWindowsAttributes_SetWin5, METH_VARARGS},
    {"GetWin5", SaveSubWindowsAttributes_GetWin5, METH_VARARGS},
    {"SetWin6", SaveSubWindowsAttributes_SetWin6, METH_VARARGS},
    {"GetWin6", SaveSubWindowsAttributes_GetWin6, METH_VARARGS},
    {"SetWin7", SaveSubWindowsAttributes_SetWin7, METH_VARARGS},
    {"GetWin7", SaveSubWindowsAttributes_GetWin7, METH_VARARGS},
    {"SetWin8", SaveSubWindowsAttributes_SetWin8, METH_VARARGS},
    {"GetWin8", SaveSubWindowsAttributes_GetWin8, METH_VARARGS},
    {"SetWin9", SaveSubWindowsAttributes_SetWin9, METH_VARARGS},
    {"GetWin9", SaveSubWindowsAttributes_GetWin9, METH_VARARGS},
    {"SetWin10", SaveSubWindowsAttributes_SetWin10, METH_VARARGS},
    {"GetWin10", SaveSubWindowsAttributes_GetWin10, METH_VARARGS},
    {"SetWin11", SaveSubWindowsAttributes_SetWin11, METH_VARARGS},
    {"GetWin11", SaveSubWindowsAttributes_GetWin11, METH_VARARGS},
    {"SetWin12", SaveSubWindowsAttributes_SetWin12, METH_VARARGS},
    {"GetWin12", SaveSubWindowsAttributes_GetWin12, METH_VARARGS},
    {"SetWin13", SaveSubWindowsAttributes_SetWin13, METH_VARARGS},
    {"GetWin13", SaveSubWindowsAttributes_GetWin13, METH_VARARGS},
    {"SetWin14", SaveSubWindowsAttributes_SetWin14, METH_VARARGS},
    {"GetWin14", SaveSubWindowsAttributes_GetWin14, METH_VARARGS},
    {"SetWin15", SaveSubWindowsAttributes_SetWin15, METH_VARARGS},
    {"GetWin15", SaveSubWindowsAttributes_GetWin15, METH_VARARGS},
    {"SetWin16", SaveSubWindowsAttributes_SetWin16, METH_VARARGS},
    {"GetWin16", SaveSubWindowsAttributes_GetWin16, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
SaveSubWindowsAttributes_dealloc(PyObject *v)
{
   SaveSubWindowsAttributesObject *obj = (SaveSubWindowsAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
SaveSubWindowsAttributes_compare(PyObject *v, PyObject *w)
{
    SaveSubWindowsAttributes *a = ((SaveSubWindowsAttributesObject *)v)->data;
    SaveSubWindowsAttributes *b = ((SaveSubWindowsAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PySaveSubWindowsAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "win1") == 0)
        return SaveSubWindowsAttributes_GetWin1(self, NULL);
    if(strcmp(name, "win2") == 0)
        return SaveSubWindowsAttributes_GetWin2(self, NULL);
    if(strcmp(name, "win3") == 0)
        return SaveSubWindowsAttributes_GetWin3(self, NULL);
    if(strcmp(name, "win4") == 0)
        return SaveSubWindowsAttributes_GetWin4(self, NULL);
    if(strcmp(name, "win5") == 0)
        return SaveSubWindowsAttributes_GetWin5(self, NULL);
    if(strcmp(name, "win6") == 0)
        return SaveSubWindowsAttributes_GetWin6(self, NULL);
    if(strcmp(name, "win7") == 0)
        return SaveSubWindowsAttributes_GetWin7(self, NULL);
    if(strcmp(name, "win8") == 0)
        return SaveSubWindowsAttributes_GetWin8(self, NULL);
    if(strcmp(name, "win9") == 0)
        return SaveSubWindowsAttributes_GetWin9(self, NULL);
    if(strcmp(name, "win10") == 0)
        return SaveSubWindowsAttributes_GetWin10(self, NULL);
    if(strcmp(name, "win11") == 0)
        return SaveSubWindowsAttributes_GetWin11(self, NULL);
    if(strcmp(name, "win12") == 0)
        return SaveSubWindowsAttributes_GetWin12(self, NULL);
    if(strcmp(name, "win13") == 0)
        return SaveSubWindowsAttributes_GetWin13(self, NULL);
    if(strcmp(name, "win14") == 0)
        return SaveSubWindowsAttributes_GetWin14(self, NULL);
    if(strcmp(name, "win15") == 0)
        return SaveSubWindowsAttributes_GetWin15(self, NULL);
    if(strcmp(name, "win16") == 0)
        return SaveSubWindowsAttributes_GetWin16(self, NULL);

    return Py_FindMethod(PySaveSubWindowsAttributes_methods, self, name);
}

int
PySaveSubWindowsAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "win1") == 0)
        obj = SaveSubWindowsAttributes_SetWin1(self, tuple);
    else if(strcmp(name, "win2") == 0)
        obj = SaveSubWindowsAttributes_SetWin2(self, tuple);
    else if(strcmp(name, "win3") == 0)
        obj = SaveSubWindowsAttributes_SetWin3(self, tuple);
    else if(strcmp(name, "win4") == 0)
        obj = SaveSubWindowsAttributes_SetWin4(self, tuple);
    else if(strcmp(name, "win5") == 0)
        obj = SaveSubWindowsAttributes_SetWin5(self, tuple);
    else if(strcmp(name, "win6") == 0)
        obj = SaveSubWindowsAttributes_SetWin6(self, tuple);
    else if(strcmp(name, "win7") == 0)
        obj = SaveSubWindowsAttributes_SetWin7(self, tuple);
    else if(strcmp(name, "win8") == 0)
        obj = SaveSubWindowsAttributes_SetWin8(self, tuple);
    else if(strcmp(name, "win9") == 0)
        obj = SaveSubWindowsAttributes_SetWin9(self, tuple);
    else if(strcmp(name, "win10") == 0)
        obj = SaveSubWindowsAttributes_SetWin10(self, tuple);
    else if(strcmp(name, "win11") == 0)
        obj = SaveSubWindowsAttributes_SetWin11(self, tuple);
    else if(strcmp(name, "win12") == 0)
        obj = SaveSubWindowsAttributes_SetWin12(self, tuple);
    else if(strcmp(name, "win13") == 0)
        obj = SaveSubWindowsAttributes_SetWin13(self, tuple);
    else if(strcmp(name, "win14") == 0)
        obj = SaveSubWindowsAttributes_SetWin14(self, tuple);
    else if(strcmp(name, "win15") == 0)
        obj = SaveSubWindowsAttributes_SetWin15(self, tuple);
    else if(strcmp(name, "win16") == 0)
        obj = SaveSubWindowsAttributes_SetWin16(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
SaveSubWindowsAttributes_print(PyObject *v, FILE *fp, int flags)
{
    SaveSubWindowsAttributesObject *obj = (SaveSubWindowsAttributesObject *)v;
    fprintf(fp, "%s", PySaveSubWindowsAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
SaveSubWindowsAttributes_str(PyObject *v)
{
    SaveSubWindowsAttributesObject *obj = (SaveSubWindowsAttributesObject *)v;
    return PyString_FromString(PySaveSubWindowsAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *SaveSubWindowsAttributes_Purpose = "";
#else
static char *SaveSubWindowsAttributes_Purpose = "";
#endif

//
// The type description structure
//
static PyTypeObject SaveSubWindowsAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "SaveSubWindowsAttributes",                    // tp_name
    sizeof(SaveSubWindowsAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)SaveSubWindowsAttributes_dealloc,  // tp_dealloc
    (printfunc)SaveSubWindowsAttributes_print,     // tp_print
    (getattrfunc)PySaveSubWindowsAttributes_getattr, // tp_getattr
    (setattrfunc)PySaveSubWindowsAttributes_setattr, // tp_setattr
    (cmpfunc)SaveSubWindowsAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)SaveSubWindowsAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    SaveSubWindowsAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static SaveSubWindowsAttributes *defaultAtts = 0;
static SaveSubWindowsAttributes *currentAtts = 0;

static PyObject *
NewSaveSubWindowsAttributes(int useCurrent)
{
    SaveSubWindowsAttributesObject *newObject;
    newObject = PyObject_NEW(SaveSubWindowsAttributesObject, &SaveSubWindowsAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new SaveSubWindowsAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new SaveSubWindowsAttributes(*defaultAtts);
    else
        newObject->data = new SaveSubWindowsAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapSaveSubWindowsAttributes(const SaveSubWindowsAttributes *attr)
{
    SaveSubWindowsAttributesObject *newObject;
    newObject = PyObject_NEW(SaveSubWindowsAttributesObject, &SaveSubWindowsAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (SaveSubWindowsAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
SaveSubWindowsAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewSaveSubWindowsAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef SaveSubWindowsAttributesMethods[] = {
    {"SaveSubWindowsAttributes", SaveSubWindowsAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *SaveSubWindowsAttributesObserver = 0;

std::string
PySaveSubWindowsAttributes_GetLogString()
{
    std::string s("SaveSubWindowsAtts = SaveSubWindowsAttributes()\n");
    if(currentAtts != 0)
        s += PySaveSubWindowsAttributes_ToString(currentAtts, "SaveSubWindowsAtts.");
    return s;
}

static void
PySaveSubWindowsAttributes_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("SaveSubWindowsAtts = SaveSubWindowsAttributes()\n");
        s += PySaveSubWindowsAttributes_ToString(currentAtts, "SaveSubWindowsAtts.");
        cb(s);
    }
}

void
PySaveSubWindowsAttributes_StartUp(SaveSubWindowsAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PySaveSubWindowsAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(SaveSubWindowsAttributesObserver == 0)
    {
        SaveSubWindowsAttributesObserver = new ObserverToCallback(subj,
            PySaveSubWindowsAttributes_CallLogRoutine, (void *)data);
    }

}

void
PySaveSubWindowsAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete SaveSubWindowsAttributesObserver;
    SaveSubWindowsAttributesObserver = 0;
}

PyMethodDef *
PySaveSubWindowsAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return SaveSubWindowsAttributesMethods;
}

bool
PySaveSubWindowsAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &SaveSubWindowsAttributesType);
}

SaveSubWindowsAttributes *
PySaveSubWindowsAttributes_FromPyObject(PyObject *obj)
{
    SaveSubWindowsAttributesObject *obj2 = (SaveSubWindowsAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PySaveSubWindowsAttributes_New()
{
    return NewSaveSubWindowsAttributes(0);
}

PyObject *
PySaveSubWindowsAttributes_Wrap(const SaveSubWindowsAttributes *attr)
{
    return WrapSaveSubWindowsAttributes(attr);
}

void
PySaveSubWindowsAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    SaveSubWindowsAttributesObject *obj2 = (SaveSubWindowsAttributesObject *)obj;
    obj2->parent = parent;
}

void
PySaveSubWindowsAttributes_SetDefaults(const SaveSubWindowsAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new SaveSubWindowsAttributes(*atts);
}

