/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyRenderingAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>
#include <ColorAttribute.h>

// ****************************************************************************
// Module: PyRenderingAttributes
//
// Purpose: 
//   This class contains special rendering attributes like antialiasing and stero settings.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a RenderingAttributes.
//
struct RenderingAttributesObject
{
    PyObject_HEAD
    RenderingAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewRenderingAttributes(int);

std::string
PyRenderingAttributes_ToString(const RenderingAttributes *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    if(atts->GetAntialiasing())
        SNPRINTF(tmpStr, 1000, "%santialiasing = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%santialiasing = 0\n", prefix);
    str += tmpStr;
    if(atts->GetOrderComposite())
        SNPRINTF(tmpStr, 1000, "%sorderComposite = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sorderComposite = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sdepthCompositeThreads = %d\n", prefix, atts->GetDepthCompositeThreads());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sdepthCompositeBlocking = %d\n", prefix, atts->GetDepthCompositeBlocking());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%salphaCompositeThreads = %d\n", prefix, atts->GetAlphaCompositeThreads());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%salphaCompositeBlocking = %d\n", prefix, atts->GetAlphaCompositeBlocking());
    str += tmpStr;
    if(atts->GetDepthPeeling())
        SNPRINTF(tmpStr, 1000, "%sdepthPeeling = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sdepthPeeling = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%socclusionRatio = %g\n", prefix, atts->GetOcclusionRatio());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%snumberOfPeels = %d\n", prefix, atts->GetNumberOfPeels());
    str += tmpStr;
    if(atts->GetMultiresolutionMode())
        SNPRINTF(tmpStr, 1000, "%smultiresolutionMode = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%smultiresolutionMode = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%smultiresolutionCellSize = %g\n", prefix, atts->GetMultiresolutionCellSize());
    str += tmpStr;
    const char *geometryRepresentation_names = "Surfaces, Wireframe, Points";
    switch (atts->GetGeometryRepresentation())
    {
      case RenderingAttributes::Surfaces:
          SNPRINTF(tmpStr, 1000, "%sgeometryRepresentation = %sSurfaces  # %s\n", prefix, prefix, geometryRepresentation_names);
          str += tmpStr;
          break;
      case RenderingAttributes::Wireframe:
          SNPRINTF(tmpStr, 1000, "%sgeometryRepresentation = %sWireframe  # %s\n", prefix, prefix, geometryRepresentation_names);
          str += tmpStr;
          break;
      case RenderingAttributes::Points:
          SNPRINTF(tmpStr, 1000, "%sgeometryRepresentation = %sPoints  # %s\n", prefix, prefix, geometryRepresentation_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    if(atts->GetStereoRendering())
        SNPRINTF(tmpStr, 1000, "%sstereoRendering = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sstereoRendering = 0\n", prefix);
    str += tmpStr;
    const char *stereoType_names = "RedBlue, Interlaced, CrystalEyes, RedGreen";
    switch (atts->GetStereoType())
    {
      case RenderingAttributes::RedBlue:
          SNPRINTF(tmpStr, 1000, "%sstereoType = %sRedBlue  # %s\n", prefix, prefix, stereoType_names);
          str += tmpStr;
          break;
      case RenderingAttributes::Interlaced:
          SNPRINTF(tmpStr, 1000, "%sstereoType = %sInterlaced  # %s\n", prefix, prefix, stereoType_names);
          str += tmpStr;
          break;
      case RenderingAttributes::CrystalEyes:
          SNPRINTF(tmpStr, 1000, "%sstereoType = %sCrystalEyes  # %s\n", prefix, prefix, stereoType_names);
          str += tmpStr;
          break;
      case RenderingAttributes::RedGreen:
          SNPRINTF(tmpStr, 1000, "%sstereoType = %sRedGreen  # %s\n", prefix, prefix, stereoType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    if(atts->GetNotifyForEachRender())
        SNPRINTF(tmpStr, 1000, "%snotifyForEachRender = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%snotifyForEachRender = 0\n", prefix);
    str += tmpStr;
    const char *scalableActivationMode_names = "Never, Always, Auto";
    switch (atts->GetScalableActivationMode())
    {
      case RenderingAttributes::Never:
          SNPRINTF(tmpStr, 1000, "%sscalableActivationMode = %sNever  # %s\n", prefix, prefix, scalableActivationMode_names);
          str += tmpStr;
          break;
      case RenderingAttributes::Always:
          SNPRINTF(tmpStr, 1000, "%sscalableActivationMode = %sAlways  # %s\n", prefix, prefix, scalableActivationMode_names);
          str += tmpStr;
          break;
      case RenderingAttributes::Auto:
          SNPRINTF(tmpStr, 1000, "%sscalableActivationMode = %sAuto  # %s\n", prefix, prefix, scalableActivationMode_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    SNPRINTF(tmpStr, 1000, "%sscalableAutoThreshold = %d\n", prefix, atts->GetScalableAutoThreshold());
    str += tmpStr;
    if(atts->GetSpecularFlag())
        SNPRINTF(tmpStr, 1000, "%sspecularFlag = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sspecularFlag = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sspecularCoeff = %g\n", prefix, atts->GetSpecularCoeff());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sspecularPower = %g\n", prefix, atts->GetSpecularPower());
    str += tmpStr;
    const unsigned char *specularColor = atts->GetSpecularColor().GetColor();
    SNPRINTF(tmpStr, 1000, "%sspecularColor = (%d, %d, %d, %d)\n", prefix, int(specularColor[0]), int(specularColor[1]), int(specularColor[2]), int(specularColor[3]));
    str += tmpStr;
    if(atts->GetDoShadowing())
        SNPRINTF(tmpStr, 1000, "%sdoShadowing = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sdoShadowing = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sshadowStrength = %g\n", prefix, atts->GetShadowStrength());
    str += tmpStr;
    if(atts->GetDoDepthCueing())
        SNPRINTF(tmpStr, 1000, "%sdoDepthCueing = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sdoDepthCueing = 0\n", prefix);
    str += tmpStr;
    if(atts->GetDepthCueingAutomatic())
        SNPRINTF(tmpStr, 1000, "%sdepthCueingAutomatic = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sdepthCueingAutomatic = 0\n", prefix);
    str += tmpStr;
    {   const double *startCuePoint = atts->GetStartCuePoint();
        SNPRINTF(tmpStr, 1000, "%sstartCuePoint = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", startCuePoint[i]);
            str += tmpStr;
            if(i < 2)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const double *endCuePoint = atts->GetEndCuePoint();
        SNPRINTF(tmpStr, 1000, "%sendCuePoint = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", endCuePoint[i]);
            str += tmpStr;
            if(i < 2)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    const char *compressionActivationMode_names = "Never, Always, Auto";
    switch (atts->GetCompressionActivationMode())
    {
      case RenderingAttributes::Never:
          SNPRINTF(tmpStr, 1000, "%scompressionActivationMode = %sNever  # %s\n", prefix, prefix, compressionActivationMode_names);
          str += tmpStr;
          break;
      case RenderingAttributes::Always:
          SNPRINTF(tmpStr, 1000, "%scompressionActivationMode = %sAlways  # %s\n", prefix, prefix, compressionActivationMode_names);
          str += tmpStr;
          break;
      case RenderingAttributes::Auto:
          SNPRINTF(tmpStr, 1000, "%scompressionActivationMode = %sAuto  # %s\n", prefix, prefix, compressionActivationMode_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    if(atts->GetColorTexturingFlag())
        SNPRINTF(tmpStr, 1000, "%scolorTexturingFlag = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%scolorTexturingFlag = 0\n", prefix);
    str += tmpStr;
    const char *compactDomainsActivationMode_names = "Never, Always, Auto";
    switch (atts->GetCompactDomainsActivationMode())
    {
      case RenderingAttributes::Never:
          SNPRINTF(tmpStr, 1000, "%scompactDomainsActivationMode = %sNever  # %s\n", prefix, prefix, compactDomainsActivationMode_names);
          str += tmpStr;
          break;
      case RenderingAttributes::Always:
          SNPRINTF(tmpStr, 1000, "%scompactDomainsActivationMode = %sAlways  # %s\n", prefix, prefix, compactDomainsActivationMode_names);
          str += tmpStr;
          break;
      case RenderingAttributes::Auto:
          SNPRINTF(tmpStr, 1000, "%scompactDomainsActivationMode = %sAuto  # %s\n", prefix, prefix, compactDomainsActivationMode_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    SNPRINTF(tmpStr, 1000, "%scompactDomainsAutoThreshold = %d\n", prefix, atts->GetCompactDomainsAutoThreshold());
    str += tmpStr;
    if(atts->GetOsprayRendering())
        SNPRINTF(tmpStr, 1000, "%sosprayRendering = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sosprayRendering = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sospraySPP = %d\n", prefix, atts->GetOspraySPP());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sosprayAO = %d\n", prefix, atts->GetOsprayAO());
    str += tmpStr;
    if(atts->GetOsprayShadows())
        SNPRINTF(tmpStr, 1000, "%sosprayShadows = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sosprayShadows = 0\n", prefix);
    str += tmpStr;
    return str;
}

static PyObject *
RenderingAttributes_Notify(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
RenderingAttributes_SetAntialiasing(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the antialiasing in the object.
    obj->data->SetAntialiasing(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
RenderingAttributes_GetAntialiasing(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetAntialiasing()?1L:0L);
    return retval;
}

/*static*/ PyObject *
RenderingAttributes_SetOrderComposite(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the orderComposite in the object.
    obj->data->SetOrderComposite(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
RenderingAttributes_GetOrderComposite(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetOrderComposite()?1L:0L);
    return retval;
}

/*static*/ PyObject *
RenderingAttributes_SetDepthCompositeThreads(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the depthCompositeThreads in the object.
    obj->data->SetDepthCompositeThreads((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
RenderingAttributes_GetDepthCompositeThreads(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetDepthCompositeThreads()));
    return retval;
}

/*static*/ PyObject *
RenderingAttributes_SetDepthCompositeBlocking(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the depthCompositeBlocking in the object.
    obj->data->SetDepthCompositeBlocking((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
RenderingAttributes_GetDepthCompositeBlocking(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetDepthCompositeBlocking()));
    return retval;
}

/*static*/ PyObject *
RenderingAttributes_SetAlphaCompositeThreads(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the alphaCompositeThreads in the object.
    obj->data->SetAlphaCompositeThreads((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
RenderingAttributes_GetAlphaCompositeThreads(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetAlphaCompositeThreads()));
    return retval;
}

/*static*/ PyObject *
RenderingAttributes_SetAlphaCompositeBlocking(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the alphaCompositeBlocking in the object.
    obj->data->SetAlphaCompositeBlocking((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
RenderingAttributes_GetAlphaCompositeBlocking(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetAlphaCompositeBlocking()));
    return retval;
}

/*static*/ PyObject *
RenderingAttributes_SetDepthPeeling(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the depthPeeling in the object.
    obj->data->SetDepthPeeling(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
RenderingAttributes_GetDepthPeeling(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetDepthPeeling()?1L:0L);
    return retval;
}

/*static*/ PyObject *
RenderingAttributes_SetOcclusionRatio(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the occlusionRatio in the object.
    obj->data->SetOcclusionRatio(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
RenderingAttributes_GetOcclusionRatio(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetOcclusionRatio());
    return retval;
}

/*static*/ PyObject *
RenderingAttributes_SetNumberOfPeels(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the numberOfPeels in the object.
    obj->data->SetNumberOfPeels((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
RenderingAttributes_GetNumberOfPeels(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetNumberOfPeels()));
    return retval;
}

/*static*/ PyObject *
RenderingAttributes_SetMultiresolutionMode(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the multiresolutionMode in the object.
    obj->data->SetMultiresolutionMode(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
RenderingAttributes_GetMultiresolutionMode(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetMultiresolutionMode()?1L:0L);
    return retval;
}

/*static*/ PyObject *
RenderingAttributes_SetMultiresolutionCellSize(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;

    float fval;
    if(!PyArg_ParseTuple(args, "f", &fval))
        return NULL;

    // Set the multiresolutionCellSize in the object.
    obj->data->SetMultiresolutionCellSize(fval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
RenderingAttributes_GetMultiresolutionCellSize(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(double(obj->data->GetMultiresolutionCellSize()));
    return retval;
}

/*static*/ PyObject *
RenderingAttributes_SetGeometryRepresentation(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the geometryRepresentation in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetGeometryRepresentation(RenderingAttributes::GeometryRepresentation(ival));
    else
    {
        fprintf(stderr, "An invalid geometryRepresentation value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Surfaces, Wireframe, Points.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
RenderingAttributes_GetGeometryRepresentation(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetGeometryRepresentation()));
    return retval;
}

/*static*/ PyObject *
RenderingAttributes_SetStereoRendering(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the stereoRendering in the object.
    obj->data->SetStereoRendering(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
RenderingAttributes_GetStereoRendering(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetStereoRendering()?1L:0L);
    return retval;
}

/*static*/ PyObject *
RenderingAttributes_SetStereoType(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the stereoType in the object.
    if(ival >= 0 && ival < 4)
        obj->data->SetStereoType(RenderingAttributes::StereoTypes(ival));
    else
    {
        fprintf(stderr, "An invalid stereoType value was given. "
                        "Valid values are in the range of [0,3]. "
                        "You can also use the following names: "
                        "RedBlue, Interlaced, CrystalEyes, RedGreen.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
RenderingAttributes_GetStereoType(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetStereoType()));
    return retval;
}

/*static*/ PyObject *
RenderingAttributes_SetNotifyForEachRender(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the notifyForEachRender in the object.
    obj->data->SetNotifyForEachRender(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
RenderingAttributes_GetNotifyForEachRender(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetNotifyForEachRender()?1L:0L);
    return retval;
}

/*static*/ PyObject *
RenderingAttributes_SetScalableActivationMode(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the scalableActivationMode in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetScalableActivationMode(RenderingAttributes::TriStateMode(ival));
    else
    {
        fprintf(stderr, "An invalid scalableActivationMode value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Never, Always, Auto.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
RenderingAttributes_GetScalableActivationMode(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetScalableActivationMode()));
    return retval;
}

/*static*/ PyObject *
RenderingAttributes_SetScalableAutoThreshold(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the scalableAutoThreshold in the object.
    obj->data->SetScalableAutoThreshold((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
RenderingAttributes_GetScalableAutoThreshold(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetScalableAutoThreshold()));
    return retval;
}

/*static*/ PyObject *
RenderingAttributes_SetSpecularFlag(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the specularFlag in the object.
    obj->data->SetSpecularFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
RenderingAttributes_GetSpecularFlag(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetSpecularFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
RenderingAttributes_SetSpecularCoeff(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;

    float fval;
    if(!PyArg_ParseTuple(args, "f", &fval))
        return NULL;

    // Set the specularCoeff in the object.
    obj->data->SetSpecularCoeff(fval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
RenderingAttributes_GetSpecularCoeff(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(double(obj->data->GetSpecularCoeff()));
    return retval;
}

/*static*/ PyObject *
RenderingAttributes_SetSpecularPower(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;

    float fval;
    if(!PyArg_ParseTuple(args, "f", &fval))
        return NULL;

    // Set the specularPower in the object.
    obj->data->SetSpecularPower(fval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
RenderingAttributes_GetSpecularPower(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(double(obj->data->GetSpecularPower()));
    return retval;
}

/*static*/ PyObject *
RenderingAttributes_SetSpecularColor(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;

    int c[4];
    if(!PyArg_ParseTuple(args, "iiii", &c[0], &c[1], &c[2], &c[3]))
    {
        c[3] = 255;
        if(!PyArg_ParseTuple(args, "iii", &c[0], &c[1], &c[2]))
        {
            double dr, dg, db, da;
            if(PyArg_ParseTuple(args, "dddd", &dr, &dg, &db, &da))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = int(da);
            }
            else if(PyArg_ParseTuple(args, "ddd", &dr, &dg, &db))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = 255;
            }
            else
            {
                PyObject *tuple = NULL;
                if(!PyArg_ParseTuple(args, "O", &tuple))
                    return NULL;

                if(!PyTuple_Check(tuple))
                    return NULL;

                // Make sure that the tuple is the right size.
                if(PyTuple_Size(tuple) < 3 || PyTuple_Size(tuple) > 4)
                    return NULL;

                // Make sure that all elements in the tuple are ints.
                for(int i = 0; i < PyTuple_Size(tuple); ++i)
                {
                    PyObject *item = PyTuple_GET_ITEM(tuple, i);
                    if(PyInt_Check(item))
                        c[i] = int(PyInt_AS_LONG(PyTuple_GET_ITEM(tuple, i)));
                    else if(PyFloat_Check(item))
                        c[i] = int(PyFloat_AS_DOUBLE(PyTuple_GET_ITEM(tuple, i)));
                    else
                        return NULL;
                }
            }
        }
        PyErr_Clear();
    }

    // Set the specularColor in the object.
    ColorAttribute ca(c[0], c[1], c[2], c[3]);
    obj->data->SetSpecularColor(ca);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
RenderingAttributes_GetSpecularColor(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the specularColor.
    PyObject *retval = PyTuple_New(4);
    const unsigned char *specularColor = obj->data->GetSpecularColor().GetColor();
    PyTuple_SET_ITEM(retval, 0, PyInt_FromLong(long(specularColor[0])));
    PyTuple_SET_ITEM(retval, 1, PyInt_FromLong(long(specularColor[1])));
    PyTuple_SET_ITEM(retval, 2, PyInt_FromLong(long(specularColor[2])));
    PyTuple_SET_ITEM(retval, 3, PyInt_FromLong(long(specularColor[3])));
    return retval;
}

/*static*/ PyObject *
RenderingAttributes_SetDoShadowing(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the doShadowing in the object.
    obj->data->SetDoShadowing(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
RenderingAttributes_GetDoShadowing(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetDoShadowing()?1L:0L);
    return retval;
}

/*static*/ PyObject *
RenderingAttributes_SetShadowStrength(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the shadowStrength in the object.
    obj->data->SetShadowStrength(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
RenderingAttributes_GetShadowStrength(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetShadowStrength());
    return retval;
}

/*static*/ PyObject *
RenderingAttributes_SetDoDepthCueing(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the doDepthCueing in the object.
    obj->data->SetDoDepthCueing(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
RenderingAttributes_GetDoDepthCueing(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetDoDepthCueing()?1L:0L);
    return retval;
}

/*static*/ PyObject *
RenderingAttributes_SetDepthCueingAutomatic(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the depthCueingAutomatic in the object.
    obj->data->SetDepthCueingAutomatic(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
RenderingAttributes_GetDepthCueingAutomatic(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetDepthCueingAutomatic()?1L:0L);
    return retval;
}

/*static*/ PyObject *
RenderingAttributes_SetStartCuePoint(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;

    double *dvals = obj->data->GetStartCuePoint();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the startCuePoint in the object as modified.
    obj->data->SelectStartCuePoint();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
RenderingAttributes_GetStartCuePoint(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the startCuePoint.
    PyObject *retval = PyTuple_New(3);
    const double *startCuePoint = obj->data->GetStartCuePoint();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(startCuePoint[i]));
    return retval;
}

/*static*/ PyObject *
RenderingAttributes_SetEndCuePoint(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;

    double *dvals = obj->data->GetEndCuePoint();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the endCuePoint in the object as modified.
    obj->data->SelectEndCuePoint();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
RenderingAttributes_GetEndCuePoint(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the endCuePoint.
    PyObject *retval = PyTuple_New(3);
    const double *endCuePoint = obj->data->GetEndCuePoint();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(endCuePoint[i]));
    return retval;
}

/*static*/ PyObject *
RenderingAttributes_SetCompressionActivationMode(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the compressionActivationMode in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetCompressionActivationMode(RenderingAttributes::TriStateMode(ival));
    else
    {
        fprintf(stderr, "An invalid compressionActivationMode value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Never, Always, Auto.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
RenderingAttributes_GetCompressionActivationMode(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetCompressionActivationMode()));
    return retval;
}

/*static*/ PyObject *
RenderingAttributes_SetColorTexturingFlag(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the colorTexturingFlag in the object.
    obj->data->SetColorTexturingFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
RenderingAttributes_GetColorTexturingFlag(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetColorTexturingFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
RenderingAttributes_SetCompactDomainsActivationMode(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the compactDomainsActivationMode in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetCompactDomainsActivationMode(RenderingAttributes::TriStateMode(ival));
    else
    {
        fprintf(stderr, "An invalid compactDomainsActivationMode value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Never, Always, Auto.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
RenderingAttributes_GetCompactDomainsActivationMode(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetCompactDomainsActivationMode()));
    return retval;
}

/*static*/ PyObject *
RenderingAttributes_SetCompactDomainsAutoThreshold(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the compactDomainsAutoThreshold in the object.
    obj->data->SetCompactDomainsAutoThreshold((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
RenderingAttributes_GetCompactDomainsAutoThreshold(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetCompactDomainsAutoThreshold()));
    return retval;
}

/*static*/ PyObject *
RenderingAttributes_SetOsprayRendering(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the osprayRendering in the object.
    obj->data->SetOsprayRendering(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
RenderingAttributes_GetOsprayRendering(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetOsprayRendering()?1L:0L);
    return retval;
}

/*static*/ PyObject *
RenderingAttributes_SetOspraySPP(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the ospraySPP in the object.
    obj->data->SetOspraySPP((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
RenderingAttributes_GetOspraySPP(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetOspraySPP()));
    return retval;
}

/*static*/ PyObject *
RenderingAttributes_SetOsprayAO(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the osprayAO in the object.
    obj->data->SetOsprayAO((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
RenderingAttributes_GetOsprayAO(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetOsprayAO()));
    return retval;
}

/*static*/ PyObject *
RenderingAttributes_SetOsprayShadows(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the osprayShadows in the object.
    obj->data->SetOsprayShadows(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
RenderingAttributes_GetOsprayShadows(PyObject *self, PyObject *args)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetOsprayShadows()?1L:0L);
    return retval;
}



PyMethodDef PyRenderingAttributes_methods[RENDERINGATTRIBUTES_NMETH] = {
    {"Notify", RenderingAttributes_Notify, METH_VARARGS},
    {"SetAntialiasing", RenderingAttributes_SetAntialiasing, METH_VARARGS},
    {"GetAntialiasing", RenderingAttributes_GetAntialiasing, METH_VARARGS},
    {"SetOrderComposite", RenderingAttributes_SetOrderComposite, METH_VARARGS},
    {"GetOrderComposite", RenderingAttributes_GetOrderComposite, METH_VARARGS},
    {"SetDepthCompositeThreads", RenderingAttributes_SetDepthCompositeThreads, METH_VARARGS},
    {"GetDepthCompositeThreads", RenderingAttributes_GetDepthCompositeThreads, METH_VARARGS},
    {"SetDepthCompositeBlocking", RenderingAttributes_SetDepthCompositeBlocking, METH_VARARGS},
    {"GetDepthCompositeBlocking", RenderingAttributes_GetDepthCompositeBlocking, METH_VARARGS},
    {"SetAlphaCompositeThreads", RenderingAttributes_SetAlphaCompositeThreads, METH_VARARGS},
    {"GetAlphaCompositeThreads", RenderingAttributes_GetAlphaCompositeThreads, METH_VARARGS},
    {"SetAlphaCompositeBlocking", RenderingAttributes_SetAlphaCompositeBlocking, METH_VARARGS},
    {"GetAlphaCompositeBlocking", RenderingAttributes_GetAlphaCompositeBlocking, METH_VARARGS},
    {"SetDepthPeeling", RenderingAttributes_SetDepthPeeling, METH_VARARGS},
    {"GetDepthPeeling", RenderingAttributes_GetDepthPeeling, METH_VARARGS},
    {"SetOcclusionRatio", RenderingAttributes_SetOcclusionRatio, METH_VARARGS},
    {"GetOcclusionRatio", RenderingAttributes_GetOcclusionRatio, METH_VARARGS},
    {"SetNumberOfPeels", RenderingAttributes_SetNumberOfPeels, METH_VARARGS},
    {"GetNumberOfPeels", RenderingAttributes_GetNumberOfPeels, METH_VARARGS},
    {"SetMultiresolutionMode", RenderingAttributes_SetMultiresolutionMode, METH_VARARGS},
    {"GetMultiresolutionMode", RenderingAttributes_GetMultiresolutionMode, METH_VARARGS},
    {"SetMultiresolutionCellSize", RenderingAttributes_SetMultiresolutionCellSize, METH_VARARGS},
    {"GetMultiresolutionCellSize", RenderingAttributes_GetMultiresolutionCellSize, METH_VARARGS},
    {"SetGeometryRepresentation", RenderingAttributes_SetGeometryRepresentation, METH_VARARGS},
    {"GetGeometryRepresentation", RenderingAttributes_GetGeometryRepresentation, METH_VARARGS},
    {"SetStereoRendering", RenderingAttributes_SetStereoRendering, METH_VARARGS},
    {"GetStereoRendering", RenderingAttributes_GetStereoRendering, METH_VARARGS},
    {"SetStereoType", RenderingAttributes_SetStereoType, METH_VARARGS},
    {"GetStereoType", RenderingAttributes_GetStereoType, METH_VARARGS},
    {"SetNotifyForEachRender", RenderingAttributes_SetNotifyForEachRender, METH_VARARGS},
    {"GetNotifyForEachRender", RenderingAttributes_GetNotifyForEachRender, METH_VARARGS},
    {"SetScalableActivationMode", RenderingAttributes_SetScalableActivationMode, METH_VARARGS},
    {"GetScalableActivationMode", RenderingAttributes_GetScalableActivationMode, METH_VARARGS},
    {"SetScalableAutoThreshold", RenderingAttributes_SetScalableAutoThreshold, METH_VARARGS},
    {"GetScalableAutoThreshold", RenderingAttributes_GetScalableAutoThreshold, METH_VARARGS},
    {"SetSpecularFlag", RenderingAttributes_SetSpecularFlag, METH_VARARGS},
    {"GetSpecularFlag", RenderingAttributes_GetSpecularFlag, METH_VARARGS},
    {"SetSpecularCoeff", RenderingAttributes_SetSpecularCoeff, METH_VARARGS},
    {"GetSpecularCoeff", RenderingAttributes_GetSpecularCoeff, METH_VARARGS},
    {"SetSpecularPower", RenderingAttributes_SetSpecularPower, METH_VARARGS},
    {"GetSpecularPower", RenderingAttributes_GetSpecularPower, METH_VARARGS},
    {"SetSpecularColor", RenderingAttributes_SetSpecularColor, METH_VARARGS},
    {"GetSpecularColor", RenderingAttributes_GetSpecularColor, METH_VARARGS},
    {"SetDoShadowing", RenderingAttributes_SetDoShadowing, METH_VARARGS},
    {"GetDoShadowing", RenderingAttributes_GetDoShadowing, METH_VARARGS},
    {"SetShadowStrength", RenderingAttributes_SetShadowStrength, METH_VARARGS},
    {"GetShadowStrength", RenderingAttributes_GetShadowStrength, METH_VARARGS},
    {"SetDoDepthCueing", RenderingAttributes_SetDoDepthCueing, METH_VARARGS},
    {"GetDoDepthCueing", RenderingAttributes_GetDoDepthCueing, METH_VARARGS},
    {"SetDepthCueingAutomatic", RenderingAttributes_SetDepthCueingAutomatic, METH_VARARGS},
    {"GetDepthCueingAutomatic", RenderingAttributes_GetDepthCueingAutomatic, METH_VARARGS},
    {"SetStartCuePoint", RenderingAttributes_SetStartCuePoint, METH_VARARGS},
    {"GetStartCuePoint", RenderingAttributes_GetStartCuePoint, METH_VARARGS},
    {"SetEndCuePoint", RenderingAttributes_SetEndCuePoint, METH_VARARGS},
    {"GetEndCuePoint", RenderingAttributes_GetEndCuePoint, METH_VARARGS},
    {"SetCompressionActivationMode", RenderingAttributes_SetCompressionActivationMode, METH_VARARGS},
    {"GetCompressionActivationMode", RenderingAttributes_GetCompressionActivationMode, METH_VARARGS},
    {"SetColorTexturingFlag", RenderingAttributes_SetColorTexturingFlag, METH_VARARGS},
    {"GetColorTexturingFlag", RenderingAttributes_GetColorTexturingFlag, METH_VARARGS},
    {"SetCompactDomainsActivationMode", RenderingAttributes_SetCompactDomainsActivationMode, METH_VARARGS},
    {"GetCompactDomainsActivationMode", RenderingAttributes_GetCompactDomainsActivationMode, METH_VARARGS},
    {"SetCompactDomainsAutoThreshold", RenderingAttributes_SetCompactDomainsAutoThreshold, METH_VARARGS},
    {"GetCompactDomainsAutoThreshold", RenderingAttributes_GetCompactDomainsAutoThreshold, METH_VARARGS},
    {"SetOsprayRendering", RenderingAttributes_SetOsprayRendering, METH_VARARGS},
    {"GetOsprayRendering", RenderingAttributes_GetOsprayRendering, METH_VARARGS},
    {"SetOspraySPP", RenderingAttributes_SetOspraySPP, METH_VARARGS},
    {"GetOspraySPP", RenderingAttributes_GetOspraySPP, METH_VARARGS},
    {"SetOsprayAO", RenderingAttributes_SetOsprayAO, METH_VARARGS},
    {"GetOsprayAO", RenderingAttributes_GetOsprayAO, METH_VARARGS},
    {"SetOsprayShadows", RenderingAttributes_SetOsprayShadows, METH_VARARGS},
    {"GetOsprayShadows", RenderingAttributes_GetOsprayShadows, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
RenderingAttributes_dealloc(PyObject *v)
{
   RenderingAttributesObject *obj = (RenderingAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
RenderingAttributes_compare(PyObject *v, PyObject *w)
{
    RenderingAttributes *a = ((RenderingAttributesObject *)v)->data;
    RenderingAttributes *b = ((RenderingAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyRenderingAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "antialiasing") == 0)
        return RenderingAttributes_GetAntialiasing(self, NULL);
    if(strcmp(name, "orderComposite") == 0)
        return RenderingAttributes_GetOrderComposite(self, NULL);
    if(strcmp(name, "depthCompositeThreads") == 0)
        return RenderingAttributes_GetDepthCompositeThreads(self, NULL);
    if(strcmp(name, "depthCompositeBlocking") == 0)
        return RenderingAttributes_GetDepthCompositeBlocking(self, NULL);
    if(strcmp(name, "alphaCompositeThreads") == 0)
        return RenderingAttributes_GetAlphaCompositeThreads(self, NULL);
    if(strcmp(name, "alphaCompositeBlocking") == 0)
        return RenderingAttributes_GetAlphaCompositeBlocking(self, NULL);
    if(strcmp(name, "depthPeeling") == 0)
        return RenderingAttributes_GetDepthPeeling(self, NULL);
    if(strcmp(name, "occlusionRatio") == 0)
        return RenderingAttributes_GetOcclusionRatio(self, NULL);
    if(strcmp(name, "numberOfPeels") == 0)
        return RenderingAttributes_GetNumberOfPeels(self, NULL);
    if(strcmp(name, "multiresolutionMode") == 0)
        return RenderingAttributes_GetMultiresolutionMode(self, NULL);
    if(strcmp(name, "multiresolutionCellSize") == 0)
        return RenderingAttributes_GetMultiresolutionCellSize(self, NULL);
    if(strcmp(name, "geometryRepresentation") == 0)
        return RenderingAttributes_GetGeometryRepresentation(self, NULL);
    if(strcmp(name, "Surfaces") == 0)
        return PyInt_FromLong(long(RenderingAttributes::Surfaces));
    if(strcmp(name, "Wireframe") == 0)
        return PyInt_FromLong(long(RenderingAttributes::Wireframe));
    if(strcmp(name, "Points") == 0)
        return PyInt_FromLong(long(RenderingAttributes::Points));

    if(strcmp(name, "stereoRendering") == 0)
        return RenderingAttributes_GetStereoRendering(self, NULL);
    if(strcmp(name, "stereoType") == 0)
        return RenderingAttributes_GetStereoType(self, NULL);
    if(strcmp(name, "RedBlue") == 0)
        return PyInt_FromLong(long(RenderingAttributes::RedBlue));
    if(strcmp(name, "Interlaced") == 0)
        return PyInt_FromLong(long(RenderingAttributes::Interlaced));
    if(strcmp(name, "CrystalEyes") == 0)
        return PyInt_FromLong(long(RenderingAttributes::CrystalEyes));
    if(strcmp(name, "RedGreen") == 0)
        return PyInt_FromLong(long(RenderingAttributes::RedGreen));

    if(strcmp(name, "notifyForEachRender") == 0)
        return RenderingAttributes_GetNotifyForEachRender(self, NULL);
    if(strcmp(name, "scalableActivationMode") == 0)
        return RenderingAttributes_GetScalableActivationMode(self, NULL);
    if(strcmp(name, "Never") == 0)
        return PyInt_FromLong(long(RenderingAttributes::Never));
    if(strcmp(name, "Always") == 0)
        return PyInt_FromLong(long(RenderingAttributes::Always));
    if(strcmp(name, "Auto") == 0)
        return PyInt_FromLong(long(RenderingAttributes::Auto));

    if(strcmp(name, "scalableAutoThreshold") == 0)
        return RenderingAttributes_GetScalableAutoThreshold(self, NULL);
    if(strcmp(name, "specularFlag") == 0)
        return RenderingAttributes_GetSpecularFlag(self, NULL);
    if(strcmp(name, "specularCoeff") == 0)
        return RenderingAttributes_GetSpecularCoeff(self, NULL);
    if(strcmp(name, "specularPower") == 0)
        return RenderingAttributes_GetSpecularPower(self, NULL);
    if(strcmp(name, "specularColor") == 0)
        return RenderingAttributes_GetSpecularColor(self, NULL);
    if(strcmp(name, "doShadowing") == 0)
        return RenderingAttributes_GetDoShadowing(self, NULL);
    if(strcmp(name, "shadowStrength") == 0)
        return RenderingAttributes_GetShadowStrength(self, NULL);
    if(strcmp(name, "doDepthCueing") == 0)
        return RenderingAttributes_GetDoDepthCueing(self, NULL);
    if(strcmp(name, "depthCueingAutomatic") == 0)
        return RenderingAttributes_GetDepthCueingAutomatic(self, NULL);
    if(strcmp(name, "startCuePoint") == 0)
        return RenderingAttributes_GetStartCuePoint(self, NULL);
    if(strcmp(name, "endCuePoint") == 0)
        return RenderingAttributes_GetEndCuePoint(self, NULL);
    if(strcmp(name, "compressionActivationMode") == 0)
        return RenderingAttributes_GetCompressionActivationMode(self, NULL);
    if(strcmp(name, "Never") == 0)
        return PyInt_FromLong(long(RenderingAttributes::Never));
    if(strcmp(name, "Always") == 0)
        return PyInt_FromLong(long(RenderingAttributes::Always));
    if(strcmp(name, "Auto") == 0)
        return PyInt_FromLong(long(RenderingAttributes::Auto));

    if(strcmp(name, "colorTexturingFlag") == 0)
        return RenderingAttributes_GetColorTexturingFlag(self, NULL);
    if(strcmp(name, "compactDomainsActivationMode") == 0)
        return RenderingAttributes_GetCompactDomainsActivationMode(self, NULL);
    if(strcmp(name, "Never") == 0)
        return PyInt_FromLong(long(RenderingAttributes::Never));
    if(strcmp(name, "Always") == 0)
        return PyInt_FromLong(long(RenderingAttributes::Always));
    if(strcmp(name, "Auto") == 0)
        return PyInt_FromLong(long(RenderingAttributes::Auto));

    if(strcmp(name, "compactDomainsAutoThreshold") == 0)
        return RenderingAttributes_GetCompactDomainsAutoThreshold(self, NULL);
    if(strcmp(name, "osprayRendering") == 0)
        return RenderingAttributes_GetOsprayRendering(self, NULL);
    if(strcmp(name, "ospraySPP") == 0)
        return RenderingAttributes_GetOspraySPP(self, NULL);
    if(strcmp(name, "osprayAO") == 0)
        return RenderingAttributes_GetOsprayAO(self, NULL);
    if(strcmp(name, "osprayShadows") == 0)
        return RenderingAttributes_GetOsprayShadows(self, NULL);

    return Py_FindMethod(PyRenderingAttributes_methods, self, name);
}

int
PyRenderingAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "antialiasing") == 0)
        obj = RenderingAttributes_SetAntialiasing(self, tuple);
    else if(strcmp(name, "orderComposite") == 0)
        obj = RenderingAttributes_SetOrderComposite(self, tuple);
    else if(strcmp(name, "depthCompositeThreads") == 0)
        obj = RenderingAttributes_SetDepthCompositeThreads(self, tuple);
    else if(strcmp(name, "depthCompositeBlocking") == 0)
        obj = RenderingAttributes_SetDepthCompositeBlocking(self, tuple);
    else if(strcmp(name, "alphaCompositeThreads") == 0)
        obj = RenderingAttributes_SetAlphaCompositeThreads(self, tuple);
    else if(strcmp(name, "alphaCompositeBlocking") == 0)
        obj = RenderingAttributes_SetAlphaCompositeBlocking(self, tuple);
    else if(strcmp(name, "depthPeeling") == 0)
        obj = RenderingAttributes_SetDepthPeeling(self, tuple);
    else if(strcmp(name, "occlusionRatio") == 0)
        obj = RenderingAttributes_SetOcclusionRatio(self, tuple);
    else if(strcmp(name, "numberOfPeels") == 0)
        obj = RenderingAttributes_SetNumberOfPeels(self, tuple);
    else if(strcmp(name, "multiresolutionMode") == 0)
        obj = RenderingAttributes_SetMultiresolutionMode(self, tuple);
    else if(strcmp(name, "multiresolutionCellSize") == 0)
        obj = RenderingAttributes_SetMultiresolutionCellSize(self, tuple);
    else if(strcmp(name, "geometryRepresentation") == 0)
        obj = RenderingAttributes_SetGeometryRepresentation(self, tuple);
    else if(strcmp(name, "stereoRendering") == 0)
        obj = RenderingAttributes_SetStereoRendering(self, tuple);
    else if(strcmp(name, "stereoType") == 0)
        obj = RenderingAttributes_SetStereoType(self, tuple);
    else if(strcmp(name, "notifyForEachRender") == 0)
        obj = RenderingAttributes_SetNotifyForEachRender(self, tuple);
    else if(strcmp(name, "scalableActivationMode") == 0)
        obj = RenderingAttributes_SetScalableActivationMode(self, tuple);
    else if(strcmp(name, "scalableAutoThreshold") == 0)
        obj = RenderingAttributes_SetScalableAutoThreshold(self, tuple);
    else if(strcmp(name, "specularFlag") == 0)
        obj = RenderingAttributes_SetSpecularFlag(self, tuple);
    else if(strcmp(name, "specularCoeff") == 0)
        obj = RenderingAttributes_SetSpecularCoeff(self, tuple);
    else if(strcmp(name, "specularPower") == 0)
        obj = RenderingAttributes_SetSpecularPower(self, tuple);
    else if(strcmp(name, "specularColor") == 0)
        obj = RenderingAttributes_SetSpecularColor(self, tuple);
    else if(strcmp(name, "doShadowing") == 0)
        obj = RenderingAttributes_SetDoShadowing(self, tuple);
    else if(strcmp(name, "shadowStrength") == 0)
        obj = RenderingAttributes_SetShadowStrength(self, tuple);
    else if(strcmp(name, "doDepthCueing") == 0)
        obj = RenderingAttributes_SetDoDepthCueing(self, tuple);
    else if(strcmp(name, "depthCueingAutomatic") == 0)
        obj = RenderingAttributes_SetDepthCueingAutomatic(self, tuple);
    else if(strcmp(name, "startCuePoint") == 0)
        obj = RenderingAttributes_SetStartCuePoint(self, tuple);
    else if(strcmp(name, "endCuePoint") == 0)
        obj = RenderingAttributes_SetEndCuePoint(self, tuple);
    else if(strcmp(name, "compressionActivationMode") == 0)
        obj = RenderingAttributes_SetCompressionActivationMode(self, tuple);
    else if(strcmp(name, "colorTexturingFlag") == 0)
        obj = RenderingAttributes_SetColorTexturingFlag(self, tuple);
    else if(strcmp(name, "compactDomainsActivationMode") == 0)
        obj = RenderingAttributes_SetCompactDomainsActivationMode(self, tuple);
    else if(strcmp(name, "compactDomainsAutoThreshold") == 0)
        obj = RenderingAttributes_SetCompactDomainsAutoThreshold(self, tuple);
    else if(strcmp(name, "osprayRendering") == 0)
        obj = RenderingAttributes_SetOsprayRendering(self, tuple);
    else if(strcmp(name, "ospraySPP") == 0)
        obj = RenderingAttributes_SetOspraySPP(self, tuple);
    else if(strcmp(name, "osprayAO") == 0)
        obj = RenderingAttributes_SetOsprayAO(self, tuple);
    else if(strcmp(name, "osprayShadows") == 0)
        obj = RenderingAttributes_SetOsprayShadows(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
RenderingAttributes_print(PyObject *v, FILE *fp, int flags)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)v;
    fprintf(fp, "%s", PyRenderingAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
RenderingAttributes_str(PyObject *v)
{
    RenderingAttributesObject *obj = (RenderingAttributesObject *)v;
    return PyString_FromString(PyRenderingAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *RenderingAttributes_Purpose = "This class contains special rendering attributes like antialiasing and stero settings.";
#else
static char *RenderingAttributes_Purpose = "This class contains special rendering attributes like antialiasing and stero settings.";
#endif

//
// The type description structure
//
static PyTypeObject RenderingAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "RenderingAttributes",                    // tp_name
    sizeof(RenderingAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)RenderingAttributes_dealloc,  // tp_dealloc
    (printfunc)RenderingAttributes_print,     // tp_print
    (getattrfunc)PyRenderingAttributes_getattr, // tp_getattr
    (setattrfunc)PyRenderingAttributes_setattr, // tp_setattr
    (cmpfunc)RenderingAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)RenderingAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    RenderingAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static RenderingAttributes *defaultAtts = 0;
static RenderingAttributes *currentAtts = 0;

static PyObject *
NewRenderingAttributes(int useCurrent)
{
    RenderingAttributesObject *newObject;
    newObject = PyObject_NEW(RenderingAttributesObject, &RenderingAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new RenderingAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new RenderingAttributes(*defaultAtts);
    else
        newObject->data = new RenderingAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapRenderingAttributes(const RenderingAttributes *attr)
{
    RenderingAttributesObject *newObject;
    newObject = PyObject_NEW(RenderingAttributesObject, &RenderingAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (RenderingAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
RenderingAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewRenderingAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef RenderingAttributesMethods[] = {
    {"RenderingAttributes", RenderingAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *RenderingAttributesObserver = 0;

std::string
PyRenderingAttributes_GetLogString()
{
    std::string s("RenderingAtts = RenderingAttributes()\n");
    if(currentAtts != 0)
        s += PyRenderingAttributes_ToString(currentAtts, "RenderingAtts.");
    return s;
}

static void
PyRenderingAttributes_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("RenderingAtts = RenderingAttributes()\n");
        s += PyRenderingAttributes_ToString(currentAtts, "RenderingAtts.");
        cb(s);
    }
}

void
PyRenderingAttributes_StartUp(RenderingAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyRenderingAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(RenderingAttributesObserver == 0)
    {
        RenderingAttributesObserver = new ObserverToCallback(subj,
            PyRenderingAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyRenderingAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete RenderingAttributesObserver;
    RenderingAttributesObserver = 0;
}

PyMethodDef *
PyRenderingAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return RenderingAttributesMethods;
}

bool
PyRenderingAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &RenderingAttributesType);
}

RenderingAttributes *
PyRenderingAttributes_FromPyObject(PyObject *obj)
{
    RenderingAttributesObject *obj2 = (RenderingAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyRenderingAttributes_New()
{
    return NewRenderingAttributes(0);
}

PyObject *
PyRenderingAttributes_Wrap(const RenderingAttributes *attr)
{
    return WrapRenderingAttributes(attr);
}

void
PyRenderingAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    RenderingAttributesObject *obj2 = (RenderingAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyRenderingAttributes_SetDefaults(const RenderingAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new RenderingAttributes(*atts);
}

