/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyColorControlPointList.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>
#include <PyColorControlPoint.h>

// ****************************************************************************
// Module: PyColorControlPointList
//
// Purpose: 
//   This class contains a list of ColorControlPoint objects.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a ColorControlPointList.
//
struct ColorControlPointListObject
{
    PyObject_HEAD
    ColorControlPointList *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewColorControlPointList(int);

std::string
PyColorControlPointList_ToString(const ColorControlPointList *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    { // new scope
        int index = 0;
        // Create string representation of controlPoints from atts.
        for(AttributeGroupVector::const_iterator pos = atts->GetControlPoints().begin(); pos != atts->GetControlPoints().end(); ++pos, ++index)
        {
            const ColorControlPoint *current = (const ColorControlPoint *)(*pos);
            SNPRINTF(tmpStr, 1000, "GetControlPoints(%d).", index);
            std::string objPrefix(prefix + std::string(tmpStr));
            str += PyColorControlPoint_ToString(current, objPrefix.c_str());
        }
        if(index == 0)
            str += "#controlPoints does not contain any ColorControlPoint objects.\n";
    }
    const char *smoothing_names = "None, Linear, CubicSpline";
    switch (atts->GetSmoothing())
    {
      case ColorControlPointList::None:
          SNPRINTF(tmpStr, 1000, "%ssmoothing = %sNone  # %s\n", prefix, prefix, smoothing_names);
          str += tmpStr;
          break;
      case ColorControlPointList::Linear:
          SNPRINTF(tmpStr, 1000, "%ssmoothing = %sLinear  # %s\n", prefix, prefix, smoothing_names);
          str += tmpStr;
          break;
      case ColorControlPointList::CubicSpline:
          SNPRINTF(tmpStr, 1000, "%ssmoothing = %sCubicSpline  # %s\n", prefix, prefix, smoothing_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    if(atts->GetEqualSpacingFlag())
        SNPRINTF(tmpStr, 1000, "%sequalSpacingFlag = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sequalSpacingFlag = 0\n", prefix);
    str += tmpStr;
    if(atts->GetDiscreteFlag())
        SNPRINTF(tmpStr, 1000, "%sdiscreteFlag = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sdiscreteFlag = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%scategoryName = \"%s\"\n", prefix, atts->GetCategoryName().c_str());
    str += tmpStr;
    return str;
}

static PyObject *
ColorControlPointList_Notify(PyObject *self, PyObject *args)
{
    ColorControlPointListObject *obj = (ColorControlPointListObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ColorControlPointList_GetControlPoints(PyObject *self, PyObject *args)
{
    ColorControlPointListObject *obj = (ColorControlPointListObject *)self;
    int index;
    if(!PyArg_ParseTuple(args, "i", &index))
        return NULL;
    if(index < 0 || (size_t)index >= obj->data->GetControlPoints().size())
    {
        char msg[400] = {'\0'};
        if(obj->data->GetControlPoints().size() == 0)
            SNPRINTF(msg, 400, "In ColorControlPointList::GetControlPoints : The index %d is invalid because controlPoints is empty.", index);
        else
            SNPRINTF(msg, 400, "In ColorControlPointList::GetControlPoints : The index %d is invalid. Use index values in: [0, %ld).",  index, obj->data->GetControlPoints().size());
        PyErr_SetString(PyExc_IndexError, msg);
        return NULL;
    }

    // Since the new object will point to data owned by the this object,
    // we need to increment the reference count.
    Py_INCREF(self);

    PyObject *retval = PyColorControlPoint_Wrap(&obj->data->GetControlPoints(index));
    // Set the object's parent so the reference to the parent can be decref'd
    // when the child goes out of scope.
    PyColorControlPoint_SetParent(retval, self);

    return retval;
}

PyObject *
ColorControlPointList_GetNumControlPoints(PyObject *self, PyObject *args)
{
    ColorControlPointListObject *obj = (ColorControlPointListObject *)self;
    return PyInt_FromLong((long)obj->data->GetControlPoints().size());
}

PyObject *
ColorControlPointList_AddControlPoints(PyObject *self, PyObject *args)
{
    ColorControlPointListObject *obj = (ColorControlPointListObject *)self;
    PyObject *element = NULL;
    if(!PyArg_ParseTuple(args, "O", &element))
        return NULL;
    if(!PyColorControlPoint_Check(element))
    {
        char msg[400] = {'\0'};
        SNPRINTF(msg, 400, "The ColorControlPointList::AddControlPoints method only accepts ColorControlPoint objects.");
        PyErr_SetString(PyExc_TypeError, msg);
        return NULL;
    }
    ColorControlPoint *newData = PyColorControlPoint_FromPyObject(element);
    obj->data->AddControlPoints(*newData);
    obj->data->SelectControlPoints();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ColorControlPointList_Remove_One_ControlPoints(PyObject *self, int index)
{
    ColorControlPointListObject *obj = (ColorControlPointListObject *)self;
    // Remove in the AttributeGroupVector instead of calling RemoveControlPoints() because we don't want to delete the object; just remove it.
    AttributeGroupVector &atts = obj->data->GetControlPoints();
    AttributeGroupVector::iterator pos = atts.begin();
    // Iterate through the vector "index" times. 
    for(int i = 0; i < index; ++i)
        ++pos;

    // If pos is still a valid iterator, remove that element.
    if(pos != atts.end())
    {
        // NOTE: Leak the object since other Python objects may reference it. Ideally,
        // we would put the object into some type of pool to be cleaned up later but
        // this will do for now.
        //
        // delete *pos;
        atts.erase(pos);
    }

    obj->data->SelectControlPoints();
    Py_INCREF(Py_None);
    return Py_None;
}

PyObject *
ColorControlPointList_RemoveControlPoints(PyObject *self, PyObject *args)
{
    int index;
    if(!PyArg_ParseTuple(args, "i", &index))
        return NULL;
    ColorControlPointListObject *obj = (ColorControlPointListObject *)self;
    if(index < 0 || index >= obj->data->GetNumControlPoints())
    {
        char msg[400] = {'\0'};
        SNPRINTF(msg, 400, "In ColorControlPointList::RemoveControlPoints : Index %d is out of range", index);
        PyErr_SetString(PyExc_IndexError, msg);
        return NULL;
    }

    return ColorControlPointList_Remove_One_ControlPoints(self, index);
}

PyObject *
ColorControlPointList_ClearControlPoints(PyObject *self, PyObject *args)
{
    ColorControlPointListObject *obj = (ColorControlPointListObject *)self;
    int n = obj->data->GetNumControlPoints();
    for(int i = 0; i < n; ++i)
    {
        ColorControlPointList_Remove_One_ControlPoints(self, 0);
        Py_DECREF(Py_None);
    }
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ColorControlPointList_SetSmoothing(PyObject *self, PyObject *args)
{
    ColorControlPointListObject *obj = (ColorControlPointListObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the smoothing in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetSmoothing(ColorControlPointList::SmoothingMethod(ival));
    else
    {
        fprintf(stderr, "An invalid smoothing value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "None, Linear, CubicSpline.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ColorControlPointList_GetSmoothing(PyObject *self, PyObject *args)
{
    ColorControlPointListObject *obj = (ColorControlPointListObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetSmoothing()));
    return retval;
}

/*static*/ PyObject *
ColorControlPointList_SetEqualSpacingFlag(PyObject *self, PyObject *args)
{
    ColorControlPointListObject *obj = (ColorControlPointListObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the equalSpacingFlag in the object.
    obj->data->SetEqualSpacingFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ColorControlPointList_GetEqualSpacingFlag(PyObject *self, PyObject *args)
{
    ColorControlPointListObject *obj = (ColorControlPointListObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetEqualSpacingFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
ColorControlPointList_SetDiscreteFlag(PyObject *self, PyObject *args)
{
    ColorControlPointListObject *obj = (ColorControlPointListObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the discreteFlag in the object.
    obj->data->SetDiscreteFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ColorControlPointList_GetDiscreteFlag(PyObject *self, PyObject *args)
{
    ColorControlPointListObject *obj = (ColorControlPointListObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetDiscreteFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
ColorControlPointList_SetCategoryName(PyObject *self, PyObject *args)
{
    ColorControlPointListObject *obj = (ColorControlPointListObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the categoryName in the object.
    obj->data->SetCategoryName(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ColorControlPointList_GetCategoryName(PyObject *self, PyObject *args)
{
    ColorControlPointListObject *obj = (ColorControlPointListObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetCategoryName().c_str());
    return retval;
}



PyMethodDef PyColorControlPointList_methods[COLORCONTROLPOINTLIST_NMETH] = {
    {"Notify", ColorControlPointList_Notify, METH_VARARGS},
    {"GetControlPoints", ColorControlPointList_GetControlPoints, METH_VARARGS},
    {"GetNumControlPoints", ColorControlPointList_GetNumControlPoints, METH_VARARGS},
    {"AddControlPoints", ColorControlPointList_AddControlPoints, METH_VARARGS},
    {"RemoveControlPoints", ColorControlPointList_RemoveControlPoints, METH_VARARGS},
    {"ClearControlPoints", ColorControlPointList_ClearControlPoints, METH_VARARGS},
    {"SetSmoothing", ColorControlPointList_SetSmoothing, METH_VARARGS},
    {"GetSmoothing", ColorControlPointList_GetSmoothing, METH_VARARGS},
    {"SetEqualSpacingFlag", ColorControlPointList_SetEqualSpacingFlag, METH_VARARGS},
    {"GetEqualSpacingFlag", ColorControlPointList_GetEqualSpacingFlag, METH_VARARGS},
    {"SetDiscreteFlag", ColorControlPointList_SetDiscreteFlag, METH_VARARGS},
    {"GetDiscreteFlag", ColorControlPointList_GetDiscreteFlag, METH_VARARGS},
    {"SetCategoryName", ColorControlPointList_SetCategoryName, METH_VARARGS},
    {"GetCategoryName", ColorControlPointList_GetCategoryName, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
ColorControlPointList_dealloc(PyObject *v)
{
   ColorControlPointListObject *obj = (ColorControlPointListObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
ColorControlPointList_compare(PyObject *v, PyObject *w)
{
    ColorControlPointList *a = ((ColorControlPointListObject *)v)->data;
    ColorControlPointList *b = ((ColorControlPointListObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyColorControlPointList_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "controlPoints") == 0)
        return ColorControlPointList_GetControlPoints(self, NULL);
    if(strcmp(name, "smoothing") == 0)
        return ColorControlPointList_GetSmoothing(self, NULL);
    if(strcmp(name, "None") == 0)
        return PyInt_FromLong(long(ColorControlPointList::None));
    if(strcmp(name, "Linear") == 0)
        return PyInt_FromLong(long(ColorControlPointList::Linear));
    if(strcmp(name, "CubicSpline") == 0)
        return PyInt_FromLong(long(ColorControlPointList::CubicSpline));

    if(strcmp(name, "equalSpacingFlag") == 0)
        return ColorControlPointList_GetEqualSpacingFlag(self, NULL);
    if(strcmp(name, "discreteFlag") == 0)
        return ColorControlPointList_GetDiscreteFlag(self, NULL);
    if(strcmp(name, "categoryName") == 0)
        return ColorControlPointList_GetCategoryName(self, NULL);

    return Py_FindMethod(PyColorControlPointList_methods, self, name);
}

int
PyColorControlPointList_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "smoothing") == 0 /* for now */ || strcmp(name, "smoothingFlag") == 0)
        obj = ColorControlPointList_SetSmoothing(self, tuple);
    else if(strcmp(name, "equalSpacingFlag") == 0)
        obj = ColorControlPointList_SetEqualSpacingFlag(self, tuple);
    else if(strcmp(name, "discreteFlag") == 0)
        obj = ColorControlPointList_SetDiscreteFlag(self, tuple);
    else if(strcmp(name, "categoryName") == 0)
        obj = ColorControlPointList_SetCategoryName(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
ColorControlPointList_print(PyObject *v, FILE *fp, int flags)
{
    ColorControlPointListObject *obj = (ColorControlPointListObject *)v;
    fprintf(fp, "%s", PyColorControlPointList_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
ColorControlPointList_str(PyObject *v)
{
    ColorControlPointListObject *obj = (ColorControlPointListObject *)v;
    return PyString_FromString(PyColorControlPointList_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *ColorControlPointList_Purpose = "This class contains a list of ColorControlPoint objects.";
#else
static char *ColorControlPointList_Purpose = "This class contains a list of ColorControlPoint objects.";
#endif

//
// The type description structure
//
static PyTypeObject ColorControlPointListType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "ColorControlPointList",                    // tp_name
    sizeof(ColorControlPointListObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)ColorControlPointList_dealloc,  // tp_dealloc
    (printfunc)ColorControlPointList_print,     // tp_print
    (getattrfunc)PyColorControlPointList_getattr, // tp_getattr
    (setattrfunc)PyColorControlPointList_setattr, // tp_setattr
    (cmpfunc)ColorControlPointList_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)ColorControlPointList_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    ColorControlPointList_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static ColorControlPointList *defaultAtts = 0;
static ColorControlPointList *currentAtts = 0;

static PyObject *
NewColorControlPointList(int useCurrent)
{
    ColorControlPointListObject *newObject;
    newObject = PyObject_NEW(ColorControlPointListObject, &ColorControlPointListType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new ColorControlPointList(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new ColorControlPointList(*defaultAtts);
    else
        newObject->data = new ColorControlPointList;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapColorControlPointList(const ColorControlPointList *attr)
{
    ColorControlPointListObject *newObject;
    newObject = PyObject_NEW(ColorControlPointListObject, &ColorControlPointListType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (ColorControlPointList *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
ColorControlPointList_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewColorControlPointList(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef ColorControlPointListMethods[] = {
    {"ColorControlPointList", ColorControlPointList_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *ColorControlPointListObserver = 0;

std::string
PyColorControlPointList_GetLogString()
{
    std::string s("ColorControlPointList = ColorControlPointList()\n");
    if(currentAtts != 0)
        s += PyColorControlPointList_ToString(currentAtts, "ColorControlPointList.");
    return s;
}

static void
PyColorControlPointList_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("ColorControlPointList = ColorControlPointList()\n");
        s += PyColorControlPointList_ToString(currentAtts, "ColorControlPointList.");
        cb(s);
    }
}

void
PyColorControlPointList_StartUp(ColorControlPointList *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyColorControlPointList_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(ColorControlPointListObserver == 0)
    {
        ColorControlPointListObserver = new ObserverToCallback(subj,
            PyColorControlPointList_CallLogRoutine, (void *)data);
    }

}

void
PyColorControlPointList_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete ColorControlPointListObserver;
    ColorControlPointListObserver = 0;
}

PyMethodDef *
PyColorControlPointList_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return ColorControlPointListMethods;
}

bool
PyColorControlPointList_Check(PyObject *obj)
{
    return (obj->ob_type == &ColorControlPointListType);
}

ColorControlPointList *
PyColorControlPointList_FromPyObject(PyObject *obj)
{
    ColorControlPointListObject *obj2 = (ColorControlPointListObject *)obj;
    return obj2->data;
}

PyObject *
PyColorControlPointList_New()
{
    return NewColorControlPointList(0);
}

PyObject *
PyColorControlPointList_Wrap(const ColorControlPointList *attr)
{
    return WrapColorControlPointList(attr);
}

void
PyColorControlPointList_SetParent(PyObject *obj, PyObject *parent)
{
    ColorControlPointListObject *obj2 = (ColorControlPointListObject *)obj;
    obj2->parent = parent;
}

void
PyColorControlPointList_SetDefaults(const ColorControlPointList *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new ColorControlPointList(*atts);
}

