/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

// ************************************************************************* //
//  File: ScatterGUIPluginInfo.C
// ************************************************************************* //

#include <ScatterPluginInfo.h>
#include <ScatterAttributes.h>
#include <QApplication>
#include <QvisScatterPlotWindow.h>

VISIT_PLOT_PLUGIN_ENTRY(Scatter,GUI)

// ****************************************************************************
//  Method: ScatterGUIPluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the GUI menu.
//
//  Returns:    A pointer to the name to use in the GUI menu.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

QString *
ScatterGUIPluginInfo::GetMenuName() const
{
    return new QString(qApp->translate("PlotNames", "Scatter"));
}


// ****************************************************************************
//  Method: ScatterGUIPluginInfo::CreatePluginWindow
//
//  Purpose:
//    Return a pointer to an plot's attribute window.
//
//  Arguments:
//    type      The type of the plot.
//    attr      The attribute subject for the plot.
//    notepad   The notepad to use for posting the window.
//
//  Returns:    A pointer to the plot's attribute window.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

QvisPostableWindowObserver *
ScatterGUIPluginInfo::CreatePluginWindow(int type, AttributeSubject *attr,
    const QString &caption, const QString &shortName, QvisNotepadArea *notepad)
{
    return new QvisScatterPlotWindow(type, (ScatterAttributes *)attr,
        caption, shortName, notepad);
}
// ****************************************************************************
// Method: ScatterGUIPluginInfo::CreatePluginWizard
//
// Purpose: 
//   Creates a Scatter plot wizard and returns a pointer to it.
//
// Arguments:
//   attr   : The attributes that should be used for the plot.
//   parent : The wizard's parent widget.
//   name   : The name of the wizard.
//
// Returns:    A pointer to the new wizard.
//
// Note:       
//
// Programmer: Brad Whitlock
// Creation:   Tue Dec 14 09:48:06 PDT 2004
//
// Modifications:
//   Mark Blair, Mon Aug 21 18:29:00 PDT 2006
//   Made argument sequence compatible with upgraded base class.
//
//   Cyrus Harrison, Wed Aug 18 14:55:58 PDT 2010
//   Pass name of the first var selection to the gui.
//
// ****************************************************************************
#include <QvisScatterPlotWizard.h>
QvisWizard *
ScatterGUIPluginInfo::CreatePluginWizard(AttributeSubject *attr,
    QWidget *parent, const std::string &varName, const avtDatabaseMetaData *md,
    const ExpressionList *expList)
{
    return new QvisScatterPlotWizard(attr, parent,varName);
}


// ****************************************************************************
//  Method: ScatterGUIPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

#include <Scatter.xpm>
const char **
ScatterGUIPluginInfo::XPMIconData() const
{
    return Scatter_xpm;
}

