/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include "QvisRadialResampleWindow.h"

#include <RadialResampleAttributes.h>

#include <QCheckBox>
#include <QLabel>
#include <QLayout>
#include <QLineEdit>


// ****************************************************************************
// Method: QvisRadialResampleWindow::QvisRadialResampleWindow
//
// Purpose: 
//   Constructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisRadialResampleWindow::QvisRadialResampleWindow(const int type,
                         RadialResampleAttributes *subj,
                         const QString &caption,
                         const QString &shortName,
                         QvisNotepadArea *notepad)
    : QvisOperatorWindow(type,subj, caption, shortName, notepad)
{
    atts = subj;
}


// ****************************************************************************
// Method: QvisRadialResampleWindow::~QvisRadialResampleWindow
//
// Purpose: 
//   Destructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisRadialResampleWindow::~QvisRadialResampleWindow()
{
}


// ****************************************************************************
// Method: QvisRadialResampleWindow::CreateWindowContents
//
// Purpose: 
//   Creates the widgets for the window.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisRadialResampleWindow::CreateWindowContents()
{
    QGridLayout *mainLayout = new QGridLayout(0);
    topLayout->addLayout(mainLayout);

    isFast = new QCheckBox(tr("Fast Mode"), central);
    connect(isFast, SIGNAL(toggled(bool)),
            this, SLOT(isFastChanged(bool)));
    mainLayout->addWidget(isFast, 0,0);

    minThetaLabel = new QLabel(tr("Min Elevation"), central);
    mainLayout->addWidget(minThetaLabel,1,0);
    minTheta = new QLineEdit(central);
    connect(minTheta, SIGNAL(returnPressed()),
            this, SLOT(minThetaProcessText()));
    mainLayout->addWidget(minTheta, 1,1);

    maxThetaLabel = new QLabel(tr("Max Elevation"), central);
    mainLayout->addWidget(maxThetaLabel,2,0);
    maxTheta = new QLineEdit(central);
    connect(maxTheta, SIGNAL(returnPressed()),
            this, SLOT(maxThetaProcessText()));
    mainLayout->addWidget(maxTheta, 2,1);

    deltaThetaLabel = new QLabel(tr("Delta Elevation"), central);
    mainLayout->addWidget(deltaThetaLabel,3,0);
    deltaTheta = new QLineEdit(central);
    connect(deltaTheta, SIGNAL(returnPressed()),
            this, SLOT(deltaThetaProcessText()));
    mainLayout->addWidget(deltaTheta, 3,1);

    radiusLabel = new QLabel(tr("Radius"), central);
    mainLayout->addWidget(radiusLabel,4,0);
    radius = new QLineEdit(central);
    connect(radius, SIGNAL(returnPressed()),
            this, SLOT(radiusProcessText()));
    mainLayout->addWidget(radius, 4,1);

    deltaRadiusLabel = new QLabel(tr("Delta Radius"), central);
    mainLayout->addWidget(deltaRadiusLabel,5,0);
    deltaRadius = new QLineEdit(central);
    connect(deltaRadius, SIGNAL(returnPressed()),
            this, SLOT(deltaRadiusProcessText()));
    mainLayout->addWidget(deltaRadius, 5,1);

    centerLabel = new QLabel(tr("Center"), central);
    mainLayout->addWidget(centerLabel,6,0);
    center = new QLineEdit(central);
    connect(center, SIGNAL(returnPressed()),
            this, SLOT(centerProcessText()));
    mainLayout->addWidget(center, 6,1);

    is3D = new QCheckBox(tr("3D Resampling"), central);
    connect(is3D, SIGNAL(toggled(bool)),
            this, SLOT(is3DChanged(bool)));
    mainLayout->addWidget(is3D, 7,0);

    minAzimuthLabel = new QLabel(tr("Min Azimuth"), central);
    mainLayout->addWidget(minAzimuthLabel,8,0);
    minAzimuth = new QLineEdit(central);
    connect(minAzimuth, SIGNAL(returnPressed()),
            this, SLOT(minAzimuthProcessText()));
    mainLayout->addWidget(minAzimuth, 8,1);

    maxAzimuthLabel = new QLabel(tr("Max Azimuth"), central);
    mainLayout->addWidget(maxAzimuthLabel,9,0);
    maxAzimuth = new QLineEdit(central);
    connect(maxAzimuth, SIGNAL(returnPressed()),
            this, SLOT(maxAzimuthProcessText()));
    mainLayout->addWidget(maxAzimuth, 9,1);

    deltaAzimuthLabel = new QLabel(tr("Delta Azimuth"), central);
    mainLayout->addWidget(deltaAzimuthLabel,10,0);
    deltaAzimuth = new QLineEdit(central);
    connect(deltaAzimuth, SIGNAL(returnPressed()),
            this, SLOT(deltaAzimuthProcessText()));
    mainLayout->addWidget(deltaAzimuth, 10,1);

}


// ****************************************************************************
// Method: QvisRadialResampleWindow::UpdateWindow
//
// Purpose: 
//   Updates the widgets in the window when the subject changes.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisRadialResampleWindow::UpdateWindow(bool doAll)
{

    for(int i = 0; i < atts->NumAttributes(); ++i)
    {
        if(!doAll)
        {
            if(!atts->IsSelected(i))
            {
                continue;
            }
        }

        switch(i)
        {
          case RadialResampleAttributes::ID_isFast:
            isFast->blockSignals(true);
            isFast->setChecked(atts->GetIsFast());
            isFast->blockSignals(false);
            break;
          case RadialResampleAttributes::ID_minTheta:
            minTheta->setText(FloatToQString(atts->GetMinTheta()));
            break;
          case RadialResampleAttributes::ID_maxTheta:
            maxTheta->setText(FloatToQString(atts->GetMaxTheta()));
            break;
          case RadialResampleAttributes::ID_deltaTheta:
            deltaTheta->setText(FloatToQString(atts->GetDeltaTheta()));
            break;
          case RadialResampleAttributes::ID_radius:
            radius->setText(FloatToQString(atts->GetRadius()));
            break;
          case RadialResampleAttributes::ID_deltaRadius:
            deltaRadius->setText(FloatToQString(atts->GetDeltaRadius()));
            break;
          case RadialResampleAttributes::ID_center:
            center->setText(FloatsToQString(atts->GetCenter(), 3));
            break;
          case RadialResampleAttributes::ID_is3D:
            if (atts->GetIs3D() == true)
            {
                minAzimuth->setEnabled(true);
                if(minAzimuthLabel)
                    minAzimuthLabel->setEnabled(true);
            }
            else
            {
                minAzimuth->setEnabled(false);
                if(minAzimuthLabel)
                    minAzimuthLabel->setEnabled(false);
            }
            if (atts->GetIs3D() == true)
            {
                maxAzimuth->setEnabled(true);
                if(maxAzimuthLabel)
                    maxAzimuthLabel->setEnabled(true);
            }
            else
            {
                maxAzimuth->setEnabled(false);
                if(maxAzimuthLabel)
                    maxAzimuthLabel->setEnabled(false);
            }
            if (atts->GetIs3D() == true)
            {
                deltaAzimuth->setEnabled(true);
                if(deltaAzimuthLabel)
                    deltaAzimuthLabel->setEnabled(true);
            }
            else
            {
                deltaAzimuth->setEnabled(false);
                if(deltaAzimuthLabel)
                    deltaAzimuthLabel->setEnabled(false);
            }
            is3D->blockSignals(true);
            is3D->setChecked(atts->GetIs3D());
            is3D->blockSignals(false);
            break;
          case RadialResampleAttributes::ID_minAzimuth:
            minAzimuth->setText(FloatToQString(atts->GetMinAzimuth()));
            break;
          case RadialResampleAttributes::ID_maxAzimuth:
            maxAzimuth->setText(FloatToQString(atts->GetMaxAzimuth()));
            break;
          case RadialResampleAttributes::ID_deltaAzimuth:
            deltaAzimuth->setText(FloatToQString(atts->GetDeltaAzimuth()));
            break;
        }
    }
}


// ****************************************************************************
// Method: QvisRadialResampleWindow::GetCurrentValues
//
// Purpose: 
//   Gets values from certain widgets and stores them in the subject.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisRadialResampleWindow::GetCurrentValues(int which_widget)
{
    bool doAll = (which_widget == -1);

    // Do minTheta
    if(which_widget == RadialResampleAttributes::ID_minTheta || doAll)
    {
        float val;
        if(LineEditGetFloat(minTheta, val))
            atts->SetMinTheta(val);
        else
        {
            ResettingError(tr("Min Elevation"),
                FloatToQString(atts->GetMinTheta()));
            atts->SetMinTheta(atts->GetMinTheta());
        }
    }

    // Do maxTheta
    if(which_widget == RadialResampleAttributes::ID_maxTheta || doAll)
    {
        float val;
        if(LineEditGetFloat(maxTheta, val))
            atts->SetMaxTheta(val);
        else
        {
            ResettingError(tr("Max Elevation"),
                FloatToQString(atts->GetMaxTheta()));
            atts->SetMaxTheta(atts->GetMaxTheta());
        }
    }

    // Do deltaTheta
    if(which_widget == RadialResampleAttributes::ID_deltaTheta || doAll)
    {
        float val;
        if(LineEditGetFloat(deltaTheta, val))
            atts->SetDeltaTheta(val);
        else
        {
            ResettingError(tr("Delta Elevation"),
                FloatToQString(atts->GetDeltaTheta()));
            atts->SetDeltaTheta(atts->GetDeltaTheta());
        }
    }

    // Do radius
    if(which_widget == RadialResampleAttributes::ID_radius || doAll)
    {
        float val;
        if(LineEditGetFloat(radius, val))
            atts->SetRadius(val);
        else
        {
            ResettingError(tr("Radius"),
                FloatToQString(atts->GetRadius()));
            atts->SetRadius(atts->GetRadius());
        }
    }

    // Do deltaRadius
    if(which_widget == RadialResampleAttributes::ID_deltaRadius || doAll)
    {
        float val;
        if(LineEditGetFloat(deltaRadius, val))
            atts->SetDeltaRadius(val);
        else
        {
            ResettingError(tr("Delta Radius"),
                FloatToQString(atts->GetDeltaRadius()));
            atts->SetDeltaRadius(atts->GetDeltaRadius());
        }
    }

    // Do center
    if(which_widget == RadialResampleAttributes::ID_center || doAll)
    {
        float val[3];
        if(LineEditGetFloats(center, val, 3))
            atts->SetCenter(val);
        else
        {
            ResettingError(tr("Center"),
                FloatsToQString(atts->GetCenter(),3));
            atts->SetCenter(atts->GetCenter());
        }
    }

    // Do minAzimuth
    if(which_widget == RadialResampleAttributes::ID_minAzimuth || doAll)
    {
        float val;
        if(LineEditGetFloat(minAzimuth, val))
            atts->SetMinAzimuth(val);
        else
        {
            ResettingError(tr("Min Azimuth"),
                FloatToQString(atts->GetMinAzimuth()));
            atts->SetMinAzimuth(atts->GetMinAzimuth());
        }
    }

    // Do maxAzimuth
    if(which_widget == RadialResampleAttributes::ID_maxAzimuth || doAll)
    {
        float val;
        if(LineEditGetFloat(maxAzimuth, val))
            atts->SetMaxAzimuth(val);
        else
        {
            ResettingError(tr("Max Azimuth"),
                FloatToQString(atts->GetMaxAzimuth()));
            atts->SetMaxAzimuth(atts->GetMaxAzimuth());
        }
    }

    // Do deltaAzimuth
    if(which_widget == RadialResampleAttributes::ID_deltaAzimuth || doAll)
    {
        float val;
        if(LineEditGetFloat(deltaAzimuth, val))
            atts->SetDeltaAzimuth(val);
        else
        {
            ResettingError(tr("Delta Azimuth"),
                FloatToQString(atts->GetDeltaAzimuth()));
            atts->SetDeltaAzimuth(atts->GetDeltaAzimuth());
        }
    }

}


//
// Qt Slot functions
//


void
QvisRadialResampleWindow::isFastChanged(bool val)
{
    atts->SetIsFast(val);
    SetUpdate(false);
    Apply();
}


void
QvisRadialResampleWindow::minThetaProcessText()
{
    GetCurrentValues(RadialResampleAttributes::ID_minTheta);
    Apply();
}


void
QvisRadialResampleWindow::maxThetaProcessText()
{
    GetCurrentValues(RadialResampleAttributes::ID_maxTheta);
    Apply();
}


void
QvisRadialResampleWindow::deltaThetaProcessText()
{
    GetCurrentValues(RadialResampleAttributes::ID_deltaTheta);
    Apply();
}


void
QvisRadialResampleWindow::radiusProcessText()
{
    GetCurrentValues(RadialResampleAttributes::ID_radius);
    Apply();
}


void
QvisRadialResampleWindow::deltaRadiusProcessText()
{
    GetCurrentValues(RadialResampleAttributes::ID_deltaRadius);
    Apply();
}


void
QvisRadialResampleWindow::centerProcessText()
{
    GetCurrentValues(RadialResampleAttributes::ID_center);
    Apply();
}


void
QvisRadialResampleWindow::is3DChanged(bool val)
{
    atts->SetIs3D(val);
    Apply();
}


void
QvisRadialResampleWindow::minAzimuthProcessText()
{
    GetCurrentValues(RadialResampleAttributes::ID_minAzimuth);
    Apply();
}


void
QvisRadialResampleWindow::maxAzimuthProcessText()
{
    GetCurrentValues(RadialResampleAttributes::ID_maxAzimuth);
    Apply();
}


void
QvisRadialResampleWindow::deltaAzimuthProcessText()
{
    GetCurrentValues(RadialResampleAttributes::ID_deltaAzimuth);
    Apply();
}


