/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

// ************************************************************************* //
//  File: avtLineoutPluginFilter.C
// ************************************************************************* //

#include <avtLineoutPluginFilter.h>

#include <avtLineoutFilter.h>
#include <LineoutAttributes.h>

// ****************************************************************************
//  Method: avtLineoutPluginFilter constructor
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   January 24, 2008
//
// ****************************************************************************

avtLineoutPluginFilter::avtLineoutPluginFilter()
{
    lineouter = NULL;
}


// ****************************************************************************
//  Method: avtLineoutPluginFilter destructor
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   January 24, 2008
//
//  Modifications:
//
// ****************************************************************************

avtLineoutPluginFilter::~avtLineoutPluginFilter()
{
    if (lineouter != NULL)
    {
        delete lineouter;
        lineouter = NULL;
    }
}


// ****************************************************************************
//  Method:  avtLineoutPluginFilter::Create
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   January 24, 2008
//
// ****************************************************************************

avtFilter *
avtLineoutPluginFilter::Create()
{
    return new avtLineoutPluginFilter();
}


// ****************************************************************************
//  Method:      avtLineoutPluginFilter::SetAtts
//
//  Purpose:
//      Sets the state of the filter based on the attribute object.
//
//  Arguments:
//      a        The attributes to use.
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   January 24, 2008
//
//  Modifications:
//
//    Hank Childs, Fri Jan 25 09:59:29 PST 2008
//    Remove ignoreGlobal, which was unused.
//
//    Brad Whitlock, Wed Mar 19 14:14:53 PDT 2014
//    Add callback to the facade filter.
//
// ****************************************************************************

void
avtLineoutPluginFilter::SetAtts(const AttributeGroup *a)
{
    atts = *(const LineoutAttributes*)a;

    //
    // Construct a new resample filter based on these attributes.
    //
    if (lineouter != NULL)
    {
        delete lineouter;
    }

    lineouter = new avtLineoutFilter();
    lineouter->SetPoint1(atts.GetPoint1());
    lineouter->SetPoint2(atts.GetPoint2());
    lineouter->SetSamplingOn(atts.GetSamplingOn());
    lineouter->SetNumberOfSamplePoints(atts.GetNumberOfSamplePoints());
    lineouter->SetUpdateDataObjectInfoCallback(UpdateDataObjectInfoCB, (void*)this);
}


// ****************************************************************************
//  Method: avtLineoutPluginFilter::Equivalent
//
//  Purpose:
//      Returns true if creating a new avtLineoutPluginFilter with the given
//      parameters would result in an equivalent avtLineoutPluginFilter.
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   January 24, 2008
//
// ****************************************************************************

bool
avtLineoutPluginFilter::Equivalent(const AttributeGroup *a)
{
    return (atts == *(LineoutAttributes*)a);
}


// ****************************************************************************
//  Method: avtLineoutPluginFilter::GetFacadedFilter
//
//  Purpose:
//      Gets the filter that the filter that we are a facade of.
//
//  Programmer: Hank Childs
//  Creation:   January 24, 2008
//
// ****************************************************************************

avtFilter *
avtLineoutPluginFilter::GetFacadedFilter(void)
{
    return lineouter;
}


// ****************************************************************************
//  Method: avtLineoutPluginFilter::GetFacadedFilter
//
//  Purpose:
//      Gets the filter that the filter that we are a facade of.
//
//  Programmer: Tom Fogal
//  Creation:   June 23, 2009
//
// ****************************************************************************

const avtFilter *
avtLineoutPluginFilter::GetFacadedFilter(void) const
{
    return lineouter;
}

// ****************************************************************************
// Method: avtLineoutPluginFilter::UpdateDataObjectInfoCB
//
// Purpose:
//   Update the data object information via a callback function.
//
// Note:       Work partially supported by DOE Grant SC0007548.
//
// Programmer: Brad Whitlock
// Creation:   Tue Mar 18 10:53:05 PDT 2014
//
// Modifications:
//
// ****************************************************************************

void
avtLineoutPluginFilter::UpdateDataObjectInfoCB(avtDataObject_p &input,
    avtDataObject_p &output, void *This)
{
    avtDataAttributes &outAtts = output->GetInfo().GetAttributes();
    const LineoutAttributes &lo = ((const avtLineoutPluginFilter *)This)->atts;

    char params[400];
    SNPRINTF(params, 400, "point1=%lg,%lg,%lg point2=%lg,%lg,%lg", 
             lo.GetPoint1()[0],lo.GetPoint1()[1],lo.GetPoint1()[2],
             lo.GetPoint2()[0],lo.GetPoint2()[1],lo.GetPoint2()[2]);
    outAtts.AddFilterMetaData("Lineout", params);
}
