/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyAxisAlignedSlice4DAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>

// ****************************************************************************
// Module: PyAxisAlignedSlice4DAttributes
//
// Purpose: 
//   Attributes for AxisAlignedSlice4D
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a AxisAlignedSlice4DAttributes.
//
struct AxisAlignedSlice4DAttributesObject
{
    PyObject_HEAD
    AxisAlignedSlice4DAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewAxisAlignedSlice4DAttributes(int);

std::string
PyAxisAlignedSlice4DAttributes_ToString(const AxisAlignedSlice4DAttributes *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    {   const intVector &I = atts->GetI();
        SNPRINTF(tmpStr, 1000, "%sI = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < I.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "%d", I[i]);
            str += tmpStr;
            if(i < I.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const intVector &J = atts->GetJ();
        SNPRINTF(tmpStr, 1000, "%sJ = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < J.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "%d", J[i]);
            str += tmpStr;
            if(i < J.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const intVector &K = atts->GetK();
        SNPRINTF(tmpStr, 1000, "%sK = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < K.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "%d", K[i]);
            str += tmpStr;
            if(i < K.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const intVector &L = atts->GetL();
        SNPRINTF(tmpStr, 1000, "%sL = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < L.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "%d", L[i]);
            str += tmpStr;
            if(i < L.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    return str;
}

static PyObject *
AxisAlignedSlice4DAttributes_Notify(PyObject *self, PyObject *args)
{
    AxisAlignedSlice4DAttributesObject *obj = (AxisAlignedSlice4DAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
AxisAlignedSlice4DAttributes_SetI(PyObject *self, PyObject *args)
{
    AxisAlignedSlice4DAttributesObject *obj = (AxisAlignedSlice4DAttributesObject *)self;

    intVector  &vec = obj->data->GetI();
    PyObject   *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = int(PyFloat_AS_DOUBLE(item));
            else if(PyInt_Check(item))
                vec[i] = int(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = int(PyLong_AsLong(item));
            else
                vec[i] = 0;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyFloat_AS_DOUBLE(tuple));
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyLong_AsLong(tuple));
    }
    else
        return NULL;

    // Mark the I in the object as modified.
    obj->data->SelectI();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
AxisAlignedSlice4DAttributes_GetI(PyObject *self, PyObject *args)
{
    AxisAlignedSlice4DAttributesObject *obj = (AxisAlignedSlice4DAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the I.
    const intVector &I = obj->data->GetI();
    PyObject *retval = PyTuple_New(I.size());
    for(size_t i = 0; i < I.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyInt_FromLong(long(I[i])));
    return retval;
}

/*static*/ PyObject *
AxisAlignedSlice4DAttributes_SetJ(PyObject *self, PyObject *args)
{
    AxisAlignedSlice4DAttributesObject *obj = (AxisAlignedSlice4DAttributesObject *)self;

    intVector  &vec = obj->data->GetJ();
    PyObject   *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = int(PyFloat_AS_DOUBLE(item));
            else if(PyInt_Check(item))
                vec[i] = int(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = int(PyLong_AsLong(item));
            else
                vec[i] = 0;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyFloat_AS_DOUBLE(tuple));
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyLong_AsLong(tuple));
    }
    else
        return NULL;

    // Mark the J in the object as modified.
    obj->data->SelectJ();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
AxisAlignedSlice4DAttributes_GetJ(PyObject *self, PyObject *args)
{
    AxisAlignedSlice4DAttributesObject *obj = (AxisAlignedSlice4DAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the J.
    const intVector &J = obj->data->GetJ();
    PyObject *retval = PyTuple_New(J.size());
    for(size_t i = 0; i < J.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyInt_FromLong(long(J[i])));
    return retval;
}

/*static*/ PyObject *
AxisAlignedSlice4DAttributes_SetK(PyObject *self, PyObject *args)
{
    AxisAlignedSlice4DAttributesObject *obj = (AxisAlignedSlice4DAttributesObject *)self;

    intVector  &vec = obj->data->GetK();
    PyObject   *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = int(PyFloat_AS_DOUBLE(item));
            else if(PyInt_Check(item))
                vec[i] = int(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = int(PyLong_AsLong(item));
            else
                vec[i] = 0;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyFloat_AS_DOUBLE(tuple));
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyLong_AsLong(tuple));
    }
    else
        return NULL;

    // Mark the K in the object as modified.
    obj->data->SelectK();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
AxisAlignedSlice4DAttributes_GetK(PyObject *self, PyObject *args)
{
    AxisAlignedSlice4DAttributesObject *obj = (AxisAlignedSlice4DAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the K.
    const intVector &K = obj->data->GetK();
    PyObject *retval = PyTuple_New(K.size());
    for(size_t i = 0; i < K.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyInt_FromLong(long(K[i])));
    return retval;
}

/*static*/ PyObject *
AxisAlignedSlice4DAttributes_SetL(PyObject *self, PyObject *args)
{
    AxisAlignedSlice4DAttributesObject *obj = (AxisAlignedSlice4DAttributesObject *)self;

    intVector  &vec = obj->data->GetL();
    PyObject   *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = int(PyFloat_AS_DOUBLE(item));
            else if(PyInt_Check(item))
                vec[i] = int(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = int(PyLong_AsLong(item));
            else
                vec[i] = 0;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyFloat_AS_DOUBLE(tuple));
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyLong_AsLong(tuple));
    }
    else
        return NULL;

    // Mark the L in the object as modified.
    obj->data->SelectL();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
AxisAlignedSlice4DAttributes_GetL(PyObject *self, PyObject *args)
{
    AxisAlignedSlice4DAttributesObject *obj = (AxisAlignedSlice4DAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the L.
    const intVector &L = obj->data->GetL();
    PyObject *retval = PyTuple_New(L.size());
    for(size_t i = 0; i < L.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyInt_FromLong(long(L[i])));
    return retval;
}



PyMethodDef PyAxisAlignedSlice4DAttributes_methods[AXISALIGNEDSLICE4DATTRIBUTES_NMETH] = {
    {"Notify", AxisAlignedSlice4DAttributes_Notify, METH_VARARGS},
    {"SetI", AxisAlignedSlice4DAttributes_SetI, METH_VARARGS},
    {"GetI", AxisAlignedSlice4DAttributes_GetI, METH_VARARGS},
    {"SetJ", AxisAlignedSlice4DAttributes_SetJ, METH_VARARGS},
    {"GetJ", AxisAlignedSlice4DAttributes_GetJ, METH_VARARGS},
    {"SetK", AxisAlignedSlice4DAttributes_SetK, METH_VARARGS},
    {"GetK", AxisAlignedSlice4DAttributes_GetK, METH_VARARGS},
    {"SetL", AxisAlignedSlice4DAttributes_SetL, METH_VARARGS},
    {"GetL", AxisAlignedSlice4DAttributes_GetL, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
AxisAlignedSlice4DAttributes_dealloc(PyObject *v)
{
   AxisAlignedSlice4DAttributesObject *obj = (AxisAlignedSlice4DAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
AxisAlignedSlice4DAttributes_compare(PyObject *v, PyObject *w)
{
    AxisAlignedSlice4DAttributes *a = ((AxisAlignedSlice4DAttributesObject *)v)->data;
    AxisAlignedSlice4DAttributes *b = ((AxisAlignedSlice4DAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyAxisAlignedSlice4DAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "I") == 0)
        return AxisAlignedSlice4DAttributes_GetI(self, NULL);
    if(strcmp(name, "J") == 0)
        return AxisAlignedSlice4DAttributes_GetJ(self, NULL);
    if(strcmp(name, "K") == 0)
        return AxisAlignedSlice4DAttributes_GetK(self, NULL);
    if(strcmp(name, "L") == 0)
        return AxisAlignedSlice4DAttributes_GetL(self, NULL);

    return Py_FindMethod(PyAxisAlignedSlice4DAttributes_methods, self, name);
}

int
PyAxisAlignedSlice4DAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "I") == 0)
        obj = AxisAlignedSlice4DAttributes_SetI(self, tuple);
    else if(strcmp(name, "J") == 0)
        obj = AxisAlignedSlice4DAttributes_SetJ(self, tuple);
    else if(strcmp(name, "K") == 0)
        obj = AxisAlignedSlice4DAttributes_SetK(self, tuple);
    else if(strcmp(name, "L") == 0)
        obj = AxisAlignedSlice4DAttributes_SetL(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
AxisAlignedSlice4DAttributes_print(PyObject *v, FILE *fp, int flags)
{
    AxisAlignedSlice4DAttributesObject *obj = (AxisAlignedSlice4DAttributesObject *)v;
    fprintf(fp, "%s", PyAxisAlignedSlice4DAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
AxisAlignedSlice4DAttributes_str(PyObject *v)
{
    AxisAlignedSlice4DAttributesObject *obj = (AxisAlignedSlice4DAttributesObject *)v;
    return PyString_FromString(PyAxisAlignedSlice4DAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *AxisAlignedSlice4DAttributes_Purpose = "Attributes for AxisAlignedSlice4D";
#else
static char *AxisAlignedSlice4DAttributes_Purpose = "Attributes for AxisAlignedSlice4D";
#endif

//
// The type description structure
//
static PyTypeObject AxisAlignedSlice4DAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "AxisAlignedSlice4DAttributes",                    // tp_name
    sizeof(AxisAlignedSlice4DAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)AxisAlignedSlice4DAttributes_dealloc,  // tp_dealloc
    (printfunc)AxisAlignedSlice4DAttributes_print,     // tp_print
    (getattrfunc)PyAxisAlignedSlice4DAttributes_getattr, // tp_getattr
    (setattrfunc)PyAxisAlignedSlice4DAttributes_setattr, // tp_setattr
    (cmpfunc)AxisAlignedSlice4DAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)AxisAlignedSlice4DAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    AxisAlignedSlice4DAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static AxisAlignedSlice4DAttributes *defaultAtts = 0;
static AxisAlignedSlice4DAttributes *currentAtts = 0;

static PyObject *
NewAxisAlignedSlice4DAttributes(int useCurrent)
{
    AxisAlignedSlice4DAttributesObject *newObject;
    newObject = PyObject_NEW(AxisAlignedSlice4DAttributesObject, &AxisAlignedSlice4DAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new AxisAlignedSlice4DAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new AxisAlignedSlice4DAttributes(*defaultAtts);
    else
        newObject->data = new AxisAlignedSlice4DAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapAxisAlignedSlice4DAttributes(const AxisAlignedSlice4DAttributes *attr)
{
    AxisAlignedSlice4DAttributesObject *newObject;
    newObject = PyObject_NEW(AxisAlignedSlice4DAttributesObject, &AxisAlignedSlice4DAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (AxisAlignedSlice4DAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
AxisAlignedSlice4DAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewAxisAlignedSlice4DAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef AxisAlignedSlice4DAttributesMethods[] = {
    {"AxisAlignedSlice4DAttributes", AxisAlignedSlice4DAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *AxisAlignedSlice4DAttributesObserver = 0;

std::string
PyAxisAlignedSlice4DAttributes_GetLogString()
{
    std::string s("AxisAlignedSlice4DAtts = AxisAlignedSlice4DAttributes()\n");
    if(currentAtts != 0)
        s += PyAxisAlignedSlice4DAttributes_ToString(currentAtts, "AxisAlignedSlice4DAtts.");
    return s;
}

static void
PyAxisAlignedSlice4DAttributes_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("AxisAlignedSlice4DAtts = AxisAlignedSlice4DAttributes()\n");
        s += PyAxisAlignedSlice4DAttributes_ToString(currentAtts, "AxisAlignedSlice4DAtts.");
        cb(s);
    }
}

void
PyAxisAlignedSlice4DAttributes_StartUp(AxisAlignedSlice4DAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyAxisAlignedSlice4DAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(AxisAlignedSlice4DAttributesObserver == 0)
    {
        AxisAlignedSlice4DAttributesObserver = new ObserverToCallback(subj,
            PyAxisAlignedSlice4DAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyAxisAlignedSlice4DAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete AxisAlignedSlice4DAttributesObserver;
    AxisAlignedSlice4DAttributesObserver = 0;
}

PyMethodDef *
PyAxisAlignedSlice4DAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return AxisAlignedSlice4DAttributesMethods;
}

bool
PyAxisAlignedSlice4DAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &AxisAlignedSlice4DAttributesType);
}

AxisAlignedSlice4DAttributes *
PyAxisAlignedSlice4DAttributes_FromPyObject(PyObject *obj)
{
    AxisAlignedSlice4DAttributesObject *obj2 = (AxisAlignedSlice4DAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyAxisAlignedSlice4DAttributes_New()
{
    return NewAxisAlignedSlice4DAttributes(0);
}

PyObject *
PyAxisAlignedSlice4DAttributes_Wrap(const AxisAlignedSlice4DAttributes *attr)
{
    return WrapAxisAlignedSlice4DAttributes(attr);
}

void
PyAxisAlignedSlice4DAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    AxisAlignedSlice4DAttributesObject *obj2 = (AxisAlignedSlice4DAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyAxisAlignedSlice4DAttributes_SetDefaults(const AxisAlignedSlice4DAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new AxisAlignedSlice4DAttributes(*atts);
}

