/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <TimeFormat.h>
#include <DataNode.h>

//
// Enum conversion methods for TimeFormat::DisplayMode
//

static const char *DisplayMode_strings[] = {
"Cycles", "Times", "CyclesAndTimes"
};

std::string
TimeFormat::DisplayMode_ToString(TimeFormat::DisplayMode t)
{
    int index = int(t);
    if(index < 0 || index >= 3) index = 0;
    return DisplayMode_strings[index];
}

std::string
TimeFormat::DisplayMode_ToString(int t)
{
    int index = (t < 0 || t >= 3) ? 0 : t;
    return DisplayMode_strings[index];
}

bool
TimeFormat::DisplayMode_FromString(const std::string &s, TimeFormat::DisplayMode &val)
{
    val = TimeFormat::Cycles;
    for(int i = 0; i < 3; ++i)
    {
        if(s == DisplayMode_strings[i])
        {
            val = (DisplayMode)i;
            return true;
        }
    }
    return false;
}

// ****************************************************************************
// Method: TimeFormat::TimeFormat
//
// Purpose: 
//   Init utility for the TimeFormat class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void TimeFormat::Init()
{
    displayMode = Cycles;
    precision = 5;

    TimeFormat::SelectAll();
}

// ****************************************************************************
// Method: TimeFormat::TimeFormat
//
// Purpose: 
//   Copy utility for the TimeFormat class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void TimeFormat::Copy(const TimeFormat &obj)
{
    displayMode = obj.displayMode;
    precision = obj.precision;

    TimeFormat::SelectAll();
}

// Type map format string
const char *TimeFormat::TypeMapFormatString = TIMEFORMAT_TMFS;
const AttributeGroup::private_tmfs_t TimeFormat::TmfsStruct = {TIMEFORMAT_TMFS};


// ****************************************************************************
// Method: TimeFormat::TimeFormat
//
// Purpose: 
//   Default constructor for the TimeFormat class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

TimeFormat::TimeFormat() : 
    AttributeSubject(TimeFormat::TypeMapFormatString)
{
    TimeFormat::Init();
}

// ****************************************************************************
// Method: TimeFormat::TimeFormat
//
// Purpose: 
//   Constructor for the derived classes of TimeFormat class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

TimeFormat::TimeFormat(private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    TimeFormat::Init();
}

// ****************************************************************************
// Method: TimeFormat::TimeFormat
//
// Purpose: 
//   Copy constructor for the TimeFormat class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

TimeFormat::TimeFormat(const TimeFormat &obj) : 
    AttributeSubject(TimeFormat::TypeMapFormatString)
{
    TimeFormat::Copy(obj);
}

// ****************************************************************************
// Method: TimeFormat::TimeFormat
//
// Purpose: 
//   Copy constructor for derived classes of the TimeFormat class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

TimeFormat::TimeFormat(const TimeFormat &obj, private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    TimeFormat::Copy(obj);
}

// ****************************************************************************
// Method: TimeFormat::~TimeFormat
//
// Purpose: 
//   Destructor for the TimeFormat class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

TimeFormat::~TimeFormat()
{
    // nothing here
}

// ****************************************************************************
// Method: TimeFormat::operator = 
//
// Purpose: 
//   Assignment operator for the TimeFormat class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

TimeFormat& 
TimeFormat::operator = (const TimeFormat &obj)
{
    if (this == &obj) return *this;

    TimeFormat::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: TimeFormat::operator == 
//
// Purpose: 
//   Comparison operator == for the TimeFormat class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
TimeFormat::operator == (const TimeFormat &obj) const
{
    // Create the return value
    return ((displayMode == obj.displayMode) &&
            (precision == obj.precision));
}

// ****************************************************************************
// Method: TimeFormat::operator != 
//
// Purpose: 
//   Comparison operator != for the TimeFormat class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
TimeFormat::operator != (const TimeFormat &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: TimeFormat::TypeName
//
// Purpose: 
//   Type name method for the TimeFormat class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
TimeFormat::TypeName() const
{
    return "TimeFormat";
}

// ****************************************************************************
// Method: TimeFormat::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the TimeFormat class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
TimeFormat::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const TimeFormat *tmp = (const TimeFormat *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: TimeFormat::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the TimeFormat class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
TimeFormat::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new TimeFormat(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: TimeFormat::NewInstance
//
// Purpose: 
//   NewInstance method for the TimeFormat class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
TimeFormat::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new TimeFormat(*this);
    else
        retval = new TimeFormat;

    return retval;
}

// ****************************************************************************
// Method: TimeFormat::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
TimeFormat::SelectAll()
{
    Select(ID_displayMode, (void *)&displayMode);
    Select(ID_precision,   (void *)&precision);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: TimeFormat::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
TimeFormat::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    TimeFormat defaultObject;
    bool addToParent = false;
    // Create a node for TimeFormat.
    DataNode *node = new DataNode("TimeFormat");

    if(completeSave || !FieldsEqual(ID_displayMode, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("displayMode", DisplayMode_ToString(displayMode)));
    }

    if(completeSave || !FieldsEqual(ID_precision, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("precision", precision));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: TimeFormat::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
TimeFormat::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("TimeFormat");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("displayMode")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 3)
                SetDisplayMode(DisplayMode(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            DisplayMode value;
            if(DisplayMode_FromString(node->AsString(), value))
                SetDisplayMode(value);
        }
    }
    if((node = searchNode->GetNode("precision")) != 0)
        SetPrecision(node->AsInt());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
TimeFormat::SetDisplayMode(TimeFormat::DisplayMode displayMode_)
{
    displayMode = displayMode_;
    Select(ID_displayMode, (void *)&displayMode);
}

void
TimeFormat::SetPrecision(int precision_)
{
    precision = precision_;
    Select(ID_precision, (void *)&precision);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

TimeFormat::DisplayMode
TimeFormat::GetDisplayMode() const
{
    return DisplayMode(displayMode);
}

int
TimeFormat::GetPrecision() const
{
    return precision;
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: TimeFormat::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
TimeFormat::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_displayMode: return "displayMode";
    case ID_precision:   return "precision";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: TimeFormat::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
TimeFormat::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_displayMode: return FieldType_enum;
    case ID_precision:   return FieldType_int;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: TimeFormat::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
TimeFormat::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_displayMode: return "enum";
    case ID_precision:   return "int";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: TimeFormat::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
TimeFormat::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const TimeFormat &obj = *((const TimeFormat*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_displayMode:
        {  // new scope
        retval = (displayMode == obj.displayMode);
        }
        break;
    case ID_precision:
        {  // new scope
        retval = (precision == obj.precision);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

