/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <SyncAttributes.h>
#include <DataNode.h>

// ****************************************************************************
// Method: SyncAttributes::SyncAttributes
//
// Purpose: 
//   Init utility for the SyncAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void SyncAttributes::Init()
{
    syncTag = -1;

    SyncAttributes::SelectAll();
}

// ****************************************************************************
// Method: SyncAttributes::SyncAttributes
//
// Purpose: 
//   Copy utility for the SyncAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void SyncAttributes::Copy(const SyncAttributes &obj)
{
    syncTag = obj.syncTag;

    SyncAttributes::SelectAll();
}

// Type map format string
const char *SyncAttributes::TypeMapFormatString = SYNCATTRIBUTES_TMFS;
const AttributeGroup::private_tmfs_t SyncAttributes::TmfsStruct = {SYNCATTRIBUTES_TMFS};


// ****************************************************************************
// Method: SyncAttributes::SyncAttributes
//
// Purpose: 
//   Default constructor for the SyncAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

SyncAttributes::SyncAttributes() : 
    AttributeSubject(SyncAttributes::TypeMapFormatString)
{
    SyncAttributes::Init();
}

// ****************************************************************************
// Method: SyncAttributes::SyncAttributes
//
// Purpose: 
//   Constructor for the derived classes of SyncAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

SyncAttributes::SyncAttributes(private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    SyncAttributes::Init();
}

// ****************************************************************************
// Method: SyncAttributes::SyncAttributes
//
// Purpose: 
//   Copy constructor for the SyncAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

SyncAttributes::SyncAttributes(const SyncAttributes &obj) : 
    AttributeSubject(SyncAttributes::TypeMapFormatString)
{
    SyncAttributes::Copy(obj);
}

// ****************************************************************************
// Method: SyncAttributes::SyncAttributes
//
// Purpose: 
//   Copy constructor for derived classes of the SyncAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

SyncAttributes::SyncAttributes(const SyncAttributes &obj, private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    SyncAttributes::Copy(obj);
}

// ****************************************************************************
// Method: SyncAttributes::~SyncAttributes
//
// Purpose: 
//   Destructor for the SyncAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

SyncAttributes::~SyncAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: SyncAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the SyncAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

SyncAttributes& 
SyncAttributes::operator = (const SyncAttributes &obj)
{
    if (this == &obj) return *this;

    SyncAttributes::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: SyncAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the SyncAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
SyncAttributes::operator == (const SyncAttributes &obj) const
{
    // Create the return value
    return ((syncTag == obj.syncTag));
}

// ****************************************************************************
// Method: SyncAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the SyncAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
SyncAttributes::operator != (const SyncAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: SyncAttributes::TypeName
//
// Purpose: 
//   Type name method for the SyncAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
SyncAttributes::TypeName() const
{
    return "SyncAttributes";
}

// ****************************************************************************
// Method: SyncAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the SyncAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
SyncAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const SyncAttributes *tmp = (const SyncAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: SyncAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the SyncAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
SyncAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new SyncAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: SyncAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the SyncAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
SyncAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new SyncAttributes(*this);
    else
        retval = new SyncAttributes;

    return retval;
}

// ****************************************************************************
// Method: SyncAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
SyncAttributes::SelectAll()
{
    Select(ID_syncTag, (void *)&syncTag);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: SyncAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
SyncAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    SyncAttributes defaultObject;
    bool addToParent = false;
    // Create a node for SyncAttributes.
    DataNode *node = new DataNode("SyncAttributes");

    if(completeSave || !FieldsEqual(ID_syncTag, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("syncTag", syncTag));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: SyncAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
SyncAttributes::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("SyncAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("syncTag")) != 0)
        SetSyncTag(node->AsInt());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
SyncAttributes::SetSyncTag(int syncTag_)
{
    syncTag = syncTag_;
    Select(ID_syncTag, (void *)&syncTag);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

int
SyncAttributes::GetSyncTag() const
{
    return syncTag;
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: SyncAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
SyncAttributes::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_syncTag: return "syncTag";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: SyncAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
SyncAttributes::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_syncTag: return FieldType_int;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: SyncAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
SyncAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_syncTag: return "int";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: SyncAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
SyncAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const SyncAttributes &obj = *((const SyncAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_syncTag:
        {  // new scope
        retval = (syncTag == obj.syncTag);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

