/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <AnnotationObjectList.h>
#include <DataNode.h>
#include <snprintf.h>
#include <AnnotationObject.h>

// ****************************************************************************
// Method: AnnotationObjectList::AnnotationObjectList
//
// Purpose: 
//   Init utility for the AnnotationObjectList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void AnnotationObjectList::Init()
{

    AnnotationObjectList::SelectAll();
}

// ****************************************************************************
// Method: AnnotationObjectList::AnnotationObjectList
//
// Purpose: 
//   Copy utility for the AnnotationObjectList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void AnnotationObjectList::Copy(const AnnotationObjectList &obj)
{
    AttributeGroupVector::const_iterator pos;

    // *** Copy the annotation field ***
    // Delete the AttributeGroup objects and clear the vector.
    for(pos = annotation.begin(); pos != annotation.end(); ++pos)
        delete *pos;
    annotation.clear();
    if(obj.annotation.size() > 0)
        annotation.reserve(obj.annotation.size());
    // Duplicate the annotation from obj.
    for(pos = obj.annotation.begin(); pos != obj.annotation.end(); ++pos)
    {
        AnnotationObject *oldAnnotationObject = (AnnotationObject *)(*pos);
        AnnotationObject *newAnnotationObject = new AnnotationObject(*oldAnnotationObject);
        annotation.push_back(newAnnotationObject);
    }


    AnnotationObjectList::SelectAll();
}

// Type map format string
const char *AnnotationObjectList::TypeMapFormatString = ANNOTATIONOBJECTLIST_TMFS;
const AttributeGroup::private_tmfs_t AnnotationObjectList::TmfsStruct = {ANNOTATIONOBJECTLIST_TMFS};


// ****************************************************************************
// Method: AnnotationObjectList::AnnotationObjectList
//
// Purpose: 
//   Default constructor for the AnnotationObjectList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AnnotationObjectList::AnnotationObjectList() : 
    AttributeSubject(AnnotationObjectList::TypeMapFormatString)
{
    AnnotationObjectList::Init();
}

// ****************************************************************************
// Method: AnnotationObjectList::AnnotationObjectList
//
// Purpose: 
//   Constructor for the derived classes of AnnotationObjectList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AnnotationObjectList::AnnotationObjectList(private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    AnnotationObjectList::Init();
}

// ****************************************************************************
// Method: AnnotationObjectList::AnnotationObjectList
//
// Purpose: 
//   Copy constructor for the AnnotationObjectList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AnnotationObjectList::AnnotationObjectList(const AnnotationObjectList &obj) : 
    AttributeSubject(AnnotationObjectList::TypeMapFormatString)
{
    AnnotationObjectList::Copy(obj);
}

// ****************************************************************************
// Method: AnnotationObjectList::AnnotationObjectList
//
// Purpose: 
//   Copy constructor for derived classes of the AnnotationObjectList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AnnotationObjectList::AnnotationObjectList(const AnnotationObjectList &obj, private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    AnnotationObjectList::Copy(obj);
}

// ****************************************************************************
// Method: AnnotationObjectList::~AnnotationObjectList
//
// Purpose: 
//   Destructor for the AnnotationObjectList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AnnotationObjectList::~AnnotationObjectList()
{
    AttributeGroupVector::iterator pos;

    // Destroy the annotation field.
    for(pos = annotation.begin(); pos != annotation.end(); ++pos)
        delete *pos;
}

// ****************************************************************************
// Method: AnnotationObjectList::operator = 
//
// Purpose: 
//   Assignment operator for the AnnotationObjectList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AnnotationObjectList& 
AnnotationObjectList::operator = (const AnnotationObjectList &obj)
{
    if (this == &obj) return *this;

    AnnotationObjectList::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: AnnotationObjectList::operator == 
//
// Purpose: 
//   Comparison operator == for the AnnotationObjectList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
AnnotationObjectList::operator == (const AnnotationObjectList &obj) const
{
    bool annotation_equal = (obj.annotation.size() == annotation.size());
    for(size_t i = 0; (i < annotation.size()) && annotation_equal; ++i)
    {
        // Make references to AnnotationObject from AttributeGroup *.
        const AnnotationObject &annotation1 = *((const AnnotationObject *)(annotation[i]));
        const AnnotationObject &annotation2 = *((const AnnotationObject *)(obj.annotation[i]));
        annotation_equal = (annotation1 == annotation2);
    }

    // Create the return value
    return (annotation_equal);
}

// ****************************************************************************
// Method: AnnotationObjectList::operator != 
//
// Purpose: 
//   Comparison operator != for the AnnotationObjectList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
AnnotationObjectList::operator != (const AnnotationObjectList &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: AnnotationObjectList::TypeName
//
// Purpose: 
//   Type name method for the AnnotationObjectList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
AnnotationObjectList::TypeName() const
{
    return "AnnotationObjectList";
}

// ****************************************************************************
// Method: AnnotationObjectList::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the AnnotationObjectList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
AnnotationObjectList::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const AnnotationObjectList *tmp = (const AnnotationObjectList *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: AnnotationObjectList::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the AnnotationObjectList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
AnnotationObjectList::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new AnnotationObjectList(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: AnnotationObjectList::NewInstance
//
// Purpose: 
//   NewInstance method for the AnnotationObjectList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
AnnotationObjectList::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new AnnotationObjectList(*this);
    else
        retval = new AnnotationObjectList;

    return retval;
}

// ****************************************************************************
// Method: AnnotationObjectList::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
AnnotationObjectList::SelectAll()
{
    Select(ID_annotation, (void *)&annotation);
}

// ****************************************************************************
// Method: AnnotationObjectList::CreateSubAttributeGroup
//
// Purpose: 
//   Contains a list of AnnotationObjectAttributes
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup *
AnnotationObjectList::CreateSubAttributeGroup(int)
{
    return new AnnotationObject;
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: AnnotationObjectList::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
AnnotationObjectList::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    AnnotationObjectList defaultObject;
    bool addToParent = false;
    // Create a node for AnnotationObjectList.
    DataNode *node = new DataNode("AnnotationObjectList");

    if(completeSave || !FieldsEqual(ID_annotation, &defaultObject))
    {
        addToParent = true;
        for(size_t i = 0; i < annotation.size(); ++i)
            annotation[i]->CreateNode(node, completeSave, true);
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: AnnotationObjectList::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
AnnotationObjectList::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("AnnotationObjectList");
    if(searchNode == 0)
        return;

    DataNode **children;

    // Clear all the AnnotationObjects if we got any.
    bool clearedAnnotations = false;
    // Go through all of the children and construct a new
    // AnnotationObject for each one of them.
    children = searchNode->GetChildren();
    if(children != 0)
    {
        for(int i = 0; i < searchNode->GetNumChildren(); ++i)
        {
            if(children[i]->GetKey() == std::string("AnnotationObject"))
            {
                if (!clearedAnnotations)
                {
                    ClearAnnotations();
                    clearedAnnotations = true;
                }
                AnnotationObject temp;
                temp.SetFromNode(children[i]);
                AddAnnotation(temp);
            }
        }
    }

}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

const AttributeGroupVector &
AnnotationObjectList::GetAnnotation() const
{
    return annotation;
}

AttributeGroupVector &
AnnotationObjectList::GetAnnotation()
{
    return annotation;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
AnnotationObjectList::SelectAnnotation()
{
    Select(ID_annotation, (void *)&annotation);
}

///////////////////////////////////////////////////////////////////////////////
// AttributeGroupVector convenience methods.
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: AnnotationObjectList::AddAnnotation
//
// Purpose: 
//   Contains a list of AnnotationObjectAttributes
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
AnnotationObjectList::AddAnnotation(const AnnotationObject &obj)
{
    AnnotationObject *newAnnotationObject = new AnnotationObject(obj);
    annotation.push_back(newAnnotationObject);

    // Indicate that things have changed by selecting it.
    Select(ID_annotation, (void *)&annotation);
}

// ****************************************************************************
// Method: AnnotationObjectList::ClearAnnotations
//
// Purpose: 
//   Contains a list of AnnotationObjectAttributes
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
AnnotationObjectList::ClearAnnotations()
{
    AttributeGroupVector::iterator pos;

    for(pos = annotation.begin(); pos != annotation.end(); ++pos)
        delete *pos;
    annotation.clear();

    // Indicate that things have changed by selecting the list.
    Select(ID_annotation, (void *)&annotation);
}

// ****************************************************************************
// Method: AnnotationObjectList::RemoveAnnotation
//
// Purpose: 
//   Contains a list of AnnotationObjectAttributes
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
AnnotationObjectList::RemoveAnnotation(int index)
{
    AttributeGroupVector::iterator pos = annotation.begin();

    // Iterate through the vector "index" times. 
    for(int i = 0; i < index; ++i)
        if(pos != annotation.end()) ++pos;

    // If pos is still a valid iterator, remove that element.
    if(pos != annotation.end())
    {
        delete *pos;
        annotation.erase(pos);
    }

    // Indicate that things have changed by selecting the list.
    Select(ID_annotation, (void *)&annotation);
}

// ****************************************************************************
// Method: AnnotationObjectList::GetNumAnnotations
//
// Purpose: 
//   Contains a list of AnnotationObjectAttributes
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

int
AnnotationObjectList::GetNumAnnotations() const
{
    return (int)annotation.size();
}

// ****************************************************************************
// Method: AnnotationObjectList::GetAnnotation
//
// Purpose: 
//   Contains a list of AnnotationObjectAttributes
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AnnotationObject &
AnnotationObjectList::GetAnnotation(int i)
{
    return *((AnnotationObject *)annotation[i]);
}

// ****************************************************************************
// Method: AnnotationObjectList::GetAnnotation
//
// Purpose: 
//   Contains a list of AnnotationObjectAttributes
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const AnnotationObject &
AnnotationObjectList::GetAnnotation(int i) const
{
    return *((AnnotationObject *)annotation[i]);
}

// ****************************************************************************
// Method: AnnotationObjectList::operator []
//
// Purpose: 
//   Contains a list of AnnotationObjectAttributes
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AnnotationObject &
AnnotationObjectList::operator [] (int i)
{
    return *((AnnotationObject *)annotation[i]);
}

// ****************************************************************************
// Method: AnnotationObjectList::operator []
//
// Purpose: 
//   Contains a list of AnnotationObjectAttributes
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const AnnotationObject &
AnnotationObjectList::operator [] (int i) const
{
    return *((AnnotationObject *)annotation[i]);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: AnnotationObjectList::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
AnnotationObjectList::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_annotation: return "annotation";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: AnnotationObjectList::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
AnnotationObjectList::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_annotation: return FieldType_attVector;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: AnnotationObjectList::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
AnnotationObjectList::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_annotation: return "attVector";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: AnnotationObjectList::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
AnnotationObjectList::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const AnnotationObjectList &obj = *((const AnnotationObjectList*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_annotation:
        {  // new scope
        bool annotation_equal = (obj.annotation.size() == annotation.size());
        for(size_t i = 0; (i < annotation.size()) && annotation_equal; ++i)
        {
            // Make references to AnnotationObject from AttributeGroup *.
            const AnnotationObject &annotation1 = *((const AnnotationObject *)(annotation[i]));
            const AnnotationObject &annotation2 = *((const AnnotationObject *)(obj.annotation[i]));
            annotation_equal = (annotation1 == annotation2);
        }

        retval = annotation_equal;
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: AnnotationObjectList::ProcessOldVersions
//
// Purpose: 
//   This method maps old AnnotationAttributes fields to the 1.9.0 version of
//   the data node tree for AnnotationAttributes.
//
// Programmer: Kathleen Bonnell
// Creation:   Thu Sep 17 10:06:49 PDT 2009
//
// Modifications:
//
// ****************************************************************************

void
AnnotationObjectList::ProcessOldVersions(DataNode *parentNode,
    const char *configVersion)
{
    if (parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("AnnotationObjectList");
    if (searchNode == 0)
        return;

    int nChildren = searchNode->GetNumChildren();
    DataNode **children = searchNode->GetChildren();

    for (int i = 0; i < nChildren; ++i)
    {
        AnnotationObject annot;
        annot.ProcessOldVersions(children[i], configVersion);
    }
}

// ****************************************************************************
//  Method: AnnotationObjectList::RemoveAnnotation
//
//  Purpose: Removes the named annotation.
//
//  Programmer: Brad Whitlock
//  Creation:   Tue Mar 20 09:24:05 PDT 2007
//
//  Modifications:
//
// ****************************************************************************

bool
AnnotationObjectList::RemoveAnnotation(const std::string &name)
{
    int index = IndexForName(name);
    if(index != -1)
    {
        RemoveAnnotation(index);
        return true;
    }

    return false;
}

// ****************************************************************************
//  Method: AnnotationObjectList::GetNewObjectName
//
//  Purpose: Returns a new name for the annotation.
//
//  Programmer: Brad Whitlock
//  Creation:   Tue Mar 20 09:24:05 PDT 2007
//
//  Modifications:
//
// ****************************************************************************

std::string
AnnotationObjectList::GetNewObjectName() const
{
    int index = 0;
    std::string name;
    bool found;
    char tmp[200];
    do
    {
        SNPRINTF(tmp, 200, "NewObject%d", index++);
        name = tmp;
        found = IndexForName(name) != -1;
    } while(found);

    return name;
}

// ****************************************************************************
//  Method: AnnotationObjectList::IndexForName
//
//  Purpose: Returns the index for the named annotation.
//
//  Programmer: Brad Whitlock
//  Creation:   Tue Mar 20 09:24:05 PDT 2007
//
//  Modifications:
//
// ****************************************************************************

int
AnnotationObjectList::IndexForName(const std::string &name) const
{
    for(int i = 0; i < GetNumAnnotations(); ++i)
    {
        if(GetAnnotation(i).GetObjectName() == name)
            return i;
    }

    return -1;
}

