/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyavtSimulationInformation.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>
#include <PyavtSimulationCommandSpecification.h>
#include <PyavtSimulationCommandSpecification.h>

// ****************************************************************************
// Module: PyavtSimulationInformation
//
// Purpose: 
//   Contains information about simulation connections
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a avtSimulationInformation.
//
struct avtSimulationInformationObject
{
    PyObject_HEAD
    avtSimulationInformation *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewavtSimulationInformation(int);

std::string
PyavtSimulationInformation_ToString(const avtSimulationInformation *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    SNPRINTF(tmpStr, 1000, "%shost = \"%s\"\n", prefix, atts->GetHost().c_str());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sport = %d\n", prefix, atts->GetPort());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%ssecurityKey = \"%s\"\n", prefix, atts->GetSecurityKey().c_str());
    str += tmpStr;
    {   const stringVector &otherNames = atts->GetOtherNames();
        SNPRINTF(tmpStr, 1000, "%sotherNames = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < otherNames.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "\"%s\"", otherNames[i].c_str());
            str += tmpStr;
            if(i < otherNames.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const stringVector &otherValues = atts->GetOtherValues();
        SNPRINTF(tmpStr, 1000, "%sotherValues = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < otherValues.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "\"%s\"", otherValues[i].c_str());
            str += tmpStr;
            if(i < otherValues.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    { // new scope
        int index = 0;
        // Create string representation of genericCommands from atts.
        for(AttributeGroupVector::const_iterator pos = atts->GetGenericCommands().begin(); pos != atts->GetGenericCommands().end(); ++pos, ++index)
        {
            const avtSimulationCommandSpecification *current = (const avtSimulationCommandSpecification *)(*pos);
            SNPRINTF(tmpStr, 1000, "GetGenericCommands(%d).", index);
            std::string objPrefix(prefix + std::string(tmpStr));
            str += PyavtSimulationCommandSpecification_ToString(current, objPrefix.c_str());
        }
        if(index == 0)
            str += "#genericCommands does not contain any avtSimulationCommandSpecification objects.\n";
    }
    const char *mode_names = "Unknown, Running, Stopped";
    switch (atts->GetMode())
    {
      case avtSimulationInformation::Unknown:
          SNPRINTF(tmpStr, 1000, "%smode = %sUnknown  # %s\n", prefix, prefix, mode_names);
          str += tmpStr;
          break;
      case avtSimulationInformation::Running:
          SNPRINTF(tmpStr, 1000, "%smode = %sRunning  # %s\n", prefix, prefix, mode_names);
          str += tmpStr;
          break;
      case avtSimulationInformation::Stopped:
          SNPRINTF(tmpStr, 1000, "%smode = %sStopped  # %s\n", prefix, prefix, mode_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    { // new scope
        int index = 0;
        // Create string representation of customCommands from atts.
        for(AttributeGroupVector::const_iterator pos = atts->GetCustomCommands().begin(); pos != atts->GetCustomCommands().end(); ++pos, ++index)
        {
            const avtSimulationCommandSpecification *current = (const avtSimulationCommandSpecification *)(*pos);
            SNPRINTF(tmpStr, 1000, "GetCustomCommands(%d).", index);
            std::string objPrefix(prefix + std::string(tmpStr));
            str += PyavtSimulationCommandSpecification_ToString(current, objPrefix.c_str());
        }
        if(index == 0)
            str += "#customCommands does not contain any avtSimulationCommandSpecification objects.\n";
    }
    SNPRINTF(tmpStr, 1000, "%smessage = \"%s\"\n", prefix, atts->GetMessage().c_str());
    str += tmpStr;
    return str;
}

static PyObject *
avtSimulationInformation_Notify(PyObject *self, PyObject *args)
{
    avtSimulationInformationObject *obj = (avtSimulationInformationObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtSimulationInformation_SetHost(PyObject *self, PyObject *args)
{
    avtSimulationInformationObject *obj = (avtSimulationInformationObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the host in the object.
    obj->data->SetHost(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtSimulationInformation_GetHost(PyObject *self, PyObject *args)
{
    avtSimulationInformationObject *obj = (avtSimulationInformationObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetHost().c_str());
    return retval;
}

/*static*/ PyObject *
avtSimulationInformation_SetPort(PyObject *self, PyObject *args)
{
    avtSimulationInformationObject *obj = (avtSimulationInformationObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the port in the object.
    obj->data->SetPort((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtSimulationInformation_GetPort(PyObject *self, PyObject *args)
{
    avtSimulationInformationObject *obj = (avtSimulationInformationObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetPort()));
    return retval;
}

/*static*/ PyObject *
avtSimulationInformation_SetSecurityKey(PyObject *self, PyObject *args)
{
    avtSimulationInformationObject *obj = (avtSimulationInformationObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the securityKey in the object.
    obj->data->SetSecurityKey(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtSimulationInformation_GetSecurityKey(PyObject *self, PyObject *args)
{
    avtSimulationInformationObject *obj = (avtSimulationInformationObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetSecurityKey().c_str());
    return retval;
}

/*static*/ PyObject *
avtSimulationInformation_SetOtherNames(PyObject *self, PyObject *args)
{
    avtSimulationInformationObject *obj = (avtSimulationInformationObject *)self;

    stringVector  &vec = obj->data->GetOtherNames();
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyString_Check(item))
                vec[i] = std::string(PyString_AS_STRING(item));
            else
                vec[i] = std::string("");
        }
    }
    else if(PyString_Check(tuple))
    {
        vec.resize(1);
        vec[0] = std::string(PyString_AS_STRING(tuple));
    }
    else
        return NULL;

    // Mark the otherNames in the object as modified.
    obj->data->SelectOtherNames();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtSimulationInformation_GetOtherNames(PyObject *self, PyObject *args)
{
    avtSimulationInformationObject *obj = (avtSimulationInformationObject *)self;
    // Allocate a tuple the with enough entries to hold the otherNames.
    const stringVector &otherNames = obj->data->GetOtherNames();
    PyObject *retval = PyTuple_New(otherNames.size());
    for(size_t i = 0; i < otherNames.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyString_FromString(otherNames[i].c_str()));
    return retval;
}

/*static*/ PyObject *
avtSimulationInformation_SetOtherValues(PyObject *self, PyObject *args)
{
    avtSimulationInformationObject *obj = (avtSimulationInformationObject *)self;

    stringVector  &vec = obj->data->GetOtherValues();
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyString_Check(item))
                vec[i] = std::string(PyString_AS_STRING(item));
            else
                vec[i] = std::string("");
        }
    }
    else if(PyString_Check(tuple))
    {
        vec.resize(1);
        vec[0] = std::string(PyString_AS_STRING(tuple));
    }
    else
        return NULL;

    // Mark the otherValues in the object as modified.
    obj->data->SelectOtherValues();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtSimulationInformation_GetOtherValues(PyObject *self, PyObject *args)
{
    avtSimulationInformationObject *obj = (avtSimulationInformationObject *)self;
    // Allocate a tuple the with enough entries to hold the otherValues.
    const stringVector &otherValues = obj->data->GetOtherValues();
    PyObject *retval = PyTuple_New(otherValues.size());
    for(size_t i = 0; i < otherValues.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyString_FromString(otherValues[i].c_str()));
    return retval;
}

/*static*/ PyObject *
avtSimulationInformation_GetGenericCommands(PyObject *self, PyObject *args)
{
    avtSimulationInformationObject *obj = (avtSimulationInformationObject *)self;
    int index;
    if(!PyArg_ParseTuple(args, "i", &index))
        return NULL;
    if(index < 0 || (size_t)index >= obj->data->GetGenericCommands().size())
    {
        char msg[400] = {'\0'};
        if(obj->data->GetGenericCommands().size() == 0)
            SNPRINTF(msg, 400, "In avtSimulationInformation::GetGenericCommands : The index %d is invalid because genericCommands is empty.", index);
        else
            SNPRINTF(msg, 400, "In avtSimulationInformation::GetGenericCommands : The index %d is invalid. Use index values in: [0, %ld).",  index, obj->data->GetGenericCommands().size());
        PyErr_SetString(PyExc_IndexError, msg);
        return NULL;
    }

    // Since the new object will point to data owned by the this object,
    // we need to increment the reference count.
    Py_INCREF(self);

    PyObject *retval = PyavtSimulationCommandSpecification_Wrap(&obj->data->GetGenericCommands(index));
    // Set the object's parent so the reference to the parent can be decref'd
    // when the child goes out of scope.
    PyavtSimulationCommandSpecification_SetParent(retval, self);

    return retval;
}

PyObject *
avtSimulationInformation_GetNumGenericCommands(PyObject *self, PyObject *args)
{
    avtSimulationInformationObject *obj = (avtSimulationInformationObject *)self;
    return PyInt_FromLong((long)obj->data->GetGenericCommands().size());
}

PyObject *
avtSimulationInformation_AddGenericCommands(PyObject *self, PyObject *args)
{
    avtSimulationInformationObject *obj = (avtSimulationInformationObject *)self;
    PyObject *element = NULL;
    if(!PyArg_ParseTuple(args, "O", &element))
        return NULL;
    if(!PyavtSimulationCommandSpecification_Check(element))
    {
        char msg[400] = {'\0'};
        SNPRINTF(msg, 400, "The avtSimulationInformation::AddGenericCommands method only accepts avtSimulationCommandSpecification objects.");
        PyErr_SetString(PyExc_TypeError, msg);
        return NULL;
    }
    avtSimulationCommandSpecification *newData = PyavtSimulationCommandSpecification_FromPyObject(element);
    obj->data->AddGenericCommands(*newData);
    obj->data->SelectGenericCommands();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
avtSimulationInformation_Remove_One_GenericCommands(PyObject *self, int index)
{
    avtSimulationInformationObject *obj = (avtSimulationInformationObject *)self;
    // Remove in the AttributeGroupVector instead of calling RemoveGenericCommands() because we don't want to delete the object; just remove it.
    AttributeGroupVector &atts = obj->data->GetGenericCommands();
    AttributeGroupVector::iterator pos = atts.begin();
    // Iterate through the vector "index" times. 
    for(int i = 0; i < index; ++i)
        ++pos;

    // If pos is still a valid iterator, remove that element.
    if(pos != atts.end())
    {
        // NOTE: Leak the object since other Python objects may reference it. Ideally,
        // we would put the object into some type of pool to be cleaned up later but
        // this will do for now.
        //
        // delete *pos;
        atts.erase(pos);
    }

    obj->data->SelectGenericCommands();
    Py_INCREF(Py_None);
    return Py_None;
}

PyObject *
avtSimulationInformation_RemoveGenericCommands(PyObject *self, PyObject *args)
{
    int index;
    if(!PyArg_ParseTuple(args, "i", &index))
        return NULL;
    avtSimulationInformationObject *obj = (avtSimulationInformationObject *)self;
    if(index < 0 || index >= obj->data->GetNumGenericCommands())
    {
        char msg[400] = {'\0'};
        SNPRINTF(msg, 400, "In avtSimulationInformation::RemoveGenericCommands : Index %d is out of range", index);
        PyErr_SetString(PyExc_IndexError, msg);
        return NULL;
    }

    return avtSimulationInformation_Remove_One_GenericCommands(self, index);
}

PyObject *
avtSimulationInformation_ClearGenericCommands(PyObject *self, PyObject *args)
{
    avtSimulationInformationObject *obj = (avtSimulationInformationObject *)self;
    int n = obj->data->GetNumGenericCommands();
    for(int i = 0; i < n; ++i)
    {
        avtSimulationInformation_Remove_One_GenericCommands(self, 0);
        Py_DECREF(Py_None);
    }
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtSimulationInformation_SetMode(PyObject *self, PyObject *args)
{
    avtSimulationInformationObject *obj = (avtSimulationInformationObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the mode in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetMode(avtSimulationInformation::RunMode(ival));
    else
    {
        fprintf(stderr, "An invalid mode value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Unknown, Running, Stopped.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtSimulationInformation_GetMode(PyObject *self, PyObject *args)
{
    avtSimulationInformationObject *obj = (avtSimulationInformationObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetMode()));
    return retval;
}

/*static*/ PyObject *
avtSimulationInformation_GetCustomCommands(PyObject *self, PyObject *args)
{
    avtSimulationInformationObject *obj = (avtSimulationInformationObject *)self;
    int index;
    if(!PyArg_ParseTuple(args, "i", &index))
        return NULL;
    if(index < 0 || (size_t)index >= obj->data->GetCustomCommands().size())
    {
        char msg[400] = {'\0'};
        if(obj->data->GetCustomCommands().size() == 0)
            SNPRINTF(msg, 400, "In avtSimulationInformation::GetCustomCommands : The index %d is invalid because customCommands is empty.", index);
        else
            SNPRINTF(msg, 400, "In avtSimulationInformation::GetCustomCommands : The index %d is invalid. Use index values in: [0, %ld).",  index, obj->data->GetCustomCommands().size());
        PyErr_SetString(PyExc_IndexError, msg);
        return NULL;
    }

    // Since the new object will point to data owned by the this object,
    // we need to increment the reference count.
    Py_INCREF(self);

    PyObject *retval = PyavtSimulationCommandSpecification_Wrap(&obj->data->GetCustomCommands(index));
    // Set the object's parent so the reference to the parent can be decref'd
    // when the child goes out of scope.
    PyavtSimulationCommandSpecification_SetParent(retval, self);

    return retval;
}

PyObject *
avtSimulationInformation_GetNumCustomCommands(PyObject *self, PyObject *args)
{
    avtSimulationInformationObject *obj = (avtSimulationInformationObject *)self;
    return PyInt_FromLong((long)obj->data->GetCustomCommands().size());
}

PyObject *
avtSimulationInformation_AddCustomCommands(PyObject *self, PyObject *args)
{
    avtSimulationInformationObject *obj = (avtSimulationInformationObject *)self;
    PyObject *element = NULL;
    if(!PyArg_ParseTuple(args, "O", &element))
        return NULL;
    if(!PyavtSimulationCommandSpecification_Check(element))
    {
        char msg[400] = {'\0'};
        SNPRINTF(msg, 400, "The avtSimulationInformation::AddCustomCommands method only accepts avtSimulationCommandSpecification objects.");
        PyErr_SetString(PyExc_TypeError, msg);
        return NULL;
    }
    avtSimulationCommandSpecification *newData = PyavtSimulationCommandSpecification_FromPyObject(element);
    obj->data->AddCustomCommands(*newData);
    obj->data->SelectCustomCommands();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
avtSimulationInformation_Remove_One_CustomCommands(PyObject *self, int index)
{
    avtSimulationInformationObject *obj = (avtSimulationInformationObject *)self;
    // Remove in the AttributeGroupVector instead of calling RemoveCustomCommands() because we don't want to delete the object; just remove it.
    AttributeGroupVector &atts = obj->data->GetCustomCommands();
    AttributeGroupVector::iterator pos = atts.begin();
    // Iterate through the vector "index" times. 
    for(int i = 0; i < index; ++i)
        ++pos;

    // If pos is still a valid iterator, remove that element.
    if(pos != atts.end())
    {
        // NOTE: Leak the object since other Python objects may reference it. Ideally,
        // we would put the object into some type of pool to be cleaned up later but
        // this will do for now.
        //
        // delete *pos;
        atts.erase(pos);
    }

    obj->data->SelectCustomCommands();
    Py_INCREF(Py_None);
    return Py_None;
}

PyObject *
avtSimulationInformation_RemoveCustomCommands(PyObject *self, PyObject *args)
{
    int index;
    if(!PyArg_ParseTuple(args, "i", &index))
        return NULL;
    avtSimulationInformationObject *obj = (avtSimulationInformationObject *)self;
    if(index < 0 || index >= obj->data->GetNumCustomCommands())
    {
        char msg[400] = {'\0'};
        SNPRINTF(msg, 400, "In avtSimulationInformation::RemoveCustomCommands : Index %d is out of range", index);
        PyErr_SetString(PyExc_IndexError, msg);
        return NULL;
    }

    return avtSimulationInformation_Remove_One_CustomCommands(self, index);
}

PyObject *
avtSimulationInformation_ClearCustomCommands(PyObject *self, PyObject *args)
{
    avtSimulationInformationObject *obj = (avtSimulationInformationObject *)self;
    int n = obj->data->GetNumCustomCommands();
    for(int i = 0; i < n; ++i)
    {
        avtSimulationInformation_Remove_One_CustomCommands(self, 0);
        Py_DECREF(Py_None);
    }
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtSimulationInformation_SetMessage(PyObject *self, PyObject *args)
{
    avtSimulationInformationObject *obj = (avtSimulationInformationObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the message in the object.
    obj->data->SetMessage(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtSimulationInformation_GetMessage(PyObject *self, PyObject *args)
{
    avtSimulationInformationObject *obj = (avtSimulationInformationObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetMessage().c_str());
    return retval;
}



PyMethodDef PyavtSimulationInformation_methods[AVTSIMULATIONINFORMATION_NMETH] = {
    {"Notify", avtSimulationInformation_Notify, METH_VARARGS},
    {"SetHost", avtSimulationInformation_SetHost, METH_VARARGS},
    {"GetHost", avtSimulationInformation_GetHost, METH_VARARGS},
    {"SetPort", avtSimulationInformation_SetPort, METH_VARARGS},
    {"GetPort", avtSimulationInformation_GetPort, METH_VARARGS},
    {"SetSecurityKey", avtSimulationInformation_SetSecurityKey, METH_VARARGS},
    {"GetSecurityKey", avtSimulationInformation_GetSecurityKey, METH_VARARGS},
    {"SetOtherNames", avtSimulationInformation_SetOtherNames, METH_VARARGS},
    {"GetOtherNames", avtSimulationInformation_GetOtherNames, METH_VARARGS},
    {"SetOtherValues", avtSimulationInformation_SetOtherValues, METH_VARARGS},
    {"GetOtherValues", avtSimulationInformation_GetOtherValues, METH_VARARGS},
    {"GetGenericCommands", avtSimulationInformation_GetGenericCommands, METH_VARARGS},
    {"GetNumGenericCommands", avtSimulationInformation_GetNumGenericCommands, METH_VARARGS},
    {"AddGenericCommands", avtSimulationInformation_AddGenericCommands, METH_VARARGS},
    {"RemoveGenericCommands", avtSimulationInformation_RemoveGenericCommands, METH_VARARGS},
    {"ClearGenericCommands", avtSimulationInformation_ClearGenericCommands, METH_VARARGS},
    {"SetMode", avtSimulationInformation_SetMode, METH_VARARGS},
    {"GetMode", avtSimulationInformation_GetMode, METH_VARARGS},
    {"GetCustomCommands", avtSimulationInformation_GetCustomCommands, METH_VARARGS},
    {"GetNumCustomCommands", avtSimulationInformation_GetNumCustomCommands, METH_VARARGS},
    {"AddCustomCommands", avtSimulationInformation_AddCustomCommands, METH_VARARGS},
    {"RemoveCustomCommands", avtSimulationInformation_RemoveCustomCommands, METH_VARARGS},
    {"ClearCustomCommands", avtSimulationInformation_ClearCustomCommands, METH_VARARGS},
    {"SetMessage", avtSimulationInformation_SetMessage, METH_VARARGS},
    {"GetMessage", avtSimulationInformation_GetMessage, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
avtSimulationInformation_dealloc(PyObject *v)
{
   avtSimulationInformationObject *obj = (avtSimulationInformationObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
avtSimulationInformation_compare(PyObject *v, PyObject *w)
{
    avtSimulationInformation *a = ((avtSimulationInformationObject *)v)->data;
    avtSimulationInformation *b = ((avtSimulationInformationObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyavtSimulationInformation_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "host") == 0)
        return avtSimulationInformation_GetHost(self, NULL);
    if(strcmp(name, "port") == 0)
        return avtSimulationInformation_GetPort(self, NULL);
    if(strcmp(name, "securityKey") == 0)
        return avtSimulationInformation_GetSecurityKey(self, NULL);
    if(strcmp(name, "otherNames") == 0)
        return avtSimulationInformation_GetOtherNames(self, NULL);
    if(strcmp(name, "otherValues") == 0)
        return avtSimulationInformation_GetOtherValues(self, NULL);
    if(strcmp(name, "genericCommands") == 0)
        return avtSimulationInformation_GetGenericCommands(self, NULL);
    if(strcmp(name, "mode") == 0)
        return avtSimulationInformation_GetMode(self, NULL);
    if(strcmp(name, "Unknown") == 0)
        return PyInt_FromLong(long(avtSimulationInformation::Unknown));
    if(strcmp(name, "Running") == 0)
        return PyInt_FromLong(long(avtSimulationInformation::Running));
    if(strcmp(name, "Stopped") == 0)
        return PyInt_FromLong(long(avtSimulationInformation::Stopped));

    if(strcmp(name, "customCommands") == 0)
        return avtSimulationInformation_GetCustomCommands(self, NULL);
    if(strcmp(name, "message") == 0)
        return avtSimulationInformation_GetMessage(self, NULL);

    return Py_FindMethod(PyavtSimulationInformation_methods, self, name);
}

int
PyavtSimulationInformation_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "host") == 0)
        obj = avtSimulationInformation_SetHost(self, tuple);
    else if(strcmp(name, "port") == 0)
        obj = avtSimulationInformation_SetPort(self, tuple);
    else if(strcmp(name, "securityKey") == 0)
        obj = avtSimulationInformation_SetSecurityKey(self, tuple);
    else if(strcmp(name, "otherNames") == 0)
        obj = avtSimulationInformation_SetOtherNames(self, tuple);
    else if(strcmp(name, "otherValues") == 0)
        obj = avtSimulationInformation_SetOtherValues(self, tuple);
    else if(strcmp(name, "mode") == 0)
        obj = avtSimulationInformation_SetMode(self, tuple);
    else if(strcmp(name, "message") == 0)
        obj = avtSimulationInformation_SetMessage(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
avtSimulationInformation_print(PyObject *v, FILE *fp, int flags)
{
    avtSimulationInformationObject *obj = (avtSimulationInformationObject *)v;
    fprintf(fp, "%s", PyavtSimulationInformation_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
avtSimulationInformation_str(PyObject *v)
{
    avtSimulationInformationObject *obj = (avtSimulationInformationObject *)v;
    return PyString_FromString(PyavtSimulationInformation_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *avtSimulationInformation_Purpose = "Contains information about simulation connections";
#else
static char *avtSimulationInformation_Purpose = "Contains information about simulation connections";
#endif

//
// The type description structure
//
static PyTypeObject avtSimulationInformationType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "avtSimulationInformation",                    // tp_name
    sizeof(avtSimulationInformationObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)avtSimulationInformation_dealloc,  // tp_dealloc
    (printfunc)avtSimulationInformation_print,     // tp_print
    (getattrfunc)PyavtSimulationInformation_getattr, // tp_getattr
    (setattrfunc)PyavtSimulationInformation_setattr, // tp_setattr
    (cmpfunc)avtSimulationInformation_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)avtSimulationInformation_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    avtSimulationInformation_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static avtSimulationInformation *defaultAtts = 0;
static avtSimulationInformation *currentAtts = 0;

static PyObject *
NewavtSimulationInformation(int useCurrent)
{
    avtSimulationInformationObject *newObject;
    newObject = PyObject_NEW(avtSimulationInformationObject, &avtSimulationInformationType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new avtSimulationInformation(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new avtSimulationInformation(*defaultAtts);
    else
        newObject->data = new avtSimulationInformation;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapavtSimulationInformation(const avtSimulationInformation *attr)
{
    avtSimulationInformationObject *newObject;
    newObject = PyObject_NEW(avtSimulationInformationObject, &avtSimulationInformationType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (avtSimulationInformation *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
avtSimulationInformation_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewavtSimulationInformation(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef avtSimulationInformationMethods[] = {
    {"avtSimulationInformation", avtSimulationInformation_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *avtSimulationInformationObserver = 0;

std::string
PyavtSimulationInformation_GetLogString()
{
    std::string s("avtSimulationInformation = avtSimulationInformation()\n");
    if(currentAtts != 0)
        s += PyavtSimulationInformation_ToString(currentAtts, "avtSimulationInformation.");
    return s;
}

static void
PyavtSimulationInformation_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("avtSimulationInformation = avtSimulationInformation()\n");
        s += PyavtSimulationInformation_ToString(currentAtts, "avtSimulationInformation.");
        cb(s);
    }
}

void
PyavtSimulationInformation_StartUp(avtSimulationInformation *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyavtSimulationInformation_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(avtSimulationInformationObserver == 0)
    {
        avtSimulationInformationObserver = new ObserverToCallback(subj,
            PyavtSimulationInformation_CallLogRoutine, (void *)data);
    }

}

void
PyavtSimulationInformation_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete avtSimulationInformationObserver;
    avtSimulationInformationObserver = 0;
}

PyMethodDef *
PyavtSimulationInformation_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return avtSimulationInformationMethods;
}

bool
PyavtSimulationInformation_Check(PyObject *obj)
{
    return (obj->ob_type == &avtSimulationInformationType);
}

avtSimulationInformation *
PyavtSimulationInformation_FromPyObject(PyObject *obj)
{
    avtSimulationInformationObject *obj2 = (avtSimulationInformationObject *)obj;
    return obj2->data;
}

PyObject *
PyavtSimulationInformation_New()
{
    return NewavtSimulationInformation(0);
}

PyObject *
PyavtSimulationInformation_Wrap(const avtSimulationInformation *attr)
{
    return WrapavtSimulationInformation(attr);
}

void
PyavtSimulationInformation_SetParent(PyObject *obj, PyObject *parent)
{
    avtSimulationInformationObject *obj2 = (avtSimulationInformationObject *)obj;
    obj2->parent = parent;
}

void
PyavtSimulationInformation_SetDefaults(const avtSimulationInformation *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new avtSimulationInformation(*atts);
}

