/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <TensorAttributes.h>
#include <DataNode.h>

// ****************************************************************************
// Method: TensorAttributes::TensorAttributes
//
// Purpose: 
//   Init utility for the TensorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void TensorAttributes::Init()
{
    useStride = false;
    stride = 1;
    nTensors = 400;
    scale = 0.25;
    scaleByMagnitude = true;
    autoScale = true;
    colorByEigenvalues = true;
    useLegend = true;
    invertColorTable = false;

    TensorAttributes::SelectAll();
}

// ****************************************************************************
// Method: TensorAttributes::TensorAttributes
//
// Purpose: 
//   Copy utility for the TensorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void TensorAttributes::Copy(const TensorAttributes &obj)
{
    useStride = obj.useStride;
    stride = obj.stride;
    nTensors = obj.nTensors;
    scale = obj.scale;
    scaleByMagnitude = obj.scaleByMagnitude;
    autoScale = obj.autoScale;
    colorByEigenvalues = obj.colorByEigenvalues;
    useLegend = obj.useLegend;
    tensorColor = obj.tensorColor;
    colorTableName = obj.colorTableName;
    invertColorTable = obj.invertColorTable;

    TensorAttributes::SelectAll();
}

// Type map format string
const char *TensorAttributes::TypeMapFormatString = TENSORATTRIBUTES_TMFS;
const AttributeGroup::private_tmfs_t TensorAttributes::TmfsStruct = {TENSORATTRIBUTES_TMFS};


// ****************************************************************************
// Method: TensorAttributes::TensorAttributes
//
// Purpose: 
//   Default constructor for the TensorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

TensorAttributes::TensorAttributes() : 
    AttributeSubject(TensorAttributes::TypeMapFormatString),
    tensorColor(0, 0, 0), colorTableName("Default")
{
    TensorAttributes::Init();
}

// ****************************************************************************
// Method: TensorAttributes::TensorAttributes
//
// Purpose: 
//   Constructor for the derived classes of TensorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

TensorAttributes::TensorAttributes(private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs),
    tensorColor(0, 0, 0), colorTableName("Default")
{
    TensorAttributes::Init();
}

// ****************************************************************************
// Method: TensorAttributes::TensorAttributes
//
// Purpose: 
//   Copy constructor for the TensorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

TensorAttributes::TensorAttributes(const TensorAttributes &obj) : 
    AttributeSubject(TensorAttributes::TypeMapFormatString)
{
    TensorAttributes::Copy(obj);
}

// ****************************************************************************
// Method: TensorAttributes::TensorAttributes
//
// Purpose: 
//   Copy constructor for derived classes of the TensorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

TensorAttributes::TensorAttributes(const TensorAttributes &obj, private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    TensorAttributes::Copy(obj);
}

// ****************************************************************************
// Method: TensorAttributes::~TensorAttributes
//
// Purpose: 
//   Destructor for the TensorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

TensorAttributes::~TensorAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: TensorAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the TensorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

TensorAttributes& 
TensorAttributes::operator = (const TensorAttributes &obj)
{
    if (this == &obj) return *this;

    TensorAttributes::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: TensorAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the TensorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
TensorAttributes::operator == (const TensorAttributes &obj) const
{
    // Create the return value
    return ((useStride == obj.useStride) &&
            (stride == obj.stride) &&
            (nTensors == obj.nTensors) &&
            (scale == obj.scale) &&
            (scaleByMagnitude == obj.scaleByMagnitude) &&
            (autoScale == obj.autoScale) &&
            (colorByEigenvalues == obj.colorByEigenvalues) &&
            (useLegend == obj.useLegend) &&
            (tensorColor == obj.tensorColor) &&
            (colorTableName == obj.colorTableName) &&
            (invertColorTable == obj.invertColorTable));
}

// ****************************************************************************
// Method: TensorAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the TensorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
TensorAttributes::operator != (const TensorAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: TensorAttributes::TypeName
//
// Purpose: 
//   Type name method for the TensorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
TensorAttributes::TypeName() const
{
    return "TensorAttributes";
}

// ****************************************************************************
// Method: TensorAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the TensorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
TensorAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const TensorAttributes *tmp = (const TensorAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: TensorAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the TensorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
TensorAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new TensorAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: TensorAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the TensorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
TensorAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new TensorAttributes(*this);
    else
        retval = new TensorAttributes;

    return retval;
}

// ****************************************************************************
// Method: TensorAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
TensorAttributes::SelectAll()
{
    Select(ID_useStride,          (void *)&useStride);
    Select(ID_stride,             (void *)&stride);
    Select(ID_nTensors,           (void *)&nTensors);
    Select(ID_scale,              (void *)&scale);
    Select(ID_scaleByMagnitude,   (void *)&scaleByMagnitude);
    Select(ID_autoScale,          (void *)&autoScale);
    Select(ID_colorByEigenvalues, (void *)&colorByEigenvalues);
    Select(ID_useLegend,          (void *)&useLegend);
    Select(ID_tensorColor,        (void *)&tensorColor);
    Select(ID_colorTableName,     (void *)&colorTableName);
    Select(ID_invertColorTable,   (void *)&invertColorTable);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: TensorAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
TensorAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    TensorAttributes defaultObject;
    bool addToParent = false;
    // Create a node for TensorAttributes.
    DataNode *node = new DataNode("TensorAttributes");

    if(completeSave || !FieldsEqual(ID_useStride, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("useStride", useStride));
    }

    if(completeSave || !FieldsEqual(ID_stride, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("stride", stride));
    }

    if(completeSave || !FieldsEqual(ID_nTensors, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("nTensors", nTensors));
    }

    if(completeSave || !FieldsEqual(ID_scale, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("scale", scale));
    }

    if(completeSave || !FieldsEqual(ID_scaleByMagnitude, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("scaleByMagnitude", scaleByMagnitude));
    }

    if(completeSave || !FieldsEqual(ID_autoScale, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("autoScale", autoScale));
    }

    if(completeSave || !FieldsEqual(ID_colorByEigenvalues, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("colorByEigenvalues", colorByEigenvalues));
    }

    if(completeSave || !FieldsEqual(ID_useLegend, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("useLegend", useLegend));
    }

        DataNode *tensorColorNode = new DataNode("tensorColor");
        if(tensorColor.CreateNode(tensorColorNode, completeSave, true))
        {
            addToParent = true;
            node->AddNode(tensorColorNode);
        }
        else
            delete tensorColorNode;
    if(completeSave || !FieldsEqual(ID_colorTableName, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("colorTableName", colorTableName));
    }

    if(completeSave || !FieldsEqual(ID_invertColorTable, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("invertColorTable", invertColorTable));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: TensorAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
TensorAttributes::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("TensorAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("useStride")) != 0)
        SetUseStride(node->AsBool());
    if((node = searchNode->GetNode("stride")) != 0)
        SetStride(node->AsInt());
    if((node = searchNode->GetNode("nTensors")) != 0)
        SetNTensors(node->AsInt());
    if((node = searchNode->GetNode("scale")) != 0)
        SetScale(node->AsDouble());
    if((node = searchNode->GetNode("scaleByMagnitude")) != 0)
        SetScaleByMagnitude(node->AsBool());
    if((node = searchNode->GetNode("autoScale")) != 0)
        SetAutoScale(node->AsBool());
    if((node = searchNode->GetNode("colorByEigenvalues")) != 0)
        SetColorByEigenvalues(node->AsBool());
    if((node = searchNode->GetNode("useLegend")) != 0)
        SetUseLegend(node->AsBool());
    if((node = searchNode->GetNode("tensorColor")) != 0)
        tensorColor.SetFromNode(node);
    if((node = searchNode->GetNode("colorTableName")) != 0)
        SetColorTableName(node->AsString());
    if((node = searchNode->GetNode("invertColorTable")) != 0)
        SetInvertColorTable(node->AsBool());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
TensorAttributes::SetUseStride(bool useStride_)
{
    useStride = useStride_;
    Select(ID_useStride, (void *)&useStride);
}

void
TensorAttributes::SetStride(int stride_)
{
    stride = stride_;
    Select(ID_stride, (void *)&stride);
}

void
TensorAttributes::SetNTensors(int nTensors_)
{
    nTensors = nTensors_;
    Select(ID_nTensors, (void *)&nTensors);
}

void
TensorAttributes::SetScale(double scale_)
{
    scale = scale_;
    Select(ID_scale, (void *)&scale);
}

void
TensorAttributes::SetScaleByMagnitude(bool scaleByMagnitude_)
{
    scaleByMagnitude = scaleByMagnitude_;
    Select(ID_scaleByMagnitude, (void *)&scaleByMagnitude);
}

void
TensorAttributes::SetAutoScale(bool autoScale_)
{
    autoScale = autoScale_;
    Select(ID_autoScale, (void *)&autoScale);
}

void
TensorAttributes::SetColorByEigenvalues(bool colorByEigenvalues_)
{
    colorByEigenvalues = colorByEigenvalues_;
    Select(ID_colorByEigenvalues, (void *)&colorByEigenvalues);
}

void
TensorAttributes::SetUseLegend(bool useLegend_)
{
    useLegend = useLegend_;
    Select(ID_useLegend, (void *)&useLegend);
}

void
TensorAttributes::SetTensorColor(const ColorAttribute &tensorColor_)
{
    tensorColor = tensorColor_;
    Select(ID_tensorColor, (void *)&tensorColor);
}

void
TensorAttributes::SetColorTableName(const std::string &colorTableName_)
{
    colorTableName = colorTableName_;
    Select(ID_colorTableName, (void *)&colorTableName);
}

void
TensorAttributes::SetInvertColorTable(bool invertColorTable_)
{
    invertColorTable = invertColorTable_;
    Select(ID_invertColorTable, (void *)&invertColorTable);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

bool
TensorAttributes::GetUseStride() const
{
    return useStride;
}

int
TensorAttributes::GetStride() const
{
    return stride;
}

int
TensorAttributes::GetNTensors() const
{
    return nTensors;
}

double
TensorAttributes::GetScale() const
{
    return scale;
}

bool
TensorAttributes::GetScaleByMagnitude() const
{
    return scaleByMagnitude;
}

bool
TensorAttributes::GetAutoScale() const
{
    return autoScale;
}

bool
TensorAttributes::GetColorByEigenvalues() const
{
    return colorByEigenvalues;
}

bool
TensorAttributes::GetUseLegend() const
{
    return useLegend;
}

const ColorAttribute &
TensorAttributes::GetTensorColor() const
{
    return tensorColor;
}

ColorAttribute &
TensorAttributes::GetTensorColor()
{
    return tensorColor;
}

const std::string &
TensorAttributes::GetColorTableName() const
{
    return colorTableName;
}

std::string &
TensorAttributes::GetColorTableName()
{
    return colorTableName;
}

bool
TensorAttributes::GetInvertColorTable() const
{
    return invertColorTable;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
TensorAttributes::SelectTensorColor()
{
    Select(ID_tensorColor, (void *)&tensorColor);
}

void
TensorAttributes::SelectColorTableName()
{
    Select(ID_colorTableName, (void *)&colorTableName);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: TensorAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
TensorAttributes::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_useStride:          return "useStride";
    case ID_stride:             return "stride";
    case ID_nTensors:           return "nTensors";
    case ID_scale:              return "scale";
    case ID_scaleByMagnitude:   return "scaleByMagnitude";
    case ID_autoScale:          return "autoScale";
    case ID_colorByEigenvalues: return "colorByEigenvalues";
    case ID_useLegend:          return "useLegend";
    case ID_tensorColor:        return "tensorColor";
    case ID_colorTableName:     return "colorTableName";
    case ID_invertColorTable:   return "invertColorTable";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: TensorAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
TensorAttributes::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_useStride:          return FieldType_bool;
    case ID_stride:             return FieldType_int;
    case ID_nTensors:           return FieldType_int;
    case ID_scale:              return FieldType_double;
    case ID_scaleByMagnitude:   return FieldType_bool;
    case ID_autoScale:          return FieldType_bool;
    case ID_colorByEigenvalues: return FieldType_bool;
    case ID_useLegend:          return FieldType_bool;
    case ID_tensorColor:        return FieldType_color;
    case ID_colorTableName:     return FieldType_colortable;
    case ID_invertColorTable:   return FieldType_bool;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: TensorAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
TensorAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_useStride:          return "bool";
    case ID_stride:             return "int";
    case ID_nTensors:           return "int";
    case ID_scale:              return "double";
    case ID_scaleByMagnitude:   return "bool";
    case ID_autoScale:          return "bool";
    case ID_colorByEigenvalues: return "bool";
    case ID_useLegend:          return "bool";
    case ID_tensorColor:        return "color";
    case ID_colorTableName:     return "colortable";
    case ID_invertColorTable:   return "bool";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: TensorAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
TensorAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const TensorAttributes &obj = *((const TensorAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_useStride:
        {  // new scope
        retval = (useStride == obj.useStride);
        }
        break;
    case ID_stride:
        {  // new scope
        retval = (stride == obj.stride);
        }
        break;
    case ID_nTensors:
        {  // new scope
        retval = (nTensors == obj.nTensors);
        }
        break;
    case ID_scale:
        {  // new scope
        retval = (scale == obj.scale);
        }
        break;
    case ID_scaleByMagnitude:
        {  // new scope
        retval = (scaleByMagnitude == obj.scaleByMagnitude);
        }
        break;
    case ID_autoScale:
        {  // new scope
        retval = (autoScale == obj.autoScale);
        }
        break;
    case ID_colorByEigenvalues:
        {  // new scope
        retval = (colorByEigenvalues == obj.colorByEigenvalues);
        }
        break;
    case ID_useLegend:
        {  // new scope
        retval = (useLegend == obj.useLegend);
        }
        break;
    case ID_tensorColor:
        {  // new scope
        retval = (tensorColor == obj.tensorColor);
        }
        break;
    case ID_colorTableName:
        {  // new scope
        retval = (colorTableName == obj.colorTableName);
        }
        break;
    case ID_invertColorTable:
        {  // new scope
        retval = (invertColorTable == obj.invertColorTable);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

bool
TensorAttributes::ChangesRequireRecalculation(const TensorAttributes &obj)
{
    return ((useStride != obj.useStride) ||
            (stride != obj.stride) ||
            (nTensors != obj.nTensors));
}

