/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <ZoneDumpAttributes.h>
#include <DataNode.h>

// ****************************************************************************
// Method: ZoneDumpAttributes::ZoneDumpAttributes
//
// Purpose: 
//   Init utility for the ZoneDumpAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void ZoneDumpAttributes::Init()
{
    lowerBound = -1e+37;
    upperBound = 1e+37;
    outputFile = "visit_zonedump.zod";
    enabled = false;

    ZoneDumpAttributes::SelectAll();
}

// ****************************************************************************
// Method: ZoneDumpAttributes::ZoneDumpAttributes
//
// Purpose: 
//   Copy utility for the ZoneDumpAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void ZoneDumpAttributes::Copy(const ZoneDumpAttributes &obj)
{
    variable = obj.variable;
    lowerBound = obj.lowerBound;
    upperBound = obj.upperBound;
    outputFile = obj.outputFile;
    enabled = obj.enabled;

    ZoneDumpAttributes::SelectAll();
}

// Type map format string
const char *ZoneDumpAttributes::TypeMapFormatString = ZONEDUMPATTRIBUTES_TMFS;
const AttributeGroup::private_tmfs_t ZoneDumpAttributes::TmfsStruct = {ZONEDUMPATTRIBUTES_TMFS};


// ****************************************************************************
// Method: ZoneDumpAttributes::ZoneDumpAttributes
//
// Purpose: 
//   Default constructor for the ZoneDumpAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ZoneDumpAttributes::ZoneDumpAttributes() : 
    AttributeSubject(ZoneDumpAttributes::TypeMapFormatString),
    variable("default")
{
    ZoneDumpAttributes::Init();
}

// ****************************************************************************
// Method: ZoneDumpAttributes::ZoneDumpAttributes
//
// Purpose: 
//   Constructor for the derived classes of ZoneDumpAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ZoneDumpAttributes::ZoneDumpAttributes(private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs),
    variable("default")
{
    ZoneDumpAttributes::Init();
}

// ****************************************************************************
// Method: ZoneDumpAttributes::ZoneDumpAttributes
//
// Purpose: 
//   Copy constructor for the ZoneDumpAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ZoneDumpAttributes::ZoneDumpAttributes(const ZoneDumpAttributes &obj) : 
    AttributeSubject(ZoneDumpAttributes::TypeMapFormatString)
{
    ZoneDumpAttributes::Copy(obj);
}

// ****************************************************************************
// Method: ZoneDumpAttributes::ZoneDumpAttributes
//
// Purpose: 
//   Copy constructor for derived classes of the ZoneDumpAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ZoneDumpAttributes::ZoneDumpAttributes(const ZoneDumpAttributes &obj, private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    ZoneDumpAttributes::Copy(obj);
}

// ****************************************************************************
// Method: ZoneDumpAttributes::~ZoneDumpAttributes
//
// Purpose: 
//   Destructor for the ZoneDumpAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ZoneDumpAttributes::~ZoneDumpAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: ZoneDumpAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the ZoneDumpAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ZoneDumpAttributes& 
ZoneDumpAttributes::operator = (const ZoneDumpAttributes &obj)
{
    if (this == &obj) return *this;

    ZoneDumpAttributes::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: ZoneDumpAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the ZoneDumpAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ZoneDumpAttributes::operator == (const ZoneDumpAttributes &obj) const
{
    // Create the return value
    return ((variable == obj.variable) &&
            (lowerBound == obj.lowerBound) &&
            (upperBound == obj.upperBound) &&
            (outputFile == obj.outputFile) &&
            (enabled == obj.enabled));
}

// ****************************************************************************
// Method: ZoneDumpAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the ZoneDumpAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ZoneDumpAttributes::operator != (const ZoneDumpAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: ZoneDumpAttributes::TypeName
//
// Purpose: 
//   Type name method for the ZoneDumpAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
ZoneDumpAttributes::TypeName() const
{
    return "ZoneDumpAttributes";
}

// ****************************************************************************
// Method: ZoneDumpAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the ZoneDumpAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ZoneDumpAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const ZoneDumpAttributes *tmp = (const ZoneDumpAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: ZoneDumpAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the ZoneDumpAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
ZoneDumpAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new ZoneDumpAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: ZoneDumpAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the ZoneDumpAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
ZoneDumpAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new ZoneDumpAttributes(*this);
    else
        retval = new ZoneDumpAttributes;

    return retval;
}

// ****************************************************************************
// Method: ZoneDumpAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
ZoneDumpAttributes::SelectAll()
{
    Select(ID_variable,   (void *)&variable);
    Select(ID_lowerBound, (void *)&lowerBound);
    Select(ID_upperBound, (void *)&upperBound);
    Select(ID_outputFile, (void *)&outputFile);
    Select(ID_enabled,    (void *)&enabled);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: ZoneDumpAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ZoneDumpAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    ZoneDumpAttributes defaultObject;
    bool addToParent = false;
    // Create a node for ZoneDumpAttributes.
    DataNode *node = new DataNode("ZoneDumpAttributes");

    if(completeSave || !FieldsEqual(ID_variable, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("variable", variable));
    }

    if(completeSave || !FieldsEqual(ID_lowerBound, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("lowerBound", lowerBound));
    }

    if(completeSave || !FieldsEqual(ID_upperBound, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("upperBound", upperBound));
    }

    if(completeSave || !FieldsEqual(ID_outputFile, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("outputFile", outputFile));
    }

    if(completeSave || !FieldsEqual(ID_enabled, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("enabled", enabled));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: ZoneDumpAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
ZoneDumpAttributes::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("ZoneDumpAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("variable")) != 0)
        SetVariable(node->AsString());
    if((node = searchNode->GetNode("lowerBound")) != 0)
        SetLowerBound(node->AsDouble());
    if((node = searchNode->GetNode("upperBound")) != 0)
        SetUpperBound(node->AsDouble());
    if((node = searchNode->GetNode("outputFile")) != 0)
        SetOutputFile(node->AsString());
    if((node = searchNode->GetNode("enabled")) != 0)
        SetEnabled(node->AsBool());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
ZoneDumpAttributes::SetVariable(const std::string &variable_)
{
    variable = variable_;
    Select(ID_variable, (void *)&variable);
}

void
ZoneDumpAttributes::SetLowerBound(double lowerBound_)
{
    lowerBound = lowerBound_;
    Select(ID_lowerBound, (void *)&lowerBound);
}

void
ZoneDumpAttributes::SetUpperBound(double upperBound_)
{
    upperBound = upperBound_;
    Select(ID_upperBound, (void *)&upperBound);
}

void
ZoneDumpAttributes::SetOutputFile(const std::string &outputFile_)
{
    outputFile = outputFile_;
    Select(ID_outputFile, (void *)&outputFile);
}

void
ZoneDumpAttributes::SetEnabled(bool enabled_)
{
    enabled = enabled_;
    Select(ID_enabled, (void *)&enabled);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

const std::string &
ZoneDumpAttributes::GetVariable() const
{
    return variable;
}

std::string &
ZoneDumpAttributes::GetVariable()
{
    return variable;
}

double
ZoneDumpAttributes::GetLowerBound() const
{
    return lowerBound;
}

double
ZoneDumpAttributes::GetUpperBound() const
{
    return upperBound;
}

const std::string &
ZoneDumpAttributes::GetOutputFile() const
{
    return outputFile;
}

std::string &
ZoneDumpAttributes::GetOutputFile()
{
    return outputFile;
}

bool
ZoneDumpAttributes::GetEnabled() const
{
    return enabled;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
ZoneDumpAttributes::SelectVariable()
{
    Select(ID_variable, (void *)&variable);
}

void
ZoneDumpAttributes::SelectOutputFile()
{
    Select(ID_outputFile, (void *)&outputFile);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: ZoneDumpAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
ZoneDumpAttributes::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_variable:   return "variable";
    case ID_lowerBound: return "lowerBound";
    case ID_upperBound: return "upperBound";
    case ID_outputFile: return "outputFile";
    case ID_enabled:    return "enabled";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: ZoneDumpAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
ZoneDumpAttributes::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_variable:   return FieldType_variablename;
    case ID_lowerBound: return FieldType_double;
    case ID_upperBound: return FieldType_double;
    case ID_outputFile: return FieldType_string;
    case ID_enabled:    return FieldType_bool;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: ZoneDumpAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
ZoneDumpAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_variable:   return "variablename";
    case ID_lowerBound: return "double";
    case ID_upperBound: return "double";
    case ID_outputFile: return "string";
    case ID_enabled:    return "bool";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: ZoneDumpAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ZoneDumpAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const ZoneDumpAttributes &obj = *((const ZoneDumpAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_variable:
        {  // new scope
        retval = (variable == obj.variable);
        }
        break;
    case ID_lowerBound:
        {  // new scope
        retval = (lowerBound == obj.lowerBound);
        }
        break;
    case ID_upperBound:
        {  // new scope
        retval = (upperBound == obj.upperBound);
        }
        break;
    case ID_outputFile:
        {  // new scope
        retval = (outputFile == obj.outputFile);
        }
        break;
    case ID_enabled:
        {  // new scope
        retval = (enabled == obj.enabled);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

